/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.editor;

import com.jaxfront.core.util.JAXFrontProperties;
import java.awt.Color;
import java.io.IOException;
import java.io.StringReader;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.FactoryConfigurationError;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLIndentHandler
implements ContentHandler,
DocumentListener {
    private Document _textDocument;
    private String _content;
    private String _indent = "    ";
    private Stack _lastName;
    private Vector _prefixMapping;
    private MutableAttributeSet _elementSet;
    private MutableAttributeSet _attrSet;
    private MutableAttributeSet _piSet;
    private MutableAttributeSet _commentSet;
    private MutableAttributeSet _defaultSet;
    private MutableAttributeSet _textSet;
    private int _indentCounter;
    private boolean _hasCharacterBetweenTags;

    private XMLIndentHandler() {
    }

    public XMLIndentHandler(Document textDocument) throws SAXException {
        this._textDocument = textDocument;
        this._lastName = new Stack();
        this._indentCounter = 0;
        this._prefixMapping = new Vector();
        this.init();
    }

    public XMLIndentHandler(String text) throws SAXException, BadLocationException {
        this._textDocument = new DefaultStyledDocument();
        this._textDocument.insertString(0, text, null);
        this._lastName = new Stack();
        this._indentCounter = 0;
        this._prefixMapping = new Vector();
        this.init();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        boolean hasValidChar = false;
        try {
            String insertString;
            this._hasCharacterBetweenTags = true;
            StringBuffer buffer = new StringBuffer();
            buffer.append(ch, start, length);
            for (int i = 0; i < buffer.length() && !hasValidChar; ++i) {
                char aChar = buffer.charAt(i);
                if (aChar <= ' ') continue;
                hasValidChar = true;
            }
            if (!hasValidChar) {
                buffer = new StringBuffer("");
                this._hasCharacterBetweenTags = false;
            }
            if ((insertString = buffer.toString()).equals("&")) {
                insertString = "&amp;";
            } else if (insertString.equals("\"")) {
                insertString = "&quot;";
            } else if (insertString.equals("<")) {
                insertString = "&gt;";
            } else if (insertString.equals(">")) {
                insertString = "&lt;";
            } else if (insertString.equals("'")) {
                insertString = "&apos;";
            }
            this._textDocument.insertString(this._textDocument.getLength(), insertString, this._textSet);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (qName.equals(this._lastName.peek())) {
                if (this._hasCharacterBetweenTags) {
                    this._textDocument.insertString(this._textDocument.getLength(), "</", this._defaultSet);
                    this._textDocument.insertString(this._textDocument.getLength(), qName, this._elementSet);
                    this._textDocument.insertString(this._textDocument.getLength(), ">", this._defaultSet);
                } else {
                    String textString = this._textDocument.getText(0, this._textDocument.getLength());
                    StringBuffer buffer = new StringBuffer(textString);
                    boolean hasInserted = false;
                    for (int i = textString.length() - 1; i > 0 && !hasInserted; --i) {
                        char temp = buffer.charAt(i);
                        if (temp != '>') continue;
                        this._textDocument.insertString(i, "/", this._defaultSet);
                        hasInserted = true;
                    }
                }
            } else {
                String pre = "";
                for (int i = 0; i < this._indentCounter - 1; ++i) {
                    pre = pre + this._indent;
                }
                this._textDocument.insertString(this._textDocument.getLength(), "\n" + pre + "</", this._defaultSet);
                this._textDocument.insertString(this._textDocument.getLength(), qName, this._elementSet);
                this._textDocument.insertString(this._textDocument.getLength(), ">", this._defaultSet);
            }
            this._lastName.push(qName);
            --this._indentCounter;
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    private void init() throws SAXException {
        try {
            this.initAttributeSet();
            this._content = this._textDocument.getText(0, this._textDocument.getLength());
            char[] charContent = this._content.toCharArray();
            for (int i = 0; i < charContent.length; ++i) {
                if (charContent[i] != '\n' && charContent[i] != ' ') continue;
                charContent[i] = 32;
            }
            String newContent = new String(charContent);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            StringReader stringReader = new StringReader(newContent);
            InputSource inputSource = new InputSource(stringReader);
            reader.setContentHandler(this);
            reader.parse(inputSource);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (SAXException ex) {
            try {
                this._textDocument.remove(0, this._textDocument.getLength());
                this._textDocument.insertString(0, this._content, null);
            }
            catch (BadLocationException exc) {
                exc.printStackTrace();
            }
            throw ex;
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
    }

    private void initAttributeSet() {
        this._elementSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this._elementSet, new Color(153, 0, 0));
        StyleConstants.setItalic(this._elementSet, false);
        this._attrSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this._attrSet, new Color(255, 0, 0));
        StyleConstants.setItalic(this._attrSet, true);
        this._piSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this._piSet, new Color(0, 153, 51));
        StyleConstants.setItalic(this._piSet, true);
        this._commentSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this._commentSet, Color.darkGray);
        StyleConstants.setItalic(this._commentSet, true);
        this._defaultSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this._defaultSet, new Color(51, 51, 255));
        StyleConstants.setItalic(this._defaultSet, false);
        this._textSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this._textSet, Color.black);
        StyleConstants.setItalic(this._textSet, false);
    }

    public void insertUpdate(DocumentEvent e) {
        if (this._textDocument instanceof StyledDocument && e.getLength() > 1) {
            int startOffset = e.getOffset();
            int length = e.getLength();
            try {
                String text = this._textDocument.getText(startOffset, length);
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this._textDocument.insertString(this._textDocument.getLength(), "\n<?" + target + " " + data + "?>", this._piSet);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public void removeUpdate(DocumentEvent e) {
    }

    private String replace(String source, String oldString, String newString) {
        while (source.indexOf(oldString) > -1) {
            int index = source.indexOf(oldString);
            StringBuffer buffer = new StringBuffer(source);
            buffer.replace(index, index + oldString.length(), newString);
            source = buffer.toString();
        }
        return source;
    }

    public String getText() {
        try {
            return this._textDocument.getText(0, this._textDocument.getLength());
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
        try {
            this._textDocument.remove(0, this._textDocument.getLength());
            this._textDocument.insertString(0, "<?xml version=\"1.0\" encoding=\"" + JAXFrontProperties.getDefaultXMLFileEncoding() + "\"?>", this._piSet);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            int i;
            String pre = "\n";
            for (i = 0; i < this._indentCounter; ++i) {
                pre = pre + this._indent;
            }
            this._textDocument.insertString(this._textDocument.getLength(), pre + "<", this._defaultSet);
            this._textDocument.insertString(this._textDocument.getLength(), qName, this._elementSet);
            if (this._lastName.isEmpty()) {
                for (i = 0; i < this._prefixMapping.size(); ++i) {
                    String[] s = (String[])this._prefixMapping.get(i);
                    this._textDocument.insertString(this._textDocument.getLength(), s[0], this._attrSet);
                    this._textDocument.insertString(this._textDocument.getLength(), s[1], this._attrSet);
                    this._textDocument.insertString(this._textDocument.getLength(), s[2], this._defaultSet);
                    this._textDocument.insertString(this._textDocument.getLength(), s[3], this._textSet);
                    this._textDocument.insertString(this._textDocument.getLength(), s[4], this._defaultSet);
                }
            }
            this._lastName.push(qName);
            for (i = 0; i < atts.getLength(); ++i) {
                String name = atts.getQName(i);
                String value = atts.getValue(i);
                if (value.indexOf("\"") > -1) {
                    value = this.replace(value, "\"", "&quot;");
                }
                if (value.indexOf(">") > -1) {
                    value = this.replace(value, ">", "&gt;");
                }
                if (value.indexOf("<") > -1) {
                    value = this.replace(value, ">", "&lt;");
                }
                if (value.indexOf("&") > -1) {
                    StringTokenizer tokenizer = new StringTokenizer(value, "&");
                    StringBuffer buffer = new StringBuffer();
                    while (tokenizer.hasMoreTokens()) {
                        String partString = tokenizer.nextToken();
                        if (partString.startsWith("quot;")) {
                            buffer.append("&");
                            buffer.append(partString);
                            continue;
                        }
                        if (partString.startsWith("gt;")) {
                            buffer.append("&");
                            buffer.append(partString);
                            continue;
                        }
                        if (partString.startsWith("lt;")) {
                            buffer.append("&");
                            buffer.append(partString);
                            continue;
                        }
                        if (partString.startsWith("apos;")) {
                            buffer.append("&");
                            buffer.append(partString);
                            continue;
                        }
                        if (partString.startsWith("amp;")) {
                            buffer.append("&");
                            buffer.append(partString);
                            continue;
                        }
                        if (buffer.length() > 0) {
                            buffer.append("&amp;");
                        }
                        buffer.append(partString);
                    }
                    value = buffer.toString();
                }
                if (value.indexOf("'") > -1) {
                    value = this.replace(value, "'", "&apos;");
                }
                this._textDocument.insertString(this._textDocument.getLength(), " " + name, this._attrSet);
                this._textDocument.insertString(this._textDocument.getLength(), "=\"", this._defaultSet);
                this._textDocument.insertString(this._textDocument.getLength(), value, this._textSet);
                this._textDocument.insertString(this._textDocument.getLength(), "\"", this._defaultSet);
            }
            this._textDocument.insertString(this._textDocument.getLength(), ">", this._defaultSet);
            ++this._indentCounter;
            this._hasCharacterBetweenTags = false;
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        String[] temp = new String[]{" xmlns:", prefix, "=\"", uri, "\""};
        this._prefixMapping.addElement(temp);
    }
}

