/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.layout;

import com.jaxfront.swing.ui.layout.JSplitterSpace;
import com.jaxfront.swing.ui.layout.SplitterBarMouseListener;
import com.jaxfront.swing.ui.layout.SplitterBarMouseMotionListener;
import com.jaxfront.swing.ui.layout.SplitterLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public class JSplitterBar
extends JPanel {
    static final Cursor VERT_CURSOR = new Cursor(8);
    static final Cursor HORIZ_CURSOR = new Cursor(11);
    static final Cursor DEF_CURSOR = new Cursor(0);
    private int orientation = 0;
    private boolean alreadyDrawn = false;
    private Rectangle originalBounds = null;
    private Window wBar;

    public JSplitterBar() {
        this.addMouseMotionListener(new SplitterBarMouseMotionListener(this));
        this.addMouseListener(new SplitterBarMouseListener(this));
    }

    private void checkOtherComponents() {
        block38: {
            int origCurr;
            int curr;
            Rectangle parentBounds;
            Insets insets;
            Component[] comps;
            Rectangle currBounds;
            block36: {
                int temp;
                block37: {
                    int temp2;
                    currBounds = this.getBounds();
                    comps = this.getParent().getComponents();
                    insets = this.getParent().getInsets();
                    parentBounds = this.getParent().getBounds();
                    for (curr = 0; curr < comps.length && comps[curr] != this; ++curr) {
                    }
                    origCurr = curr;
                    if (this.orientation != 0) break block36;
                    if (currBounds.y >= this.originalBounds.y) break block37;
                    boolean done = false;
                    for (temp2 = curr - 1; !done && temp2 > -1; --temp2) {
                        if (!(comps[temp2] instanceof JSplitterBar)) continue;
                        Rectangle r = comps[temp2].getBounds();
                        if (currBounds.y <= r.y + r.height) {
                            comps[temp2].setLocation(r.x, currBounds.y - r.height);
                            for (int c = curr - 1; c > temp2; --c) {
                                comps[c].setVisible(false);
                            }
                            curr = temp2;
                            currBounds = comps[temp2].getBounds();
                            continue;
                        }
                        done = true;
                    }
                    if (currBounds.y <= insets.top) {
                        int temp3;
                        int delta = currBounds.y - insets.top;
                        for (temp3 = curr - 1; temp3 > -1; --temp3) {
                            comps[temp3].setVisible(false);
                        }
                        done = false;
                        for (temp3 = curr; !done && temp3 <= origCurr; ++temp3) {
                            if (comps[temp3] instanceof JSplitterBar) {
                                Point p = comps[temp3].getLocation();
                                p.y -= delta;
                                comps[temp3].setLocation(p);
                                continue;
                            }
                            done = comps[temp3].isVisible();
                        }
                    }
                    curr = origCurr;
                    for (temp2 = curr + 1; temp2 < comps.length && !comps[temp2].isVisible(); ++temp2) {
                        comps[temp2].setVisible(true);
                    }
                    break block38;
                }
                if (currBounds.y <= this.originalBounds.y) break block38;
                boolean done = false;
                for (temp = curr + 1; !done && temp < comps.length; ++temp) {
                    if (!(comps[temp] instanceof JSplitterBar)) continue;
                    Rectangle r = comps[temp].getBounds();
                    if (currBounds.y + currBounds.height >= r.y) {
                        comps[temp].setLocation(r.x, currBounds.y + currBounds.height);
                        for (int c = curr + 1; c < temp; ++c) {
                            comps[c].setVisible(false);
                        }
                        curr = temp;
                        currBounds = comps[temp].getBounds();
                        continue;
                    }
                    done = true;
                }
                if (currBounds.y + currBounds.height >= parentBounds.height - insets.bottom) {
                    int temp4;
                    int delta = currBounds.y + currBounds.height - (parentBounds.height - insets.bottom);
                    for (temp4 = curr + 1; temp4 < comps.length; ++temp4) {
                        comps[temp4].setVisible(false);
                    }
                    done = false;
                    for (temp4 = curr; !done && temp4 >= origCurr; --temp4) {
                        if (comps[temp4] instanceof JSplitterBar) {
                            Point p = comps[temp4].getLocation();
                            p.y -= delta;
                            comps[temp4].setLocation(p);
                            continue;
                        }
                        done = comps[temp4].isVisible();
                    }
                }
                curr = origCurr;
                for (temp = curr - 1; temp > -1 && !comps[temp].isVisible(); --temp) {
                    comps[temp].setVisible(true);
                }
                break block38;
            }
            if (currBounds.x < this.originalBounds.x) {
                int temp;
                boolean done = false;
                for (temp = curr - 1; !done && temp > -1; --temp) {
                    if (!(comps[temp] instanceof JSplitterBar)) continue;
                    Rectangle r = comps[temp].getBounds();
                    if (currBounds.x <= r.x + r.width) {
                        comps[temp].setLocation(currBounds.x - r.width, r.y);
                        for (int c = curr - 1; c > temp; --c) {
                            comps[c].setVisible(false);
                        }
                        curr = temp;
                        currBounds = comps[temp].getBounds();
                        continue;
                    }
                    done = true;
                }
                if (currBounds.x <= insets.left) {
                    int temp5;
                    int delta = currBounds.x - insets.left;
                    for (temp5 = curr - 1; temp5 > -1; --temp5) {
                        comps[temp5].setVisible(false);
                    }
                    done = false;
                    for (temp5 = curr; !done && temp5 <= origCurr; ++temp5) {
                        if (comps[temp5] instanceof JSplitterBar) {
                            Point p = comps[temp5].getLocation();
                            p.x -= delta;
                            comps[temp5].setLocation(p);
                            continue;
                        }
                        done = comps[temp5].isVisible();
                    }
                }
                curr = origCurr;
                for (temp = curr + 1; temp < comps.length && !comps[temp].isVisible(); ++temp) {
                    comps[temp].setVisible(true);
                }
            } else if (currBounds.x > this.originalBounds.x) {
                int temp;
                boolean done = false;
                for (temp = curr + 1; !done && temp < comps.length; ++temp) {
                    if (!(comps[temp] instanceof JSplitterBar)) continue;
                    Rectangle r = comps[temp].getBounds();
                    if (currBounds.x + currBounds.width >= r.x) {
                        comps[temp].setLocation(currBounds.x + currBounds.width, r.y);
                        for (int c = curr + 1; c < temp; ++c) {
                            comps[c].setVisible(false);
                        }
                        curr = temp;
                        currBounds = comps[temp].getBounds();
                        continue;
                    }
                    done = true;
                }
                if (currBounds.x + currBounds.width >= parentBounds.width - insets.right) {
                    int temp6;
                    int delta = currBounds.x + currBounds.width - (parentBounds.width - insets.right);
                    for (temp6 = curr + 1; temp6 < comps.length; ++temp6) {
                        comps[temp6].setVisible(false);
                    }
                    done = false;
                    for (temp6 = curr; !done && temp6 >= origCurr; --temp6) {
                        if (comps[temp6] instanceof JSplitterBar) {
                            Point p = comps[temp6].getLocation();
                            p.x -= delta;
                            comps[temp6].setLocation(p);
                            continue;
                        }
                        done = comps[temp6].isVisible();
                    }
                }
                curr = origCurr;
                for (temp = curr - 1; temp > -1 && !comps[temp].isVisible(); --temp) {
                    comps[temp].setVisible(true);
                }
            }
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    void mouseDrag(MouseEvent e) {
        if (SplitterLayout.dragee == null) {
            SplitterLayout.dragee = this;
        } else if (SplitterLayout.dragee != this) {
            return;
        }
        Container c = this.getParent();
        Point fl = c.getLocationOnScreen();
        while (c.getParent() != null) {
            c = c.getParent();
        }
        if (!this.alreadyDrawn) {
            this.originalBounds = this.getBounds();
            this.wBar = new Window((Frame)c);
            this.wBar.setBackground(this.getBackground().darker());
        }
        Container cp = this.getParent();
        Dimension parentDim = cp.getSize();
        Point l = this.getLocationOnScreen();
        Insets insets = cp.getInsets();
        if (this.orientation == 0) {
            parentDim.width -= insets.right + insets.left;
        } else {
            parentDim.height -= insets.top + insets.bottom;
        }
        Rectangle r = this.getBounds();
        int x = l.x + (this.orientation == 1 ? e.getX() : 0);
        int y = l.y + (this.orientation == 0 ? e.getY() : 0);
        if (x < fl.x + insets.left) {
            x = fl.x + insets.left;
        } else if (this.orientation == 1 && x > fl.x + parentDim.width - r.width) {
            x = fl.x + parentDim.width - r.width;
        }
        if (y < fl.y + insets.top) {
            y = fl.y + insets.top;
        } else if (this.orientation == 0 && y > fl.y + parentDim.height - r.height) {
            y = fl.y + parentDim.height - r.height;
        }
        this.wBar.setBounds(x, y, this.orientation == 1 ? 3 : parentDim.width, this.orientation == 0 ? 3 : parentDim.height);
        if (!this.alreadyDrawn) {
            this.wBar.setVisible(true);
            this.alreadyDrawn = true;
        }
    }

    void mouseEnter(MouseEvent e) {
        if (SplitterLayout.dragee != null) {
            return;
        }
        this.setCursor(this.orientation == 0 ? VERT_CURSOR : HORIZ_CURSOR);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void mouseExit(MouseEvent e) {
        if (SplitterLayout.dragee != null) {
            return;
        }
        this.setCursor(DEF_CURSOR);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void mouseRelease(MouseEvent e) {
        if (this.alreadyDrawn) {
            if (SplitterLayout.dragee != this) {
                return;
            }
            SplitterLayout.dragee = null;
            this.wBar.setVisible(false);
            this.wBar.dispose();
            this.wBar = null;
            this.alreadyDrawn = false;
            Rectangle r = this.getBounds();
            r.x = r.x + (this.orientation == 1 ? e.getX() : 0);
            r.y = r.y + (this.orientation == 0 ? e.getY() : 0);
            this.setLocation(r.x, r.y);
            this.setCursor(DEF_CURSOR);
            this.checkOtherComponents();
            this.invalidate();
            this.getParent().validate();
            SplitterLayout.dragee = null;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(this.getBackground());
        Component[] c = this.getComponents();
        if (c != null && c.length > 0) {
            for (int i = 0; i < c.length; ++i) {
                if (!(c[i] instanceof JSplitterSpace)) continue;
                Rectangle r = c[i].getBounds();
                if (this.orientation == 0) {
                    g.fill3DRect(r.x + 2, r.y + r.height / 2 - 1, r.width - 5, 3, true);
                    continue;
                }
                g.fill3DRect(r.x + r.width / 2 - 1, r.y + 2, 3, r.y + r.height - 5, true);
            }
        } else {
            Rectangle r = this.getBounds();
            if (this.orientation == 0) {
                g.fill3DRect(2, r.height / 2 - 1, r.width - 5, 3, true);
            } else {
                g.fill3DRect(r.width / 2 - 1, 2, 3, r.height - 5, true);
            }
        }
    }

    void setOrientation(int o) {
        this.orientation = o;
    }

    public void swapOrientation() {
        this.setOrientation(this.getOrientation() == 1 ? 0 : 1);
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

