/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.swing.ui.tools.BubbleHelp;
import com.jaxfront.swing.ui.tools.BubbleTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;

public class BubbleHelpSingleton
implements BubbleHelp {
    private static BubbleTimer timer = null;
    private static JToolTip bubbleTip = null;
    private Popup tipWindow;
    private Color _windowColor;
    private Point point = new Point();
    private String helpString = null;
    private int _delay = 2000;
    private WeakReference targetComponentRef;
    private static BubbleHelpSingleton _instance = null;

    private BubbleHelpSingleton(String help, int delay) {
        this.setHelpString(help);
        this.setDelay(delay);
    }

    public static BubbleHelpSingleton getInstance() {
        if (_instance == null) {
            _instance = new BubbleHelpSingleton("", 2000);
        }
        return _instance;
    }

    public void defuse() {
        this.hideBubble();
        this.disarmBubble();
    }

    public synchronized void armBubble() {
        BubbleHelpSingleton.getTimer().arm(this, this.getDelay());
    }

    public synchronized void armBubble(Point atPoint) {
        this.armBubble();
        this.point.x = atPoint.x;
        this.point.y = atPoint.y;
    }

    public synchronized void armBubble(Point atPoint, Component newTarget) {
        this.targetComponentRef = new WeakReference<Component>(newTarget);
        this.armBubble();
        this.point.x = atPoint.x;
        this.point.y = atPoint.y;
    }

    public synchronized void armBubble(int x, int y, Component newTarget) {
        this.targetComponentRef = new WeakReference<Component>(newTarget);
        this.armBubble();
        this.point.x = x;
        this.point.y = y;
    }

    public synchronized void armBubble(int x, int y) {
        this.armBubble();
        this.point.x = x;
        this.point.y = y;
    }

    synchronized void disarmBubble() {
        if (BubbleHelpSingleton.getTimer() != null) {
            BubbleHelpSingleton.getTimer().disarm();
        }
    }

    public void timeElapsed(BubbleTimer timer) {
        this.showBubble();
    }

    void showBubble() {
        if (this.targetComponentRef != null && this.targetComponentRef.get() != null) {
            Component aTargetComp = (Component)this.targetComponentRef.get();
            if (aTargetComp instanceof JComponent) {
                this.setHelpString(((JComponent)aTargetComp).getToolTipText());
                bubbleTip = ((JComponent)aTargetComp).createToolTip();
            }
            bubbleTip.setTipText(this.getHelpString());
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            Window ancestorWindow = SwingUtilities.getWindowAncestor(aTargetComp);
            if (ancestorWindow != null) {
                this.tipWindow = popupFactory.getPopup(ancestorWindow, bubbleTip, this.point.x + 10, this.point.y + 10);
                this.tipWindow.show();
            } else {
                return;
            }
        }
    }

    public void hideBubble() {
        if (this.tipWindow != null) {
            this.tipWindow.hide();
        }
        this.tipWindow = null;
        if (bubbleTip != null) {
            bubbleTip.getUI().uninstallUI(bubbleTip);
        }
        bubbleTip = null;
    }

    public void setHelpString(String helpString) {
        this.helpString = helpString;
    }

    public String getHelpString() {
        return this.helpString;
    }

    public Color getWindowColor() {
        if (this._windowColor == null) {
            this._windowColor = new Color(240, 230, 120);
        }
        return this._windowColor;
    }

    public void setWindowColor(Color windowColor) {
        this._windowColor = windowColor;
    }

    public void reset() {
        this.defuse();
    }

    private static void setTimer(BubbleTimer timer) {
        BubbleHelpSingleton.timer = timer;
    }

    private static BubbleTimer getTimer() {
        if (timer == null) {
            BubbleHelpSingleton.setTimer(new BubbleTimer());
            timer.start();
        }
        return timer;
    }

    public void setDelay(int _delay) {
        this._delay = _delay;
    }

    public int getDelay() {
        return this._delay;
    }
}

