/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.util.JAXFrontProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class CollapsibleTitleBorder
extends TitledBorder {
    private Point _textLoc = new Point();
    private Rectangle _checkBoxRectangle;
    private Rectangle _optionalCheckBoxRectangle;
    private Rectangle _newBoxRectangle;
    private Rectangle _deleteBoxRectangle;
    private Rectangle _titelBoxRectangle;
    private boolean _isChecked;
    private boolean _useOptionalCheckBox;
    private boolean _isOptionalBoxChecked = true;
    private boolean _isOptional;
    private boolean _isEnabled = true;
    private float _captionIndent = 0.0f;
    private JLabel _arrowDownComponent;
    private JLabel _arrowUpComponent;
    private JLabel _selectedBoxComponent;
    private JLabel _selectedBoxComponentDisabled;
    private JLabel _unSelectedBoxComponent;
    private JLabel _unSelectedBoxComponentDisabled;
    private JLabel _newComponent;
    private JLabel _deleteComponent;
    public static final int DEFAULT_POSITION = 0;
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    public static final int DEFAULT_JUSTIFICATION = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    private static final int LEADING = 4;
    private static final int TRAILING = 5;
    protected static final int EDGE_SPACING = 2;
    protected static final int TEXT_SPACING = 2;
    protected static final int TEXT_INSET_H = 5;

    public CollapsibleTitleBorder(String title) {
        super(title);
    }

    public CollapsibleTitleBorder(String title, boolean isRecursive) {
        super(title);
    }

    public CollapsibleTitleBorder(String title, boolean isRecursive, float captionIndent) {
        super(title);
        this._captionIndent = captionIndent;
    }

    public CollapsibleTitleBorder(Border border) {
        super(border);
    }

    public CollapsibleTitleBorder(Border border, String title) {
        super(border, title);
    }

    public CollapsibleTitleBorder(Border border, String title, int titleJustification, int titlePosition) {
        super(border, title, titleJustification, titlePosition);
    }

    public CollapsibleTitleBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont) {
        super(border, title, titleJustification, titlePosition, titleFont);
    }

    public CollapsibleTitleBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
        super(border, title, titleJustification, titlePosition, titleFont, titleColor);
    }

    private static boolean computeIntersection(Rectangle dest, int rx, int ry, int rw, int rh) {
        int x1 = Math.max(rx, dest.x);
        int x2 = Math.min(rx + rw, dest.x + dest.width);
        int y1 = Math.max(ry, dest.y);
        int y2 = Math.min(ry + rh, dest.y + dest.height);
        dest.x = x1;
        dest.y = y1;
        dest.width = x2 - x1;
        dest.height = y2 - y1;
        return dest.width > 0 && dest.height > 0;
    }

    private JLabel getArrowDownComponent() {
        if (this._arrowDownComponent == null) {
            this._arrowDownComponent = new JLabel(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/arrowDown_9x6.gif"));
        }
        return this._arrowDownComponent;
    }

    private JLabel getArrowUpComponent() {
        if (this._arrowUpComponent == null) {
            this._arrowUpComponent = new JLabel(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/arrowUp_9x6.gif"));
        }
        return this._arrowUpComponent;
    }

    private JLabel getSelectedBoxComponent() {
        if (this._selectedBoxComponent == null) {
            this._selectedBoxComponent = new JLabel(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/selectedBox_15x15.jpg"));
        }
        return this._selectedBoxComponent;
    }

    private JLabel getSelectedBoxComponentDisabled() {
        if (this._selectedBoxComponentDisabled == null) {
            this._selectedBoxComponentDisabled = new JLabel(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/selectedBoxDisabled_15x15.jpg"));
        }
        return this._selectedBoxComponentDisabled;
    }

    private JLabel getUnSelectedBoxComponent() {
        if (this._unSelectedBoxComponent == null) {
            this._unSelectedBoxComponent = new JLabel(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/notSelectedBox_15x15.jpg"));
        }
        return this._unSelectedBoxComponent;
    }

    private JLabel getUnSelectedBoxComponentDisabled() {
        if (this._unSelectedBoxComponentDisabled == null) {
            this._unSelectedBoxComponentDisabled = new JLabel(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/notSelectedBoxDisabled_15x15.jpg"));
        }
        return this._unSelectedBoxComponentDisabled;
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    public boolean isInCheckBox(Point p) {
        return this._checkBoxRectangle.contains(p);
    }

    public boolean isInDeleteBox(Point p) {
        return this._deleteBoxRectangle.contains(p);
    }

    public boolean isInNewBox(Point p) {
        return this._newBoxRectangle.contains(p);
    }

    public boolean isInOptionalCheckBox(Point p) {
        if (this._optionalCheckBoxRectangle != null) {
            return this._optionalCheckBoxRectangle.contains(p);
        }
        return false;
    }

    public boolean isInTitelBox(Point p) {
        if (this._titelBoxRectangle != null) {
            return this._titelBoxRectangle.contains(p);
        }
        return false;
    }

    private static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    public boolean isOptional() {
        return this._isOptional;
    }

    public boolean isOptionalBoxChecked() {
        return this._isOptionalBoxChecked;
    }

    private int getCaptionIndent() {
        if (this._captionIndent > 0.0f) {
            return (int)this._captionIndent;
        }
        return 0;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Border border = this.getBorder();
        int checkBoxSize = 0;
        int optionalCheckBoxSize = 0;
        int spaceChecked = 0;
        int spaceOptionalBox = 0;
        if (this._isOptional) {
            checkBoxSize = 8;
            spaceChecked = 4;
        }
        if (this._useOptionalCheckBox) {
            optionalCheckBoxSize = 15;
            spaceOptionalBox = 0;
        }
        if (this.getTitle() == null || this.getTitle().equals("")) {
            if (border != null) {
                border.paintBorder(c, g, x, y, width, height);
            }
            return;
        }
        Rectangle grooveRect = new Rectangle(x + 2, y + 2, width - 4, height - 4);
        Font font = g.getFont();
        Color color = g.getColor();
        g.setFont(this.getFont(c));
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getHeight();
        int descent = fm.getDescent();
        int ascent = fm.getAscent();
        int stringWidth = fm.stringWidth(this.getTitle()) + checkBoxSize + spaceChecked + optionalCheckBoxSize + spaceOptionalBox;
        Insets insets = border != null ? border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
        int titlePos = this.getTitlePosition();
        switch (titlePos) {
            case 1: {
                int diff = ascent + descent + (Math.max(2, 4) - 2);
                grooveRect.y += diff;
                grooveRect.height -= diff;
                this._textLoc.y = grooveRect.y - (descent + 2);
                break;
            }
            case 0: 
            case 2: {
                int diff = Math.max(0, ascent / 2 + 2 - 2);
                grooveRect.y += diff;
                grooveRect.height -= diff;
                this._textLoc.y = grooveRect.y - descent + (insets.top + ascent + descent) / 2;
                break;
            }
            case 3: {
                this._textLoc.y = grooveRect.y + insets.top + ascent + 2;
                break;
            }
            case 4: {
                this._textLoc.y = grooveRect.y + grooveRect.height - (insets.bottom + descent + 2);
                break;
            }
            case 5: {
                grooveRect.height -= fontHeight / 2;
                this._textLoc.y = grooveRect.y + grooveRect.height - descent + (ascent + descent - insets.bottom) / 2;
                break;
            }
            case 6: {
                grooveRect.height -= fontHeight;
                this._textLoc.y = grooveRect.y + grooveRect.height + ascent + 2;
            }
        }
        switch (this.getTitleJustification()) {
            case 0: 
            case 1: {
                this._textLoc.x = grooveRect.x + 5 + insets.left;
                break;
            }
            case 3: {
                this._textLoc.x = grooveRect.x + grooveRect.width - (stringWidth + 5 + insets.right);
                break;
            }
            case 2: {
                this._textLoc.x = grooveRect.x + (grooveRect.width - stringWidth) / 2;
            }
        }
        int justification = this.getTitleJustification();
        if (CollapsibleTitleBorder.isLeftToRight(c)) {
            if (justification == 4 || justification == 0) {
                justification = 1;
            } else if (justification == 5) {
                justification = 3;
            }
        } else if (justification == 4 || justification == 0) {
            justification = 3;
        } else if (justification == 5) {
            justification = 1;
        }
        switch (justification) {
            case 1: {
                this._textLoc.x = grooveRect.x + 5 + insets.left;
                break;
            }
            case 3: {
                this._textLoc.x = grooveRect.x + grooveRect.width - (stringWidth + 5 + insets.right);
                break;
            }
            case 2: {
                this._textLoc.x = grooveRect.x + (grooveRect.width - stringWidth) / 2;
            }
        }
        if (this.getCaptionIndent() > this._textLoc.x) {
            this._textLoc.x = this.getCaptionIndent();
        }
        if (border != null) {
            if (titlePos == 2 || titlePos == 5) {
                Rectangle clipRect = new Rectangle();
                Rectangle saveClip = g.getClipBounds();
                clipRect.setBounds(saveClip);
                if (CollapsibleTitleBorder.computeIntersection(clipRect, x, y, this._textLoc.x, height)) {
                    g.setClip(clipRect);
                    border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                }
                clipRect.setBounds(saveClip);
                if (CollapsibleTitleBorder.computeIntersection(clipRect, this._textLoc.x + stringWidth, 0, width - stringWidth - this._textLoc.x, height)) {
                    g.setClip(clipRect);
                    border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                }
                clipRect.setBounds(saveClip);
                if (titlePos == 2) {
                    if (CollapsibleTitleBorder.computeIntersection(clipRect, this._textLoc.x, grooveRect.y + insets.top, stringWidth, height - grooveRect.y - insets.top)) {
                        g.setClip(clipRect);
                        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                    }
                } else if (CollapsibleTitleBorder.computeIntersection(clipRect, this._textLoc.x, y, stringWidth, height - insets.bottom - (height - grooveRect.height - grooveRect.y))) {
                    g.setClip(clipRect);
                    border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                }
                g.setClip(saveClip);
            } else {
                border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
            }
        }
        int _checkBoxX = this._textLoc.x + 2;
        int _checkBoxY = this._textLoc.y - 9;
        if (this._isOptional) {
            if (this._isChecked) {
                g.drawImage(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/arrowDown_9x6.gif").getImage(), _checkBoxX, _checkBoxY, null, this.getArrowDownComponent());
            } else {
                g.drawImage(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/arrowUp_9x6.gif").getImage(), _checkBoxX, _checkBoxY, null, this.getArrowUpComponent());
            }
        }
        int checkBoxLocX = 0;
        int checkBoxLoxY = 0;
        if (this._useOptionalCheckBox) {
            checkBoxLocX = this._textLoc.x + checkBoxSize + spaceChecked;
            checkBoxLoxY = this._textLoc.y - 12;
            if (this._isEnabled) {
                if (this._isOptionalBoxChecked) {
                    g.drawImage(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/selectedBox_15x15.jpg").getImage(), checkBoxLocX, checkBoxLoxY, Color.white, this.getSelectedBoxComponent());
                } else {
                    g.drawImage(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/notSelectedBox_15x15.jpg").getImage(), checkBoxLocX, checkBoxLoxY, Color.white, this.getUnSelectedBoxComponent());
                }
            } else if (this._isOptionalBoxChecked) {
                g.drawImage(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/selectedBoxDisabled_15x15.jpg").getImage(), checkBoxLocX, checkBoxLoxY, Color.white, this.getSelectedBoxComponentDisabled());
            } else {
                g.drawImage(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/notSelectedBoxDisabled_15x15.jpg").getImage(), checkBoxLocX, checkBoxLoxY, Color.white, this.getUnSelectedBoxComponentDisabled());
            }
        }
        int newLocX = this._textLoc.x + checkBoxSize + g.getFontMetrics().stringWidth(this.getTitle()) + 10;
        int deleteLocX = newLocX + 18;
        int recLoxY = _checkBoxY - 2;
        this._checkBoxRectangle = new Rectangle(_checkBoxX, _checkBoxY, 9, 6);
        this._optionalCheckBoxRectangle = new Rectangle(checkBoxLocX, checkBoxLoxY, optionalCheckBoxSize, optionalCheckBoxSize);
        this._newBoxRectangle = new Rectangle(newLocX, recLoxY, 16, 16);
        this._deleteBoxRectangle = new Rectangle(deleteLocX, recLoxY, 16, 16);
        String titel = this.getTitle();
        int titelH = (int)g.getFontMetrics().getStringBounds(titel, g).getHeight();
        int titelW = (int)g.getFontMetrics().getStringBounds(titel, g).getWidth();
        this._titelBoxRectangle = new Rectangle(this._textLoc.x + checkBoxSize + spaceChecked, y, titelW, titelH);
        g.setColor(this.getTitleColor());
        g.drawString(this.getTitle(), this._textLoc.x + checkBoxSize + spaceChecked + optionalCheckBoxSize + spaceOptionalBox, this._textLoc.y);
        g.setFont(font);
        g.setColor(color);
    }

    public void setChecked(boolean checked) {
        this._isChecked = checked;
    }

    public boolean isChecked() {
        return this._isChecked;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            super.setTitleColor(Color.black);
        } else {
            super.setTitleColor(Color.gray);
        }
        this._isEnabled = enabled;
    }

    public void setOptional(boolean optional) {
        this._isOptional = optional;
    }

    public void setOptionalBoxChecked(boolean checked) {
        this._isOptionalBoxChecked = checked;
    }

    public void setUseOptionalCheckBox(boolean checked) {
        this._useOptionalCheckBox = checked;
    }

    public boolean useOptionalCheckBox() {
        return this._useOptionalCheckBox;
    }
}

