/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.type.SimpleGroup;
import com.jaxfront.core.type.SimpleGroupList;
import com.jaxfront.core.type.SimpleTypeList;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.ListVisualizer;
import com.jaxfront.core.ui.TabbableView;
import com.jaxfront.core.ui.TreeNode;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.xui.StyleDefinition;
import com.jaxfront.swing.ui.editor.AbstractEditorPanel;
import com.jaxfront.swing.ui.editor.TypeWorkspace;
import com.jaxfront.swing.ui.tools.FunctionalPanel;
import com.jaxfront.swing.ui.tools.GUITools;
import com.jaxfront.swing.ui.tools.Scrolling;
import com.jaxfront.swing.ui.visualizers.AbstractView;
import com.jaxfront.swing.ui.visualizers.ComplexGroupView;
import com.jaxfront.swing.ui.visualizers.SimpleGroupView;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class FocusHelper {
    public static void focus(Type source) {
        FocusHelper.focus(source, null);
    }

    public static void focus(Type source, Type context) {
        FocusHelper.focus(source, context, true);
    }

    public static Visualizer getErrorVisualizer(List path) {
        Type currentType = (Type)path.get(path.size() - 1);
        Type parentType = (Type)path.get(path.size() - 2);
        Visualizer visualizer = FocusHelper.evaluteBestMatchingVisualizer(parentType, currentType);
        return visualizer;
    }

    public static Visualizer evaluteBestMatchingVisualizer(Type parentType, Type aType) {
        Vector vis;
        Visualizer visualizer = null;
        Type possibleContext = null;
        if (parentType != null) {
            possibleContext = parentType;
        }
        if ((vis = TypeVisualizerFactory.getInstance().getAllVisualizers(aType)).size() == 0) {
            vis.add(TypeVisualizerFactory.getInstance().getVisualizer(aType));
        }
        for (int v = 0; v < vis.size(); ++v) {
            visualizer = (Visualizer)vis.get(v);
            Type visContext = visualizer.getContext();
            if (possibleContext != null && possibleContext.equals(visContext)) break;
            visualizer = (Visualizer)vis.get(0);
        }
        return visualizer;
    }

    public static Type getLastVisibleTreeNode(List path, AbstractEditorPanel editor) {
        Type lastVisibleTreeType = null;
        for (int i = 0; i < path.size(); ++i) {
            TreeNode currentNode;
            Type currentType = (Type)path.get(i);
            if (!currentType.getDOM().getGlobalDefinition().isShowingTree() || editor.getNavigationTree() == null || !currentType.isRepresentedAsTreeNode() || (currentNode = editor.getNavigationTree().getNode(currentType)) == null) continue;
            lastVisibleTreeType = currentType;
        }
        return lastVisibleTreeType;
    }

    public static void selectViewPathTypes(List path, AbstractEditorPanel editor, AbstractView errorView, boolean openDialog) {
        Type lastVisibleTreeType = FocusHelper.getLastVisibleTreeNode(path, editor);
        Vector<JDialog> dialogsToSetModal = new Vector<JDialog>();
        for (int i = 0; i < path.size(); ++i) {
            TreeNode currentNode;
            Type currentType = (Type)path.get(i);
            Type childType = null;
            if (i + 1 < path.size()) {
                childType = (Type)path.get(i + 1);
            }
            Visualizer visualizer = null;
            Vector vis = TypeVisualizerFactory.getInstance().getAllVisualizers(currentType);
            if (vis.size() == 0) {
                vis.add(TypeVisualizerFactory.getInstance().getVisualizer(currentType));
            }
            for (int v = 0; v < vis.size(); ++v) {
                visualizer = (Visualizer)vis.get(0);
                FocusHelper.expandBorderPanel((AbstractView)visualizer, true);
            }
            if (lastVisibleTreeType == currentType && (currentNode = editor.getNavigationTree().getNode(currentType)) != null) {
                editor.selectNode(currentNode);
            }
            if (childType == null) continue;
            StyleDefinition currentStyle = currentType.getXUIDefinition().getStyle();
            if (currentStyle.isUsingTab()) {
                Vector alVis = TypeVisualizerFactory.getInstance().getAllVisualizers(currentType);
                if (alVis.size() == 0) {
                    alVis.add(TypeVisualizerFactory.getInstance().getVisualizer(currentType));
                }
                for (int vJ = 0; vJ < alVis.size(); ++vJ) {
                    ComplexGroupView acView;
                    Visualizer aTabVis = ((Visualizer)alVis.get(vJ)).getImplementation();
                    if (aTabVis instanceof ComplexGroupView) {
                        acView = (ComplexGroupView)aTabVis;
                        acView.setSelectedTab(childType);
                        continue;
                    }
                    if (!(aTabVis instanceof TabbableView)) continue;
                    acView = (TabbableView)aTabVis;
                    JComponent tabComponent = (JComponent)TypeVisualizerFactory.getInstance().getVisualizer(childType);
                    acView.showTab(childType, tabComponent);
                }
                continue;
            }
            if (currentType.getTypeClassification() == 65) {
                Visualizer aView = TypeVisualizerFactory.getInstance().getVisualizer(currentType).getImplementation();
                if (!(aView instanceof SimpleGroupView)) continue;
                ((SimpleGroupView)aView).focus(childType);
                continue;
            }
            if (!currentType.isList() || currentType.getTypeClassification() == 128) continue;
            Vector allVisualizers = TypeVisualizerFactory.getInstance().getAllVisualizers(currentType);
            ListVisualizer listItemView = null;
            if (allVisualizers.size() == 0) {
                allVisualizers.add(TypeVisualizerFactory.getInstance().getVisualizer(currentType));
            }
            if (currentType.getXUIDefinition(false) != null && currentType.getXUIDefinition().getStyle().isUsingTableList()) {
                for (int av = 0; av < allVisualizers.size(); ++av) {
                    listItemView = (ListVisualizer)allVisualizers.get(av);
                    listItemView.selectType(childType, true);
                }
            }
            if (!currentStyle.hasHeader() || !currentStyle.getTableInfo().isDialogEditMode()) continue;
            if (currentType.getDOM().getGlobalDefinition().isShowingTree() && editor.getNavigationTree() != null && currentType.isRepresentedAsTreeNode() && currentStyle.isSelfViewHolder()) {
                openDialog = false;
            }
            if (!openDialog) continue;
            JDialog dialog = listItemView.getEditDialog(childType, childType);
            Component focusableComponent = errorView.getFirstFocusableComponent();
            if (focusableComponent != null) {
                focusableComponent.requestFocus();
            }
            if (dialog.isModal()) {
                dialogsToSetModal.add(dialog);
                dialog.setModal(false);
            }
            dialog.setVisible(true);
        }
        for (int dis = dialogsToSetModal.size() - 1; dis >= 0; --dis) {
            JDialog adialog = (JDialog)dialogsToSetModal.get(dis);
            adialog.setVisible(false);
            adialog.setModal(true);
            adialog.setVisible(true);
        }
    }

    public static void scrollTo(AbstractView errorView, TypeWorkspace workspace) {
        if (errorView != null) {
            errorView.focusFirstComponent(false);
            if (errorView.isVisible()) {
                JViewport view;
                Rectangle compRect = GUITools.getComponentPositionRelativeToFrame(errorView);
                if (compRect != null && !Scrolling.isVisible(view = workspace.getScrollPane().getViewport(), compRect)) {
                    if (compRect.y == 0) {
                        compRect.y = -view.getViewPosition().y;
                    }
                    view.scrollRectToVisible(compRect);
                }
                errorView.focusComponent(errorView);
            }
        }
    }

    public static void expandBorderPanel(AbstractView view, boolean expanded) {
        if (view != null) {
            FunctionalPanel borderPanel;
            AbstractView viewImplementation = (AbstractView)view.getImplementation();
            if (view.getBorderPanel() != null) {
                view.getBorderPanel().setExpandState(expanded);
            }
            if (view.getImplementation() != null && viewImplementation instanceof AbstractView && (borderPanel = viewImplementation.getBorderPanel()) != null) {
                borderPanel.setExpandState(expanded);
            }
        }
    }

    public static AbstractView evaluateErrorView(Type source, Type context) {
        boolean wasBlocked = source.getDOM().getUndoManager().isBlocked();
        source.getDOM().getUndoManager().blockInput(true);
        AbstractView errorView = null;
        Vector visualizers = TypeVisualizerFactory.getInstance().getAllVisualizers(source);
        if (visualizers.size() > 0) {
            errorView = (AbstractView)visualizers.get(0);
        } else {
            if (source instanceof SimpleGroup && source.getParent() != null && source.getParent() instanceof SimpleGroupList || source.getParent() instanceof SimpleTypeList) {
                source = source.getParent();
            }
            errorView = (AbstractView)TypeVisualizerFactory.getInstance().getFirstCachedVisualizer(source);
        }
        if (errorView == null) {
            errorView = (AbstractView)TypeVisualizerFactory.getInstance().getVisualizer(source);
        }
        if (!wasBlocked) {
            source.getDOM().getUndoManager().blockInput(false);
        }
        return errorView;
    }

    public static void focus(Type source, Type context, boolean openDialog) {
        if (!source.isReleased()) {
            final Type aSourceF = source;
            final Type aContextF = context;
            final boolean openDialogF = openDialog;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FocusHelper.focusNew(aSourceF, aContextF, openDialogF);
                }
            });
        }
    }

    public static void focusSync(Type source, Type context, boolean openDialog) {
        if (!source.isReleased()) {
            FocusHelper.focusNew(source, context, openDialog);
        }
    }

    public static void focusNew(Type source, Type context, boolean openDialog) {
        TypeWorkspace workspace;
        AbstractEditorPanel editor;
        if (!source.isReleased() && (editor = (AbstractEditorPanel)source.getDOM().getEditor()) != null && editor.getWorkspace() != null && (workspace = editor.getWorkspace()) != null) {
            workspace = editor.getWorkspace();
            List path = DOMHelper.vizualizerSelectorTypePathForFocus((Type)source);
            AbstractView errorView = FocusHelper.evaluateErrorView(source, context);
            editor.setIsSelectingTreeNode(true);
            FocusHelper.selectViewPathTypes(path, editor, errorView, openDialog);
            FocusHelper.setBorderPanelStates(errorView, true);
            FocusHelper.scrollTo(errorView, workspace);
            editor.setIsSelectingTreeNode(false);
        }
    }

    public static void setBorderPanelStates(AbstractView errorView, boolean expanded) {
        if (errorView != null) {
            FunctionalPanel borderPanel;
            Visualizer viewImplementation = errorView.getImplementation();
            if (errorView.getBorderPanel() != null) {
                errorView.getBorderPanel().setExpandState(expanded);
            }
            if (errorView.getImplementation() != null && viewImplementation instanceof AbstractView && (borderPanel = ((AbstractView)viewImplementation).getBorderPanel()) != null) {
                borderPanel.setExpandState(expanded);
            }
            if (viewImplementation != null && viewImplementation.getModel() != null && !viewImplementation.getModel().isReleased()) {
                Type tableViewType = viewImplementation.getModel().getViewContextType();
                Type parent = null;
                parent = tableViewType != null ? tableViewType : viewImplementation.getModel().getParent();
                if (parent != null) {
                    Vector visualizers = TypeVisualizerFactory.getInstance().getAllVisualizers(parent);
                    for (int v = 0; v < visualizers.size(); ++v) {
                        Visualizer parentVisualizer = (Visualizer)visualizers.get(v);
                        if (parentVisualizer == null) continue;
                        FocusHelper.setBorderPanelStates((AbstractView)parentVisualizer, expanded);
                    }
                }
            }
        }
    }
}

