/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.swing.ui.tools.Label2D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.util.Hashtable;

public class FontTools {
    private static Hashtable _fonts = new Hashtable();
    private static Font _defaultFont;
    public static final Font PLAINFONT;
    public static final Font BOLDFONT;

    public static Font evaluateDefaultFont() {
        String operatingSystem = System.getProperty("os.name");
        if (operatingSystem != null && operatingSystem.toLowerCase().startsWith("windows")) {
            Font f = FontTools.getFont("Tahoma");
            if (f == null) {
                f = FontTools.getFont("Verdana");
            }
            if (f == null) {
                f = FontTools.getFont("Arial");
            }
            if (f == null) {
                return new Font("sansserif", 0, 11);
            }
            if (f == null) {
                return new Font("Dialog", 0, 12);
            }
            return f.deriveFont(0, 11.0f);
        }
        Font f = FontTools.getFont("Helvetica");
        if (f == null) {
            f = FontTools.getFont("Lucida");
        }
        if (f == null) {
            return new Font("sansserif", 0, 11);
        }
        if (f == null) {
            return new Font("Dialog", 0, 12);
        }
        return f.deriveFont(0, 11.0f);
    }

    public static Font getBoldFont(float size) {
        return BOLDFONT.deriveFont(size);
    }

    public static Font getDefaultFont() {
        return _defaultFont;
    }

    public static Font getFont(String fontName) {
        return (Font)_fonts.get(fontName.toLowerCase());
    }

    public static Font getFont(String fontName, float size) {
        Font f = FontTools.getFont(fontName);
        if (f == null) {
            f = FontTools.evaluateDefaultFont();
        }
        return f.deriveFont(size);
    }

    public static Font getFont(String fontname, int style, float size) {
        Font f = FontTools.getFont(fontname);
        if (f == null) {
            f = _defaultFont;
        }
        return f.deriveFont(style, size);
    }

    public static Font getPlainFont(float size) {
        return PLAINFONT.deriveFont(size);
    }

    public static void main(String[] args) {
        Frame f = new Frame("FontTools | Test");
        Label2D a = new Label2D("On the 8th day God started debugging");
        Label2D b = new Label2D("On the 8th day God started debugging");
        Label2D c = new Label2D("On the 8th day God started debugging");
        a.setBackground(new Color(0x990033));
        b.setBackground(new Color(0x330099));
        a.setForeground(Color.white);
        b.setForeground(Color.white);
        a.setAntialias(true);
        b.setAntialias(true);
        c.setAntialias(true);
        a.setFont(FontTools.getFont("GoodDogPlain", 3, 36.0f));
        b.setFont(FontTools.getFont("Staccato 222 BT", 0, 36.0f));
        c.setFont(FontTools.getDefaultFont());
        f.setLayout(new BorderLayout());
        f.setBackground(Color.lightGray);
        f.add((Component)a, "North");
        f.add((Component)b, "Center");
        f.add((Component)c, "South");
        f.setLocation(200, 200);
        f.setSize(400, 300);
        f.show();
    }

    public static void registerFont(String name, Font font) {
        _fonts.put(name, font);
    }

    public static void setDefaultFont(Font font) {
        if (font != null) {
            _defaultFont = font;
        }
    }

    public static void setFont(Container c) {
        FontTools.setFont(c, FontTools.getDefaultFont());
    }

    public static void setFont(Container c, Font f) {
        int comps = c.getComponentCount();
        for (int i = 0; i < comps; ++i) {
            Component comp = c.getComponent(i);
            comp.setFont(f);
            if (!(comp instanceof Container)) continue;
            FontTools.setFont((Container)comp, f);
        }
    }

    static {
        Font[] fontlist = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i = 0; i < fontlist.length; ++i) {
            FontTools.registerFont(fontlist[i].getName().toLowerCase(), fontlist[i]);
        }
        PLAINFONT = _defaultFont = FontTools.evaluateDefaultFont();
        BOLDFONT = _defaultFont.deriveFont(1);
    }
}

