/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.log.LogRegistry;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public class GenericAction
extends AbstractAction {
    private Object _controller;
    private String _functionName = "";
    private Object _param;
    private static ActionEvent actionEvent;

    private GenericAction(String actionName, Object aController) {
        this(actionName, aController, null);
    }

    public GenericAction(String actionName, Object controller, String funcName) {
        this(actionName, controller, funcName, null, null);
    }

    public GenericAction(String actionName, Object controller, String funcName, Object param, Icon icon) {
        super(actionName, icon);
        this._controller = controller;
        this._functionName = funcName;
        this._param = param;
    }

    public void actionPerformed(ActionEvent ev) {
        Object controller = this.getController();
        Method function = null;
        Class<?> c = controller.getClass();
        try {
            Class[] parameterTypes;
            if (this._param == null) {
                parameterTypes = new Class[]{};
                function = c.getMethod(this._functionName, parameterTypes);
            } else {
                parameterTypes = new Class[]{this._param.getClass()};
                function = c.getMethod(this._functionName, parameterTypes);
            }
        }
        catch (NoSuchMethodException e) {
            LogRegistry.getInstance().warn(this.getClass(), "NoSuchMethodException: Unable to call method (" + this._functionName + ") on objet (" + controller.getClass().getName() + ").");
            return;
        }
        catch (SecurityException s) {
            LogRegistry.getInstance().warn(this.getClass(), "SecurityException: Unable to call method (" + this._functionName + ") on objet (" + controller.getClass().getName() + ").");
            return;
        }
        try {
            Object[] args;
            if (this._param == null) {
                args = new Object[]{};
                function.invoke(controller, args);
            } else {
                args = new Object[]{this._param};
                function.invoke(controller, args);
            }
        }
        catch (IllegalAccessException e1) {
            LogRegistry.getInstance().warn(this.getClass(), e1.toString() + ": Unable to call method (" + this._functionName + ") on objet (" + controller.getClass().getName() + ").");
        }
        catch (IllegalArgumentException e2) {
            LogRegistry.getInstance().warn(this.getClass(), e2.toString() + ": Unable to call method (" + this._functionName + ") on objet (" + controller.getClass().getName() + ").");
        }
        catch (InvocationTargetException e3) {
            LogRegistry.getInstance().warn(this.getClass(), e3.toString() + ": Unable to call method (" + this._functionName + ") on objet (" + controller.getClass().getName() + ").");
        }
    }

    public static ActionEvent getActionEvent() {
        return actionEvent;
    }

    protected Object getController() {
        return this._controller;
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public static void setActionEvent(ActionEvent newActionEvent) {
        actionEvent = newActionEvent;
    }
}

