/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.VirtualType;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.io.BrowserControl;
import com.jaxfront.core.xui.XUIDefinition;
import com.jaxfront.swing.ui.tools.FontFactory;
import com.jaxfront.swing.ui.tools.FunctionalGraphics;
import com.jaxfront.swing.ui.tools.GUITools;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class HeaderPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private Type _type;
    private String _headerTitle;
    private String _httpURL;
    private String _toolTipText;
    private int _separator;
    private int _textIndent = 0;
    private Font _textFont;
    private int _insetHeight = 20;
    private Color _textColor;
    private Color _startColor;
    private Color _endColor;
    private int _topSpacing;
    private int _bottomSpacing;
    private boolean _popupEnabled = true;
    private boolean _listenerInitialized = false;
    private ImageIcon _imageIcon;
    private JPopupMenu _popUpMenu;
    public static final int SEPARATOR_NONE = 0;
    public static final int SEPARATOR_CLASSIC = 1;
    public static final int SEPARATOR_MODERN = 2;
    public static final int SEPARATOR_VERTICAL = 3;
    private Action _copyContentAction;
    private Action _pasteContentAction;
    private FunctionalGraphics _funcGrap = null;

    public HeaderPanel(String text) {
        this(text, 2, Color.yellow, Color.black, Color.lightGray);
    }

    public HeaderPanel(String name, int separator) {
        this(name, 2, (Color)UIManager.getDefaults().get("TitledBorder.titleColor"), Color.black, Color.lightGray, separator);
    }

    public HeaderPanel(String text, int height, int topSpacing, int bottomSpacing, Color textColor, Color startColor, Color endColor, int separator) {
        this(null, text, height, topSpacing, bottomSpacing, textColor, startColor, endColor, separator, null);
    }

    public HeaderPanel(Type type, String text, int height, int topSpacing, int bottomSpacing, Color textColor, Color startColor, Color endColor, int separator) {
        this(type, text, height, topSpacing, bottomSpacing, textColor, startColor, endColor, separator, null);
    }

    public HeaderPanel(Type type, String text, int height, int topSpacing, int bottomSpacing, Color textColor, Color startColor, Color endColor, int separator, Font textFont) {
        this(type, text, height, topSpacing, bottomSpacing, textColor, startColor, endColor, separator, textFont, null);
    }

    public HeaderPanel(Type type, String text, int height, int topSpacing, int bottomSpacing, Color textColor, Color startColor, Color endColor, int separator, Font textFont, ImageIcon imageIcon) {
        this(type, text, height, topSpacing, bottomSpacing, textColor, startColor, endColor, separator, textFont, imageIcon, true);
    }

    public HeaderPanel(Type type, String text, int height, int topSpacing, int bottomSpacing, Color textColor, Color startColor, Color endColor, int separator, Font textFont, ImageIcon imageIcon, boolean enableCopyPastePopup) {
        this._type = type;
        this._headerTitle = text;
        this._insetHeight = height;
        this._topSpacing = topSpacing;
        this._bottomSpacing = bottomSpacing;
        this.setTextColor(textColor);
        this._startColor = startColor;
        this._endColor = endColor;
        this._separator = separator;
        this.setFont(textFont);
        this._imageIcon = imageIcon;
        this.setPopupMenuEnabled(enableCopyPastePopup);
        this.checkFormulaNLS();
    }

    public HeaderPanel(String text, int height, int topSpacing, int bottomSpacing, Color textColor, ImageIcon imageIcon) {
        this(null, text, height, topSpacing, bottomSpacing, textColor, null, null, 0, (Font)UIManager.getDefaults().get("Label.font"), imageIcon);
    }

    public HeaderPanel(Type type, String text, int height, int topSpacing, int bottomSpacing, Color textColor, ImageIcon imageIcon) {
        this(type, text, height, topSpacing, bottomSpacing, textColor, null, null, 0, (Font)UIManager.getDefaults().get("Label.font"), imageIcon);
    }

    public HeaderPanel(String name, int height, Color textColor, Color startColor, Color endColor) {
        this(name, height, 1, 1, textColor, startColor, endColor, 0);
    }

    public HeaderPanel(String text, int height, Color textColor, Color startColor, Color endColor, int separator) {
        this(text, height, 1, 1, textColor, startColor, endColor, separator);
    }

    public Dimension getPreferredSize() {
        int additionalSpace = 0;
        int iconHeight = 0;
        if (this._separator == 1) {
            additionalSpace = 4;
        } else if (this._separator == 2) {
            additionalSpace = 2;
        }
        if (this._imageIcon != null) {
            iconHeight = this._imageIcon.getIconHeight();
        }
        if (this._separator == 3) {
            return new Dimension(5, super.getHeight());
        }
        return new Dimension(0, this._bottomSpacing + this._topSpacing + this._insetHeight + additionalSpace + iconHeight);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        HeaderPanel headerPanel = new HeaderPanel("HEADER 1", 10, 0, 0, Color.yellow, Color.black, Color.lightGray, 1);
        AbstractAction serializeTrueAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
            }
        };
        serializeTrueAction.putValue("SmallIcon", JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/redBall.gif"));
        serializeTrueAction.putValue("Name", "Set Serializable");
        headerPanel.getFunctionalGrapics().addBorderAction(serializeTrueAction, 0);
        headerPanel.getFunctionalGrapics().addBorderAction(serializeTrueAction, 0);
        p.add(headerPanel);
        p.add(new JTextField());
        HeaderPanel headerPanel2 = new HeaderPanel("HEADER 2", 10, 30, 10, Color.yellow, Color.black, Color.lightGray, 0);
        headerPanel2.getFunctionalGrapics().addBorderAction(serializeTrueAction, 0);
        p.add(headerPanel2);
        try {
            HeaderPanel headerPanel3 = new HeaderPanel("Image Test", 100, 0, 0, Color.yellow, new ImageIcon(new File("c:/temp/jaxfront.gif").toURL()));
            headerPanel3.getFunctionalGrapics().addBorderAction(serializeTrueAction, 0);
            p.add(headerPanel3);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        f.getContentPane().add(p);
        f.pack();
        GUITools.centerWindow(f);
        f.show();
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setFont(this.getFont());
        g.setColor(this.getTextColor());
        switch (this._separator) {
            case 0: {
                if (this._imageIcon == null) {
                    this.paintHorizontal(g);
                    break;
                }
                this.paintImage(g);
                break;
            }
            case 1: {
                this.paintClassic(g);
                break;
            }
            case 2: {
                this.paintModern(g);
                break;
            }
            case 3: {
                this.paintVertical(g);
            }
        }
        if (this._funcGrap != null) {
            this._funcGrap.paint(g, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    public void paintHorizontal(Graphics g) {
        int x = 2;
        int titleY = this._insetHeight > 0 ? this._insetHeight + this._topSpacing : g.getFontMetrics().getHeight();
        GUITools.drawHorizontalGradient(g, this._startColor, this._endColor, 0, 0 + this._topSpacing, this.getSize().width, this._insetHeight);
        if (this.getHeaderTitle() != null) {
            if (titleY <= 0) {
                titleY = this.getFont().getSize() + this._topSpacing;
            }
            int indent = (this.getSize().height - this.getFont().getSize()) / 2;
            g.setColor(this.getTextColor());
            this.drawText(g, this.getHeaderTitle(), x, this.getFont().getSize() + indent);
        }
    }

    public void drawText(Graphics g, String text, int x, int y) {
        if (this._funcGrap != null) {
            x = this._funcGrap.getTextInsetHorizontal();
        }
        g.drawString(this.getHeaderTitle(), x + this._textIndent, y);
    }

    public void setTextIndent(int indent) {
        this._textIndent = indent;
    }

    public void paintImage(Graphics g) {
        g.setColor(this.getTextColor());
        int titleY = this._insetHeight > 0 ? this._insetHeight + this._topSpacing : g.getFontMetrics().getHeight();
        GUITools.drawHorizontalGradient(g, this._startColor, this._endColor, 0, 0 + this._topSpacing, this.getSize().width, this._imageIcon.getIconHeight());
        GUITools.drawImage(g, this._imageIcon, 0, this._topSpacing);
        if (this.getHeaderTitle() != null) {
            if (titleY <= 0) {
                titleY = this.getFont().getSize() + this._topSpacing;
            }
            int indent = (this.getSize().height - this.getFont().getSize()) / 2;
            g.setColor(this.getTextColor());
            this.drawText(g, this.getHeaderTitle(), 2, this.getFont().getSize() + indent);
        }
    }

    public void paintVertical(Graphics g) {
        int titleY = this._insetHeight > 0 ? this._insetHeight + this._topSpacing : g.getFontMetrics().getHeight();
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        if (this.getHeaderTitle() != null) {
            if (titleY <= 0) {
                titleY = this.getFont().getSize() + this._topSpacing;
            }
            g.setColor(this.getTextColor());
            this.drawText(g, this.getHeaderTitle(), 1, titleY);
        }
        x = this.getSize().width / 2;
        y = 0;
        w = this.getSize().width / 2;
        h = this.getSize().height;
        GUITools.drawGradient(g, Color.gray, Color.white, x, y, w, h);
    }

    public void paintClassic(Graphics g) {
        int titleY = this._insetHeight > 0 ? this._insetHeight : g.getFontMetrics().getHeight();
        int indent = (this.getSize().height - this.getFont().getSize()) / 2;
        int h = 2;
        int x = 2;
        if (this.getHeaderTitle() != null) {
            if (titleY <= 0) {
                titleY = this.getFont().getSize();
            }
            titleY = this.getFont().getSize() + indent;
            g.setColor(this.getTextColor());
            this.drawText(g, this.getHeaderTitle(), 2, titleY);
        }
        int gradientY = titleY + 2;
        GUITools.drawHorizontalGradient(g, this._startColor, this._endColor, x, gradientY, this.getSize().width, h);
    }

    public void paintModern(Graphics g) {
        int titleY = this._insetHeight > 0 ? this._insetHeight : g.getFontMetrics().getHeight();
        int indent = (this.getSize().height - this.getFont().getSize()) / 2;
        int h = 1;
        int x = 0;
        if (this.getHeaderTitle() != null) {
            if (titleY <= 0) {
                titleY = this.getFont().getSize();
            }
            titleY = this.getFont().getSize() + indent;
            g.setColor(this.getTextColor());
            this.drawText(g, this.getHeaderTitle(), 2, titleY);
            int headerWidth = g.getFontMetrics().stringWidth(this.getHeaderTitle());
            x = headerWidth + 3;
            if (this._funcGrap != null) {
                x += this._funcGrap.getTextInsetHorizontal();
            }
        }
        int gradientY = titleY - this.getFont().getSize() / 2 + h / 2;
        GUITools.drawHorizontalGradient(g, Color.gray, Color.gray, x, gradientY, this.getSize().width, h);
    }

    public void setHeaderTitle(String text) {
        this._headerTitle = text;
    }

    public String getHeaderTitle() {
        if (this._type != null && this._type.isVirtual()) {
            return ((VirtualType)this._type).getValue();
        }
        return this._headerTitle;
    }

    public void setLink(String linkURL) {
        this._httpURL = linkURL;
    }

    public void setToolTipText(String toolTipText) {
        this._toolTipText = toolTipText;
    }

    public void mouseClicked(MouseEvent e) {
        Object o = e.getSource();
        if (o instanceof HeaderPanel && this._httpURL != null) {
            BrowserControl.displayURL((String)this._httpURL);
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.setCursor(new Cursor(0));
    }

    public void mouseMoved(MouseEvent e) {
        Object o = e.getSource();
        if (o instanceof HeaderPanel) {
            if (this._httpURL != null) {
                this.setCursor(new Cursor(12));
            }
            super.setToolTipText(this._toolTipText);
        } else {
            this.setCursor(new Cursor(0));
            super.setToolTipText(null);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (((e.getModifiers() & 8) != 0 || (e.getModifiers() & 4) != 0) && this._type != null) {
            this.getPasteContentAction().setEnabled(this._type.getDOM().getClipBoard().canPaste(this._type, false));
            this.getPopUpMenu().show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    private JPopupMenu getPopUpMenu() {
        if (this._popUpMenu == null) {
            this._popUpMenu = new JPopupMenu("------");
            this._popUpMenu.add(new JMenuItem(this.getCopyContentAction()));
            this._popUpMenu.add(new JMenuItem(this.getPasteContentAction()));
        }
        return this._popUpMenu;
    }

    public void setPopupMenuEnabled(boolean enabled) {
        if (enabled) {
            this.initListener();
        } else {
            this.releaseListener();
        }
        this._popupEnabled = enabled;
    }

    public boolean isPopupMenuEnabled() {
        return this._popupEnabled;
    }

    private String getLanguage() {
        if (this._type != null) {
            return this._type.getDOM().getLanguage();
        }
        return null;
    }

    Action getCopyContentAction() {
        if (this._copyContentAction == null) {
            this._copyContentAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText(this.getLanguage(), "button_copy_content", "copy content"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/copy_16x16.gif")){

                public void actionPerformed(ActionEvent e) {
                    if (HeaderPanel.this._type != null) {
                        HeaderPanel.this._type.getDOM().getClipBoard().copy(HeaderPanel.this._type);
                    }
                }
            };
        }
        return this._copyContentAction;
    }

    Action getPasteContentAction() {
        if (this._pasteContentAction == null) {
            this._pasteContentAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText(this.getLanguage(), "button_paste_content", "paste content"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/pasteContent_16x16.gif")){

                public void actionPerformed(ActionEvent e) {
                    if (HeaderPanel.this._type != null) {
                        HeaderPanel.this._type.getDOM().getClipBoard().paste(HeaderPanel.this._type, null, false, false);
                        HeaderPanel.this._type.getDOM().validateKeyRefIntegrity(true);
                    }
                }
            };
        }
        return this._pasteContentAction;
    }

    public void setFont(Font textFont) {
        this._textFont = textFont;
    }

    public int getSeparatorType() {
        return this._separator;
    }

    public void releaseListener() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this._listenerInitialized = false;
    }

    public void initListener() {
        if (!this._listenerInitialized) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this._listenerInitialized = true;
        }
    }

    public Font getFont() {
        if (this._textFont == null) {
            this._textFont = this._separator == 1 ? FontFactory.getHeaderFontClassicDefinition().createFont() : (this._separator == 2 ? FontFactory.getHeaderFontModernDefinition().createFont() : FontFactory.getHeaderFontDefinition().createFont());
        }
        return this._textFont;
    }

    public void setInsetHeight(int height) {
        this._insetHeight = height;
    }

    public int getInsetHeight() {
        return this._insetHeight;
    }

    public void setTextColor(Color textColor) {
        this._textColor = textColor;
    }

    public void setStartColor(Color startColor) {
        this._startColor = startColor;
    }

    public Color getTextColor() {
        if (this._textColor == null) {
            this._textColor = (Color)UIManager.getDefaults().get("TitledBorder.titleColor");
        }
        return this._textColor;
    }

    private void checkFormulaNLS() {
        if (this._type != null && this._type.getDOM().getNLS().hasFormula(this._type, "caption", null)) {
            String formulaExpression = this._type.getDOM().getNLS().getFormula(this._type, "caption", null);
            FormulaExpression formula = new FormulaExpression(this._type, formulaExpression);
            VirtualType vt = new VirtualType(this._type);
            this._type = vt;
            vt.setFormulaExpression(formula);
            XUIDefinition xuiDefinition = new XUIDefinition((Type)vt, null);
            vt.setUIDefinition(xuiDefinition);
        }
    }

    public FunctionalGraphics getFunctionalGrapics() {
        if (this._funcGrap == null) {
            this._funcGrap = new FunctionalGraphics(this);
            this._funcGrap._imageYOffset = 6;
        }
        return this._funcGrap;
    }
}

