/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.TreePath;

public class OverlayListener
extends MouseInputAdapter {
    JTree tree;
    Component oldGlassPane;
    TreePath path;
    int row;
    Rectangle bounds;
    JComponent c = new JComponent(){

        public void paint(Graphics g) {
            boolean selected = OverlayListener.this.tree.isRowSelected(OverlayListener.this.row);
            Component renderer = OverlayListener.this.tree.getCellRenderer().getTreeCellRendererComponent(OverlayListener.this.tree, OverlayListener.this.path.getLastPathComponent(), OverlayListener.this.tree.isRowSelected(OverlayListener.this.row), OverlayListener.this.tree.isExpanded(OverlayListener.this.row), OverlayListener.this.tree.getModel().isLeaf(OverlayListener.this.path.getLastPathComponent()), OverlayListener.this.row, selected);
            OverlayListener.this.c.setFont(OverlayListener.this.tree.getFont());
            Rectangle paintBounds = SwingUtilities.convertRectangle(OverlayListener.this.tree, OverlayListener.this.bounds, this);
            SwingUtilities.paintComponent(g, renderer, this, paintBounds);
            if (selected) {
                return;
            }
            g.setColor(Color.blue);
            ((Graphics2D)g).draw(paintBounds);
        }
    };

    public OverlayListener(JTree tree) {
        this.tree = tree;
        tree.addMouseListener(this);
        tree.addMouseMotionListener(this);
    }

    public void mouseExited(MouseEvent e) {
        this.resetGlassPane();
    }

    private void resetGlassPane() {
        if (this.oldGlassPane != null) {
            this.c.setVisible(false);
            this.tree.getRootPane().setGlassPane(this.oldGlassPane);
            this.oldGlassPane = null;
        }
    }

    public void mouseMoved(MouseEvent me) {
        this.path = this.tree.getPathForLocation(me.getX(), me.getY());
        if (this.path == null) {
            this.resetGlassPane();
            return;
        }
        this.row = this.tree.getRowForPath(this.path);
        this.bounds = this.tree.getPathBounds(this.path);
        if (!this.tree.getVisibleRect().contains(this.bounds)) {
            if (this.tree.getRootPane() != null) {
                if (this.oldGlassPane == null) {
                    this.oldGlassPane = this.tree.getRootPane().getGlassPane();
                    this.c.setOpaque(false);
                    this.tree.getRootPane().setGlassPane(this.c);
                    this.c.setVisible(true);
                } else {
                    this.tree.getRootPane().repaint();
                }
            }
        } else {
            this.resetGlassPane();
        }
    }

    public static void main(String[] args) {
        JTree tree = new JTree();
        new OverlayListener(tree);
        JSplitPane split = new JSplitPane();
        split.setLeftComponent(new JScrollPane(tree));
        JFrame frame = new JFrame("TreeOverlay Test");
        frame.getContentPane().add(split);
        frame.setSize(300, 300);
        frame.setVisible(true);
    }

    public void release() {
        this.tree.removeMouseListener(this);
        this.tree.removeMouseMotionListener(this);
        this.tree = null;
    }
}

