/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.swing.ui.tools.FunctionalTitleBorder;
import com.jaxfront.swing.ui.tools.GenericAction;
import com.jaxfront.swing.ui.tools.TreeUtil;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class TypeTree
extends JTree {
    private FunctionalTitleBorder _functionalBorder;

    public TypeTree() {
        this((Type)null);
    }

    public TypeTree(Type container) {
        super(new Model());
        this.setRootVisible(false);
        this.setDocument(container);
        this.initBorder();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("count:" + TreeUtil.countNodes(this, (DefaultMutableTreeNode)this.getModel().getRoot()));
        ((DefaultTreeModel)this.getModel()).insertNodeInto(node, (MutableTreeNode)this.getModel().getRoot(), 0);
    }

    public void setDocument(Type container) {
        ((Model)this.getModel()).setDocument(container);
        this.expandRow(0);
    }

    public void release() {
        if (this.getFunctionalBorder() != null) {
            this.getFunctionalBorder().release();
        }
        this.setModel(null);
    }

    public Type getDocument() {
        return ((Model)this.getModel()).getDocument();
    }

    public Type getNode(Object treeNode) {
        return ((Model)this.getModel()).getNode(treeNode);
    }

    private void initBorder() {
        this.getFunctionalBorder().addBorderAction("collapse", (Action)new GenericAction("collapseAllNodes", this, "collapseAllNodes"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/collapse_16x16.gif").getImage(), "collapse all Reports beneath selection", 1);
        this.getFunctionalBorder().addBorderAction("expand", (Action)new GenericAction("expandAllNodes", this, "expandAllNodes"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/expand_16x16.gif").getImage(), "expand all Reports beneath selection", 1);
        this.getFunctionalBorder().addBorderActionSeparator(1);
        this.getFunctionalBorder().addBorderAction("search", (Action)new GenericAction("searchForNodes", this, "searchForNodes"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/search_16x16.gif").getImage(), "search all Reports for text", 1);
    }

    public void collapseAllNodes() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (node != null) {
            TreeUtil.collapseJTreeNode(this, node, -1);
        }
    }

    public void setBorderActionRootComponent(JComponent borderActionRoot) {
        borderActionRoot.setBorder(this.getFunctionalBorder());
        this.getFunctionalBorder().setRootComponent(borderActionRoot);
    }

    public FunctionalTitleBorder getFunctionalBorder() {
        if (this._functionalBorder == null) {
            this._functionalBorder = new FunctionalTitleBorder(BorderFactory.createEmptyBorder(), " ");
        }
        return this._functionalBorder;
    }

    public void expandAllNodes() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (node != null) {
            TreeUtil.expandJTreeNode((JTree)this, node, -1);
        }
    }

    public void searchForNodes() {
        TreeUtil.searchForNodes(this, this, "Component", "found Component");
    }

    public static class Model
    extends DefaultTreeModel
    implements Serializable {
        private Type document;
        private Hashtable nodeMap = new Hashtable();

        public Model() {
            this((Type)null);
        }

        public Model(Type container) {
            super(new DefaultMutableTreeNode());
            this.setDocument(container);
        }

        public synchronized void setDocument(Type container) {
            this.document = container;
            ((DefaultMutableTreeNode)this.getRoot()).removeAllChildren();
            this.nodeMap.clear();
            this.buildTree();
            this.fireTreeStructureChanged(this, new Object[]{this.getRoot()}, new int[0], new Object[0]);
        }

        public Type getDocument() {
            return this.document;
        }

        public Type getNode(Object treeNode) {
            return (Type)this.nodeMap.get(treeNode);
        }

        private void buildTree() {
            if (this.document == null) {
                return;
            }
            List nodes = this.document.getDirectChildren();
            int len = nodes != null ? nodes.size() : 0;
            MutableTreeNode root = (MutableTreeNode)this.getRoot();
            for (int i = 0; i < len; ++i) {
                Type node = (Type)nodes.get(i);
                this.insertComponentNode(node, root);
            }
        }

        private MutableTreeNode insertNode(String what, MutableTreeNode where) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(what);
            this.insertNodeInto(node, where, where.getChildCount());
            return node;
        }

        private MutableTreeNode insertAttributeNode(String what, MutableTreeNode where) {
            if (what.length() > 0) {
                MutableTreeNode treeNode = this.insertNode(what, where);
                this.nodeMap.put(treeNode, what);
                return treeNode;
            }
            return null;
        }

        private void insertComponentAttributes(Type what, MutableTreeNode where) {
            this.insertAttributeNode("XPATH:" + what.getXPathLocation(), where);
            this.insertAttributeNode("Type@isSerializable:" + what.isSerializable(), where);
            this.insertAttributeNode("Value:" + what.getDisplayValue(), where);
        }

        private MutableTreeNode insertComponentNode(Type what, MutableTreeNode where) {
            String name = what.getClass().getName();
            if (what.getName() != null) {
                name = what.getName() + " -> " + name;
            }
            MutableTreeNode element = this.insertNode(name.toString(), where);
            this.nodeMap.put(element, what);
            this.insertComponentAttributes(what, element);
            Vector<Type> children = null;
            if (what.isList() && ((ListType)what).getDirectChildren().size() == 0) {
                Vector<Type> editingTypeVec = new Vector<Type>();
                editingTypeVec.add(((ListType)what).getEditingType());
                children = editingTypeVec;
            } else {
                children = what.getDirectChildren();
            }
            int len = children != null ? children.size() : 0;
            for (int i = 0; i < len; ++i) {
                Type node = (Type)children.get(i);
                this.insertComponentNode(node, element);
            }
            return element;
        }

        public class UIUserObject {
            private String _visualName;
            private String _value;
            private String _xPath;
            private boolean showValue = true;

            public UIUserObject(String visualName, String value, String xpath) {
                this.setVisualName(visualName);
                this.setValue(value);
                this.setXPath(xpath);
            }

            public String toString() {
                if (this.isShowValue() && this.getValue() != null) {
                    return this.getVisualName() + " : " + this.getValue();
                }
                return this.getVisualName();
            }

            public void setValue(String value) {
                this._value = value;
            }

            public String getValue() {
                return this._value;
            }

            public void setVisualName(String visualName) {
                this._visualName = visualName;
            }

            public String getVisualName() {
                return this._visualName;
            }

            public void setXPath(String _xPath) {
                this._xPath = _xPath;
            }

            public String getXPath() {
                return this._xPath;
            }

            void setShowValue(boolean showValue) {
                this.showValue = showValue;
            }

            private boolean isShowValue() {
                return this.showValue;
            }
        }
    }
}

