/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.swing.ui.tools.FunctionalTitleBorder;
import com.jaxfront.swing.ui.tools.GenericAction;
import com.jaxfront.swing.ui.tools.TreeUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class UITree
extends JTree {
    private FunctionalTitleBorder _functionalBorder;

    public UITree() {
        this((Container)null);
    }

    public UITree(Container container) {
        super(new Model());
        this.setRootVisible(false);
        this.setDocument(container);
        this.initBorder();
    }

    public void setDocument(Container container) {
        ((Model)this.getModel()).setDocument(container);
        this.expandRow(0);
    }

    public void release() {
        if (this.getFunctionalBorder() != null) {
            this.getFunctionalBorder().release();
        }
        this.setModel(null);
    }

    public Container getDocument() {
        return ((Model)this.getModel()).getDocument();
    }

    public Container getNode(Object treeNode) {
        return ((Model)this.getModel()).getNode(treeNode);
    }

    private void initBorder() {
        this.getFunctionalBorder().addBorderAction("collapse", (Action)new GenericAction("collapseAllNodes", this, "collapseAllNodes"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/collapse_16x16.gif").getImage(), "collapse all Reports beneath selection", 1);
        this.getFunctionalBorder().addBorderAction("expand", (Action)new GenericAction("expandAllNodes", this, "expandAllNodes"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/expand_16x16.gif").getImage(), "expand all Reports beneath selection", 1);
        this.getFunctionalBorder().addBorderActionSeparator(1);
        this.getFunctionalBorder().addBorderAction("search", (Action)new GenericAction("searchForNodes", this, "searchForNodes"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/search_16x16.gif").getImage(), "search all Reports for text", 1);
    }

    public void collapseAllNodes() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (node != null) {
            TreeUtil.collapseJTreeNode(this, node, -1);
        }
    }

    public void setBorderActionRootComponent(JComponent borderActionRoot) {
        borderActionRoot.setBorder(this.getFunctionalBorder());
        this.getFunctionalBorder().setRootComponent(borderActionRoot);
    }

    public FunctionalTitleBorder getFunctionalBorder() {
        if (this._functionalBorder == null) {
            this._functionalBorder = new FunctionalTitleBorder(BorderFactory.createEmptyBorder(), " ");
        }
        return this._functionalBorder;
    }

    public void expandAllNodes() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (node != null) {
            TreeUtil.expandJTreeNode((JTree)this, node, -1);
        }
    }

    public void searchForNodes() {
        TreeUtil.searchForNodes(this, this, "Component", "found Component");
    }

    public static class Model
    extends DefaultTreeModel
    implements Serializable {
        private Container document;
        private Hashtable nodeMap = new Hashtable();

        public Model() {
            this((Container)null);
        }

        public Model(Container container) {
            super(new DefaultMutableTreeNode());
            this.setDocument(container);
        }

        public synchronized void setDocument(Container container) {
            this.document = container;
            ((DefaultMutableTreeNode)this.getRoot()).removeAllChildren();
            this.nodeMap.clear();
            this.buildTree();
            this.fireTreeStructureChanged(this, new Object[]{this.getRoot()}, new int[0], new Object[0]);
        }

        public Container getDocument() {
            return this.document;
        }

        public Container getNode(Object treeNode) {
            return (Container)this.nodeMap.get(treeNode);
        }

        private void buildTree() {
            if (this.document == null) {
                return;
            }
            Component[] nodes = this.document.getComponents();
            int len = nodes != null ? nodes.length : 0;
            MutableTreeNode root = (MutableTreeNode)this.getRoot();
            for (int i = 0; i < len; ++i) {
                Component node = nodes[i];
                if (node instanceof Container) {
                    this.insertContainerNode((Container)node, root);
                    continue;
                }
                this.insertComponentNode(node, root);
            }
        }

        private MutableTreeNode insertNode(String what, MutableTreeNode where) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(what);
            this.insertNodeInto(node, where, where.getChildCount());
            return node;
        }

        private MutableTreeNode insertAttributeNode(String what, MutableTreeNode where) {
            if (what.length() > 0) {
                MutableTreeNode treeNode = this.insertNode(what, where);
                this.nodeMap.put(treeNode, what);
                return treeNode;
            }
            return null;
        }

        private void insertComponentAttributes(Component what, MutableTreeNode where) {
            Rectangle bounds = what.getBounds();
            if (what instanceof Visualizer) {
                this.insertAttributeNode("@XPath:" + ((Visualizer)what).getModel().getXPathLocation(), where);
            }
            this.insertAttributeNode("@Bounds: X:" + bounds.getX() + " Y:" + bounds.getY() + " width:" + bounds.getWidth() + " height:" + bounds.getHeight(), where);
            Dimension dim = what.getPreferredSize();
            this.insertAttributeNode("@PreferredSize: width:" + dim.getWidth() + " height:" + dim.getHeight(), where);
            dim = what.getSize();
            this.insertAttributeNode("@Size: width:" + dim.getWidth() + " height:" + dim.getHeight(), where);
            dim = what.getMinimumSize();
            this.insertAttributeNode("@MinSize: width:" + dim.getWidth() + " height:" + dim.getHeight(), where);
            dim = what.getMaximumSize();
            this.insertAttributeNode("@MaxSize: width:" + dim.getWidth() + " height:" + dim.getHeight(), where);
            if (what instanceof Visualizer) {
                this.insertAttributeNode("Type@isSerializable:" + ((Visualizer)what).getModel().isSerializable(), where);
            }
            if (what instanceof Container && ((Container)what).getLayout() != null) {
                this.insertAttributeNode("@LayoutManager:" + ((Container)what).getLayout(), where);
            }
            if (what instanceof JComponent && ((JComponent)what).getBorder() != null) {
                this.insertAttributeNode("@Border:" + ((JComponent)what).getBorder(), where);
            }
        }

        private MutableTreeNode insertContainerNode(Container what, MutableTreeNode where) {
            String name = what.getClass().getName();
            if (what.getName() != null) {
                name = what.getName() + " -> " + name;
            }
            MutableTreeNode element = this.insertNode(name.toString(), where);
            this.nodeMap.put(element, what);
            this.insertComponentAttributes(what, element);
            Component[] children = what.getComponents();
            int len = children != null ? children.length : 0;
            for (int i = 0; i < len; ++i) {
                Component node = children[i];
                if (node instanceof Container) {
                    this.insertContainerNode((Container)node, element);
                    continue;
                }
                this.insertComponentNode(node, element);
            }
            return element;
        }

        private MutableTreeNode insertComponentNode(Component what, MutableTreeNode where) {
            String name = what.getClass().getName();
            if (what.getName() != null) {
                name = what.getName() + " -> " + name;
            }
            MutableTreeNode element = this.insertNode(name.toString(), where);
            this.nodeMap.put(element, what);
            this.insertComponentAttributes(what, element);
            return element;
        }

        public class UIUserObject {
            private String _visualName;
            private String _value;
            private String _xPath;
            private boolean showValue = true;

            public UIUserObject(String visualName, String value, String xpath) {
                this.setVisualName(visualName);
                this.setValue(value);
                this.setXPath(xpath);
            }

            public String toString() {
                if (this.isShowValue() && this.getValue() != null) {
                    return this.getVisualName() + " : " + this.getValue();
                }
                return this.getVisualName();
            }

            public void setValue(String value) {
                this._value = value;
            }

            public String getValue() {
                return this._value;
            }

            public void setVisualName(String visualName) {
                this._visualName = visualName;
            }

            public String getVisualName() {
                return this._visualName;
            }

            public void setXPath(String _xPath) {
                this._xPath = _xPath;
            }

            public String getXPath() {
                return this._xPath;
            }

            void setShowValue(boolean showValue) {
                this.showValue = showValue;
            }

            private boolean isShowValue() {
                return this.showValue;
            }
        }
    }
}

