/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMChangeListener;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.EmptyType;
import com.jaxfront.core.type.SimpleTypeList;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.EditablePanel;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.ImageHelper;
import com.jaxfront.core.util.XMLSchemaPositionSorter;
import com.jaxfront.core.xui.FormLayoutInfo;
import com.jaxfront.core.xui.StyleDefinition;
import com.jaxfront.swing.ui.layout.TabActionIcon;
import com.jaxfront.swing.ui.tools.FontFactory;
import com.jaxfront.swing.ui.tools.FormLayoutBuilder;
import com.jaxfront.swing.ui.visualizers.AbstractCompositeView;
import com.jaxfront.swing.ui.visualizers.AbstractView;
import com.jaxfront.swing.ui.visualizers.UIController;
import com.jaxfront.swing.ui.wrapper.JAXJButton;
import com.jaxfront.swing.ui.wrapper.JAXJTabbedPane;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;

public abstract class AbstractCompositeTabView
extends AbstractCompositeView {
    private JAXJTabbedPane _tabbedPane;

    public AbstractCompositeTabView() {
    }

    public AbstractCompositeTabView(Type context) {
        super(context);
    }

    public void actionPerformed(ActionEvent e) {
        Type selectedType = null;
        if (this.getModel().isAbstract() && this.getModel().isRequired() && selectedType != null) {
            this.resetError();
        }
        this.getModel().setChoosenType(selectedType);
        if (this.getEditor() != null) {
            this.getEditor().updateUI();
        }
    }

    protected void defaultBuild() {
        boolean isEditable;
        this.setName("mainVisualizerPanel");
        this._isInitializing = true;
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        JComponent itemVisualizer = null;
        CompositeType model = (CompositeType)this.getModel();
        StyleDefinition style = model.getStyle();
        Vector tempList = model.getComposites();
        Vector list = new Vector();
        JPanel compHolder = this.getComponentHolder();
        this._componentHolderTableLayout = new FormLayout("0:g(-1.0)", "p");
        compHolder.setLayout(this._componentHolderTableLayout);
        boolean isTabHolder = style.isTabHolder();
        if (model.isChoice()) {
            tempList = model.getAttributes();
        }
        if (model.isAbstract()) {
            tempList = new Vector();
        }
        if (this.isUsingTableLayout()) {
            this.applyTableLayout(compHolder);
            this.add((Component)compHolder, "Center");
        } else {
            if (isTabHolder) {
                this.getTabbedPane().addChangeListener(UIController.getInstance());
                this.getTabbedPane().addChangeListener(this);
            }
            list = tempList;
            int indexOfFirstVisibleItemVisualizer = -1;
            for (int i = 0; i < list.size(); ++i) {
                Visualizer visualizer;
                Type child = (Type)list.get(i);
                StyleDefinition childStyle = child.getStyle();
                boolean childVisible = childStyle.isVisible();
                boolean childVisibleAtRuntime = childStyle.isVisibleAtRuntime();
                itemVisualizer = null;
                if (!childVisible && !childVisibleAtRuntime) continue;
                if (indexOfFirstVisibleItemVisualizer == -1) {
                    indexOfFirstVisibleItemVisualizer = i;
                }
                if (!isTabHolder && !childStyle.isSelfViewHolder() && (visualizer = TypeVisualizerFactory.getInstance().getVisualizer(child, this._context)) instanceof JComponent) {
                    itemVisualizer = (JComponent)visualizer;
                }
                if (!(!isTabHolder || childStyle.isSelfViewHolder() && child.getDOM().getGlobalDefinition().isShowingTree() && child.getDOM().getRootType().isRepresentedAsTreeNode())) {
                    if (child.isSimple() || child instanceof SimpleTypeList && !child.getStyle().isUsingSerialList()) {
                        itemVisualizer = (JComponent)TypeVisualizerFactory.getInstance().getVisualizer(child, this._context);
                        this.getVisualizers().put(child, itemVisualizer);
                        this.addComponentToComponentHolder(compHolder, itemVisualizer);
                    } else if (childStyle.isVisibleInOptionalTreeMode()) {
                        this.addTab(child);
                    }
                } else if (itemVisualizer != null) {
                    this.getVisualizers().put(child.getName(), itemVisualizer);
                    this.addComponentToComponentHolder(compHolder, itemVisualizer, child);
                }
                if (i == indexOfFirstVisibleItemVisualizer && itemVisualizer != null) {
                    this.setFirstFocusableComponent(((AbstractView)itemVisualizer).getFirstFocusableComponent());
                }
                if (childStyle.isVisibleInOptionalTreeMode() || !child.isRepresentedAsTreeNode() || itemVisualizer == null) continue;
                itemVisualizer.setVisible(false);
            }
            if (style.isTabHolder()) {
                this.addComponentToComponentHolder(compHolder, this.getTabbedPane());
                if (this.getTabbedPane().getTabCount() > 0) {
                    this.getTabbedPane().setSelectedIndex(-1);
                    this.getTabbedPane().setSelectedIndex(0);
                } else {
                    this.getTabbedPane().setVisible(false);
                }
            }
            JComponent editorComponent = this._componentHolderTableLayout.getColumnCount() > 1 || this._componentHolderTableLayout.getRowCount() > 1 ? this.getCaptionPanel(compHolder) : compHolder;
            this.setParentTableLayout(this._componentHolderTableLayout);
            this.setParentTablePanel(compHolder);
            this.add((Component)editorComponent, "Center");
        }
        if (style.hasHint()) {
            String hintText = style.getHintText();
            Color color = style.getHintColor();
            boolean isFormula = style.isHintTextFormula();
            boolean isBold = style.isHintTextBold();
            this.showHint(hintText, isFormula, color, isBold);
        }
        if (!(isEditable = style.isEditable())) {
            this.setEditable(isEditable);
        }
        this._isInitializing = false;
    }

    public void addTab(Type type) {
        if (type != null && this.getTabIndex(type) == -1) {
            int index = 0;
            int topIndent = this.getDOM().getGlobalDefinition().getGlobalTopIndent();
            int bottomIndent = this.getDOM().getGlobalDefinition().getGlobalBottomIndent();
            int leftIndent = this.getDOM().getGlobalDefinition().getGlobalLeftIndent();
            int rightIndent = this.getDOM().getGlobalDefinition().getGlobalRightIndent();
            String columnSpec = "" + leftIndent + ",f:400px:g(100)," + rightIndent;
            String rowSpec = "" + topIndent + ",pref," + bottomIndent;
            FormLayout formLayout = new FormLayout(columnSpec, rowSpec);
            JPanel indentPanel = new JPanel(formLayout);
            indentPanel.setName("indentPanel");
            indentPanel.putClientProperty("TAB_TYPE", type);
            XMLSchemaPositionSorter sorter = new XMLSchemaPositionSorter(false);
            for (int a = 0; a < this.getTabbedPane().getTabCount(); ++a) {
                Type compareTabType = (Type)((JComponent)this.getTabbedPane().getComponentAt(a)).getClientProperty("TAB_TYPE");
                if (compareTabType == null) continue;
                boolean isGreater = sorter.compare((Object)compareTabType, (Object)type);
                if (!isGreater) {
                    index = a;
                    break;
                }
                if (a != this.getTabbedPane().getTabCount() - 1) continue;
                index = a + 1;
                break;
            }
            this._isInsertingTab = true;
            TabActionIcon icon = null;
            if (type.getDOM().getGlobalDefinition().isUserModfiedTabSerialization() && !type.isRequired()) {
                icon = this.getTabActionIcon(index);
            }
            this.getTabbedPane().insertTab(type.getStyle().getCaptionTitleLabel(), icon, indentPanel, null, index);
            this._isInsertingTab = false;
            if (!this._isInitializing) {
                this.getTabbedPane().setSelectedIndex(-1);
                this.getTabbedPane().setSelectedIndex(index);
            }
            this.getTabbedPane().setVisible(true);
        }
    }

    public TabActionIcon getTabActionIcon(int index) {
        boolean isEditable = this.getStyle().isHierarchyEnabled(this.getModel());
        Action tabAction = this.getSerializeTabAction();
        tabAction.putValue("tabIndex", new Integer(index));
        Action inverseAction = this.getNotSerializeTabAction();
        tabAction.setEnabled(isEditable);
        inverseAction.setEnabled(isEditable);
        TabActionIcon icon = new TabActionIcon(tabAction, inverseAction);
        return icon;
    }

    public Action getSerializeTabAction() {
        AbstractAction aAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AbstractCompositeTabView.this.getSelectedTabType().setSerializable(true);
                AbstractCompositeTabView.this.getSelectedTabType().setEditable(true);
                AbstractCompositeTabView.this.getModel().putClientProperty("userChangedSerialize", (Object)"true");
                AbstractCompositeTabView.this.getStyle().setApplicationRequired(true);
            }
        };
        aAction.putValue("SmallIcon", ImageHelper.getInstance().getImageIcon("com/jaxfront/core/images/files/serializeDelete.gif"));
        return aAction;
    }

    public Action getNotSerializeTabAction() {
        AbstractAction aAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AbstractCompositeTabView.this.getSelectedTabType().setSerializable(false);
                AbstractCompositeTabView.this.getSelectedTabType().setEditable(false);
                AbstractCompositeTabView.this.getModel().removeClientProperty("userChangedSerialize");
                AbstractCompositeTabView.this.getStyle().setApplicationRequired(false);
            }
        };
        aAction.putValue("SmallIcon", ImageHelper.getInstance().getImageIcon("com/jaxfront/core/images/files/serializeNew.gif"));
        return aAction;
    }

    private int getTabIndex(Type type) {
        int tabIndex = -1;
        for (int a = 0; a < this.getTabbedPane().getTabCount(); ++a) {
            Type tabType = (Type)((JComponent)this.getTabbedPane().getComponentAt(a)).getClientProperty("TAB_TYPE");
            if (tabType != type) continue;
            tabIndex = a;
            break;
        }
        return tabIndex;
    }

    public void removeTab(Type type) {
        if (this.getTabbedPane() != null && this.getTabbedPane().getTabCount() > 0) {
            int tabIndex = this.getTabIndex(type);
            if (tabIndex > -1) {
                this.getTabbedPane().removeTabAt(tabIndex);
                this.getVisualizers().remove(type.getName());
            }
            int selectedIndex = this.getTabbedPane().getSelectedIndex();
            this.getTabbedPane().setSelectedIndex(-1);
            if (selectedIndex > -1) {
                this.getTabbedPane().setSelectedIndex(selectedIndex);
            } else {
                this.getTabbedPane().setVisible(false);
            }
        }
    }

    private void addComponentToComponentHolder(JPanel holderPanel, JComponent newComponent) {
        if (newComponent != null && holderPanel != null && this._componentHolderTableLayout != null) {
            int numberOfRows = this._componentHolderTableLayout.getRowCount();
            RowSpec rowSpec = new RowSpec("pref");
            this._componentHolderTableLayout.insertRow(numberOfRows, rowSpec);
            holderPanel.add((Component)newComponent, "1," + numberOfRows);
        }
    }

    private void addComponentToComponentHolder(JPanel holderPanel, JComponent newComponent, Type type) {
        if (newComponent != null && holderPanel != null && this._componentHolderTableLayout != null) {
            int numberOfRows = this._componentHolderTableLayout.getRowCount();
            if (newComponent instanceof AbstractView) {
                AbstractView view = (AbstractView)newComponent;
                view.setRowIndexInParentTableLayout(numberOfRows);
                view.setParentTableLayout(this._componentHolderTableLayout);
            }
            if (type.getStyle().isVisibleAtRuntime() && !type.getStyle().isVisible()) {
                RowSpec rowSpec = new RowSpec("top:pref");
                this._componentHolderTableLayout.insertRow(numberOfRows, rowSpec);
            } else {
                this._componentHolderTableLayout.insertRow(numberOfRows, this.getRowSpec("pref"));
            }
            holderPanel.add((Component)newComponent, "1," + numberOfRows);
        }
    }

    private JPanel getComponentHolder() {
        if (this._componentHolderPanel == null) {
            this._componentHolderPanel = new JPanel();
            this._componentHolderPanel.setName("componentHolderPanel");
        }
        return this._componentHolderPanel;
    }

    public void domChanged(DOMChangeEvent event) {
        if (this.getModel() != null && this.getModel().isChoice() && event.isAddingNode()) {
            Type source = (Type)event.getSource();
            if (source.isEmpty()) {
                EmptyType emptyType = ((CompositeType)this.getModel()).getEmptyType();
                if (emptyType != null && emptyType == source) {
                    this.showChoice(source);
                }
            } else if (this.isRelevant(source)) {
                this.showChoice(source);
            }
        }
    }

    public Border getBorder() {
        Border b = null;
        if (this._borderPanel != null) {
            b = this._borderPanel.getBorder();
        }
        return b;
    }

    protected Hashtable getVisualizers() {
        if (this._visualizers == null) {
            this._visualizers = new Hashtable();
        }
        return this._visualizers;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this._optionalCheckBox) {
            if (this._label != null) {
                this._label.setEnabled(this._optionalCheckBox.isSelected());
            }
            if (this._visibleComponent != null) {
                this._visibleComponent.setEnabled(this._optionalCheckBox.isSelected());
            }
        }
    }

    protected boolean isRelevant(Type type) {
        if (this.getModel().isAbstract()) {
            if (type.getParent() == this.getModel()) {
                return true;
            }
        } else if (type.isAbstract()) {
            List choices = ((CompositeType)this.getModel()).getDirectChildren();
            Iterator choiceTypes = choices.iterator();
            while (choiceTypes.hasNext()) {
                if (!type.equals(choiceTypes.next())) continue;
                return true;
            }
        } else {
            Iterator choiceTypes = ((CompositeType)this.getModel()).getRelevantChoiceTypes().iterator();
            while (choiceTypes.hasNext()) {
                if (!type.equals(choiceTypes.next())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSimpleComposite(Type type) {
        if (!type.isComposite()) {
            return false;
        }
        CompositeType composite = (CompositeType)type;
        return composite.getComposites().size() == 1 && ((Type)composite.getComposites().get(0)).isSimple();
    }

    protected boolean isUsingTableLayout() {
        return this.getStyle().getLayoutManager("main") != null;
    }

    public void markError() {
        Border border = BorderFactory.createEtchedBorder(this.getDOM().getErrorMarkingColor(), Color.lightGray);
        this.setBorder(border);
    }

    public void populateModel() {
        if (((CompositeType)this.getModel()).isChoice()) {
            Visualizer visualizer;
            Type type = this.getModel().getChoosenType();
            if (type != null && (!type.isRepresentedAsTreeNode() || this.getModel().isRepresentedAsTreeNode()) && (visualizer = (Visualizer)this.getVisualizers().get(type.getName())) != null) {
                visualizer.populateModel();
            }
        } else {
            Iterator iterator = ((CompositeType)this.getModel()).getComposites().iterator();
            while (iterator.hasNext()) {
                Visualizer visualizer;
                Type type = (Type)iterator.next();
                if (type.isRepresentedAsTreeNode() || (visualizer = (Visualizer)this.getVisualizers().get(type.getName())) == null) continue;
                visualizer.populateModel();
            }
        }
    }

    public void populateView() {
        if (this.getModel() != null) {
            Iterator composites = ((CompositeType)this.getModel()).getComposites().iterator();
            Type childContext = this._context;
            while (composites.hasNext()) {
                if (childContext == null && this.isUsingTableLayout()) {
                    childContext = this.getModel();
                }
                Type subType = (Type)composites.next();
                Visualizer visualizer = TypeVisualizerFactory.getInstance().getVisualizer(subType, childContext, false);
                if (visualizer == null || !visualizer.getModel().getStyle().isEditorComponentVisible()) continue;
                visualizer.populateView();
            }
        }
    }

    public void resetError() {
        this.setBorder(this._originalBorder);
    }

    public void setBorder(Border border) {
        if (this._componentHolderPanel != null) {
            this._componentHolderPanel.setBorder(border);
        }
    }

    public void setEnabled(boolean enabled) {
        Iterator iterator;
        List compositeTypes = ((CompositeType)this.getModel()).getComposites();
        if (compositeTypes != null) {
            iterator = compositeTypes.iterator();
            while (iterator.hasNext()) {
                Type currentType = (Type)iterator.next();
                if (currentType == null) continue;
                currentType.setEnabled(enabled);
            }
        }
        if (this._label != null) {
            this._label.setEnabled(enabled);
        }
        if (this._visibleComponent != null) {
            this._visibleComponent.setEnabled(enabled);
        }
        if (this._borderPanel != null) {
            this._borderPanel.setEnabled(enabled);
        }
        if (this._optionalCheckBox != null) {
            this._optionalCheckBox.setEnabled(enabled);
        }
        if (this._buttons != null) {
            iterator = this._buttons.iterator();
            while (iterator.hasNext()) {
                ((JAXJButton)iterator.next()).setEnabled(enabled);
            }
        }
    }

    public void setEnabled(boolean enabled, boolean setOptionalToo) {
        this.setEnabled(enabled);
        if (this._optionalCheckBox != null && setOptionalToo) {
            this._optionalCheckBox.setEnabled(enabled);
        }
    }

    public void setEditable(boolean editable) {
        Iterator iterator;
        List compositeTypes;
        if (this._optionalCheckBox != null) {
            this._optionalCheckBox.setEditable(editable);
        }
        if ((compositeTypes = ((CompositeType)this.getModel()).getComposites()) != null) {
            iterator = compositeTypes.iterator();
            while (iterator.hasNext()) {
                Type currentType = (Type)iterator.next();
                if (currentType == null || currentType.isLocked()) continue;
                currentType.setEditable(editable);
            }
        }
        if (this._buttons != null) {
            iterator = this._buttons.iterator();
            while (iterator.hasNext()) {
                ((JAXJButton)iterator.next()).setEditable(editable);
            }
        }
    }

    public void setLabelColor(Color color) {
    }

    public abstract void setRequired(boolean var1);

    public abstract void setApplicationRequired(boolean var1);

    private void removeChoiceTreeEntry(Type type) {
        if (type != null) {
            List childs;
            if (type.isRepresentedAsTreeNode() && type.getDOM().getEditor().getTreeModel() != null) {
                type.getDOM().getEditor().getTreeModel().removeNode(type);
            }
            if (type.isComposite() && type.isChoice()) {
                this.removeChoiceTreeEntry(type.getChoosenType());
            } else if (type.getDirectChildren() != null && (childs = type.getDirectChildren()).size() > 0) {
                Iterator iterator = childs.iterator();
                while (iterator.hasNext()) {
                    Type child = (Type)iterator.next();
                    this.removeChoiceTreeEntry(child);
                }
            }
        }
    }

    private void addChoiceTreeEntry(Type type) {
        if (type != null) {
            List childs;
            if (type.isRepresentedAsTreeNode() && type.getDOM().getEditor() != null && type.getDOM().getEditor().getTreeModel() != null) {
                type.getDOM().getEditor().getTreeModel().insertNode(type);
            }
            if (type.isComposite() && type.isChoice()) {
                this.addChoiceTreeEntry(type.getChoosenType());
            } else if (type.getDirectChildren() != null && (childs = type.getDirectChildren()).size() > 0) {
                Iterator iterator = childs.iterator();
                while (iterator.hasNext()) {
                    Type child = (Type)iterator.next();
                    this.addChoiceTreeEntry(child);
                }
            }
        }
    }

    public void showChoice(Type type) {
        if (this._visibleComponent != null) {
            Type visibleType = ((Visualizer)this._visibleComponent).getModel();
            this.removeChoiceTreeEntry(visibleType);
            this.getSelectedPanel().remove(this._visibleComponent);
        }
        if (type != null) {
            if (!(type.getStyle().isRepresentedAsTreeNode() && type.getStyle().isSelfViewHolder() || type.isEmpty())) {
                this._visibleComponent = (JComponent)TypeVisualizerFactory.getInstance().getVisualizer(type, this._context);
                if (this._visibleComponent != null) {
                    if (type.isSimple()) {
                        ((Visualizer)this._visibleComponent).showLabel(false);
                    } else if (this.isSimpleComposite(type)) {
                        this._visibleComponent.setBorder(null);
                    }
                    this.showSelection(this._visibleComponent);
                }
            }
            if (!type.isEmpty()) {
                this.addChoiceTreeEntry(type);
            }
        }
        this.updateUI();
    }

    public void showLabel(boolean show) {
    }

    private void showSelection(JComponent component) {
        this.getSelectedPanel().add(component);
    }

    public void showTab(Type selectedType, Object component) {
        Component swingComponent = (Component)component;
        if (this.getTabbedPane() != null) {
            int index = this.getTabbedPane().indexOfComponent(swingComponent);
            if (index == -1) {
                Type tabbedType = ((Visualizer)swingComponent).getModel();
                index = this.getTabbedPane().indexOfTab(tabbedType.getStyle().getCaptionTitleLabel());
                if (index != -1) {
                    this.getTabbedPane().setSelectedIndex(index);
                    JPanel holderPanel = (JPanel)this.getTabbedPane().getSelectedComponent();
                    holderPanel.removeAll();
                    holderPanel.setLayout(new BorderLayout());
                    holderPanel.add(swingComponent, "Center");
                }
            } else {
                this.getTabbedPane().setSelectedIndex(index);
            }
        }
    }

    public void release() {
        if (this.getDOM() != null) {
            this.getDOM().removeDOMChangeListener((DOMChangeListener)this);
        }
        super.release();
        this._group = null;
        this._visualizers = null;
        if (this._tabbedPane != null) {
            this._tabbedPane.removeChangeListener(UIController.getInstance());
            this._tabbedPane.removeChangeListener(this);
        }
        this._tabbedPane = null;
        this._visibleComponent = null;
        this._selectedPanel = null;
        this._optionalCheckBox = null;
        this._componentHolderPanel = null;
        this._componentHolderTableLayout = null;
    }

    protected JComponent createEditorComponent() {
        return null;
    }

    public void stateChanged(ChangeEvent event) {
        Type tabType;
        JTabbedPane pane;
        if (this.getModel() == null) {
            return;
        }
        if (!this._isInsertingTab && (pane = (JTabbedPane)event.getSource()).getSelectedComponent() != null && (tabType = this.getSelectedTabType()) != null) {
            Visualizer visualizer = (Visualizer)this.getVisualizers().get(tabType.getName());
            if (visualizer == null) {
                JPanel tabSpaceHolder = null;
                tabType.putClientProperty("tabHolder", (Object)pane);
                visualizer = TypeVisualizerFactory.getInstance().getVisualizer(tabType, this._context);
                if (this.getDOM().getGlobalDefinition().hasTabsTopSpace() || this.getDOM().getGlobalDefinition().hasTabsBottomSpace()) {
                    int topSpace = this.getDOM().getGlobalDefinition().getTopSpaceTabs();
                    int bottomSpace = this.getDOM().getGlobalDefinition().getBottomSpaceTabs();
                    String pref = "pref";
                    String column = "f:p:g(100)";
                    String row = topSpace + "px" + "," + pref + "," + bottomSpace + "px";
                    FormLayout verticalIndentForTabsTL = new FormLayout(column, row);
                    tabSpaceHolder = new JPanel(verticalIndentForTabsTL);
                    tabSpaceHolder.setName("tabSpaceHolder");
                    tabSpaceHolder.add((Component)((JComponent)visualizer), "1,2");
                }
                this.getVisualizers().put(tabType.getName(), visualizer);
                if (tabSpaceHolder == null) {
                    JPanel holderPanel = (JPanel)pane.getSelectedComponent();
                    if (holderPanel.getLayout().getClass() == BorderLayout.class) {
                        holderPanel.add((Component)((JComponent)visualizer), "Center");
                    } else {
                        holderPanel.add((Component)((JComponent)visualizer), "2,2");
                    }
                } else {
                    ((JPanel)pane.getSelectedComponent()).add(tabSpaceHolder, "2,2");
                }
                EditablePanel editor = this.getDOM().getEditor();
                if (editor != null) {
                    ((JComponent)editor).updateUI();
                }
            }
            AbstractView view = (AbstractView)visualizer;
            if (!this._isInitializing) {
                view.highlightTreeEntry(tabType);
            }
            view.focusFirstComponent(true);
        }
    }

    protected double getDefaultComponentHeight() {
        if (this.getStyle().isUsingPlugIn() || this.getStyle().isChoiceAsRadioButton() && !this.getStyle().isChoiceOrientationHorizontal()) {
            return 0.0;
        }
        return super.getDefaultComponentHeight();
    }

    protected String getStringDefaultComponentHeight() {
        if (this.getStyle().isUsingPlugIn() || this.getStyle().isChoiceAsRadioButton() && !this.getStyle().isChoiceOrientationHorizontal()) {
            return "pref";
        }
        return super.getStringDefaultComponentHeight();
    }

    public void setChoosenKeyValue(String xpathRelativeToChoosenKey, String newValue) {
    }

    public void setChoosenKeyContextValue(String xpathRelativeToChoosenKeyContext, String newValue) {
    }

    public Type getModel() {
        return this._model;
    }

    public Type getSelectedTabType() {
        Type tabType = null;
        if (this.getTabbedPane() != null) {
            tabType = (Type)((JComponent)this.getTabbedPane().getSelectedComponent()).getClientProperty("TAB_TYPE");
        }
        return tabType;
    }

    private JPanel getSelectedPanel() {
        if (this._selectedPanel == null) {
            this._selectedPanel = new JPanel();
            this._selectedPanel.setName("selectedPanel");
        }
        return this._selectedPanel;
    }

    private int getCurrentTabIndex(Type type) {
        if (type != null && this.getTabbedPane() != null) {
            for (int a = 0; a < this.getTabbedPane().getTabCount(); ++a) {
                Type tabType = (Type)((JComponent)this.getTabbedPane().getComponentAt(a)).getClientProperty("TAB_TYPE");
                if (tabType != type) continue;
                return a;
            }
        }
        return -1;
    }

    public void setSelectedTab(Type type) {
        int currentTabIndex;
        if (type != null && this.getTabbedPane() != null && (currentTabIndex = this.getCurrentTabIndex(type)) > -1 && currentTabIndex < this.getTabbedPane().getTabCount()) {
            this.getTabbedPane().setSelectedIndex(currentTabIndex);
        }
    }

    protected void setTabbedPane(JAXJTabbedPane _tabbedPane) {
        this._tabbedPane = _tabbedPane;
    }

    protected JAXJTabbedPane getTabbedPane() {
        if (this._tabbedPane == null) {
            this._tabbedPane = new JAXJTabbedPane();
            this._tabbedPane.setFont(FontFactory.getTabFontDefinition().createFont());
            this._tabbedPane.setPopUpMenu(this.createPopUpMenu());
        }
        return this._tabbedPane;
    }

    public void setTabName(String oldName, String newName) {
        int index = this.getTabbedPane().indexOfTab(oldName);
        if (index != -1) {
            this.getTabbedPane().setTitleAt(index, newName);
        }
    }

    private void applyTableLayout(JPanel holderPanel) {
        FormLayoutInfo layout = (FormLayoutInfo)this.getStyle().getLayoutManager("main");
        JPanel tablePanel = FormLayoutBuilder.applyTableLayout(this, this.getModel(), this._context, layout, holderPanel);
        FormLayout tableLayout = (FormLayout)tablePanel.getLayout();
        JComponent captionPanel = tablePanel;
        if (this.getStyle().hasCaption()) {
            tablePanel.setBorder(null);
            captionPanel = this.getCaptionPanel(captionPanel);
        } else if (this.getStyle().isRepresentedAsTab() || this.getModel().getParent() != null && this.getModel().getParent().isChoice()) {
            tablePanel.setBorder(null);
        }
        this.setParentTableLayout(tableLayout);
        this.setParentTablePanel(tablePanel);
        this.addComponentToComponentHolder(holderPanel, captionPanel);
    }
}

