/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMChangeListener;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractListTypeTableModel
extends AbstractTableModel
implements DOMChangeListener {
    protected ListType _list;
    protected String[] _columnNames;

    public AbstractListTypeTableModel(ListType listType) {
        this._list = listType;
        this._list.getDOM().addDOMChangeListener((DOMChangeListener)this);
    }

    public void domChanged(DOMChangeEvent event) {
        Type type;
        if (!(event.isAboutToSave() || event.isSaved() || event.isCancelled() || event.isAboutToValidate() || (type = (Type)event.getSource()) == null || type.getParentList() != this._list)) {
            if (event.isRemovingNode()) {
                this.fireTableDataChanged();
            } else if (event.isAddingNode()) {
                this.fireTableRowsInserted(this._list.getList().size() - 1, this._list.getList().size());
            }
        }
    }

    public Class getColumnClass(int columnIndex) {
        return SimpleType.class;
    }

    public abstract int getColumnCount();

    public abstract String getColumnName(int var1);

    public ListType getList() {
        return this._list;
    }

    public int getRowCount() {
        return this._list.getList().size();
    }

    public Type getType(int rowIndex) {
        if (rowIndex == -1 || this.getRowCount() == 0 || rowIndex >= this.getRowCount()) {
            return null;
        }
        return (Type)this._list.getList().get(rowIndex);
    }

    public abstract Object getValueAt(int var1, int var2);

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public abstract void setValueAt(Object var1, int var2, int var3);
}

