/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.FormulaException;
import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.LineBorder;

public class KeyRefCellRenderer
extends DefaultListCellRenderer {
    private Type _keyRefType;
    private FormulaExpression _formulaExpression;

    public KeyRefCellRenderer(Type keyRefType) {
        this._keyRefType = keyRefType;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel defaultListCellRenderer = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value != null) {
            Type type = (Type)value;
            if (type.isEmpty()) {
                defaultListCellRenderer.setText(" ");
            } else {
                String typeValue = type.getDisplayValue();
                if (this._keyRefType != null && this.getFormulaExpression() != null) {
                    this.getFormulaExpression().setSource(type);
                    try {
                        typeValue = this.getFormulaExpression().evaluate();
                    }
                    catch (FormulaException ex) {
                        LogRegistry.getInstance().error(this.getClass(), ex.getMessage());
                    }
                }
                if (typeValue != null && typeValue.equals("")) {
                    typeValue = " ";
                }
                SimpleType st = (SimpleType)type;
                String path = "";
                try {
                    path = st.getFullCaption();
                }
                catch (Exception e) {
                    // empty catch block
                }
                defaultListCellRenderer.setText(path + " " + typeValue);
            }
        }
        this.setComponentOrientation(list.getComponentOrientation());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
            defaultListCellRenderer.setBorder(BorderFactory.createRaisedBevelBorder());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            defaultListCellRenderer.setBorder(LineBorder.createGrayLineBorder());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        return defaultListCellRenderer;
    }

    private FormulaExpression getFormulaExpression() {
        if (this._formulaExpression == null && this._keyRefType.getXUIDefinition().getStyle().hasKeyRefSelectionLineInfoFE()) {
            this._formulaExpression = new FormulaExpression(null, this._keyRefType.getXUIDefinition().getStyle().getKeyRefSelectionLineInfoFE());
        }
        return this._formulaExpression;
    }
}

