/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMChangeListener;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.keyRef.KeyContextWrapper;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.schema.SchemaKeyRef;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.schema.impl.KeyContainer;
import com.jaxfront.core.schema.impl.KeyKeyRefEvent;
import com.jaxfront.core.schema.impl.KeyKeyRefListener;
import com.jaxfront.core.schema.impl.KeyRefDefinition;
import com.jaxfront.core.type.AbstractListType;
import com.jaxfront.core.type.EmptyType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.ui.ListVisualizer;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.EventUtil;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.sort.FastQSort;
import com.jaxfront.core.xpath.XPathError;
import com.jaxfront.swing.ui.tools.FocusHelper;
import com.jaxfront.swing.ui.tools.GUITools;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import com.jaxfront.swing.ui.visualizers.KeyRefListCellRenderer;
import com.jaxfront.swing.ui.visualizers.MultiColumnComboBoxRenderer;
import com.jaxfront.swing.ui.wrapper.JAXJButton;
import com.jaxfront.swing.ui.wrapper.JAXJComboBox;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class KeyRefView
extends AbstractSimpleTypeView
implements ActionListener,
DOMChangeListener,
PropertyChangeListener,
KeyKeyRefListener {
    private Vector _choiceList;
    private Type _originalKeyType;
    private EmptyType emptyEntry = null;
    private FormulaExpression _conditionFE;
    private boolean _isAddingNewType = false;
    private JAXJComboBox _contextComboBox;
    private JAXJButton _newRefTypeButton;
    private JButton _detailsRefTypeButton;
    private JButton _okButton;
    private JButton _cancelButton;
    private JButton _jumpToButton;
    private JPanel _buttonPanel;
    private JComponent _keyRefPanel;
    private JDialog _dialog;
    private JScrollPane _scrollPane;
    private Border _originalBorder;
    private Type _selectedRefType;
    private Type _createdReference;
    private SimpleType _referencedKeyFieldType;
    private Type _createdKeyListEntry;
    private String _assignedKeyName = null;
    private AbstractAction _jumpToAction;
    private AbstractAction _detailsAction;
    private AbstractAction _newRefAction;
    private Visualizer _dialogVisualizer = null;
    static int viewCounter = 0;
    private static final String NEW_ICON = "com/jaxfront/core/images/files/new_16x16.gif";
    private static final String DETAILS_ICON = "com/jaxfront/core/images/files/edit_16x16.gif";
    private static final String BACKLINK_ICON = "com/jaxfront/core/images/files/showList_16x16.gif";

    public KeyRefView(Type type) {
        this(type, null);
    }

    public KeyRefView(Type type, Type context) {
        super(context);
        this.emptyEntry = new EmptyType(type.getSchemaElement(), type.getDOM());
        this.setModel(type);
    }

    private boolean isShowingNewButton() {
        boolean canAdd = false;
        ListType parentList = this.getSimpleModel().evaluateKeyHolderList();
        if (parentList != null && parentList != null) {
            canAdd = !((AbstractListType)parentList).violateCardinality(1);
        }
        return this.getStyle().isKeyRefShowingNewButton() && canAdd;
    }

    private boolean isShowingDetailsButton() {
        return this.getStyle().isKeyRefShowingDetailsButton();
    }

    private boolean canDetailsBeEnabled() {
        return this._contextComboBox != null && this._contextComboBox.getSelectedItem() != this.emptyEntry;
    }

    private boolean canJumpToBeEnabled() {
        return this._contextComboBox != null && this._contextComboBox.getSelectedItem() != this.emptyEntry;
    }

    private boolean isShowingBackLinkButton() {
        return this.getStyle().isKeyRefShowingBackLinkButton();
    }

    private void cancelDialog() {
        this._dialog.setVisible(false);
        if (this._isAddingNewType && this.getSelectedType() != null) {
            this.removeRefTypeFromRefList();
            this._createdKeyListEntry = null;
            this._createdReference = null;
            if (this._originalKeyType != null) {
                this.setSelectedType(this._originalKeyType.getDisplayValue());
            }
            this._originalKeyType = null;
            this.populateModel();
            this._isAddingNewType = false;
        } else {
            if (this._originalKeyType != null) {
                this.getToShowType().bind(this._originalKeyType);
                this.getDOM().fireDOMChanged(DOMChangeEvent.DOM_CANCELLED((Object)this._originalKeyType));
            }
            this._originalKeyType = null;
            this.populateModel();
            if (this._dialogVisualizer != null) {
                TypeVisualizerFactory.getInstance().releaseCache(this._dialogVisualizer.getModel(), this._dialogVisualizer.getContext(), false);
            }
            this._dialogVisualizer = null;
        }
        this.getDOM().getController().blockDirtyChange(false);
    }

    private void commitDialog() {
        this._dialog.setVisible(false);
        if (this._createdReference != null) {
            this.setSelectedType(this._createdReference);
        }
        this._createdReference = null;
        this._isAddingNewType = false;
        if (this._dialogVisualizer != null) {
            TypeVisualizerFactory.getInstance().releaseCache(this._dialogVisualizer.getModel(), this._dialogVisualizer.getContext(), false);
        }
        if (this.getDOM().getController().changeWhileBlocking()) {
            this.getDOM().getController().blockDirtyChange(false);
            this.getDOM().getController().fireDirtyChange();
        } else {
            this.getDOM().getController().blockDirtyChange(false);
        }
        this._dialogVisualizer = null;
    }

    protected void jumpToKeyType() {
        if (this.getSelectedType() != null && !this.getSelectedType().isEmpty()) {
            Type parentType = this.getModel();
            Type treeNodeParent = this.getModel().getRepresentedTreeNodeParent();
            while (parentType != null) {
                JDialog dialog;
                ListVisualizer listView;
                if ((parentType = parentType.getParent()) != null && parentType.isList() && parentType.getXUIDefinition().getStyle().isDialogMode() && (listView = (ListVisualizer)TypeVisualizerFactory.getInstance().getVisualizer(parentType)) != null && listView.getSelectedType() != null && (dialog = listView.getEditDialog(listView.getSelectedType(), null)) != null) {
                    dialog.setVisible(false);
                }
                if (treeNodeParent != parentType) continue;
                parentType = null;
            }
            FocusHelper.focus(this.getSelectedType(), null, false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._okButton) {
            this.commitDialog();
        } else if (e.getSource() == this._cancelButton) {
            this.cancelDialog();
        } else if (e.getSource() == this._contextComboBox && this._contextComboBox.getSelectedItem() instanceof Type && this.getSelectedType() != this._contextComboBox.getSelectedItem()) {
            this.setSelectedType((Type)this._contextComboBox.getSelectedItem());
            this._referencedKeyFieldType = null;
            this.getDOM().getController().hasChanged(true);
            this.checkButtonEnabling();
        }
    }

    protected Action getNewRefAction() {
        if (this._newRefAction == null) {
            String buttonText = GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_new", "New");
            String[] accelDef = EventUtil.parseAccelDefinitions((String)buttonText);
            this._newRefAction = new AbstractAction(accelDef[0], JAXFrontProperties.getImageIcon((String)NEW_ICON)){

                public void actionPerformed(ActionEvent e) {
                    KeyRefView.this._isAddingNewType = true;
                    KeyRefView.this._originalKeyType = (Type)KeyRefView.this.getReferencedKeyFieldType();
                    KeyRefView.this.getModel().getDOM().getController().blockDirtyChange(true);
                    KeyRefView.this.addNewReference();
                    if (KeyRefView.this._createdKeyListEntry != null) {
                        KeyRefView.this.populateModel();
                        KeyRefView.this.showSelection(KeyRefView.this._createdKeyListEntry);
                    } else {
                        KeyRefView.this.getModel().getDOM().getController().blockDirtyChange(false);
                    }
                }
            };
            if (accelDef[1] != null) {
                EventUtil.createKeyStrokes((Action)this._newRefAction, (String)accelDef[1]);
            }
        }
        return this._newRefAction;
    }

    protected Action getDetailsAction() {
        if (this._detailsAction == null) {
            String buttonText = GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_details", "D${e}tails");
            String[] accelDef = EventUtil.parseAccelDefinitions((String)buttonText);
            this._detailsAction = new AbstractAction(accelDef[0], JAXFrontProperties.getImageIcon((String)DETAILS_ICON)){

                public void actionPerformed(ActionEvent e) {
                    if (KeyRefView.this.getSelectedType() != null && !KeyRefView.this.getSelectedType().isEmpty()) {
                        KeyRefView.this.getModel().getDOM().getController().blockDirtyChange(true);
                        Type toShowType = KeyRefView.this.getToShowType();
                        try {
                            KeyRefView.this.getDOM().setIsBinding(true);
                            KeyRefView.this._originalKeyType = toShowType.deepClone(null, true, true);
                            KeyRefView.this.getDOM().setIsBinding(false);
                        }
                        catch (CloneNotSupportedException e1) {
                            LogRegistry.getInstance().error(this.getClass(), e.toString());
                        }
                        KeyRefView.this.showSelection(toShowType);
                    }
                }
            };
            if (accelDef[1] != null) {
                EventUtil.createKeyStrokes((Action)this._detailsAction, (String)accelDef[1]);
            }
        }
        return this._detailsAction;
    }

    protected Action getJumpToAction() {
        if (this._jumpToAction == null) {
            String buttonText = GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_list_add", "Add${ALT+A}");
            String[] accelDef = EventUtil.parseAccelDefinitions((String)buttonText);
            this._jumpToAction = new AbstractAction("", JAXFrontProperties.getImageIcon((String)BACKLINK_ICON)){

                public void actionPerformed(ActionEvent e) {
                    KeyRefView.this.jumpToKeyType();
                }
            };
            if (accelDef[1] != null) {
                EventUtil.createKeyStrokes((Action)this._jumpToAction, (String)accelDef[1]);
            }
        }
        return this._jumpToAction;
    }

    private Type getParentListEntry(Type aChildType) {
        Type result = aChildType;
        while (aChildType.getParent() != null && !aChildType.getParent().isList()) {
            if ((aChildType = aChildType.getParent()) == null) continue;
            result = aChildType;
        }
        if (result.isList()) {
            return result;
        }
        return null;
    }

    private ListType evaluateReferencedKeyList() {
        return this.getSimpleModel().evaluateKeyHolderList();
    }

    private Type addNewReference() {
        List posEdParents;
        Type posKeyType = this.evaluateKeyFieldTypeInEdTypeBranch();
        if (posKeyType.isEditingType()) {
            KeyContainer posKeyContainer = this.getSimpleModel().evaluatePossibleKeyContainer();
            Type contextBase = posKeyContainer.getContext().getLastContextEntry();
            try {
                DOMHelper.createFromEditingTypeXPath((Type)contextBase, (String)posKeyContainer.getSchemaKey().getSelectorXPath());
            }
            catch (XPathError e) {
                LogRegistry.getInstance().error(this.getClass(), e.toString());
            }
            posKeyType = this.evaluateKeyFieldTypeInEdTypeBranch();
        }
        if ((posEdParents = DOMHelper.getEditingTypeParentPath((Type)posKeyType)) != null && posEdParents.size() > 0) {
            this._createdKeyListEntry = DOMHelper.createBranchFromEditingTypes((List)posEdParents);
        } else {
            ListType keyList = this.evaluateReferencedKeyList();
            this._createdKeyListEntry = keyList.addNewChild();
        }
        return this._createdKeyListEntry;
    }

    public void setRequired(boolean required) {
        if (this._contextComboBox != null) {
            if (this.getStyle().getBackgroundColor() != null) {
                this._contextComboBox.setBackground(this.getStyle().getBackgroundColor());
                this._contextComboBox.getEditor().getEditorComponent().setBackground(this.getStyle().getBackgroundColor());
            } else if (required) {
                if (this.getStyle().isApplicationRequired()) {
                    this._contextComboBox.setBackground(this.getDOM().getApplicationFieldColor());
                    this._contextComboBox.getEditor().getEditorComponent().setBackground(this.getDOM().getApplicationFieldColor());
                } else {
                    this._contextComboBox.setBackground(this.getDOM().getSchemaRequiredFieldColor());
                    this._contextComboBox.getEditor().getEditorComponent().setBackground(this.getDOM().getSchemaRequiredFieldColor());
                }
            } else {
                this._contextComboBox.setBackground(this.getDOM().getOptionalFieldColor());
                this._contextComboBox.getEditor().getEditorComponent().setBackground(this.getDOM().getOptionalFieldColor());
            }
        }
    }

    private void updateContextComboBox() {
        this._choiceList = new Vector();
        this._choiceList.add(this.emptyEntry);
        KeyRefDefinition refDef = this.getSimpleModel().getKeyRefDefinition();
        if (refDef != null) {
            SchemaKeyRef skr = refDef.getSchemakeyRef();
            KeyContextWrapper context = new KeyContextWrapper(KeyContainer.createContext((Type)this.getModel(), (SchemaNode)skr.getKey().getSchemaElement()));
            KeyContainer keyCont = this.getDOM().getKeyKeyRefManager().getKeyContainer(this.getAssignedKeyName(), (Object)context);
            if (keyCont != null) {
                this._choiceList.addAll(keyCont.getKeyTypes());
                FastQSort qSort = new FastQSort();
                try {
                    qSort.sort((List)this._choiceList, StringUtil.getNaturalTypeXPathComparator(), 0);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.setChoices(this._choiceList);
    }

    private void setSelectedType(Type selectedType) {
        this._selectedRefType = selectedType;
        if (selectedType != null) {
            this._contextComboBox.setSelectedItem(selectedType);
        } else if (this._contextComboBox != null) {
            this._contextComboBox.setSelectedIndex(0);
        }
        this.populateModel();
    }

    private void setSelectedTypeFromModel() {
        String modelValue = ((SimpleType)this.getModel()).getValue();
        if (modelValue != null) {
            if (this._contextComboBox != null) {
                this._contextComboBox.removeActionListener(this);
                this.setSelectedType(modelValue);
                this._contextComboBox.addActionListener(this);
            }
        } else {
            this._contextComboBox.removeActionListener(this);
            this.setSelectedType((Type)this.emptyEntry);
            this._contextComboBox.addActionListener(this);
            this._contextComboBox.setSelectedIndex(-1);
        }
    }

    private void setSelectedType(String selectedKeyValue) {
        Vector keys = this._choiceList;
        if (selectedKeyValue != null) {
            for (int k = 0; k < keys.size(); ++k) {
                Type aType = (Type)keys.get(k);
                if (!aType.isSimple() || !selectedKeyValue.equals(((SimpleType)aType).getValue())) continue;
                this.setSelectedType(aType);
                return;
            }
        }
        if (this._contextComboBox.getItemCount() > 0) {
            this.setSelectedType((Type)null);
            this._contextComboBox.setSelectedIndex(0);
        }
    }

    private JComponent initKeyRefPanel() {
        Type source;
        this.hideOtherFields();
        this._contextComboBox = new JAXJComboBox();
        this.getDOM().getKeyKeyRefManager().addKeyKeyRefListener((KeyKeyRefListener)this);
        this.setFirstFocusableComponent(this._contextComboBox);
        boolean useMultiColumnRenderer = false;
        FormulaExpression fe = null;
        if (this.getModel().getXUIDefinition().getStyle().hasKeyRefSelectionLineInfoFE() && (fe = new FormulaExpression(source = this.getModel(), this.getModel().getXUIDefinition().getStyle().getKeyRefSelectionLineInfoFE())).getExpression() != null && fe.getExpression().startsWith("array")) {
            useMultiColumnRenderer = true;
        }
        JComponent renderer = null;
        renderer = useMultiColumnRenderer ? new MultiColumnComboBoxRenderer(fe) : new KeyRefListCellRenderer(this.getModel());
        this._contextComboBox.setRenderer(renderer);
        renderer.setDefaultValue(this.getSimpleModel().getDefaultValue());
        renderer.setDefaultPrefix(this.getDOM().getGlobalDefinition().getDefaultValuePreFix());
        renderer.setDefaultPostfix(this.getDOM().getGlobalDefinition().getDefaultValuePostFix());
        this._contextComboBox.setAutoscrolls(true);
        this._contextComboBox.setPreferredSize(new Dimension((int)this._contextComboBox.getPreferredSize().getWidth(), (int)new JTextField().getPreferredSize().getHeight()));
        this._originalBorder = this._contextComboBox.getBorder();
        this.updateContextComboBox();
        this.setSelectedType(((SimpleType)this.getModel()).getValue());
        this._newRefTypeButton = new JAXJButton(this.getNewRefAction());
        this._newRefTypeButton.addFocusListener(this);
        this.addButtonKeyListener(this._newRefTypeButton);
        this._newRefTypeButton.setMargin(new Insets(1, 1, 1, 1));
        this._newRefTypeButton.setPreferredSize(new Dimension((int)this._newRefTypeButton.getPreferredSize().getWidth(), (int)new JTextField().getPreferredSize().getHeight()));
        this._detailsRefTypeButton = new JButton(this.getDetailsAction());
        this.addButtonKeyListener(this._detailsRefTypeButton);
        this._detailsRefTypeButton.addFocusListener(this);
        this._detailsRefTypeButton.setMargin(new Insets(1, 1, 1, 1));
        this._detailsRefTypeButton.setPreferredSize(new Dimension((int)this._detailsRefTypeButton.getPreferredSize().getWidth(), (int)new JTextField().getPreferredSize().getHeight()));
        this._jumpToButton = new JButton(this.getJumpToAction());
        this.addButtonKeyListener(this._jumpToButton);
        this._jumpToButton.addFocusListener(this);
        this._jumpToButton.setPreferredSize(new Dimension((int)this._detailsRefTypeButton.getPreferredSize().getWidth(), (int)new JTextField().getPreferredSize().getHeight()));
        int newButtonConstraint = 0;
        int detailsButtonConstraint = 0;
        int backLinkButtonConstraint = 0;
        if (this.isShowingNewButton()) {
            newButtonConstraint = 55;
        }
        if (this.isShowingDetailsButton()) {
            detailsButtonConstraint = 70;
        }
        if (this.isShowingBackLinkButton()) {
            backLinkButtonConstraint = 30;
        }
        String columnSpec = "fill:pref:grow," + newButtonConstraint + "," + detailsButtonConstraint + "," + backLinkButtonConstraint;
        String rowSpec = this.getStringDefaultComponentHeight();
        this._keyRefPanel = new JPanel(new FormLayout(columnSpec, rowSpec));
        this._keyRefPanel.setFocusable(false);
        this._keyRefPanel.add((Component)this._contextComboBox, "1,1");
        if (this.isShowingNewButton()) {
            this._keyRefPanel.add((Component)this._newRefTypeButton, "2,1");
        }
        if (this.isShowingDetailsButton()) {
            this._keyRefPanel.add((Component)this._detailsRefTypeButton, "3,1");
        }
        if (this.isShowingBackLinkButton()) {
            this._keyRefPanel.add((Component)this._jumpToButton, "4,1");
        }
        this._contextComboBox.addActionListener(this);
        this._contextComboBox.addFocusListener(this);
        this.checkButtonEnabling();
        return this._keyRefPanel;
    }

    protected JComponent createEditorComponent() {
        try {
            this._editorComponent = this.initKeyRefPanel();
            return this._editorComponent;
        }
        catch (Exception ex) {
            LogRegistry.getInstance().error(this.getClass(), "No identity constraint found for the type: " + this.getModel().getXPathLocation());
            return null;
        }
    }

    public String getText() {
        String text = ((SimpleType)this.getModel()).getValue();
        if (text == null) {
            text = "";
        }
        return text;
    }

    public void populateView() {
        if (this.getModel() != null) {
            this.setSelectedTypeFromModel();
        }
    }

    private void setChoices(Vector choices) {
        if (this._contextComboBox != null) {
            this._contextComboBox.setModel(new DefaultComboBoxModel(choices));
        }
    }

    private JDialog getDialog() {
        if (this._dialog == null) {
            Rectangle bounds;
            this._dialog = GUITools.createDialogFor(this.getEditor().getWindow(), true);
            this._dialog.getContentPane().setLayout(new BorderLayout());
            this._dialog.addWindowListener(new WindowListener(){

                public void windowActivated(WindowEvent e) {
                }

                public void windowClosed(WindowEvent e) {
                }

                public void windowClosing(WindowEvent e) {
                    KeyRefView.this.cancelDialog();
                }

                public void windowDeactivated(WindowEvent e) {
                }

                public void windowDeiconified(WindowEvent e) {
                }

                public void windowIconified(WindowEvent e) {
                }

                public void windowOpened(WindowEvent e) {
                }
            });
            KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
            this._dialog.getRootPane().registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    KeyRefView.this.cancelDialog();
                }
            }, stroke, 2);
            this._okButton = new JButton(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_ok", "Ok"));
            this._cancelButton = new JButton(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_cancel", "Cancel"));
            this._okButton.addActionListener(this);
            this.addButtonKeyListener(this._okButton);
            this._cancelButton.addActionListener(this);
            this.addButtonKeyListener(this._cancelButton);
            this._buttonPanel = new JPanel(new BorderLayout());
            this._buttonPanel.add((Component)this._okButton, "West");
            this._buttonPanel.add((Component)this._cancelButton, "East");
            SimpleType referencedKeyList = this.getReferencedKeyFieldType();
            if (referencedKeyList == null) {
                referencedKeyList = this.evaluateReferencedKeyList();
            }
            if (referencedKeyList.getXUIDefinition().getStyle().getTableInfo() != null) {
                String cancelButtonAlignment;
                String okButtonAlignment = referencedKeyList.getXUIDefinition().getStyle().getTableInfo().getOkButtonAlignment();
                if (okButtonAlignment.equalsIgnoreCase(cancelButtonAlignment = referencedKeyList.getXUIDefinition().getStyle().getTableInfo().getCancelButtonAlignment())) {
                    JPanel buttonBoxPanel = new JPanel();
                    buttonBoxPanel.setLayout(new BoxLayout(buttonBoxPanel, 0));
                    if (referencedKeyList.getXUIDefinition().getStyle().getTableInfo().getOkButtonSeqPos() == 0) {
                        buttonBoxPanel.add(this._okButton);
                        buttonBoxPanel.add(this._cancelButton);
                    } else {
                        buttonBoxPanel.add(this._cancelButton);
                        buttonBoxPanel.add(this._okButton);
                    }
                    if (okButtonAlignment.equalsIgnoreCase("left")) {
                        this._buttonPanel.add((Component)buttonBoxPanel, "West");
                    } else if (okButtonAlignment.equalsIgnoreCase("right")) {
                        this._buttonPanel.add((Component)buttonBoxPanel, "East");
                    } else {
                        this._buttonPanel.add((Component)buttonBoxPanel, "Center");
                    }
                } else if (referencedKeyList.getXUIDefinition().getStyle().getTableInfo().getOkButtonSeqPos() == 0) {
                    if (okButtonAlignment.equalsIgnoreCase("left") && cancelButtonAlignment.equalsIgnoreCase("right")) {
                        this._buttonPanel.add((Component)this._okButton, "West");
                        this._buttonPanel.add((Component)this._cancelButton, "East");
                    }
                } else if (okButtonAlignment.equalsIgnoreCase("right") && cancelButtonAlignment.equalsIgnoreCase("left")) {
                    this._buttonPanel.add((Component)this._cancelButton, "West");
                    this._buttonPanel.add((Component)this._okButton, "East");
                }
            } else {
                this._buttonPanel.add((Component)this._okButton, "West");
                this._buttonPanel.add((Component)this._cancelButton, "East");
            }
            Dimension dimension = new Dimension(600, 600);
            Point location = new Point(0, 0);
            if (referencedKeyList.getXUIDefinition().getStyle().isDialogMode() && referencedKeyList.getXUIDefinition().getStyle().getTableInfo() != null) {
                Dimension tempDim = referencedKeyList.getXUIDefinition().getStyle().getTableInfo().getDialogSize();
                Point tempPoint = referencedKeyList.getXUIDefinition().getStyle().getTableInfo().getDialogLocation();
                if (tempDim.getHeight() != -1.0 || tempDim.getWidth() != -1.0) {
                    dimension = tempDim;
                }
                if (tempPoint.getX() != -1.0 || tempPoint.getY() != -1.0) {
                    location = tempPoint;
                }
            }
            this._dialog.setSize(dimension);
            if (location.getX() == 0.0 && location.getY() == 0.0) {
                bounds = this.getEditor().getWindow().getBounds();
                location.x = bounds.x + (bounds.width - this._dialog.getSize().width) / 2;
                location.y = bounds.y + (bounds.height - this._dialog.getSize().height) / 2;
            } else {
                bounds = this.getEditor().getBounds();
                location.x = (int)bounds.getX() + location.x;
                location.y = (int)bounds.getY() + location.y;
            }
            if (location.x < 0) {
                location.x = 0;
            }
            if (location.y < 0) {
                location.y = 0;
            }
            this._dialog.setLocation(location);
        }
        return this._dialog;
    }

    protected void showSelection(Type currentRefType) {
        if (currentRefType != null) {
            this._dialogVisualizer = TypeVisualizerFactory.getInstance().getVisualizer(currentRefType, this.getModel());
            this._scrollPane = new JScrollPane(this.createIndentedComponent((JComponent)this._dialogVisualizer));
            this.getDialog().getContentPane().removeAll();
            this.getDialog().getContentPane().add((Component)this._scrollPane, "Center");
            this.getDialog().getContentPane().add((Component)this._buttonPanel, "South");
            String dialogTitle = currentRefType.getName();
            if (currentRefType.getParent() != null && currentRefType.getParent().isList()) {
                dialogTitle = currentRefType.getParent().getXUIDefinition().getStyle().getDialogLabel();
            }
            this.getDialog().setTitle(dialogTitle);
            this.getDialog().setVisible(true);
        }
    }

    public void domChanged(DOMChangeEvent event) {
        if (this.getModel() != null && event.getSource() != null && event.getSource() instanceof Type) {
            Type source = (Type)event.getSource();
            if (event.getType() == 256L && !source.isEmpty() && source.getParent() != null && source.getParent() == this.getReferencedKeyFieldType()) {
                this.updateContextComboBox();
                this.setSelectedType(((SimpleType)this.getModel()).getValue());
                this.populateModel();
            }
        }
    }

    protected void defaultBuild() {
        super.defaultBuild();
        this.getDOM().addDOMChangeListener((DOMChangeListener)this);
    }

    public void markError() {
        if (this._contextComboBox != null) {
            Border border = BorderFactory.createEtchedBorder(this.getDOM().getErrorMarkingColor(), Color.lightGray);
            this._contextComboBox.setBorder(border);
        }
    }

    private String[] getSchemaKeyRefFields() {
        KeyRefDefinition keyRefDef = ((SimpleType)this.getModel()).getKeyRefDefinition();
        if (keyRefDef != null) {
            return new String[]{keyRefDef.getName()};
        }
        return new String[0];
    }

    private void hideOtherFields() {
        if (this.getSchemaKeyRefFields() != null) {
            for (int a = 1; a < this.getSchemaKeyRefFields().length; ++a) {
                Type keyRefFieldType;
                String refFieldXPath = this.getSchemaKeyRefFields()[a];
                if (refFieldXPath == null || (keyRefFieldType = TypePathExecuter.getInstance().getTypeForXPath(this.getModel(), refFieldXPath)) == null) continue;
                keyRefFieldType.getXUIDefinition().getStyle().setVisibleAtRuntime(false);
            }
        }
    }

    public void populateModel() {
        if (this.getModel() != null && this.getSelectedType() != null && this._contextComboBox != null) {
            if (this.getSelectedType().isEmpty()) {
                ((SimpleType)this.getModel()).setValue((Object)this, "", false);
            } else if (this.getSelectedType().isSimple()) {
                ((SimpleType)this.getModel()).setValue((Object)this, ((SimpleType)this.getSelectedType()).getPlainValue(), false);
            }
        }
    }

    public void resetError() {
        if (this._contextComboBox != null) {
            this._contextComboBox.setBorder(this._originalBorder);
        }
    }

    public void release() {
        if (this.getDOM() != null) {
            this.getDOM().removeDOMChangeListener((DOMChangeListener)this);
            this.getDOM().getKeyKeyRefManager().removeKeyKeyRefListener((KeyKeyRefListener)this);
            this.getDOM().getPropertyChangeSupport().removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (this._contextComboBox != null) {
            this._contextComboBox.release();
            this._contextComboBox.removeFocusListener(this);
            this._contextComboBox.removeActionListener(this);
            this._contextComboBox.setRenderer(null);
        }
        if (this._newRefTypeButton != null) {
            this._newRefTypeButton.removeFocusListener(this);
        }
        if (this._detailsRefTypeButton != null) {
            this._detailsRefTypeButton.removeFocusListener(this);
        }
        if (this._jumpToButton != null) {
            this._jumpToButton.removeFocusListener(this);
        }
        this._choiceList = null;
        this._selectedRefType = null;
        this._conditionFE = null;
        this._contextComboBox = null;
        this._newRefTypeButton = null;
        this._detailsRefTypeButton = null;
        this._okButton = null;
        this._cancelButton = null;
        this._jumpToButton = null;
        this._buttonPanel = null;
        this._dialog = null;
        this._scrollPane = null;
        this._originalBorder = null;
        super.release();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this._contextComboBox != null) {
            this._contextComboBox.setEnabled(enabled);
        }
        if (this._newRefTypeButton != null) {
            this._newRefTypeButton.setEnabled(enabled);
        }
        if (this._detailsRefTypeButton != null) {
            this._detailsRefTypeButton.setEnabled(enabled);
        }
        if (this._jumpToButton != null) {
            this._jumpToButton.setEnabled(enabled);
        }
    }

    public void setEditable(boolean editable) {
        if (this._contextComboBox != null) {
            this._contextComboBox.setEditable(editable, false);
            this._contextComboBox.setFocusable(editable);
        }
        if (this._newRefTypeButton != null) {
            this._newRefTypeButton.setEditable(editable);
        }
    }

    private FormulaExpression getConditionFormulaExpression() {
        if (this._conditionFE == null && this.getModel().getXUIDefinition().getStyle().hasKeyRefConditionFormulaExpression()) {
            this._conditionFE = new FormulaExpression(null, this.getModel().getXUIDefinition().getStyle().getKeyRefConditionFE());
        }
        return this._conditionFE;
    }

    protected SimpleType getReferencedKeyFieldType() {
        if (this._referencedKeyFieldType == null) {
            this._referencedKeyFieldType = (SimpleType)((SimpleType)this.getModel()).getReferencedKeyType();
        }
        return this._referencedKeyFieldType;
    }

    protected Type evaluateKeyFieldTypeInEdTypeBranch() {
        return this.getSimpleModel().evaluatePossibleKeyType();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (this.getModel() != null && evt.getSource() != null && evt.getSource() instanceof Type) {
            if (evt.getSource() == this.getReferencedKeyFieldType()) {
                this.populateModel();
                this.populateView();
            } else if (evt.getSource() == this.getModel()) {
                this.populateView();
                this.checkButtonEnabling();
            }
        }
    }

    private void checkButtonEnabling() {
        if (this._detailsRefTypeButton != null) {
            this._detailsRefTypeButton.setEnabled(this.canDetailsBeEnabled());
        }
        if (this._jumpToButton != null) {
            this._jumpToButton.setEnabled(this.canJumpToBeEnabled());
        }
    }

    public void requestFocus() {
        if (this._detailsRefTypeButton != null && this._detailsRefTypeButton.isFocusable()) {
            this._detailsRefTypeButton.requestFocus();
        }
    }

    public void keyAdded(KeyKeyRefEvent event) {
        if (event.getKeyName().equals(this.getAssignedKeyName())) {
            this.updateContextComboBox();
            this.setSelectedTypeFromModel();
            if (this._isAddingNewType) {
                this._createdReference = event.getEventSourceType();
            }
        }
    }

    public void keyChanged(KeyKeyRefEvent event) {
        if (event.getKeyName().equals(this.getAssignedKeyName())) {
            Type lastSelectedType = this.getSelectedType();
            this.updateContextComboBox();
            if (lastSelectedType != event.getEventSourceType()) {
                this.setSelectedTypeFromModel();
            } else {
                this.setSelectedType(((SimpleType)event.getEventSourceType()).getPlainValue());
            }
            this._contextComboBox.repaint();
        }
    }

    public void keyRefAdded(KeyKeyRefEvent event) {
    }

    public void keyRefChanged(KeyKeyRefEvent event) {
    }

    public void keyRefRemoved(KeyKeyRefEvent event) {
    }

    public void keyRemoved(KeyKeyRefEvent event) {
        if (event.getKeyName().equals(this.getAssignedKeyName())) {
            if (event.getEventSourceType() == this._referencedKeyFieldType) {
                this._referencedKeyFieldType = null;
            }
            if (!this.getModel().isReleased()) {
                this.updateContextComboBox();
                this.setSelectedTypeFromModel();
                this._contextComboBox.repaint();
            } else if (JAXFrontProperties.LOG_ENABLED) {
                LogRegistry.getInstance().error(this.getClass(), "not destroyed view found for released key!");
            }
        }
    }

    public void removeRefTypeFromRefList() {
        try {
            ListType keyList = this.evaluateReferencedKeyList();
            if (keyList != null) {
                TypeVisualizerFactory.getInstance().removeVisualizerStructure(this._createdKeyListEntry, true);
                keyList.removeChild(this._createdKeyListEntry);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Type getSelectedType() {
        return this._selectedRefType;
    }

    public String getAssignedKeyName() {
        if (this._assignedKeyName == null) {
            this._assignedKeyName = this.getSimpleModel().getKeyRefDefinition().getKeyName();
        }
        return this._assignedKeyName;
    }

    private Type getToShowType() {
        Type toShowType = this.getParentListEntry(this.getSelectedType());
        if (toShowType == null) {
            toShowType = DOMHelper.getComplexParent((Type)this.getSelectedType());
        }
        if (toShowType == null) {
            toShowType = this.getReferencedKeyFieldType();
            if (toShowType == null) {
                toShowType = this.getSelectedType().getParent();
            } else if (toShowType.isSimple() && toShowType.getParent() != null) {
                toShowType = this.getSelectedType().getParent();
            }
        }
        return toShowType;
    }
}

