/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.swing.ui.beans.FocusableCheckBox;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import com.jaxfront.swing.ui.wrapper.JAXJButtonGroup;
import com.jaxfront.swing.ui.wrapper.JAXJCheckBox;
import com.jaxfront.swing.ui.wrapper.JAXJRadioButton;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class SimpleTypeBooleanView
extends AbstractSimpleTypeView
implements ActionListener,
ItemListener {
    private JPanel _buttonPanel;
    private JPanel _spacerPanel;
    private JAXJButtonGroup _buttonGroup;
    private JAXJRadioButton _yesButton;
    private JAXJRadioButton _noButton;
    private JAXJRadioButton _noneButton;
    private JAXJRadioButton _invisibleButton;
    private JAXJCheckBox _unDefinedButton;
    private FocusableCheckBox _checkBox;
    private boolean hasUserChangedState = false;
    public static final String _true = "true";
    public static final String _false = "false";
    public static final String _iTrue = "1";
    public static final String _iFalse = "0";

    public SimpleTypeBooleanView(SimpleType type) {
        this.setModel((Type)type);
    }

    public SimpleTypeBooleanView(SimpleType type, Type context) {
        super(context);
        this.setModel((Type)type);
    }

    public void actionPerformed(ActionEvent e) {
        this.hasUserChangedState = true;
        if (this._noneButton != null && e.getSource() == this._noneButton) {
            ((SimpleType)this.getModel()).setValue((Object)this, null, false);
        } else {
            this.populateModel();
        }
    }

    protected JComponent createEditorComponent() {
        if (this.getStyle().isBooleanViewCheckBox()) {
            this._checkBox = new FocusableCheckBox();
            this._checkBox.addItemListener(this);
            this.setEditorField(this._checkBox);
            this.setFirstFocusableComponent(this._checkBox);
            this._editorComponent = this._checkBox;
        } else {
            int spaceBetweenButtons = 0;
            if (UIManager.getLookAndFeel().getName().startsWith("JGoodies Plastic")) {
                spaceBetweenButtons = 10;
            }
            FormLayout formLayout = new FormLayout("p," + spaceBetweenButtons + ",p," + spaceBetweenButtons + ",p", "f:p:g");
            this._buttonPanel = new JPanel(formLayout);
            this._buttonPanel.setFocusable(true);
            this._buttonGroup = new JAXJButtonGroup();
            String yesButtonText = GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_yes", "Yes");
            String noButtonText = GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_no", "No");
            this._yesButton = new JAXJRadioButton(yesButtonText);
            this._noButton = new JAXJRadioButton(noButtonText);
            this._yesButton.addActionListener(this);
            this._yesButton.addFocusListener(this);
            this._noButton.addActionListener(this);
            this._noButton.addFocusListener(this);
            this._spacerPanel = new JPanel();
            if (this.getDOM().getGlobalDefinition().isFirstRadioButtonYes()) {
                this._buttonGroup.add(this._yesButton);
                this._buttonGroup.add(this._noButton);
                this._buttonPanel.add((Component)this._yesButton, "1,1");
                this._buttonPanel.add((Component)this._spacerPanel, "2,1");
                this._buttonPanel.add((Component)this._noButton, "3,1");
                this.setFirstFocusableComponent(this._yesButton);
            } else {
                this._buttonGroup.add(this._noButton);
                this._buttonGroup.add(this._yesButton);
                this._buttonPanel.add((Component)this._noButton, "1,1");
                this._buttonPanel.add((Component)this._yesButton, "3,1");
                this.setFirstFocusableComponent(this._noButton);
            }
            String defaultValue = ((SimpleType)this.getModel()).getDefaultValue();
            if (this.getStyle().getLeafDefaultValue() != null) {
                defaultValue = this.getStyle().getLeafDefaultValue();
            }
            if (this.getStyle().isBoolean3StateButton() || defaultValue == null && !this.getModel().isRequired() && !this.getDOM().getGlobalDefinition().isSingleChoiceAndSerialize() && this.getDOM().getGlobalDefinition().isUsingBooleanDefaultOption()) {
                String noneText = "(" + GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_default", "Default") + ")";
                this._noneButton = new JAXJRadioButton(noneText);
                this._noneButton.setSelected(true);
                this._noneButton.addActionListener(this);
                this._buttonPanel.add((Component)this._spacerPanel, "4,1");
                this._buttonPanel.add((Component)this._noneButton, "5,1");
                this._buttonGroup.add(this._noneButton);
            }
            this._editorComponent = this._buttonPanel;
        }
        return this._editorComponent;
    }

    public String getText() {
        String value = null;
        if (this.hasUserChangedState) {
            value = this._checkBox != null ? (this._checkBox.isSelected() ? _true : _false) : (this._buttonGroup.isSelected(this._yesButton.getModel()) ? _true : _false);
        }
        return value;
    }

    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        this.hasUserChangedState = true;
        if (this._unDefinedButton != null && e.getSource() == this._unDefinedButton) {
            if (this._invisibleButton == null) {
                this._invisibleButton = new JAXJRadioButton();
                this._buttonGroup.add(this._invisibleButton);
            }
            if (e.getStateChange() == 1) {
                ((SimpleType)this.getModel()).setValue((Object)this, "", false);
                this._invisibleButton.setSelected(true);
                this._noButton.setSelected(false);
                this._yesButton.setSelected(false);
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        } else if (e.getSource() == this._checkBox) {
            this.populateModel();
        }
    }

    public void populateView() {
        boolean state;
        boolean isDefinded = false;
        String nativeValue = ((SimpleType)this.getModel()).getPlainValue();
        String modelValue = ((SimpleType)this.getModel()).getValue();
        String defaultValue = ((SimpleType)this.getModel()).getDefaultValue();
        if (modelValue != null) {
            if (modelValue.equals(_iFalse)) {
                modelValue = _false;
            } else if (modelValue.equals(_iTrue)) {
                modelValue = _true;
            }
        }
        if (nativeValue != null) {
            if (nativeValue.equals(_iFalse)) {
                nativeValue = _false;
            } else if (nativeValue.equals(_iTrue)) {
                nativeValue = _true;
            }
        }
        String xuiDefaultValue = this.getStyle().getLeafDefaultValue();
        if (modelValue == null || modelValue.length() == 0) {
            if (xuiDefaultValue != null && xuiDefaultValue.length() > 0) {
                state = xuiDefaultValue.equals(_true);
                isDefinded = true;
                ((SimpleType)this.getModel()).setValue((Object)this, Boolean.toString(state), false);
            } else if (defaultValue != null && defaultValue.length() > 0) {
                state = defaultValue.equals(_true);
                isDefinded = true;
                ((SimpleType)this.getModel()).setValue((Object)this, Boolean.toString(state), false);
            } else {
                state = false;
            }
        } else {
            state = modelValue.equals(_true);
            isDefinded = true;
        }
        if (this.getModel().isRequired()) {
            isDefinded = true;
        }
        if (!this.getStyle().isBooleanViewRadioButtonUnselected()) {
            if (this.getModel() != null && isDefinded) {
                this.select(state);
            }
        } else if (nativeValue != null) {
            state = nativeValue.equals(_true);
            this.select(state);
        }
    }

    public void release() {
        super.release();
        if (this._checkBox != null) {
            this._checkBox.removeFocusListener(this);
        }
        if (this._yesButton != null) {
            this._yesButton.removeFocusListener(this);
        }
        if (this._noButton != null) {
            this._noButton.removeFocusListener(this);
        }
        this._buttonPanel = null;
        this._buttonGroup = null;
        this._yesButton = null;
        this._noButton = null;
        this._invisibleButton = null;
        this._unDefinedButton = null;
        this._checkBox = null;
    }

    private void select(boolean yesNo) {
        if (this._checkBox != null) {
            this._checkBox.setSelected(yesNo);
        } else if (this._buttonGroup != null) {
            if (this._yesButton != null) {
                this._buttonGroup.setSelected(this._yesButton.getModel(), yesNo);
            }
            if (this._noButton != null) {
                this._buttonGroup.setSelected(this._noButton.getModel(), !yesNo);
            }
        }
    }

    public void setEnabled(boolean enabled, boolean setOptionalToo) {
        super.setEnabled(enabled, setOptionalToo);
        if (this._checkBox != null) {
            this._checkBox.setEnabled(enabled);
        } else {
            if (this._noButton != null) {
                this._noButton.setEnabled(enabled);
            }
            if (this._yesButton != null) {
                this._yesButton.setEnabled(enabled);
            }
            if (this._unDefinedButton != null) {
                this._unDefinedButton.setEditable(enabled);
            }
            if (this._invisibleButton != null) {
                this._invisibleButton.setEditable(enabled);
            }
            if (this._noneButton != null) {
                this._noneButton.setEditable(enabled);
            }
        }
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (editable) {
            this.setRequired(this.getModel().isRequired());
        }
        if (this._noButton != null) {
            this._noButton.setEditable(editable);
            if (editable) {
                this._noButton.setOpaque(true);
                this._noButton.setFocusable(true);
            } else {
                this._noButton.setOpaque(false);
                this._noButton.setFocusable(true);
            }
        }
        if (this._yesButton != null) {
            this._yesButton.setEditable(editable);
            if (editable) {
                this._yesButton.setOpaque(true);
                this._yesButton.setFocusable(true);
            } else {
                this._yesButton.setOpaque(false);
                this._yesButton.setFocusable(true);
            }
        }
        if (this._unDefinedButton != null) {
            this._unDefinedButton.setEditable(editable);
        }
        if (this._noneButton != null) {
            this._noneButton.setEditable(editable);
        }
        if (this._invisibleButton != null) {
            this._invisibleButton.setEditable(editable);
        }
        if (this._checkBox != null) {
            this._checkBox.setEditable(editable);
            if (editable) {
                this._checkBox.setOpaque(true);
                this._checkBox.setFocusable(true);
            } else {
                this._checkBox.setOpaque(false);
                this._checkBox.setFocusable(true);
            }
        }
    }

    public void setRequired(boolean required) {
    }

    public String toString() {
        return super.toString();
    }

    public void focusLost(FocusEvent e) {
    }

    public void setBackground(Color color) {
        if (this._buttonGroup != null) {
            this._buttonGroup.setBackground(color);
        }
        if (this._spacerPanel != null) {
            this._spacerPanel.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        if (this._buttonGroup != null) {
            this._buttonGroup.setForeground(color);
        }
        if (this._spacerPanel != null) {
            this._spacerPanel.setForeground(color);
        }
    }
}

