/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.schema.SchemaSimpleType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.JAXFrontDateTools;
import com.jaxfront.swing.ui.beans.JCalendarPopUp;
import com.jaxfront.swing.ui.beans.JTimeOneField;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SimpleTypeDateTimeView
extends AbstractSimpleTypeView
implements PropertyChangeListener {
    private JTimeOneField _timeField = null;
    private JCalendarPopUp _calendarPopUp = null;
    private Calendar _calendar = null;
    private String _currentDate = "";
    private String _currentTime = "";
    private String _day = "";
    private String _month = "";
    private String _year = "";

    public SimpleTypeDateTimeView(SimpleType type) {
        this.setModel((Type)type);
    }

    public SimpleTypeDateTimeView(SimpleType type, Type context) {
        super(context);
        this.setModel((Type)type);
    }

    protected JComponent createEditorComponent() {
        this._calendarPopUp = new JCalendarPopUp((SimpleType)this.getModel());
        this._calendar = Calendar.getInstance();
        this._calendarPopUp.addPropertyChangeListener(this);
        this._calendarPopUp.addFocusListener(this);
        this._calendarPopUp.addKeyListener(this);
        this.setFirstFocusableComponent(this._calendarPopUp.getTextField());
        this.setEditorField(this._calendarPopUp.getTextField());
        this.initDateToday();
        boolean useErrorSound = this.getDOM().getGlobalDefinition().isErrorSound();
        this._timeField = new JTimeOneField(useErrorSound, this.getModel(), !((SchemaSimpleType)this.getModel().getSchemaType()).hasRegularExpression());
        this._timeField.setPreferredSize(new Dimension(60, (int)this.getDefaultComponentHeight()));
        this._timeField.addPropertyChangeListener(this);
        this._timeField.addFocusListener(this);
        this._timeField.getTimeField().addKeyListener(this);
        JPanel editor = new JPanel();
        editor.setLayout(new BorderLayout(0, 0));
        editor.addPropertyChangeListener(this);
        editor.add(this._calendarPopUp);
        editor.add((Component)this._timeField, "East");
        this._editorComponent = editor;
        return editor;
    }

    private String getCalendarString(JCalendarPopUp popUp) {
        return popUp.getCurrentDateFromTextField();
    }

    public String getText() {
        String dateTime = "";
        this._currentDate = this.getCalendarString(this._calendarPopUp);
        this._currentTime = this._timeField.getTime();
        if (!(this._currentDate != null && this._currentDate.length() != 0 || this._currentTime != null && this._currentTime.length() != 0 && !this._currentTime.startsWith("00:00:00"))) {
            return dateTime;
        }
        if (this._currentDate == null || this._currentDate.length() == 0) {
            this._currentDate = "";
        }
        if (this._currentTime == null || this._currentTime.length() == 0) {
            this._currentTime = "";
        }
        dateTime = this._currentDate + "T" + this._currentTime;
        return dateTime;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("time")) {
            this.populateModel();
            this.populateView();
        } else if (evt.getPropertyName().equals("calendar")) {
            if (evt.getNewValue() != null) {
                this.populateModel();
                this.populateView();
            }
        } else if (evt.getPropertyName().equals("newDate")) {
            this.populateModel();
            this.populateView();
        } else if (this.getModel() == evt.getSource()) {
            this.populateView();
        }
    }

    private void initDateToday() {
        if (this._calendar != null) {
            this._day = Integer.toString(this._calendar.get(5));
            if (this._day != null && this._day.length() < 2) {
                this._day = "0" + this._day;
            }
            this._month = Integer.toString(this._calendar.get(2) + 1);
            if (this._month != null && this._month.length() < 2) {
                this._month = "0" + this._month;
            }
            this._year = Integer.toString(this._calendar.get(1));
        }
    }

    private void splitDate(String longDate) {
        if (longDate != null && longDate.length() > 0) {
            StringTokenizer stk = new StringTokenizer(longDate, ".");
            if (stk.hasMoreElements()) {
                this._day = stk.nextToken();
            }
            if (stk.hasMoreElements()) {
                this._month = stk.nextToken();
            }
            if (stk.hasMoreElements()) {
                this._year = stk.nextToken();
            }
        }
    }

    public void populateView() {
        if (this._model != null) {
            this.convertToDateTimeView(((SimpleType)this.getModel()).getValue());
            if (this._calendarPopUp != null && this._currentDate != null) {
                this._calendarPopUp.setText(this._currentDate);
            }
            if (this._timeField != null && this._currentTime != null) {
                if (this._currentTime != null && this.getStyle().getTimeFormat() != null) {
                    try {
                        this._currentTime = JAXFrontDateTools.formatTo((DateFormat)JAXFrontDateTools.isoTimeFormat, (String)this._currentTime, (String)this.getStyle().getTimeFormat());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this._timeField.setTime(this._currentTime);
            }
        }
        if (this.getEditor() != null) {
            this.getEditor().repaint();
        }
    }

    private void convertToDateTimeView(String value) {
        int indexDate;
        if (value != null && value.length() > 0 && (indexDate = value.indexOf("T")) > 0) {
            String date = value.substring(0, indexDate);
            StringTokenizer st = new StringTokenizer(date, "-");
            if (st.hasMoreElements()) {
                this._year = st.nextToken();
            }
            if (st.hasMoreElements()) {
                this._month = st.nextToken();
            }
            if (st.hasMoreElements()) {
                this._day = st.nextToken();
            }
            this._currentDate = date;
            this._currentTime = value.substring(indexDate + 1, value.length());
        }
    }

    public void populateModel() {
        super.populateModel();
    }

    public void setRequired(boolean required) {
        if (this._calendarPopUp != null && this._timeField != null) {
            if (this.getStyle().getBackgroundColor() != null) {
                this._calendarPopUp.setBackground(this.getStyle().getBackgroundColor());
                this._timeField.setBackground(this.getStyle().getBackgroundColor());
            } else if (required) {
                if (this.getStyle().isApplicationRequired()) {
                    this._calendarPopUp.setBackground(this.getDOM().getApplicationFieldColor());
                    this._timeField.setBackground(this.getDOM().getApplicationFieldColor());
                } else {
                    this._calendarPopUp.setBackground(this.getDOM().getSchemaRequiredFieldColor());
                    this._timeField.setBackground(this.getDOM().getSchemaRequiredFieldColor());
                }
            } else {
                this._calendarPopUp.setBackground(this.getDOM().getOptionalFieldColor());
                this._timeField.setBackground(this.getDOM().getOptionalFieldColor());
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this._timeField != null && this._calendarPopUp != null) {
            this._timeField.setEnabled(enabled);
        }
        this._calendarPopUp.setEnabled(enabled);
    }

    public void setEditable(boolean editable) {
        if (this._timeField != null && this._calendarPopUp != null) {
            this._timeField.setEditable(editable);
            this._calendarPopUp.setEditable(editable);
            this._calendarPopUp.setBackground(this._timeField.getBackground());
        }
        if (editable) {
            this.initColor();
        }
    }

    public void release() {
        if (this._model != null && this._model.getDOM() != null) {
            this.getDOM().getPropertyChangeSupport().removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (this._calendarPopUp != null) {
            this._calendarPopUp.removeFocusListener(this);
            this._calendarPopUp.removeKeyListener(this);
            this._calendarPopUp.release();
        }
        if (this._timeField != null) {
            this._timeField.removeFocusListener(this);
            this._timeField.removeKeyListener(this);
        }
        super.release();
    }
}

