/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.dom.CodeTables;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import com.jaxfront.swing.ui.wrapper.JAXJButtonGroup;
import com.jaxfront.swing.ui.wrapper.JAXJRadioButton;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SimpleTypeRadioView
extends AbstractSimpleTypeView
implements ActionListener {
    private JAXJButtonGroup _buttonGroup = null;

    public SimpleTypeRadioView(SimpleType type) {
        this.setModel((Type)type);
    }

    public SimpleTypeRadioView(SimpleType type, Type context) {
        super(context);
        this.setModel((Type)type);
    }

    public void setBackground(Color color) {
        if (this._buttonGroup != null) {
            this._buttonGroup.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        if (this._buttonGroup != null) {
            this._buttonGroup.setForeground(color);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.populateModel();
    }

    protected JComponent createEditorComponent() {
        int i;
        JPanel radioBtnPanel = new JPanel();
        int orientationType = 0;
        String orientation = ((SimpleType)this.getModel()).getXUIDefinition().getStyle().getLeafEnumerationOrientation();
        if (orientation != null && orientation.equals("vertical")) {
            orientationType = 1;
        }
        radioBtnPanel.setLayout(new BoxLayout(radioBtnPanel, orientationType));
        String[] enumeration = ((SimpleType)this.getModel()).getEnumeration();
        String defaultSelection = ((SimpleType)this.getModel()).getXUIDefinition().getStyle().getLeafDefaultValue();
        String codeset = ((SimpleType)this.getModel()).getXUIDefinition().getStyle().getCodeSetName();
        String currentValue = this.getDOM().getSchema().getCodeTables().getText(this.getModel(), codeset, ((SimpleType)this.getModel()).getValue(), this.getDOM().getLanguage());
        boolean useCodeSet = false;
        AbstractButton invalidButton = null;
        boolean isFirstRadioButton = true;
        boolean useNone = false;
        if (enumeration.length > 0 && enumeration[0] != null && enumeration[0].equals("")) {
            useNone = true;
            if (this.getModel().isRequired()) {
                useNone = false;
                String[] enumerationOld = enumeration;
                enumeration = new String[enumeration.length - 1];
                for (i = 1; i < enumerationOld.length; ++i) {
                    enumeration[i - 1] = enumerationOld[i];
                }
            } else {
                enumeration[0] = GUIComponentNLS.getInstance().getNLSNoneText(this.getDOM());
            }
        }
        String display = null;
        for (i = 0; i < enumeration.length; ++i) {
            display = enumeration[i];
            if (display == null || display.equals("")) continue;
            String value = display = enumeration[i];
            if (!(codeset == null || useNone && i == 0)) {
                value = this.getDOM().getSchema().getCodeTables().getId(this.getModel(), codeset, i, this.getDOM().getLanguage());
                useCodeSet = true;
            }
            boolean selected = value != null && value.equals(defaultSelection);
            JAXJRadioButton radioBtn = new JAXJRadioButton(display, selected);
            radioBtn.setActionCommand(value);
            this.getButtonGroup().add(radioBtn);
            radioBtn.addActionListener(this);
            radioBtn.addFocusListener(this);
            if (isFirstRadioButton) {
                this.setFirstFocusableComponent(radioBtn);
            }
            if (useCodeSet && !this.getStyle().isEnumerationAllowingInvalidCodes() && CodeTables.isValueInvalid((String)radioBtn.getActionCommand(), (String)this.getDOM().getLanguage())) {
                radioBtn.setVisible(false);
                if (radioBtn.getActionCommand().equals(currentValue)) {
                    invalidButton = radioBtn;
                }
            }
            if (i > 0 && orientationType == 0) {
                JLabel spacer = new JLabel("  ");
                radioBtnPanel.add(spacer);
            }
            radioBtnPanel.add(radioBtn);
            isFirstRadioButton = false;
        }
        if (invalidButton != null) {
            invalidButton.setEnabled(false);
            invalidButton.setVisible(true);
            Vector<AbstractButton> validButtons = new Vector<AbstractButton>();
            validButtons.add(invalidButton);
            Enumeration<AbstractButton> radiobtns = this.getButtonGroup().getElements();
            JAXJRadioButton radioBtn = null;
            while (radiobtns.hasMoreElements()) {
                radioBtn = (JAXJRadioButton)radiobtns.nextElement();
                validButtons.add(radioBtn);
                this.getButtonGroup().remove(radioBtn);
                radioBtnPanel.remove(radioBtn);
            }
            for (int i2 = 0; i2 < validButtons.size(); ++i2) {
                radioBtn = (JAXJRadioButton)validButtons.get(i2);
                this.getButtonGroup().add(radioBtn);
                radioBtnPanel.add(radioBtn);
            }
        }
        this._editorComponent = radioBtnPanel;
        return radioBtnPanel;
    }

    private JAXJButtonGroup getButtonGroup() {
        if (this._buttonGroup == null) {
            this._buttonGroup = new JAXJButtonGroup();
        }
        return this._buttonGroup;
    }

    private boolean isDefaultValue(String value) {
        boolean isDefaultValue = false;
        if (value != null && value.equals(this.getSimpleModel().getDefaultValue())) {
            isDefaultValue = true;
        }
        return isDefaultValue;
    }

    public String getText() {
        String currentValue = "";
        if (this.getButtonGroup().getSelection() != null && (currentValue = this.getButtonGroup().getSelection().getActionCommand()) != null && currentValue.equals(GUIComponentNLS.getInstance().getNLSNoneText(this.getDOM()))) {
            currentValue = null;
        }
        return currentValue;
    }

    public void populateView() {
        String value = ((SimpleType)this.getModel()).getValue();
        String defaultValue = ((SimpleType)this.getModel()).getDefaultValue();
        String defaultSelection = this.getStyle().getLeafEnumerationDefaultSelection();
        if (value == null || value.length() == 0) {
            if (defaultSelection != null && defaultSelection.length() > 0) {
                value = defaultSelection;
                ((SimpleType)this.getModel()).setValue((Object)this, value, false);
            } else if (defaultValue != null && defaultValue.length() > 0) {
                value = defaultValue;
                ((SimpleType)this.getModel()).setValue((Object)this, value, false);
            }
        } else if (value.equals(defaultValue) && defaultSelection != null) {
            value = defaultSelection;
        }
        Enumeration<AbstractButton> radiobtns = this.getButtonGroup().getElements();
        while (radiobtns.hasMoreElements()) {
            JAXJRadioButton radioBtn = (JAXJRadioButton)radiobtns.nextElement();
            if (radioBtn.getActionCommand().equals(value)) {
                radioBtn.setSelected(true);
                continue;
            }
            if (value != null || !radioBtn.getActionCommand().equals(GUIComponentNLS.getInstance().getNLSNoneText(this.getDOM()))) continue;
            radioBtn.setSelected(true);
        }
    }

    public void setEnabled(boolean enabled, boolean setOptionalToo) {
        super.setEnabled(enabled, setOptionalToo);
        if (this._buttonGroup != null) {
            Enumeration<AbstractButton> groupElems = this._buttonGroup.getElements();
            while (groupElems.hasMoreElements()) {
                JComponent comp = groupElems.nextElement();
                comp.setEnabled(enabled);
            }
        }
    }

    public void setEditable(boolean editable) {
        if (this._buttonGroup != null) {
            if (editable) {
                this.setRequired(this.getModel().isRequired());
            }
            Enumeration<AbstractButton> groupElems = this._buttonGroup.getElements();
            while (groupElems.hasMoreElements()) {
                JAXJRadioButton comp = (JAXJRadioButton)groupElems.nextElement();
                comp.setEditable(editable);
                if (!editable) {
                    comp.setOpaque(false);
                    continue;
                }
                comp.setOpaque(true);
            }
        }
    }

    public void setRequired(boolean required) {
    }

    public void release() {
        super.release();
        if (this.getButtonGroup() != null) {
            Enumeration<AbstractButton> buttons = this.getButtonGroup().getElements();
            while (buttons.hasMoreElements()) {
                AbstractButton object = buttons.nextElement();
                if (!(object instanceof JButton)) continue;
                ((JButton)object).removeFocusListener(this);
            }
        }
        this._buttonGroup = null;
    }
}

