/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.image;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;

public class ImageViewer
extends JComponent {
    private static final long serialVersionUID = 2101898117587404467L;
    private Image image = null;

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n = super.getWidth();
        int n2 = super.getHeight();
        graphics.clearRect(0, 0, n, n2);
        if (this.image != null) {
            int n3 = this.image.getWidth(null);
            int n4 = this.image.getHeight(null);
            int n5 = n - 10;
            int n6 = n2 - 10;
            if (n5 > 0 && n6 > 0 && n3 > 0 && n4 > 0) {
                int n7 = Math.min(4096 * n5 / n3, 4096 * n6 / n4);
                int n8 = n3 * n7 / 4096;
                int n9 = n4 * n7 / 4096;
                int n10 = (n - n8) / 2;
                int n11 = (n2 - n9) / 2;
                int n12 = n10 + n8;
                int n13 = n11 + n9;
                graphics.drawImage(this.image, n10, n11, n12, n13, 0, 0, n3, n4, null);
                Graphics2D graphics2D = (Graphics2D)graphics;
                AffineTransform affineTransform = graphics2D.getTransform();
                double d = (double)(n12 - n10) / (double)n3;
                BasicStroke basicStroke = new BasicStroke((float)(2.0 / d));
                affineTransform.translate(n10, n11);
                affineTransform.scale(d, d);
                graphics2D.setTransform(affineTransform);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setStroke(basicStroke);
                this.extendPaint(graphics, n3, n4);
            }
        }
    }

    protected void extendPaint(Graphics graphics, int n, int n2) {
    }
}

