/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.property;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.stamppagetor.ImageCache;
import org.stamppagetor.ImageSelectionDialog;
import org.stamppagetor.property.PropertyCell;
import org.stamppagetor.property.PropertyTableModel;

public class PropertyCellImage
extends PropertyCell
implements ActionListener {
    private final JPanel componentPanel;
    private final JTextField field = new JTextField();
    private final JButton button;
    private static final String buttonAction = "selectImage";

    public PropertyCellImage(PropertyTableModel propertyTableModel, int n) {
        super(propertyTableModel, n);
        this.field.setBorder(null);
        this.field.addActionListener(this);
        this.field.addFocusListener(this);
        this.button = new JButton("Img...");
        this.button.setActionCommand(buttonAction);
        this.button.addActionListener(this);
        this.componentPanel = new JPanel();
        this.componentPanel.setLayout(new BorderLayout());
        this.componentPanel.add((Component)this.field, "Center");
        this.componentPanel.add((Component)this.button, "East");
        super.setCellStyle(this.componentPanel);
    }

    @Override
    public JComponent getControl() {
        return this.componentPanel;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.field.selectAll();
    }

    @Override
    protected void setValue(Object object) {
        this.field.setText(this.tableModel.getInfo(this.tableIndex).toString(object));
    }

    @Override
    public void storeValue() {
        String string = this.field.getText();
        Object object = this.tableModel.getInfo(this.tableIndex).parseString(string);
        if (object != null) {
            this.tableModel.setValueAt(object, this.tableIndex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(buttonAction)) {
            ImageSelectionDialog imageSelectionDialog = new ImageSelectionDialog(null, ImageCache.getInstance());
            if (imageSelectionDialog != null) {
                imageSelectionDialog.showDialog();
                String string = imageSelectionDialog.getSelection();
                if (string != null) {
                    this.field.setText(string);
                    this.storeValue();
                }
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }
}

