/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.ui;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.stamppagetor.StampDocument;
import org.stamppagetor.UiPlatform;
import org.stamppagetor.ui.RuleStatic;
import org.stamppagetor.ui.UiBundle;
import org.stamppagetor.ui.UiItemMenu;

public class UiBundleExportPfd
extends UiBundle {
    private static final FileNameExtensionFilter pdfFileFilter = new FileNameExtensionFilter("PDF documents", "pdf");

    public UiBundleExportPfd() {
        super("EXPORT_PDF", RuleStatic.TRUE);
        this.addUiItem(new UiItemMenu(1500, "Album", "Export As PDF..."));
    }

    @Override
    public void doAction(UiPlatform uiPlatform) {
        try {
            StampDocument stampDocument = uiPlatform.getDoc();
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(pdfFileFilter);
            int n = jFileChooser.showSaveDialog(uiPlatform.getMainFrame());
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                stampDocument.printPDF(file);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Can not export PDF!", "Export Error", 0);
        }
    }
}

