/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.tool;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.NonBlockingGenericDialog;
import ij.gui.Overlay;
import ij.gui.ShapeRoi;
import ij.gui.Toolbar;
import ij.plugin.Colors;
import ij.plugin.tool.PlugInTool;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;

public class OverlayBrushTool
extends PlugInTool
implements Runnable {
    private static String WIDTH_KEY = "obrush.width";
    private float width = (float)Prefs.get(WIDTH_KEY, 5.0);
    private BasicStroke stroke = new BasicStroke(this.width, 0, 1);
    private GeneralPath path;
    private boolean newPath;
    private int transparency;
    private Thread thread;
    private boolean dialogShowing;

    public void mousePressed(ImagePlus imp, MouseEvent e) {
        ImageCanvas ic = imp.getCanvas();
        float x = (float)ic.offScreenXD(e.getX());
        float y = (float)ic.offScreenYD(e.getY());
        this.path = new GeneralPath();
        this.path.moveTo(x, y);
        this.newPath = true;
    }

    public void mouseDragged(ImagePlus imp, MouseEvent e) {
        ImageCanvas ic = imp.getCanvas();
        double x = ic.offScreenXD(e.getX());
        double y = ic.offScreenYD(e.getY());
        this.path.lineTo(x, y);
        Overlay overlay = imp.getOverlay();
        if (overlay == null) {
            overlay = new Overlay();
        }
        ShapeRoi roi = new ShapeRoi(this.path);
        Color color = Toolbar.getForegroundColor();
        float red = (float)((double)color.getRed() / 255.0);
        float green = (float)((double)color.getGreen() / 255.0);
        float blue = (float)((double)color.getBlue() / 255.0);
        float alpha = (float)((double)(100 - this.transparency) / 100.0);
        roi.setStrokeColor(new Color(red, green, blue, alpha));
        roi.setStroke(this.stroke);
        if (this.newPath) {
            overlay.add(roi);
            this.newPath = false;
        } else {
            overlay.remove(overlay.size() - 1);
            overlay.add(roi);
        }
        imp.setOverlay(overlay);
    }

    public void showOptionsDialog() {
        this.thread = new Thread((Runnable)this, "Brush Options");
        this.thread.setPriority(5);
        this.thread.start();
        if (IJ.debugMode) {
            IJ.log("Options.show: " + this.dialogShowing);
        }
    }

    public String getToolName() {
        return "Overlay Brush Tool";
    }

    public String getToolIcon() {
        return "C037La077Ld098L6859L4a2fL2f4fL3f99L5e9bL9b98L6888L5e8dL888cC123P2f7f9ebdcaf70";
    }

    public void run() {
        new Options();
    }

    class Options
    implements DialogListener {
        Options() {
            if (OverlayBrushTool.this.dialogShowing) {
                return;
            }
            OverlayBrushTool.this.dialogShowing = true;
            if (IJ.debugMode) {
                IJ.log("Options: true");
            }
            this.showDialog();
        }

        public void showDialog() {
            Color color = Toolbar.getForegroundColor();
            String colorName = Colors.getColorName(color, "red");
            NonBlockingGenericDialog gd = new NonBlockingGenericDialog("Overlay Brush Options");
            gd.addSlider("Brush width (pixels):", 1.0, 50.0, OverlayBrushTool.this.width);
            gd.addSlider("Transparency (%):", 0.0, 100.0, OverlayBrushTool.this.transparency);
            gd.addChoice("Color:", Colors.colors, colorName);
            gd.setInsets(10, 0, 0);
            gd.addMessage("Also set the color using Color Picker (shift-k)");
            gd.hideCancelButton();
            gd.addHelp("");
            gd.setHelpLabel("Undo");
            gd.setOKLabel("Close");
            gd.addDialogListener(this);
            ((GenericDialog)gd).showDialog();
            if (IJ.debugMode) {
                IJ.log("Options: false");
            }
            OverlayBrushTool.this.dialogShowing = false;
        }

        public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
            if (e != null && e.toString().contains("Undo")) {
                ImagePlus imp = WindowManager.getCurrentImage();
                if (imp == null) {
                    return true;
                }
                Overlay overlay = imp.getOverlay();
                if (overlay != null && overlay.size() > 0) {
                    overlay.remove(overlay.size() - 1);
                    imp.draw();
                }
                return true;
            }
            OverlayBrushTool.this.width = (float)gd.getNextNumber();
            OverlayBrushTool.this.transparency = (int)gd.getNextNumber();
            String colorName = gd.getNextChoice();
            Color color = Colors.getColor(colorName, Color.black);
            Toolbar.setForegroundColor(color);
            OverlayBrushTool.this.stroke = new BasicStroke(OverlayBrushTool.this.width, 0, 1);
            Prefs.set(WIDTH_KEY, OverlayBrushTool.this.width);
            return true;
        }
    }
}

