/*
 * Decompiled with CFR 0.152.
 */
package org.bric.gui.output;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.LineBorder;
import org.bric.utils.Utils;

public class ProgressBarFrame
extends JFrame {
    int processed = 0;
    int total = 0;
    int errors = 0;
    private long startTime;
    private int sleepValue;
    DefaultListModel model = new DefaultListModel();
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel6;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane2;

    public ProgressBarFrame() {
        this.initComponents();
        this.jList1.setModel(this.model);
        this.startTime = System.currentTimeMillis();
        this.sleepValue = Utils.prefs.getInt("sleepValue", 500);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jProgressBar1 = new JProgressBar();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Image Resize Progress");
        this.jScrollPane2.setViewportView(this.jList1);
        this.jPanel2.setBackground(new Color(230, 230, 240));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(0, 0, 0), 1, true), "Details"));
        this.jLabel6.setText("Errors: 0");
        this.jLabel2.setText("Processed: 0/0");
        this.jButton1.setText("Cancel");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgressBarFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Hide List");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgressBarFrame.this.jButton2ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Elapsed Time: 0s");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1, -2, 151, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 99, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton2).addComponent(this.jButton1, -2, 71, -2)).addContainerGap()));
        jPanel2Layout.linkSize(0, this.jLabel1, this.jLabel2);
        jPanel2Layout.linkSize(0, this.jButton1, this.jButton2);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel6)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton2).addComponent(this.jLabel1)).addGap(0, 6, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2).addComponent(this.jProgressBar1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 157, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -2, 26, -2).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.jScrollPane2.setVisible(!this.jScrollPane2.isVisible());
        this.jButton2.setText(this.jButton2.getText().contains("Hide") ? "Show List" : "Hide List");
        this.setResizable(!this.isResizable());
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ProgressBarFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(ProgressBarFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ProgressBarFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ProgressBarFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ProgressBarFrame().setVisible(true);
            }
        });
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        Utils.centerWindow(this);
    }

    public void updateValue(boolean succeded) {
        ++this.processed;
        this.jProgressBar1.setValue(this.processed * 100 / this.total);
        this.updateLabel();
        if (!succeded) {
            this.updateErrors();
        }
        if (this.processed == this.total) {
            this.close();
        }
    }

    public void skip() {
        ++this.processed;
        this.updateLabel();
    }

    private void updateLabel() {
        this.jLabel2.setText("Processed: " + this.processed + "/" + this.total);
        SimpleDateFormat formatter = new SimpleDateFormat("mm:ss:SSS");
        String dateFormatted = formatter.format(System.currentTimeMillis() - this.startTime);
        this.jLabel1.setText("Elapsed Time: " + dateFormatted);
    }

    public void showProgress(final String file) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressBarFrame.this.model.addElement(file);
            }
        });
    }

    public void setImagesCount(int imagesCount) {
        this.total = imagesCount;
        this.jLabel2.setText("Processed: " + this.processed + "/" + this.total);
    }

    public void updateErrors() {
        ++this.errors;
        this.jLabel6.setText("Errors: " + this.errors);
    }

    public void close() {
        try {
            Thread.sleep(this.sleepValue);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ProgressBarFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.dispose();
    }

    @Override
    public void dispose() {
        super.dispose();
        System.gc();
    }
}

