/*
 * Decompiled with CFR 0.152.
 */
package org.bric.gui.tabs;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.bric.gui.tabs.ImageEditTab;
import org.bric.imageEditParameters.ResizeParameters;

public class ResizeJPanel
extends JPanel
implements ImageEditTab {
    private JCheckBox antialisingCheckBox;
    private JCheckBox aspectCheckBox;
    private JSpinner heightSpinner;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JCheckBox orientationCheckBox;
    private JComboBox renderingComboBox;
    private JCheckBox resizeEnableCheckBox;
    private JComboBox resizeFilterComboBox;
    private JComboBox sharpenComboBox;
    private JComboBox unitCombo;
    private JSpinner widthSpinner;

    public ResizeJPanel() {
        this.initComponents();
        this.updateModels();
    }

    private void initComponents() {
        this.resizeEnableCheckBox = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.widthSpinner = new JSpinner();
        this.heightSpinner = new JSpinner();
        this.unitCombo = new JComboBox();
        this.aspectCheckBox = new JCheckBox();
        this.orientationCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.antialisingCheckBox = new JCheckBox();
        this.resizeFilterComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.renderingComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.sharpenComboBox = new JComboBox();
        ResourceBundle bundle = ResourceBundle.getBundle("lang/gui/tabs/Bundle");
        this.resizeEnableCheckBox.setText(bundle.getString("ResizeJPanel.resizeEnableCheckBox.text"));
        this.resizeEnableCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ResizeJPanel.this.resizeEnableCheckBoxItemStateChanged(evt);
            }
        });
        this.jLabel6.setText(bundle.getString("ResizeJPanel.jLabel6.text"));
        this.jLabel6.setEnabled(false);
        this.jLabel7.setText(bundle.getString("ResizeJPanel.jLabel7.text"));
        this.jLabel7.setEnabled(false);
        this.widthSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.widthSpinner.setEnabled(false);
        this.widthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ResizeJPanel.this.widthSpinnerStateChanged(evt);
            }
        });
        this.heightSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.heightSpinner.setEnabled(false);
        this.heightSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ResizeJPanel.this.heightSpinnerStateChanged(evt);
            }
        });
        this.unitCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"pixels", "percent"}));
        this.unitCombo.setEnabled(false);
        this.unitCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ResizeJPanel.this.unitComboItemStateChanged(evt);
            }
        });
        this.aspectCheckBox.setText(bundle.getString("ResizeJPanel.aspectCheckBox.text"));
        this.aspectCheckBox.setEnabled(false);
        this.aspectCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ResizeJPanel.this.aspectCheckBoxItemStateChanged(evt);
            }
        });
        this.orientationCheckBox.setText(bundle.getString("ResizeJPanel.orientationCheckBox.text"));
        this.orientationCheckBox.setEnabled(false);
        this.orientationCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ResizeJPanel.this.orientationCheckBoxItemStateChanged(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(bundle.getString("ResizeJPanel.jPanel1.border.title")));
        this.antialisingCheckBox.setSelected(true);
        this.antialisingCheckBox.setText(bundle.getString("ResizeJPanel.antialisingCheckBox.text"));
        this.antialisingCheckBox.setEnabled(false);
        this.resizeFilterComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"auto", "BiCubic", "BiCubicHighFreqResponse", "BiLinear", "Lanczos3", "MultiStep", "Nearest_Neighbor", "Bell", "Box", "Hermite", "Mitchell", "Triangle", "Thumpnail"}));
        this.resizeFilterComboBox.setEnabled(false);
        this.resizeFilterComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ResizeJPanel.this.resizeFilterComboBoxItemStateChanged(evt);
            }
        });
        this.jLabel1.setText(bundle.getString("ResizeJPanel.jLabel1.text"));
        this.jLabel1.setEnabled(false);
        this.jLabel2.setText(bundle.getString("ResizeJPanel.jLabel2.text"));
        this.jLabel2.setEnabled(false);
        this.renderingComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Quality", "Speed"}));
        this.renderingComboBox.setEnabled(false);
        this.jLabel3.setText(bundle.getString("ResizeJPanel.jLabel3.text"));
        this.jLabel3.setEnabled(false);
        this.sharpenComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"none", "Normal", "Oversharpened", "Soft", "Verysharp"}));
        this.sharpenComboBox.setEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.antialisingCheckBox).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resizeFilterComboBox, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sharpenComboBox, -2, -1, -2).addComponent(this.renderingComboBox, -2, 149, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.antialisingCheckBox, this.jLabel1, this.jLabel2);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.resizeFilterComboBox, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.renderingComboBox, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.sharpenComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.antialisingCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel7, -2, 55, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.widthSpinner).addComponent(this.heightSpinner, -2, 94, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unitCombo, -2, -1, -2)).addComponent(this.aspectCheckBox).addComponent(this.orientationCheckBox))).addComponent(this.resizeEnableCheckBox)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.resizeEnableCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.widthSpinner, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.heightSpinner, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.unitCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.aspectCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.orientationCheckBox).addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void resizeEnableCheckBoxItemStateChanged(ItemEvent evt) {
        Component[] com = this.getComponents();
        for (int a = 0; a < com.length; ++a) {
            if (com[a] == this.resizeEnableCheckBox) continue;
            com[a].setEnabled(this.resizeEnableCheckBox.isSelected());
        }
        this.updateAdvancePanel();
    }

    private void widthSpinnerStateChanged(ChangeEvent evt) {
        this.valueCorrection(0);
    }

    private void heightSpinnerStateChanged(ChangeEvent evt) {
        this.valueCorrection(1);
    }

    private void aspectCheckBoxItemStateChanged(ItemEvent evt) {
        this.updateModels();
    }

    private void orientationCheckBoxItemStateChanged(ItemEvent evt) {
        this.updateModels();
    }

    private void unitComboItemStateChanged(ItemEvent evt) {
        this.updateModels();
    }

    private void resizeFilterComboBoxItemStateChanged(ItemEvent evt) {
        this.updateAdvancePanel();
    }

    public boolean getAntialisingCheckBox() {
        return this.antialisingCheckBox.isSelected();
    }

    public void setAntialisingCheckBox(boolean value) {
        this.antialisingCheckBox.setSelected(value);
    }

    public boolean getAspectCheckBox() {
        return this.aspectCheckBox.isSelected();
    }

    public void setAspectCheckBox(boolean value) {
        this.aspectCheckBox.setSelected(value);
    }

    public String getHeightSpinner() {
        return this.heightSpinner.getValue().toString();
    }

    public void setHeightSpinner(String value) {
        this.heightSpinner.getModel().setValue(Integer.parseInt(value));
    }

    public boolean getOrientationCheckBox() {
        return this.orientationCheckBox.isSelected();
    }

    public void setOrientationCheckBox(boolean value) {
        this.orientationCheckBox.setSelected(value);
    }

    public int getRenderingComboBox() {
        return this.renderingComboBox.getSelectedIndex();
    }

    public void setRenderingComboBox(int index) {
        this.renderingComboBox.setSelectedIndex(index);
    }

    public boolean getResizeEnableCheckBox() {
        return this.resizeEnableCheckBox.isSelected();
    }

    public void setResizeEnableCheckBox(boolean value) {
        this.resizeEnableCheckBox.setSelected(value);
    }

    public int getResizeFilterComboBox() {
        return this.resizeFilterComboBox.getSelectedIndex();
    }

    public void setResizeFilterComboBox(int index) {
        this.resizeFilterComboBox.setSelectedIndex(index);
    }

    public int getSharpenComboBox() {
        return this.sharpenComboBox.getSelectedIndex();
    }

    public void setSharpenComboBox(int index) {
        this.sharpenComboBox.setSelectedIndex(index);
    }

    public int getUnitCombo() {
        return this.unitCombo.getSelectedIndex();
    }

    public void setUnitCombo(int index) {
        this.unitCombo.setSelectedIndex(index);
    }

    public String getWidthSpinner() {
        return this.widthSpinner.getValue().toString();
    }

    public void setWidthSpinner(int widthSpinner) {
        this.widthSpinner.getModel().setValue(widthSpinner);
    }

    @Override
    public ResizeParameters getImageEditParameters() {
        ResizeParameters resizeParameters = new ResizeParameters();
        resizeParameters.setEnabled(this.resizeEnableCheckBox.isSelected());
        resizeParameters.setWidth((Integer)this.widthSpinner.getValue());
        resizeParameters.setHeight((Integer)this.heightSpinner.getValue());
        resizeParameters.setMaintainAspectRatio(this.aspectCheckBox.isSelected());
        resizeParameters.setConsiderOrientation(this.orientationCheckBox.isSelected());
        resizeParameters.setAntialising(this.antialisingCheckBox.isSelected());
        resizeParameters.setRendering(this.renderingComboBox.getSelectedIndex());
        resizeParameters.setFilter(this.resizeFilterComboBox.getSelectedItem().toString());
        resizeParameters.setSharpen(this.sharpenComboBox.getSelectedItem().toString());
        resizeParameters.setUnits(this.unitCombo.getSelectedIndex());
        return resizeParameters;
    }

    private void updateModels() {
        int value;
        int minimum = value = 1;
        if (this.aspectCheckBox.isSelected() && !this.orientationCheckBox.isSelected()) {
            minimum = 0;
        }
        if (this.unitCombo.getSelectedIndex() == 1) {
            minimum = 1;
            value = 100;
            this.orientationCheckBox.setEnabled(false);
        } else if (this.unitCombo.getSelectedIndex() == 0 && this.resizeEnableCheckBox.isSelected()) {
            this.orientationCheckBox.setEnabled(true);
        }
        SpinnerNumberModel widthModel = new SpinnerNumberModel((Number)value, Integer.valueOf(minimum), null, (Number)1);
        SpinnerNumberModel heightModel = new SpinnerNumberModel((Number)value, Integer.valueOf(minimum), null, (Number)1);
        if (this.unitCombo.getSelectedIndex() == 1 && this.aspectCheckBox.isSelected()) {
            widthModel = heightModel;
        }
        this.widthSpinner.setModel(widthModel);
        this.heightSpinner.setModel(heightModel);
        this.valueCorrection(0);
    }

    private void valueCorrection(int valueChanged) {
        if (this.aspectCheckBox.isSelected() && !this.orientationCheckBox.isSelected() && this.unitCombo.getSelectedIndex() == 0) {
            if (valueChanged == 1) {
                this.widthSpinner.setValue(0);
            } else {
                this.heightSpinner.setValue(0);
            }
            if (valueChanged == 0 && this.heightSpinner.getValue().equals(0) && this.widthSpinner.getValue().equals(0)) {
                this.widthSpinner.setValue(1);
            } else if (this.heightSpinner.getValue().equals(0) && this.widthSpinner.getValue().equals(0)) {
                this.heightSpinner.setValue(1);
            }
        }
    }

    private void updateAdvancePanel() {
        if (this.resizeEnableCheckBox.isSelected()) {
            switch (this.resizeFilterComboBox.getSelectedIndex()) {
                case 0: 
                case 1: 
                case 3: 
                case 6: {
                    this.handleGraphicsParameters(Boolean.TRUE);
                    this.handleSharpenParameters(Boolean.FALSE);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.handleGraphicsParameters(Boolean.FALSE);
                    this.handleSharpenParameters(Boolean.TRUE);
                }
            }
            this.resizeFilterComboBox.setEnabled(Boolean.TRUE);
            this.jLabel1.setEnabled(Boolean.TRUE);
        } else {
            this.resizeFilterComboBox.setEnabled(Boolean.FALSE);
            this.jLabel1.setEnabled(Boolean.FALSE);
            this.handleGraphicsParameters(Boolean.FALSE);
            this.handleSharpenParameters(Boolean.FALSE);
        }
    }

    private void handleGraphicsParameters(boolean handle) {
        this.renderingComboBox.setEnabled(handle);
        this.jLabel2.setEnabled(handle);
        this.antialisingCheckBox.setEnabled(handle);
    }

    private void handleSharpenParameters(boolean handle) {
        this.sharpenComboBox.setEnabled(handle);
        this.jLabel3.setEnabled(handle);
    }
}

