/*
 * Decompiled with CFR 0.152.
 */
package org.bric.utils;

import ij.IJ;
import ij.ImagePlus;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.bric.input.GenerateThumbnail;
import org.bric.input.ImportedImage;
import org.bric.utils.BufferedImageCreator;

public class Utils {
    public static final String FS = System.getProperty("file.separator");
    public static final int REPLACE_ALL = 0;
    public static final int REPLACE = 1;
    public static final int SKIP_ALL = 2;
    public static final int SKIP = 3;
    public static final int NOT_SET = 4;
    public static final int OVERWRITE = 5;
    public static final int OVERWRITE_ALL = 6;
    public static final int ADD = 1;
    public static final int ADD_ALL = 0;
    public static Preferences prefs = Preferences.userRoot();
    public static String[] supportedOutputExtensions = new String[]{"jpg", "jpeg", "png", "bmp", "pnm", "ppm", "pgm", "pbm", "tif", "tiff", "gif", "pdf"};
    public static String[] supportedInputExtensions = new String[]{"jpg", "jpeg", "png", "bmp", "tiff", "tif", "gif", "psd", "pnm", "ppm", "pgm", "pbm", "wbmp", "pdf"};

    public static void setFileChooserProperties(JFileChooser chooser) {
        FileNameExtensionFilter[] filters;
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileSelectionMode(2);
        for (FileNameExtensionFilter filter : filters = new FileNameExtensionFilter[]{new FileNameExtensionFilter("JPEG Image(*.jpg, *.jpeg)", "JPG", "JPEG"), new FileNameExtensionFilter("PNG Images(*.png)", "PNG"), new FileNameExtensionFilter("BMP Images(*.bmp)", "BMP"), new FileNameExtensionFilter("TIFF Images(*.tiff, *.tif)", "TIFF", "TIF"), new FileNameExtensionFilter("GIF Images(*.gif)", "GIF"), new FileNameExtensionFilter("Photoshop Files(*.psd)", "PSD"), new FileNameExtensionFilter("PNM Images(*.pnm)", "PNM"), new FileNameExtensionFilter("PPM Images(*.ppm)", "PPM"), new FileNameExtensionFilter("PGM Images(*.pgm)", "PGM"), new FileNameExtensionFilter("PBM Images(*.pbm)", "PBM"), new FileNameExtensionFilter("WBMP Images(*.wbmp)", "WBMP"), new FileNameExtensionFilter("PDF Files(*.pdf)", "PDF"), new FileNameExtensionFilter("All supported file types", "JPG", "JPEG", "PNG", "GIF", "BMP", "TIFF", "TIF", "PNM", "PPM", "PGM", "PBM", "WBMP", "PSD", "PDF")}) {
            chooser.setFileFilter(filter);
        }
    }

    public static void outOfMemoryErrorMessage() {
        JOptionPane.showMessageDialog(null, "Out of memory!\nRerun the program with -Xmx argument, using more than " + Runtime.getRuntime().maxMemory() / 1000000L + "m", "Out of memory error.", 0);
    }

    public static BufferedImage loadImage(String filename) {
        BufferedImage image = Utils.librarySwitch(filename, 0);
        if (image == null) {
            image = Utils.librarySwitch(filename, 1);
        }
        if (image == null) {
            image = Utils.librarySwitch(filename, 2);
        }
        return image;
    }

    public static BufferedImage librarySwitch(String filename, int library) {
        try {
            switch (library) {
                case 0: {
                    BufferedImage newImage = Sanselan.getBufferedImage(new File(filename));
                    return newImage;
                }
                case 1: {
                    BufferedImage newImage = ImageIO.read(new File(filename));
                    return newImage;
                }
                case 2: {
                    ImagePlus imp = IJ.openImage(filename);
                    BufferedImage newImage = BufferedImageCreator.create(imp, 0);
                    return newImage;
                }
            }
        }
        catch (ImageReadException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
        catch (OutOfMemoryError ex) {
            if (library == 2) {
                Utils.outOfMemoryErrorMessage();
            }
            System.gc();
            return null;
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static void centerWindow(Window frame) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)((dimension.getWidth() - (double)frame.getWidth()) / 2.0);
        int y = (int)((dimension.getHeight() - (double)frame.getHeight()) / 2.0);
        frame.setLocation(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMetadataThumbnail(ImportedImage image, boolean metadata, boolean thumbnail) {
        block20: {
            if (thumbnail) {
                if (image.getImageType().equalsIgnoreCase("PDF")) {
                    image.setThumbnailImageIcon(new ImageIcon(GenerateThumbnail.generate(image.getPath(), 125, 125)));
                } else {
                    BufferedImage importImage = Utils.loadImage(image.getPath());
                    if (importImage != null) {
                        image.setThumbnailImageIcon(new ImageIcon(GenerateThumbnail.generate(importImage, 125, 125)));
                    } else {
                        image.setCorrupted(true);
                    }
                }
            }
            if (metadata) {
                try {
                    image.setSize(new File(image.getPath()).length());
                    if (image.getImageType().equalsIgnoreCase("PDF")) {
                        image.setDimensions("unknown");
                        break block20;
                    }
                    ImageInputStream in = ImageIO.createImageInputStream(new File(image.getPath()));
                    try {
                        Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
                        if (readers.hasNext()) {
                            ImageReader reader = readers.next();
                            try {
                                reader.setInput(in);
                                image.setDimensions(reader.getWidth(0) + "x" + reader.getHeight(0));
                            }
                            finally {
                                reader.dispose();
                            }
                        }
                        if (image.getDimensions() == null || image.getDimensions().equals("unknown")) {
                            throw new Exception();
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Exception e) {
                    BufferedImage importImage = Utils.loadImage(image.getPath());
                    if (importImage != null) {
                        image.setDimensions(importImage.getWidth() + "x" + importImage.getHeight());
                    }
                    image.setCorrupted(true);
                }
            }
        }
        if (image.getDimensions() == null) {
            image.setDimensions("unknown");
        }
    }

    public static HashSet<Integer> getExistingNumsHash(String outputPath) {
        String[] outputPathArray = outputPath.split(Pattern.quote(File.separator));
        int outputPathSize = outputPathArray.length;
        String outputName = outputPathArray[outputPathSize - 1];
        HashSet<Integer> numsHashset = new HashSet<Integer>();
        File outputDir = new File(outputPath.substring(0, outputPath.lastIndexOf(FS)));
        List<String> list = Arrays.asList(outputDir.list());
        ArrayList<Integer> shardCharPositionList = new ArrayList<Integer>();
        for (int i = 0; i < outputName.length(); ++i) {
            char ch = outputName.charAt(i);
            if (ch != '#') continue;
            shardCharPositionList.add(i);
        }
        for (String file : list) {
            if (!file.matches(Utils.createRegex(outputName))) continue;
            ArrayList<Integer> numFreqList = new ArrayList<Integer>();
            int offset = 0;
            for (int j = 0; j < shardCharPositionList.size(); ++j) {
                for (int i = 0; i < file.length(); ++i) {
                    StringBuilder b = new StringBuilder();
                    char ch = file.charAt(i);
                    if (i != (Integer)shardCharPositionList.get(j) + offset) continue;
                    while (Character.isDigit(ch)) {
                        b.append(ch);
                        ch = file.charAt(++i);
                        ++offset;
                    }
                    --offset;
                    numFreqList.add(Integer.parseInt(b.toString()));
                }
            }
            Iterator i$ = numFreqList.iterator();
            while (i$.hasNext()) {
                int v = (Integer)i$.next();
                numsHashset.add(v);
            }
        }
        return numsHashset;
    }

    public static String createRegex(String s) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if ("\\.^$|?*+[]{}()-_".indexOf(ch) != -1) {
                b.append('\\').append(ch);
                continue;
            }
            b.append(ch);
        }
        b.append("\\.(jpg|jpeg|png|gif|tif|tiff|bmp|pdf|wbmp|pbm|pgm|ppm|pnm|psd|JPG|JPEG|PNG|GIF|TIF|TIFF|BMP|PDF|WBMP|PBM|PGM|PPM|PNM|PSD)");
        return b.toString().replaceAll("#", "[0-9]+");
    }
}

