/*
 * Decompiled with CFR 0.152.
 */
package net.grelf;

public class Gaussian {
    private float mean;
    private float oneOverSSquared;

    public Gaussian(float f, float f2) {
        this.mean = f;
        float f3 = f2 / (float)StrictMath.sqrt(-StrictMath.log(0.5));
        this.oneOverSSquared = 1.0f / (f3 * f3);
    }

    public float calc(float f) {
        float f2 = f - this.mean;
        return (float)StrictMath.exp(-f2 * f2 * this.oneOverSSquared);
    }

    public static double[] getProfileAsArray(int n, double d) {
        double[] dArray = new double[n];
        float f = (float)n / 2.0f;
        float f2 = f / 2.0f;
        Gaussian gaussian = new Gaussian(f, f2);
        for (int i = 0; i < n; ++i) {
            dArray[i] = d * (double)gaussian.calc(i);
        }
        return dArray;
    }

    public String toString() {
        return "Gaussian: mean = " + this.mean + ", 1 / S-squared = " + this.oneOverSSquared;
    }
}

