/*
 * Decompiled with CFR 0.152.
 */
package net.grelf;

import java.awt.Point;
import java.io.Serializable;
import net.grelf.VectorFloat;

public class PointFloat
implements Cloneable,
Serializable {
    public float x;
    public float y;
    private static final double EPSILON = 1.0E-7;

    public PointFloat(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public PointFloat(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public PointFloat offset(VectorFloat vectorFloat) {
        PointFloat pointFloat = new PointFloat(this.x + vectorFloat.getDx(), this.y + vectorFloat.getDy());
        return pointFloat;
    }

    public double distanceFrom(PointFloat pointFloat) {
        double d = this.x - pointFloat.x;
        double d2 = this.y - pointFloat.y;
        return StrictMath.sqrt(d * d + d2 * d2);
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        PointFloat pointFloat = (PointFloat)object;
        if ((double)Math.abs(pointFloat.x - this.x) > 1.0E-7) {
            return false;
        }
        return !((double)Math.abs(pointFloat.y - this.y) > 1.0E-7);
    }

    public int hashCode() {
        return (int)(this.x * 23.0f + this.y * 17.0f);
    }

    public PointFloat clone() {
        return new PointFloat(this.x, this.y);
    }

    public String toString() {
        return "PointFloat: at (" + this.x + ", " + this.y + ")";
    }
}

