/*
 * Decompiled with CFR 0.152.
 */
package net.grelf;

import java.io.PrintWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.grelf.Util;
import org.w3c.dom.Document;

public class XmlUtil {
    private XmlUtil() {
    }

    public static StringBuffer escape(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        block7: for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer2.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer2.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer2.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer2.append("&quot;");
                    continue block7;
                }
                case '&': {
                    stringBuffer2.append("&amp;");
                    continue block7;
                }
                default: {
                    stringBuffer2.append(c);
                }
            }
        }
        return stringBuffer2;
    }

    public static void outputDocument(PrintWriter printWriter, Document document) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(printWriter));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            Util.logWarning(transformerConfigurationException.toString());
        }
        catch (TransformerException transformerException) {
            Util.logWarning(transformerException.toString());
        }
        catch (Exception exception) {
            Util.logWarning(exception.toString());
        }
    }
}

