/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.astro;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.grelf.Maths;
import net.grelf.Util;

public class JulianDate
implements Cloneable,
Serializable {
    private double jd;
    private static final double JD1970_DAYS = 2440587.5;
    private static final double SECS_PER_DAY = 86400.0;
    public static final double J2000 = 2451545.0;
    public static final double B1950 = 2433282.4235;
    private static final DecimalFormat DF5 = new DecimalFormat("0.00000");

    public JulianDate(double d) {
        this.jd = d;
    }

    public JulianDate(long l) {
        double d = (double)l / 1000.0;
        this.jd = 2440587.5 + d / 86400.0;
    }

    public long toMsSince1970() {
        double d = (this.jd - 2440587.5) * 86400.0 * 1000.0;
        return (long)d;
    }

    public JulianDate(Calendar calendar) {
        this(calendar.getTimeInMillis());
    }

    public GregorianCalendar toGregorianCalendar() {
        double d = this.jd - 2440587.5;
        long l = (long)(d * 86400.0 * 1000.0);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l);
        return gregorianCalendar;
    }

    public JulianDate() {
        this(new GregorianCalendar());
    }

    public JulianDate(String string) throws DatatypeConfigurationException {
        this(DatatypeFactory.newInstance().newXMLGregorianCalendar(string));
    }

    public static JulianDate createJulianDate(String string) {
        try {
            return new JulianDate(string);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            return JulianDate.createJulianDateNonW3C(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return JulianDate.createJulianDateNonW3C(string);
        }
    }

    private static JulianDate createJulianDateNonW3C(String string) {
        try {
            double d = 0.0;
            int n = TimeZone.getDefault().getRawOffset();
            d = (double)n / 3600000.0;
            int n2 = (int)Math.floor(d);
            int n3 = (int)Math.floor((d - (double)n2) * 60.0);
            return new JulianDate(new GregorianCalendar(Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(5, 7)) - 1, Integer.parseInt(string.substring(8, 10)), Integer.parseInt(string.substring(11, 13)) + n2, Integer.parseInt(string.substring(14, 16)) + n3, Integer.parseInt(string.substring(17))));
        }
        catch (NumberFormatException numberFormatException) {
            Util.logWarning("NumberFormatException in createJulianDateNonW3C");
            return null;
        }
    }

    public JulianDate(XMLGregorianCalendar xMLGregorianCalendar) {
        this(xMLGregorianCalendar.toGregorianCalendar());
    }

    public String toString() {
        return DF5.format(this.toDouble());
    }

    public double toDouble() {
        return this.jd;
    }

    public String toImageTimestampFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        return simpleDateFormat.format(this.toGregorianCalendar().getTime());
    }

    public String toXmlDateTime() {
        try {
            GregorianCalendar gregorianCalendar = this.toGregorianCalendar();
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            return xMLGregorianCalendar.toXMLFormat();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            Util.logWarning("DatatypeConfigurationException when converting Julian Date {0} to xs:dateTime", this.toString());
            return "";
        }
    }

    public double toMeanSiderealTimeAtGreenwichInDegrees() {
        double d = this.jd - 2451545.0;
        double d2 = d / 36525.0;
        double d3 = d2 * d2;
        return Maths.in360(280.46061837 + 360.98564736629 * d + 3.87933E-4 * d3 - d2 * d3 / 3.871E7);
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        JulianDate julianDate = (JulianDate)object;
        return Math.abs(this.jd - julianDate.jd) < 1.0E-8;
    }

    public int hashCode() {
        return (int)(this.jd * 123456.789);
    }

    public JulianDate clone() {
        return new JulianDate(this.jd);
    }
}

