/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.astro;

import java.io.Serializable;
import net.grelf.Angle;
import net.grelf.Maths;

public class SkyVector
implements Cloneable,
Serializable {
    private Angle separation;
    private Angle pa;

    public Angle getSeparation() {
        return this.separation;
    }

    public Angle getPa() {
        return this.pa;
    }

    public SkyVector(double d, double d2) {
        if (d < 0.0) {
            d = -d;
            d2 = Maths.in360(d2 + 180.0);
        }
        this.separation = new Angle(d, Angle.Units.DEGREES);
        this.pa = new Angle(d2, Angle.Units.DEGREES);
    }

    public SkyVector(Angle angle, Angle angle2) {
        this.separation = angle;
        this.pa = angle2;
        if (this.separation.getRadians() < 0.0) {
            this.separation = new Angle(-this.separation.getRadians(), this.separation.getStdErrRadians(), Angle.Units.RADIANS);
            this.pa = new Angle(this.pa.getDegrees() + 180.0, this.pa.getStdErrDegrees(), Angle.Units.DEGREES).in360();
        }
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        SkyVector skyVector = (SkyVector)object;
        if (!this.pa.equals(skyVector.pa)) {
            return false;
        }
        return this.separation.equals(skyVector.separation);
    }

    public int hashCode() {
        return this.pa.hashCode() * 37 + this.separation.hashCode() * 11;
    }

    public SkyVector clone() {
        return new SkyVector(this.pa, this.separation);
    }

    public String toString() {
        return "PA " + this.pa.toString() + ", separation " + this.separation.toString();
    }

    public String toString(Angle.Units units) {
        return "PA " + this.pa.toString(units) + ", separation " + this.separation.toString(units);
    }
}

