/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import net.grelf.PointFloat;
import net.grelf.Util;
import net.grelf.grip.Accumulator;
import net.grelf.grip.BlobMask;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.Config;
import net.grelf.grip.MatchPair;
import net.grelf.grip.StarSegmenter;
import net.grelf.grip.Warp;
import net.grelf.image.Image;
import net.grelf.image.Image64;
import net.grelf.image.Image8or16Base;
import net.grelf.image.IncompatibleImageException;
import net.grelf.image.RangeDouble;
import net.grelf.image.Timer;

public class Accumulator64
extends Image64
implements Accumulator {
    public Accumulator64(int n, int n2, int n3) {
        this(n, n2, n3, false);
    }

    public Accumulator64(int n, int n2, int n3, boolean bl) {
        super(n, n2, n3, bl);
    }

    public Accumulator64(BufferedImage bufferedImage) throws IncompatibleImageException {
        super(bufferedImage);
    }

    @Override
    public boolean brightestShiftAccumulate(Image8or16Base image8or16Base, int n, int n2, List<PointFloat> list) throws IncompatibleImageException {
        Timer timer = new Timer("Accumulator64.brightestShiftAccumulate", image8or16Base);
        boolean bl = true;
        PointFloat pointFloat = list.get(n);
        PointFloat pointFloat2 = list.get(n2);
        if (null == pointFloat) {
            Util.warning("Error", "No centre found for shifting image " + (n + 1));
            bl = false;
        } else if (null == pointFloat2) {
            Util.warning("Error", "No centre found in middle image for shifting image " + (n + 1));
            bl = false;
        } else {
            double d = pointFloat2.x - pointFloat.x;
            double d2 = pointFloat2.y - pointFloat.y;
            this.addTranslated(image8or16Base.getBufferedImage(), d, d2);
        }
        timer.stop();
        return bl;
    }

    @Override
    public boolean averageShiftAccumulate(Image8or16Base image8or16Base, int n, int n2, List<MatchPair> list, BlobMeas[][] blobMeasArray, int n3) throws IncompatibleImageException {
        int n4;
        Timer timer = new Timer("Accumulator64.averageShiftAccumulate", image8or16Base);
        boolean bl = true;
        ArrayList<MatchPair> arrayList = new ArrayList<MatchPair>();
        for (MatchPair matchPair : list) {
            MatchPair matchPair2;
            if (matchPair.blobNo1 >= n3 || matchPair.blobNo2 >= n3) continue;
            if (matchPair.imNo2 == n && null != (matchPair2 = MatchPair.findBlobInMiddleImage(n, n4 = matchPair.blobNo2, n2))) {
                arrayList.add(matchPair2);
            }
            if (matchPair.imNo1 != n || null == (matchPair2 = MatchPair.findBlobInMiddleImage(n, n4 = matchPair.blobNo1, n2))) continue;
            arrayList.add(matchPair2);
        }
        int n5 = arrayList.size();
        if (n5 == 0) {
            Util.warning("Error", "No relevant matches found for shifting image " + (n + 1));
            bl = false;
        } else {
            int n6 = 0;
            n4 = 0;
            for (int i = 0; i < n5; ++i) {
                MatchPair matchPair = (MatchPair)arrayList.get(i);
                PointFloat pointFloat = blobMeasArray[matchPair.imNo1][matchPair.blobNo1].centre;
                PointFloat pointFloat2 = blobMeasArray[matchPair.imNo2][matchPair.blobNo2].centre;
                int n7 = (int)pointFloat.x;
                int n8 = (int)pointFloat.y;
                int n9 = (int)pointFloat2.x;
                int n10 = (int)pointFloat2.y;
                n6 += n7 - n9;
                n4 += n8 - n10;
            }
            double d = (double)n6 / (double)n5;
            double d2 = (double)n4 / (double)n5;
            this.addTranslated(image8or16Base.getBufferedImage(), d, d2);
        }
        timer.stop();
        return bl;
    }

    @Override
    public boolean warpAccumulate(Image8or16Base image8or16Base, int n, int n2, List<MatchPair> list, BlobMeas[][] blobMeasArray, int n3) throws IncompatibleImageException {
        BufferedImage bufferedImage = Warp.warp(image8or16Base.getBufferedImage(), n, n2, list, blobMeasArray, n3);
        if (null == bufferedImage) {
            return false;
        }
        this.add(bufferedImage);
        bufferedImage.flush();
        bufferedImage = null;
        return true;
    }

    @Override
    public void addWithStarBoost(Image8or16Base image8or16Base, int n) throws IncompatibleImageException {
        double d;
        double d2;
        this.checkCompatibility("add with star boost", image8or16Base.getBufferedImage());
        Timer timer = new Timer("Accumulator64.addWithStarBoost ()", this);
        BlobMask blobMask = StarSegmenter.segment((Image)image8or16Base, Integer.parseInt(Config.getValue("StarSegmentDifference.value")), Integer.parseInt(Config.getValue("StarSegmentRadius.value")));
        byte[][] byArray = blobMask.getData();
        WritableRaster writableRaster = image8or16Base.getBufferedImage().getRaster();
        int n2 = this.getNBands();
        int[] nArray = new int[n2];
        int n3 = StrictMath.min(this.getWidth(), image8or16Base.getWidth());
        int n4 = StrictMath.min(this.getHeight(), image8or16Base.getHeight());
        writableRaster.getPixel(0, 0, nArray);
        double d3 = d2 = (d = this.data[0][0] + (double)nArray[0]);
        double d4 = 1.0;
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            int n6 = 0;
            while (n6 < n3) {
                d4 = 3 == byArray[n6][i] ? (double)n : 1.0;
                writableRaster.getPixel(n6, i, nArray);
                for (int j = 0; j < n2; ++j) {
                    this.data[j][n5] = d = this.data[j][n5] + (double)nArray[j] * d4;
                    if (d < d2) {
                        d2 = d;
                        continue;
                    }
                    if (!(d > d3)) continue;
                    d3 = d;
                }
                ++n6;
                ++n5;
            }
        }
        if (d3 - d2 < 1.0) {
            d3 = d2 + 1.0;
        }
        this.setRangeDouble(new RangeDouble(d2, d3));
        timer.stop();
    }
}

