/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import net.grelf.grip.Config;
import net.grelf.image.Image;
import net.grelf.image.Metadata;

public class BatchMetadata {
    private List<Float> apertures = null;
    private String camera = null;
    private List<Long> captureTimesMs = null;
    private String copyright = null;
    private List<Float> exposuresS = null;
    private List<String> fileNames = new ArrayList<String>();
    private List<Integer> focalLengths = null;
    private List<Integer> isos = null;
    private List<Float> meanCircularities = null;
    private List<Integer> nStars = new ArrayList<Integer>();
    private String observer = null;

    public float getAperture(int n) {
        return this.apertures.get(n).floatValue();
    }

    public String getCamera() {
        return this.camera;
    }

    public long getCaptureTimeMs(int n) {
        return this.captureTimesMs.get(n);
    }

    public String getCopyright() {
        return this.copyright;
    }

    public float getExposureS(int n) {
        return this.exposuresS.get(n).floatValue();
    }

    public String getFileName(int n) {
        return this.fileNames.get(n);
    }

    public int getFocalLength(int n) {
        return this.focalLengths.get(n);
    }

    public int getISO(int n) {
        return this.isos.get(n);
    }

    public float getMeanCircularity(int n) {
        return this.meanCircularities.get(n).floatValue();
    }

    public int getNStars(int n) {
        return this.nStars.get(n);
    }

    public String getObserver() {
        return this.observer;
    }

    public BatchMetadata() {
        this.meanCircularities = new ArrayList<Float>();
        this.captureTimesMs = new ArrayList<Long>();
        this.exposuresS = new ArrayList<Float>();
        this.apertures = new ArrayList<Float>();
        this.isos = new ArrayList<Integer>();
        this.focalLengths = new ArrayList<Integer>();
    }

    public void dispose() {
        this.apertures = null;
        this.camera = null;
        this.captureTimesMs = null;
        this.copyright = null;
        this.exposuresS = null;
        this.fileNames = null;
        this.focalLengths = null;
        this.isos = null;
        this.meanCircularities = null;
        this.nStars = null;
        this.observer = null;
    }

    public Metadata add(File file, Image image) {
        this.fileNames.add(file.getName());
        Metadata metadata = image.getMetadata();
        if (null != metadata) {
            long l = metadata.getTimeInMillis();
            this.captureTimesMs.add(l);
            this.exposuresS.add(Float.valueOf(metadata.getExposure()));
            this.apertures.add(Float.valueOf(metadata.getAperture()));
            this.isos.add(metadata.getISO());
            this.focalLengths.add(metadata.getFocalLength());
            if (null == this.camera || 0 == this.camera.length()) {
                this.camera = metadata.getCamera();
                if (null == this.camera) {
                    this.camera = Config.getValue("Camera.value");
                }
            }
            if (null == this.copyright || 0 == this.copyright.length()) {
                this.copyright = metadata.getCopyright();
                if (null == this.copyright) {
                    this.copyright = Config.getValue("Copyright.value");
                }
            }
            if (null == this.observer || 0 == this.observer.length()) {
                this.observer = metadata.getPhotographer();
                if (null == this.observer) {
                    this.observer = Config.getValue("Observer.value");
                }
            }
        }
        return metadata;
    }

    public void addToNStars(int n) {
        this.nStars.add(n);
    }

    public void addToMeanCircularities(float f) {
        this.meanCircularities.add(Float.valueOf(f));
    }

    public int getNImages() {
        return this.fileNames.size();
    }

    public Metadata setImageMetadata(Image image, int n) {
        int n2 = this.fileNames.size();
        Metadata metadata = new Metadata();
        image.setMetadata(metadata);
        metadata.addValue("ImageKind", "GRIP combined image");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy:MM:dd hh:mm:ss");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(this.captureTimesMs.get(0));
        Date date = gregorianCalendar.getTime();
        String string = simpleDateFormat.format(date);
        metadata.addValue("DateTimeFirst", string);
        gregorianCalendar.setTimeInMillis(this.captureTimesMs.get(n2 - 1));
        date = gregorianCalendar.getTime();
        String string2 = simpleDateFormat.format(date);
        metadata.addValue("DateTimeLast", string2);
        metadata.addValue("NImages", "" + n);
        metadata.addValue("Exposure", (float)n * this.exposuresS.get(0).floatValue() + "s");
        metadata.addValue("Aperture", "f over " + this.apertures.get(0));
        metadata.addValue("ISO", "" + this.isos.get(0));
        metadata.addValue("FocalLength", "" + this.focalLengths.get(0) + "mm");
        if (null != this.camera) {
            metadata.addValue("CAMERA", this.camera);
        }
        if (null != this.observer) {
            metadata.addValue("OBSERVER", this.observer);
        }
        if (null != this.copyright) {
            metadata.addValue("COPYRIGHT", this.copyright);
        }
        return metadata;
    }
}

