/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.io.Serializable;
import java.text.DecimalFormat;
import net.grelf.PointFloat;
import net.grelf.Statistics;
import net.grelf.Util;
import net.grelf.astro.Star;
import net.grelf.grip.Blob;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.ImFrame;

public class BlobMeas
implements Cloneable,
Comparable<BlobMeas>,
Serializable {
    public double brightness;
    public long[] channelBrightnesses;
    public Statistics[] backgroundStatistics = null;
    public long[] accurateBrightnesses = null;
    public float[] snRatios = null;
    public int nPixelsMeasured = 0;
    public PointFloat centre;
    public int area;
    public Blob blob;
    public int minX;
    public int minY;
    public int maxX;
    public int maxY;
    private Star star = null;
    private static final DecimalFormat FIXED1 = new DecimalFormat("0.0");

    public Star getStar() {
        return this.star;
    }

    public Star getOrCreateStar() {
        if (null != this.star) {
            return this.star;
        }
        this.star = new Star();
        return this.star;
    }

    public double calculateCircularity() {
        double d = StrictMath.sqrt((double)this.area / Math.PI);
        double d2 = this.blob.perimeter() / (Math.PI * 2);
        return d2 / d;
    }

    public void setStar(Star star) {
        this.star = star;
    }

    @Override
    public int compareTo(BlobMeas blobMeas) {
        if (blobMeas.brightness < this.brightness) {
            return -1;
        }
        if (blobMeas.brightness > this.brightness) {
            return 1;
        }
        return 0;
    }

    public BlobMeas clone() {
        BlobMeas blobMeas = new BlobMeas();
        blobMeas.brightness = this.brightness;
        blobMeas.channelBrightnesses = (long[])(null == this.channelBrightnesses ? null : (long[])this.channelBrightnesses.clone());
        blobMeas.backgroundStatistics = null == this.backgroundStatistics ? null : (Statistics[])this.backgroundStatistics.clone();
        blobMeas.accurateBrightnesses = (long[])(null == this.accurateBrightnesses ? null : (long[])this.accurateBrightnesses.clone());
        blobMeas.nPixelsMeasured = this.nPixelsMeasured;
        blobMeas.centre = this.centre.clone();
        blobMeas.area = this.area;
        blobMeas.blob = this.blob;
        blobMeas.minX = this.minX;
        blobMeas.minY = this.minY;
        blobMeas.maxX = this.maxX;
        blobMeas.maxY = this.maxY;
        if (null != this.star) {
            blobMeas.star = this.star.clone();
        }
        return blobMeas;
    }

    public String toString() {
        return "BlobMeas: at " + this.centre.toString() + ", area " + this.area + ", brightness " + this.brightness;
    }

    public String toHoverString() {
        if (null == this.star) {
            return "area=" + this.area + " brightness=" + (int)this.brightness;
        }
        StringBuffer stringBuffer = new StringBuffer("star=" + this.star.getId());
        if (null != this.star.getMagnitude()) {
            stringBuffer.append(" magnitude=");
            stringBuffer.append(this.star.getMagnitude().toString());
        }
        return stringBuffer.toString();
    }

    public StringBuffer toSummary(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("Blob:");
        stringBuffer.append(string);
        stringBuffer.append("Centre = (");
        stringBuffer.append(FIXED1.format(this.centre.x));
        stringBuffer.append(", ");
        stringBuffer.append(FIXED1.format(this.centre.y));
        stringBuffer.append(")");
        stringBuffer.append(string);
        stringBuffer.append("Area = ");
        stringBuffer.append(this.area);
        stringBuffer.append(" pixels");
        if (null != this.accurateBrightnesses) {
            stringBuffer.append(string);
            stringBuffer.append("Accurate brightness");
            stringBuffer.append(string);
            stringBuffer.append("(from ");
            stringBuffer.append(this.nPixelsMeasured);
            stringBuffer.append(" px) = ");
            stringBuffer.append(Util.rootSumOfSquares(this.accurateBrightnesses));
            int n = this.accurateBrightnesses.length;
            if (3 == n) {
                stringBuffer.append(string);
                stringBuffer.append("R = ");
                stringBuffer.append(this.accurateBrightnesses[0]);
                if (null != this.snRatios) {
                    stringBuffer.append(" [S/N = ");
                    stringBuffer.append(FIXED1.format(this.snRatios[0]));
                    stringBuffer.append("]");
                }
                stringBuffer.append(string);
                stringBuffer.append("G = ");
                stringBuffer.append(this.accurateBrightnesses[1]);
                if (null != this.snRatios) {
                    stringBuffer.append(" [S/N = ");
                    stringBuffer.append(FIXED1.format(this.snRatios[1]));
                    stringBuffer.append("]");
                }
                stringBuffer.append(string);
                stringBuffer.append("B = ");
                stringBuffer.append(this.accurateBrightnesses[2]);
                if (null != this.snRatios) {
                    stringBuffer.append(" [S/N = ");
                    stringBuffer.append(FIXED1.format(this.snRatios[2]));
                    stringBuffer.append("]");
                }
            } else if (0 < n) {
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(string);
                    stringBuffer.append("Band ");
                    stringBuffer.append(i);
                    stringBuffer.append(" brightness = ");
                    stringBuffer.append(this.accurateBrightnesses[0]);
                    if (null == this.snRatios) continue;
                    stringBuffer.append(" [S/N = ");
                    stringBuffer.append(FIXED1.format(this.snRatios[0]));
                    stringBuffer.append("]");
                }
            }
        } else if (null != this.channelBrightnesses) {
            stringBuffer.append(string);
            stringBuffer.append("Detected brightness = ");
            stringBuffer.append((long)this.brightness);
            int n = this.channelBrightnesses.length;
            if (3 == n) {
                stringBuffer.append(string);
                stringBuffer.append("R = ");
                stringBuffer.append(this.channelBrightnesses[0]);
                stringBuffer.append(string);
                stringBuffer.append("G = ");
                stringBuffer.append(this.channelBrightnesses[1]);
                stringBuffer.append(string);
                stringBuffer.append("B = ");
                stringBuffer.append(this.channelBrightnesses[2]);
            } else if (1 < n) {
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(string);
                    stringBuffer.append("Band ");
                    stringBuffer.append(i);
                    stringBuffer.append(" brightness = ");
                    stringBuffer.append(this.channelBrightnesses[0]);
                }
            }
        }
        if (null != this.star) {
            stringBuffer.append(string);
            stringBuffer.append(string);
            stringBuffer.append("Star:");
            stringBuffer.append(string);
            stringBuffer.append(this.star.toFoldedString(string));
        }
        stringBuffer.append(string);
        stringBuffer.append(string);
        stringBuffer.append("Ring radius factor = ");
        stringBuffer.append(FIXED1.format(this.blob.getMeasuringRingSizeFactor()));
        return stringBuffer;
    }

    public void showSummary() {
        StringBuffer stringBuffer = this.toSummary("\n");
        Util.message("@(" + (int)this.centre.x + ", " + (int)this.centre.y + ")", stringBuffer.toString());
    }

    public StringBuffer toXML(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("<BlobMeas>\n");
        stringBuffer.append(string);
        stringBuffer.append("\t<Brightness>");
        stringBuffer.append(this.brightness);
        stringBuffer.append("</Brightness>\n");
        stringBuffer.append(string);
        stringBuffer.append("\t<ChannelBrightnesses>");
        int n2 = this.channelBrightnesses.length;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(this.channelBrightnesses[n]);
            if (n >= this.channelBrightnesses.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("</ChannelBrightnesses>\n");
        if (null != this.backgroundStatistics) {
            stringBuffer.append(string);
            stringBuffer.append("\t<Background>\n");
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(string);
                stringBuffer.append("\t\t<Channel>\n");
                stringBuffer.append(this.backgroundStatistics[n].toXML(string + "\t\t\t"));
                stringBuffer.append(string);
                stringBuffer.append("\t\t</Channel>\n");
            }
            stringBuffer.append(string);
            stringBuffer.append("\t</Background>\n");
        }
        if (null != this.accurateBrightnesses) {
            stringBuffer.append(string);
            stringBuffer.append("\t<AccurateBrightnesses>");
            for (n = 0; n < this.accurateBrightnesses.length; ++n) {
                stringBuffer.append(this.accurateBrightnesses[n]);
                if (n >= this.accurateBrightnesses.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("</AccurateBrightnesses>\n");
            stringBuffer.append(string);
            stringBuffer.append("\t<NPixelsMeasured>");
            stringBuffer.append(this.nPixelsMeasured);
            stringBuffer.append("</NPixelsMeasured>\n");
            if (null != this.snRatios) {
                stringBuffer.append(string);
                stringBuffer.append("\t<SNRatios>");
                for (n = 0; n < this.snRatios.length; ++n) {
                    stringBuffer.append(this.snRatios[n]);
                    if (n >= this.snRatios.length - 1) continue;
                    stringBuffer.append(",");
                }
                stringBuffer.append("</SNRatios>\n");
            }
        }
        stringBuffer.append(string);
        stringBuffer.append("\t<Centre>");
        stringBuffer.append(this.centre.x);
        stringBuffer.append(",");
        stringBuffer.append(this.centre.y);
        stringBuffer.append("</Centre>\n");
        stringBuffer.append(string);
        stringBuffer.append("\t<Area>");
        stringBuffer.append(this.area);
        stringBuffer.append("</Area>\n");
        stringBuffer.append(string);
        stringBuffer.append("\t<MinX>");
        stringBuffer.append(this.minX);
        stringBuffer.append("</MinX>\n");
        stringBuffer.append(string);
        stringBuffer.append("\t<MinY>");
        stringBuffer.append(this.minY);
        stringBuffer.append("</MinY>\n");
        stringBuffer.append(string);
        stringBuffer.append("\t<MaxX>");
        stringBuffer.append(this.maxX);
        stringBuffer.append("</MaxX>\n");
        stringBuffer.append(string);
        stringBuffer.append("\t<MaxY>");
        stringBuffer.append(this.maxY);
        stringBuffer.append("</MaxY>\n");
        stringBuffer.append(this.blob.toXML(string));
        stringBuffer.append("\t");
        if (null != this.star) {
            stringBuffer.append(this.star.toXML(string));
            stringBuffer.append("\t");
        }
        stringBuffer.append(string);
        stringBuffer.append("</BlobMeas>\n");
        return stringBuffer;
    }

    public static void drawBoundaries(ImFrame imFrame, BlobMeasList blobMeasList) {
        blobMeasList.drawBoundaries(imFrame);
    }

    public static void showBrightestBlobs(ImFrame imFrame, BlobMeasList blobMeasList) {
        blobMeasList.showBrightestBlobs(imFrame);
    }
}

