/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import net.grelf.FileIO;
import net.grelf.FileIOBlobsFilter;
import net.grelf.FileIOChartFilter;
import net.grelf.FileIOImageFilter;
import net.grelf.FileIO_HTMLFilter;
import net.grelf.Util;
import net.grelf.astro.StarChart;
import net.grelf.grip.BatchMenu;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.Config;
import net.grelf.grip.ConfigMenu;
import net.grelf.grip.DefaultMeasurementHandler;
import net.grelf.grip.GripFileMenu;
import net.grelf.grip.HelpMenu;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImTable;
import net.grelf.grip.StarChartFrame;

public final class GRIP
extends JFrame
implements ClipboardOwner {
    public static final String VERSION = "12.6.24";
    public static final Cursor GRIP_DEFAULT_CURSOR = new Cursor(0);
    public static final Cursor GRIP_HAND_CURSOR = new Cursor(12);
    public static final Cursor GRIP_WAIT_CURSOR = new Cursor(3);
    private static GRIP instance = null;
    protected static final String OK_STATUS = "                           ";
    private static int nNewImages = 0;
    private static List<ImFrame> imFrames = new ArrayList<ImFrame>();
    private static ImTable table = null;
    private static ImageIcon icon;

    public static void main(final String ... stringArray) throws Exception {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GRIP gRIP = GRIP.getInstance();
                    Config.load();
                    GRIP.setTable(new ImTable(gRIP, "Select images", true));
                    for (String string : stringArray) {
                        if (string.endsWith(".accum")) {
                            gRIP.openFile(string);
                            continue;
                        }
                        if (string.endsWith(".blobs")) {
                            gRIP.openBlobs(string);
                            continue;
                        }
                        if (string.endsWith(".chart")) {
                            gRIP.openChart(string);
                            continue;
                        }
                        String[] stringArray2 = FileIOImageFilter.getAllKnownExtensions();
                        for (int i = 0; i < stringArray2.length; ++i) {
                            if (!string.endsWith(stringArray2[i])) continue;
                            gRIP.openFile(string);
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            Util.warning("Error", exception.toString());
            throw exception;
        }
    }

    public static synchronized GRIP getInstance() {
        if (null == instance) {
            instance = new GRIP();
            Util.setOwningApp(instance, icon);
        }
        return instance;
    }

    private GRIP() {
        super("GRIP");
        Logger.getLogger("net.grelf").setLevel(Level.ALL);
        try {
            Logger.getLogger("net.grelf").addHandler(new FileHandler("grip.log", 0, 3));
            Logger.getLogger("net.grelf").info("Started");
        }
        catch (IOException iOException) {
            Logger.getLogger("net.grelf").log(Level.SEVERE, "Cannot create log file handler", iOException);
        }
        icon = GRIP.createImageIcon("gripicon.png");
        if (null != icon) {
            this.setIconImage(icon.getImage());
        }
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(new GripFileMenu());
        jMenuBar.add(new BatchMenu());
        jMenuBar.add(new ConfigMenu());
        jMenuBar.add(new HelpMenu());
        this.setJMenuBar(jMenuBar);
        this.getContentPane().add(new Content(VERSION, "grip.png", 200, 120));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ((GRIP)windowEvent.getSource()).exit();
            }
        });
        this.setLocation(0, 0);
        this.pack();
        this.setVisible(true);
    }

    protected void exit() {
        if (Util.confirm(this, "End application", "Really close this program?")) {
            Logger.getLogger("net.grelf").info("Exit");
            System.exit(0);
        }
    }

    public static void about() {
        long l = 0x100000L;
        Runtime runtime = Runtime.getRuntime();
        Util.message("About GRIP", "<html>GRIP<br>Version 12.6.24<br>Copyright \u00a9 Graham Relf, UK, 2006 - 2012<br>gr@grelf.net<br><hr><br>Running in: " + System.getProperty("java.vm.name") + "<br>" + "Version: " + System.getProperty("java.vm.version") + "<br>" + "From: " + System.getProperty("java.vm.vendor") + "<br>" + "Available processors: " + runtime.availableProcessors() + "<br>" + "JVM memory: " + runtime.totalMemory() / l + "Mb<br>" + "free: " + runtime.freeMemory() / l + "Mb<br>" + "used: " + (runtime.totalMemory() - runtime.freeMemory()) / l + "Mb<br>" + "max: " + runtime.maxMemory() / l + "Mb");
    }

    protected static int getNNewImages() {
        return nNewImages;
    }

    protected static void incNNewImages() {
        ++nNewImages;
    }

    public static List<ImFrame> getImFramesList() {
        return imFrames;
    }

    public List<StarChartFrame> getAllStarChartFrames() {
        ArrayList<StarChartFrame> arrayList = new ArrayList<StarChartFrame>();
        for (ImFrame imFrame : GRIP.getImFramesList()) {
            if (!(imFrame instanceof StarChartFrame)) continue;
            arrayList.add((StarChartFrame)imFrame);
        }
        return arrayList;
    }

    public static ImTable getTable() {
        return table;
    }

    protected static void setTable(ImTable imTable) {
        table = imTable;
    }

    public static ImageIcon getIcon() {
        return icon;
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = GRIP.class.getResource(string);
        if (null != uRL) {
            return new ImageIcon(uRL);
        }
        Util.logWarning("Couldn''t find file: {0}", string);
        return null;
    }

    public void openFiles() {
        File[] fileArray = FileIO.selectInputFiles("Open images", null, new FileFilter[]{new FileIOImageFilter()});
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                this.openFile(fileArray[i].getPath());
            }
        }
    }

    private void openFile(String string) {
        new ImFrame(string, new DefaultMeasurementHandler());
    }

    public void openBlobs() {
        String string = FileIO.selectInputFile("Load a .blobs file", null, new FileFilter[]{new FileIOBlobsFilter(1)});
        if (null != string) {
            this.openBlobs(string);
        }
    }

    private void openBlobs(String string) {
        BlobMeasList.loadFromXML(string);
    }

    public void openChart() {
        String string = FileIO.selectInputFile("Load a .chart file", null, new FileFilter[]{new FileIOChartFilter(1)});
        if (null != string) {
            this.openChart(string);
        }
    }

    public void openAAVSO_Chart() {
        String string = FileIO.selectInputFile("Load an AAVSO HTML file", null, new FileFilter[]{new FileIO_HTMLFilter(1)});
        if (null != string) {
            this.openChart(string);
        }
    }

    private void openChart(String string) {
        if (string.endsWith(".chart")) {
            StarChart.loadFromXML(string);
        } else if (string.endsWith(".html") || string.endsWith(".htm")) {
            StarChart.loadFromHTML(string);
        } else {
            Util.warning(this, "Sorry", (Object)"Not a recognised chart file type");
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private static class Content
    extends JComponent {
        String version;
        Image logo;

        public Content(String string, String string2, int n, int n2) {
            this.version = string;
            this.setPreferredSize(new Dimension(n, n2));
            URL uRL = GRIP.class.getResource(string2);
            if (null != uRL) {
                this.logo = this.getToolkit().createImage(uRL);
                if (null != this.logo) {
                    Dimension dimension = new Dimension(n, n2);
                    this.setPreferredSize(dimension);
                } else {
                    Util.logWarning("Couldn''t load file: {0}", uRL.getPath());
                }
            }
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n = 0;
            if (null != this.logo) {
                n = this.logo.getHeight(this);
                graphics.drawImage(this.logo, 0, 0, this);
            }
            graphics.drawString("Version " + this.version, 4, n + 20);
            graphics.drawString("Copyright \u00a9 Graham Relf, UK, 2006-12", 4, n + 40);
            graphics.drawString("www.grelf.net", 4, n + 60);
        }
    }
}

