/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import net.grelf.Stack;
import net.grelf.Stack_;
import net.grelf.astro.Magnitude;
import net.grelf.astro.Star;
import net.grelf.grip.BlobMask;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.ConvolutionMenu;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPane;
import net.grelf.grip.MeasurementHandler;
import net.grelf.grip.PointList;
import net.grelf.grip.StarChartFrame;
import net.grelf.grip.XYText;
import net.grelf.image.Image;

public class GlassPane
extends JComponent {
    protected static final int CROSS_ARM = 3;
    private static final Color CROSS_COLOUR = new Color(255, 0, 0);
    private static final Color SQUARE_COLOUR = new Color(255, 0, 0);
    private static final Color CURVE_COLOUR = new Color(0, 0, 255);
    private static final Color MASK_COLOUR = new Color(0, 255, 0);
    private static final Color TEXT_COLOUR = new Color(255, 255, 0);
    private BlobMeasList blobMeases = null;
    private BlobMask blobMask = null;
    private DrawingMode drawingMode = DrawingMode.UNDEFINED;
    private Stack<DrawingMode> modeStack = new Stack_<DrawingMode>();
    private JMenuBar menubar;
    private boolean measured = false;
    private int iStart = 0;
    private PointList points = null;
    private ImPane ip;
    private MeasurementHandler mh;
    private Point meridianEnd1 = null;
    private Point meridianEnd2 = null;

    public BlobMask getMask() {
        return this.blobMask;
    }

    public void setMask(BlobMask blobMask) {
        this.blobMask = blobMask;
    }

    public DrawingMode getDrawingMode() {
        return this.drawingMode;
    }

    public void setDrawingMode(DrawingMode drawingMode) {
        this.drawingMode = drawingMode;
        this.meridianEnd1 = null;
        this.meridianEnd2 = null;
        if (drawingMode != DrawingMode.MOVE) {
            this.measured = false;
            if (this.drawingMode == DrawingMode.BLOB_HOVER) {
                this.blobMeases = this.ip.getImFrame().getBlobMeases();
            } else {
                this.clearPoints();
                this.blobMeases = null;
            }
            if (this.drawingMode == DrawingMode.HOVER || this.drawingMode == DrawingMode.BLOB_HOVER || this.drawingMode == DrawingMode.STAR_CHART) {
                this.points.add(new Point(0, 0));
            }
            this.repaint();
        }
    }

    protected void pushDrawingMode() {
        this.modeStack.push(this.drawingMode);
    }

    protected void popDrawingMode() {
        DrawingMode drawingMode = this.modeStack.pop();
        if (null != drawingMode) {
            this.drawingMode = drawingMode;
        }
    }

    public boolean getMeasured() {
        return this.measured;
    }

    public void setMeasured(boolean bl) {
        this.measured = bl;
    }

    public PointList getPoints() {
        return this.points;
    }

    public void setPoints(PointList pointList) {
        this.points = pointList;
    }

    public void clearPoints() {
        this.points = new PointList(this.mh);
        this.points.setLabels(null);
    }

    public final void setImPane(ImPane imPane) {
        this.ip = imPane;
    }

    public GlassPane(DrawingMode drawingMode, JMenuBar jMenuBar, MeasurementHandler measurementHandler) {
        this(drawingMode, jMenuBar, measurementHandler, null);
    }

    public GlassPane(DrawingMode drawingMode, JMenuBar jMenuBar, MeasurementHandler measurementHandler, ImFrame imFrame) {
        this.drawingMode = drawingMode;
        this.menubar = jMenuBar;
        this.mh = measurementHandler;
        this.points = new PointList(measurementHandler);
        if (this.drawingMode == DrawingMode.HOVER || this.drawingMode == DrawingMode.BLOB_HOVER || this.drawingMode == DrawingMode.STAR_CHART) {
            this.points.add(new Point(0, 0));
        }
        if (this.drawingMode == DrawingMode.BLOB_HOVER && null != imFrame) {
            this.blobMeases = imFrame.getBlobMeases();
            this.setImPane(imFrame.getImPane());
        } else {
            this.blobMeases = null;
        }
    }

    public void dispose() {
        if (null != this.blobMeases) {
            this.blobMeases.clear();
        }
        this.blobMeases = null;
        if (null != this.points) {
            this.points.clear();
        }
        this.points = null;
        this.mh = null;
        this.modeStack = null;
    }

    private void drawCross(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setPaint(CROSS_COLOUR);
        graphics2D.drawLine(n - 3, n2, n + 3, n2);
        graphics2D.drawLine(n, n2 - 3, n, n2 + 3);
    }

    private void drawSquare(Graphics2D graphics2D, int n, int n2, int n3) {
        graphics2D.setPaint(SQUARE_COLOUR);
        int n4 = n - n3;
        int n5 = n + n3;
        int n6 = n2 - n3;
        int n7 = n2 + n3;
        graphics2D.drawLine(n4, n6, n5, n6);
        graphics2D.drawLine(n4, n6, n4, n7);
        graphics2D.drawLine(n5, n7, n4, n7);
        graphics2D.drawLine(n5, n7, n5, n6);
        graphics2D.drawLine(n, n2, n, n2);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (null != this.ip) {
            this.drawComponent(graphics, this.ip.getScale(), new Point(this.ip.getOrigin()));
        }
    }

    public void overlayMeridian(double d) {
        Image image = this.ip.getImage();
        int n = image.getWidth() / 2;
        int n2 = image.getHeight() / 2;
        int n3 = Math.min(n, n2) - 10;
        double d2 = Math.toRadians(d);
        int n4 = (int)((double)n3 * Math.cos(d2));
        int n5 = -((int)((double)n3 * Math.sin(d2)));
        this.meridianEnd1 = new Point(n - n4, n2 - n5);
        this.meridianEnd2 = new Point(n + n4, n2 + n5);
    }

    public void drawComponent(Graphics graphics, int n, Point point) {
        --point.x;
        --point.y;
        if (null != this.points) {
            DrawingMode drawingMode;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setPaint(CURVE_COLOUR);
            int n2 = 0;
            if (null != this.menubar) {
                n2 = this.menubar.getHeight();
            }
            int n3 = this.ip.getWidth() / 2;
            int n4 = this.ip.getHeight() / 2;
            if (null != this.meridianEnd1 && null != this.meridianEnd2) {
                graphics2D.drawLine(this.meridianEnd1.x / n - point.x, this.meridianEnd1.y / n - point.y, this.meridianEnd2.x / n - point.x, this.meridianEnd2.y / n - point.y);
            }
            if ((drawingMode = this.drawingMode) == DrawingMode.MOVE) {
                drawingMode = this.modeStack.peek();
            }
            switch (drawingMode) {
                case HOVER: {
                    if (0 >= this.points.size()) break;
                    Point point2 = this.points.get(0);
                    int n5 = point2.x - point.x;
                    int n6 = point2.y - point.y + n2;
                    this.drawCross(graphics2D, n5, n6);
                    int n7 = point2.x * n;
                    int n8 = point2.y * n;
                    Image image = this.ip.getImage();
                    if (n7 < 0 || n7 >= image.getWidth() || n8 < 0 || n8 >= image.getHeight()) break;
                    int n9 = image.getNBands();
                    int[] nArray = image.getPixel(n7, n8);
                    StringBuffer stringBuffer = new StringBuffer("(" + n7 + ", " + n8 + ") ");
                    if (n9 == 1) {
                        stringBuffer.append("G");
                        stringBuffer.append(nArray[0]);
                    } else if (n9 == 3) {
                        stringBuffer.append("R");
                        stringBuffer.append(nArray[0]);
                        stringBuffer.append(" G");
                        stringBuffer.append(nArray[1]);
                        stringBuffer.append(" B");
                        stringBuffer.append(nArray[2]);
                    }
                    int n10 = n5 + 4;
                    int n11 = n6 - 4;
                    if (n5 > n3) {
                        n10 = n5 - 154;
                    }
                    if (point2.y < 20) {
                        n11 = n6 + 34;
                    }
                    graphics2D.drawString(stringBuffer.toString(), n10, n11);
                    break;
                }
                case BLOB_HOVER: {
                    BlobMeas blobMeas;
                    if (0 >= this.points.size() || null == this.blobMeases) break;
                    Point point3 = this.points.get(0);
                    int n12 = point3.x * n;
                    int n13 = point3.y * n;
                    Image image = this.ip.getImage();
                    int n14 = image.getWidth();
                    int n15 = image.getHeight();
                    if (n12 < 0 || n12 >= n14 || n13 < 0 || n13 >= n15 || null == (blobMeas = this.blobMeases.getNearestBlob(n12, n13))) break;
                    n12 = (int)blobMeas.centre.x;
                    n13 = (int)blobMeas.centre.y;
                    int n16 = n12 / n - point.x;
                    int n17 = n13 / n - point.y + n2;
                    this.drawCross(graphics2D, n16, n17);
                    String string = "(" + n12 + ", " + n13 + ") " + blobMeas.toHoverString();
                    int n18 = n16 + 4;
                    int n19 = n17 - 4;
                    if (n16 > n3) {
                        n18 = n16 - 154;
                    }
                    if (n17 < 20) {
                        n19 = n17 + 34;
                    }
                    graphics2D.drawString(string, n18, n19);
                    break;
                }
                case STAR_CHART: {
                    Star star;
                    if (0 >= this.points.size() || !(this.ip.getImFrame() instanceof StarChartFrame)) break;
                    Point point4 = this.points.get(0);
                    int n20 = point4.x * n;
                    int n21 = point4.y * n;
                    Image image = this.ip.getImage();
                    int n22 = image.getWidth();
                    int n23 = image.getHeight();
                    if (n20 < 0 || n20 >= n22 || n21 < 0 || n21 >= n23 || null == (star = ((StarChartFrame)this.ip.getImFrame()).getStarChart().findNearestStar(n20, n21))) break;
                    Point point5 = star.getPlotPoint();
                    n20 = point5.x;
                    n21 = point5.y;
                    int n24 = n20 / n - point.x;
                    int n25 = n21 / n - point.y + n2;
                    this.drawCross(graphics2D, n24, n25);
                    String string = star.getId();
                    Magnitude magnitude = star.getMagnitude();
                    if (null != magnitude) {
                        string = string + " m" + magnitude.toString();
                    }
                    int n26 = n24 + 4;
                    int n27 = n25 - 4;
                    if (n24 > n3) {
                        n26 = n24 - 50;
                    }
                    if (n25 < 20) {
                        n27 = n25 + 34;
                    }
                    graphics2D.drawString(string, n26, n27);
                    break;
                }
                case POINT: {
                    if (0 >= this.points.size()) break;
                    Point point6 = this.points.get(0);
                    int n28 = point6.x / n - point.x;
                    int n29 = point6.y / n - point.y + n2;
                    this.drawCross(graphics2D, n28, n29);
                    break;
                }
                case CONTROL_POINTS: {
                    for (int i = 0; i < this.points.size(); ++i) {
                        Point point7 = this.points.get(i);
                        int n30 = point7.x / n - point.x;
                        int n31 = point7.y / n - point.y + n2;
                        this.drawCross(graphics2D, n30, n31);
                        n30 = n30 > n3 ? (n30 -= 10) : (n30 += 4);
                        n31 = n31 > n4 ? (n31 -= 10) : (n31 += 4);
                        graphics2D.drawString("" + (i + 1), n30, n31);
                    }
                    break;
                }
                case KERNEL: {
                    if (0 >= this.points.size()) break;
                    Point point8 = this.points.get(0);
                    int n32 = point8.x / n - point.x;
                    int n33 = point8.y / n - point.y + n2;
                    this.drawSquare(graphics2D, n32, n33, ConvolutionMenu.getKernel().getHalfWidth() / n);
                    break;
                }
                case BLOB_PAIR: 
                case CALIBRATE: 
                case POINT_PAIR: 
                case STAR_PAIR: {
                    int n34 = 0;
                    int n35 = 0;
                    int n36 = 0;
                    int n37 = 0;
                    if (0 < this.points.size()) {
                        Point point9 = this.points.get(0);
                        n34 = point9.x / n - point.x;
                        n35 = point9.y / n - point.y + n2;
                        this.drawCross(graphics2D, n34, n35);
                    }
                    if (1 >= this.points.size()) break;
                    Point point10 = this.points.get(1);
                    n36 = point10.x / n - point.x;
                    n37 = point10.y / n - point.y + n2;
                    this.drawCross(graphics2D, n36, n37);
                    graphics2D.setPaint(CURVE_COLOUR);
                    graphics2D.drawLine(n34, n35, n36, n37);
                    break;
                }
                case CROP: 
                case DELETE_MATCHES: 
                case ENCLOSE_SPECTRUM: 
                case RECTANGLE: {
                    int n38 = 0;
                    int n39 = 0;
                    int n40 = 0;
                    int n41 = 0;
                    if (0 < this.points.size()) {
                        Point point11 = this.points.get(0);
                        n38 = point11.x / n - point.x;
                        n39 = point11.y / n - point.y + n2;
                        this.drawCross(graphics2D, n38, n39);
                    }
                    if (1 >= this.points.size()) break;
                    Point point12 = this.points.get(1);
                    n40 = point12.x / n - point.x;
                    n41 = point12.y / n - point.y + n2;
                    int n42 = Math.abs(n40 - n38);
                    int n43 = Math.abs(n41 - n39);
                    this.drawCross(graphics2D, n40, n41);
                    graphics2D.setPaint(CURVE_COLOUR);
                    int n44 = Math.min(n38, n40);
                    int n45 = Math.min(n39, n41);
                    graphics2D.drawRect(n44, n45, n42, n43);
                    String string = n42 * n + " x " + n43 * n + " px";
                    graphics2D.drawString(string, n44 + 5, n45 + 15);
                    break;
                }
                case OPEN_CURVE: {
                    for (int i = 1; i < this.points.size(); ++i) {
                        Point point13 = this.points.get(i - 1);
                        Point point14 = this.points.get(i);
                        graphics2D.drawLine(point13.x / n - point.x, point13.y / n - point.y + n2, point14.x / n - point.x, point14.y / n - point.y + n2);
                    }
                    if (!this.measured || this.iStart >= this.points.size()) break;
                    Point point15 = this.points.get(this.iStart);
                    int n46 = point15.x / n - point.x;
                    int n47 = point15.y / n - point.y + n2;
                    this.drawCross(graphics2D, n46, n47);
                    break;
                }
                case CLOSED_CURVE: {
                    for (int i = 1; i < this.points.size(); ++i) {
                        Point point16 = this.points.get(i - 1);
                        Point point17 = this.points.get(i);
                        graphics2D.drawLine(point16.x / n - point.x, point16.y / n - point.y + n2, point17.x / n - point.x, point17.y / n - point.y + n2);
                    }
                    if (!this.measured || this.points.centreX == 0 || this.points.centreY == 0) break;
                    this.drawCross(graphics2D, this.points.centreX / n - point.x, this.points.centreY / n - point.y + n2);
                    break;
                }
                case MASK: {
                    int n48;
                    int n49;
                    if (null == this.blobMask) break;
                    byte[][] byArray = this.blobMask.getData();
                    graphics2D.setPaint(MASK_COLOUR);
                    for (int i = 0; i < byArray[0].length; ++i) {
                        for (int j = 0; j < byArray.length; ++j) {
                            int n50;
                            if (0 == byArray[j][i]) continue;
                            int n51 = n50 = j;
                            while (j < byArray.length && 0 != byArray[j][i]) {
                                n50 = j++;
                            }
                            int n52 = n51 / n - point.x + 1;
                            n49 = n50 / n - point.x + 1;
                            n48 = i / n - point.y + n2 + 1;
                            graphics2D.drawLine(n52, n48, n49, n48);
                        }
                    }
                    List<XYText> list = this.points.getLabels();
                    if (null == list) break;
                    graphics2D.setPaint(TEXT_COLOUR);
                    for (XYText xYText : list) {
                        n49 = xYText.x / n - point.x;
                        n48 = xYText.y / n - point.y + n2;
                        graphics2D.drawString(xYText.text, n49, n48);
                    }
                    break;
                }
            }
        }
    }
}

