/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.grelf.Util;
import net.grelf.astro.StarChart;
import net.grelf.grip.DefaultMeasurementHandler;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImGraphic;
import net.grelf.grip.ImTable;
import net.grelf.grip.ImageSizeAction;
import net.grelf.grip.ImageSizeDialogue;

public class GripFileMenu
extends JMenu
implements ActionListener,
MenuListener,
ImageSizeAction {
    private JMenuItem itemImage;
    private JMenuItem itemBlobs;
    private JMenuItem itemChart;
    private JMenuItem itemAAVSO;

    public GripFileMenu() {
        super("File");
        this.setMnemonic('F');
        this.itemImage = Util.menuItem(this, "Open image(s)", "open", 79, 79);
        this.add(this.itemImage);
        this.itemImage.setToolTipText("Load RAW, TIFF, JPEG, PNG, etc");
        this.add(Util.menuItem(this, "New star chart", "star", 67, 0));
        this.add(Util.menuItem(this, "New blank image", "new", 78, 78));
        this.add(Util.menuItem(this, "New test grid of squares", "grid", 68, 0));
        this.add(Util.menuItem(this, "New Mandelbrot curve", "mandel", 77, 0));
        this.addSeparator();
        this.itemBlobs = Util.menuItem(this, "Open blob data & image", "blob", 66, 0);
        this.add(this.itemBlobs);
        this.itemBlobs.setToolTipText("Load a .blobs file saved by GRIP");
        this.itemChart = Util.menuItem(this, "Open star chart", "chart", 83, 0);
        this.add(this.itemChart);
        this.itemChart.setToolTipText("Load a .chart file saved by GRIP");
        this.itemAAVSO = Util.menuItem(this, "Open AAVSO sequence", "aavso", 65, 0);
        this.add(this.itemAAVSO);
        this.itemAAVSO.setToolTipText("Load saved HTML file as a chart");
        this.addSeparator();
        this.add(Util.menuItem(this, "Find and refresh image table", "table", 84, 84));
        this.addSeparator();
        this.add(Util.menuItem(this, "Exit", "exit", 88, 0));
    }

    @Override
    public void process(ImageSizeDialogue imageSizeDialogue) {
        int n = imageSizeDialogue.getWidth();
        int n2 = imageSizeDialogue.getHeight();
        imageSizeDialogue.dispose();
        if (0 < n && 0 < n2) {
            GRIP.incNNewImages();
            new ImFrame("New image " + GRIP.getNNewImages(), GRIP.getNNewImages(), n, n2, new DefaultMeasurementHandler());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("aavso")) {
            GRIP.getInstance().openAAVSO_Chart();
        } else if (string.equals("blob")) {
            GRIP.getInstance().openBlobs();
        } else if (string.equals("chart")) {
            GRIP.getInstance().openChart();
        } else if (string.equals("exit")) {
            GRIP.getInstance().exit();
        } else if (string.equals("experiment")) {
            this.experiment();
        } else if (string.equals("grid")) {
            new ImGraphic().drawGrid();
        } else if (string.equals("mandel")) {
            new ImGraphic().drawMandelbrot();
        } else if (string.equals("new")) {
            int n = 1024;
            int n2 = 768;
            new ImageSizeDialogue(n, n2, "New image", this);
        } else if (string.equals("open")) {
            GRIP.getInstance().openFiles();
        } else if (string.equals("star")) {
            StarChart.createChart();
        } else if (string.equals("table")) {
            ImTable imTable = GRIP.getTable();
            if (null != imTable) {
                imTable.refresh();
                imTable.setVisible(true);
            } else if (0 < GRIP.getImFramesList().size()) {
                GRIP.setTable(new ImTable(GRIP.getInstance(), "Select images", true));
            } else {
                Util.message(this, "Sorry", "No images currently open");
            }
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    private void experiment() {
    }
}

