/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import net.grelf.Util;
import net.grelf.grip.AssociatedPane;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GlassPane;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPane;
import net.grelf.image.Image8or16Base;

public class Hist3D_Pane
extends ImPane
implements AssociatedPane {
    private static final int DIM = 256;
    private static final int PLOT_WIDTH = 257;
    private static final int PLOT_HEIGHT = 257;
    private static final int PLOT_GAP = 10;
    private static final int SPECTRUM_WIDTH = 256;
    private static final int SPECTRUM_HEIGHT = 40;
    private static final Color RED = new Color(192, 0, 0);
    private static final Color GREEN = new Color(0, 192, 0);
    private static final Color BLUE = new Color(0, 96, 192);
    private static final int IMAGE_TYPE = 1;
    private static final float DISPLAY_LEVELS = 254.0f;
    private BufferedImage image;
    private BufferedImage rgIm = new BufferedImage(257, 257, 1);
    private BufferedImage gbIm = new BufferedImage(257, 257, 1);
    private BufferedImage brIm = new BufferedImage(257, 257, 1);
    private BufferedImage spectrumIm = new BufferedImage(256, 40, 1);
    private int markR = -1;
    private int markG = -1;
    private int markB = -1;
    private int shift = 0;
    private static int[] rLUT = new int[256];
    private static int[] gLUT = new int[256];
    private static int[] bLUT = new int[256];
    private static final int rgImX0 = 0;
    private static final int rgImY0 = 0;
    private static final int gbImX0 = 267;
    private static final int gbImY0 = 0;
    private static final int brImX0 = 267;
    private static final int brImY0 = 267;
    private static final int spectrumImX0 = 0;
    private static final int spectrumImY0 = 474;

    public static void display(ImFrame imFrame) {
        net.grelf.image.Image image = imFrame.getImPane().getImage();
        if (!(image instanceof Image8or16Base)) {
            Util.message("Sorry", "Not available for 32- or 64-bits-per-channel images");
        } else {
            BufferedImage bufferedImage = ((Image8or16Base)image).getBufferedImage();
            if (image.getNBands() != 3) {
                Util.message("Sorry", "3D histograms are only displayable for 3-channel (RGB) images.");
            } else {
                ImFrame imFrame2 = new ImFrame("3D histogram [" + imFrame.getCaption() + "]", new Hist3D_Pane(bufferedImage));
                imFrame.getImPane().setAssociatedPane((Hist3D_Pane)imFrame2.getImPane());
            }
        }
    }

    public Hist3D_Pane(BufferedImage bufferedImage) {
        super(null, 524, 524, new GlassPane(DrawingMode.UNDEFINED, null, null));
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.image = bufferedImage;
        int n6 = this.image.getSampleModel().getSampleSize(0);
        this.shift = n6 - 8;
        this.setPreferredSize(new Dimension(524, 524));
        int[][] nArray = new int[256][256];
        int[][] nArray2 = new int[256][256];
        int[][] nArray3 = new int[256][256];
        int n7 = 0;
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                nArray3[i][j] = 0;
                nArray2[i][j] = 0;
                nArray[i][j] = 0;
            }
        }
        WritableRaster writableRaster = this.image.getRaster();
        int[] nArray4 = new int[3];
        if (this.shift <= 0) {
            for (n5 = 0; n5 < this.image.getHeight(); ++n5) {
                for (n4 = 0; n4 < this.image.getWidth(); ++n4) {
                    writableRaster.getPixel(n4, n5, nArray4);
                    nArray[nArray4[0]][nArray4[1]] = n3 = nArray[nArray4[0]][nArray4[1]] + 1;
                    if (n3 > n7) {
                        n7 = n3;
                    }
                    nArray2[nArray4[1]][nArray4[2]] = n3 = nArray2[nArray4[1]][nArray4[2]] + 1;
                    if (n3 > n7) {
                        n7 = n3;
                    }
                    nArray3[nArray4[2]][nArray4[0]] = n3 = nArray3[nArray4[2]][nArray4[0]] + 1;
                    if (n3 <= n7) continue;
                    n7 = n3;
                }
            }
        } else {
            for (n5 = 0; n5 < this.image.getHeight(); ++n5) {
                for (n4 = 0; n4 < this.image.getWidth(); ++n4) {
                    writableRaster.getPixel(n4, n5, nArray4);
                    int n8 = 0;
                    while (n8 < 3) {
                        int n9 = n8++;
                        nArray4[n9] = nArray4[n9] >> this.shift;
                    }
                    nArray[nArray4[0]][nArray4[1]] = n3 = nArray[nArray4[0]][nArray4[1]] + 1;
                    if (n3 > n7) {
                        n7 = n3;
                    }
                    nArray2[nArray4[1]][nArray4[2]] = n3 = nArray2[nArray4[1]][nArray4[2]] + 1;
                    if (n3 > n7) {
                        n7 = n3;
                    }
                    nArray3[nArray4[2]][nArray4[0]] = n3 = nArray3[nArray4[2]][nArray4[0]] + 1;
                    if (n3 <= n7) continue;
                    n7 = n3;
                }
            }
        }
        Graphics2D graphics2D = this.rgIm.createGraphics();
        Graphics2D graphics2D2 = this.gbIm.createGraphics();
        Graphics2D graphics2D3 = this.brIm.createGraphics();
        int n10 = 0;
        int n11 = 0;
        for (int i = 0; i < 256; i += 50) {
            graphics2D.setPaint(RED);
            n11 = this.rgTranslateY(i);
            graphics2D.drawLine(this.rgTranslateX(0), n11, this.rgTranslateX(256), n11);
            graphics2D.setPaint(GREEN);
            n10 = this.rgTranslateX(i);
            graphics2D.drawLine(n10, this.rgTranslateY(256), n10, this.rgTranslateY(0));
            graphics2D2.setPaint(GREEN);
            n10 = this.gbTranslateX(i);
            graphics2D2.drawLine(n10, this.gbTranslateY(256), n10, this.gbTranslateY(0));
            graphics2D2.setPaint(BLUE);
            n11 = this.gbTranslateY(i);
            graphics2D2.drawLine(this.gbTranslateX(0), n11, this.gbTranslateX(256), n11);
            graphics2D3.setPaint(BLUE);
            n11 = this.brTranslateY(i);
            graphics2D3.drawLine(this.brTranslateX(0), n11, this.brTranslateX(256), n11);
            graphics2D3.setPaint(RED);
            n10 = this.brTranslateX(i);
            graphics2D3.drawLine(n10, this.brTranslateY(256), n10, this.brTranslateY(0));
        }
        WritableRaster writableRaster2 = this.spectrumIm.getRaster();
        for (n10 = 0; n10 < 256; ++n10) {
            for (n11 = 0; n11 < 40; ++n11) {
                this.setPixel(n10, n10, n11, writableRaster2);
            }
        }
        float f = 254.0f / (float)n7;
        WritableRaster writableRaster3 = this.rgIm.getRaster();
        WritableRaster writableRaster4 = this.gbIm.getRaster();
        WritableRaster writableRaster5 = this.brIm.getRaster();
        for (n2 = 0; n2 < 256; ++n2) {
            for (n = 0; n < 256; ++n) {
                n11 = nArray[n2][n];
                if (n11 <= 0) continue;
                this.setPixel((int)((double)((float)n11 * f) + 0.5), this.rgTranslateX(n2), this.rgTranslateY(n), writableRaster3);
            }
        }
        for (n2 = 0; n2 < 256; ++n2) {
            for (n = 0; n < 256; ++n) {
                n11 = nArray2[n2][n];
                if (n11 <= 0) continue;
                this.setPixel((int)((double)((float)n11 * f) + 0.5), this.gbTranslateX(n), this.gbTranslateY(n2), writableRaster4);
            }
        }
        for (n2 = 0; n2 < 256; ++n2) {
            for (n = 0; n < 256; ++n) {
                n11 = nArray3[n2][n];
                if (n11 <= 0) continue;
                this.setPixel((int)((double)((float)n11 * f) + 0.5), this.brTranslateX(n2), this.brTranslateY(n), writableRaster5);
            }
        }
    }

    private void setPixel(int n, int n2, int n3, WritableRaster writableRaster) {
        if (n > 255) {
            n = 255;
        }
        int[] nArray = new int[]{rLUT[n], gLUT[n], bLUT[n]};
        writableRaster.setPixel(n2, n3, nArray);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.drawImage((Image)this.rgIm, 0, 0, null);
        graphics2D.drawImage((Image)this.gbIm, 267, 0, null);
        graphics2D.drawImage((Image)this.brIm, 267, 267, null);
        graphics2D.drawImage((Image)this.spectrumIm, 0, 474, null);
        if (this.markR != -1 && this.markG != -1 && this.markB != -1) {
            graphics2D.setPaint(Color.white);
            int n = 0 + this.rgTranslateX(this.markR);
            int n2 = 0 + this.rgTranslateY(this.markG);
            graphics2D.drawRect(n - 2, n2 - 2, 5, 5);
            n = 267 + this.gbTranslateX(this.markB);
            n2 = 0 + this.gbTranslateY(this.markG);
            graphics2D.drawRect(n - 2, n2 - 2, 5, 5);
            n = 267 + this.brTranslateX(this.markB);
            n2 = 267 + this.brTranslateY(this.markR);
            graphics2D.drawRect(n - 2, n2 - 2, 5, 5);
            graphics2D.setPaint(Color.black);
            graphics2D.drawString(this.markR + ", " + this.markG + ", " + this.markB, 50, 307);
        }
    }

    private int rgTranslateX(int n) {
        return 256 - n;
    }

    private int rgTranslateY(int n) {
        return 256 - n;
    }

    private int gbTranslateX(int n) {
        return n + 1;
    }

    private int gbTranslateY(int n) {
        return 256 - n;
    }

    private int brTranslateX(int n) {
        return n + 1;
    }

    private int brTranslateY(int n) {
        return n + 1;
    }

    @Override
    public void dragAction(int n, int n2, int[] nArray) {
    }

    @Override
    public void moveAction(int n, int n2, int[] nArray) {
        if (this.shift <= 0) {
            this.markR = nArray[0];
            this.markG = nArray[1];
            this.markB = nArray[2];
        } else {
            this.markR = nArray[0] >> this.shift;
            this.markG = nArray[1] >> this.shift;
            this.markB = nArray[2] >> this.shift;
        }
        this.repaint();
    }

    @Override
    public void pressAction(int n, int n2, int[] nArray) {
    }

    @Override
    public void releaseAction(int n, int n2, int[] nArray) {
    }

    @Override
    public int getNBands() {
        return this.image.getSampleModel().getNumBands();
    }

    @Override
    public int getNBits() {
        return this.image.getSampleModel().getSampleSize(0);
    }

    static {
        Hist3D_Pane.rLUT[0] = 96;
        Hist3D_Pane.gLUT[0] = 96;
        Hist3D_Pane.bLUT[0] = 96;
        int n = 1;
        int n2 = 126;
        while (n < 21) {
            Hist3D_Pane.rLUT[n] = n2;
            Hist3D_Pane.gLUT[n] = 0;
            Hist3D_Pane.bLUT[n] = 0;
            ++n;
            n2 += 6;
        }
        n2 = 1;
        while (n < 42) {
            Hist3D_Pane.rLUT[n] = 255;
            Hist3D_Pane.gLUT[n] = n2;
            Hist3D_Pane.bLUT[n] = 0;
            ++n;
            n2 += 12;
        }
        while (n < 84) {
            Hist3D_Pane.rLUT[n] = n2;
            Hist3D_Pane.gLUT[n] = 255;
            Hist3D_Pane.bLUT[n] = 0;
            ++n;
            n2 -= 6;
        }
        n2 = 1;
        while (n < 126) {
            Hist3D_Pane.rLUT[n] = 0;
            Hist3D_Pane.gLUT[n] = 255;
            Hist3D_Pane.bLUT[n] = n2;
            ++n;
            n2 += 6;
        }
        while (n < 168) {
            Hist3D_Pane.rLUT[n] = 0;
            Hist3D_Pane.gLUT[n] = n2;
            Hist3D_Pane.bLUT[n] = 255;
            ++n;
            n2 -= 6;
        }
        n2 = 1;
        while (n < 210) {
            Hist3D_Pane.rLUT[n] = n2;
            Hist3D_Pane.gLUT[n] = 0;
            Hist3D_Pane.bLUT[n] = 255;
            ++n;
            n2 += 6;
        }
        n2 = 1;
        while (n < 252) {
            Hist3D_Pane.rLUT[n] = 255;
            Hist3D_Pane.gLUT[n] = n2;
            Hist3D_Pane.bLUT[n] = 255;
            ++n;
            n2 += 6;
        }
        while (n < 256) {
            Hist3D_Pane.rLUT[n] = 255;
            Hist3D_Pane.gLUT[n] = 255;
            Hist3D_Pane.bLUT[n] = 255;
            ++n;
        }
    }
}

