/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JComponent;
import net.grelf.FileIO;
import net.grelf.FileIO_CSVFilter;
import net.grelf.FileIO_XMLFilter;
import net.grelf.Statistics;
import net.grelf.Util;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.DefaultMeasurementHandler;
import net.grelf.grip.ImFrame;
import net.grelf.grip.Measurement;

public class HistogramBlobs
extends JComponent
implements Printable {
    private ImFrame imframe;
    private BlobMeasList blobMeases;
    private int minArea;
    private int maxArea;
    private int modeArea;
    private double meanArea;
    private double stdDevArea;
    private double minBrightness;
    private double maxBrightness;
    private double modeBrightness;
    private double meanBrightness;
    private double stdDevBrightness;
    private int[] fArea = null;
    private int[] fBrightness = null;
    private int[] scaledFArea = null;
    private int[] scaledFBrightness = null;

    public static void display(ImFrame imFrame, BlobMeasList blobMeasList) {
        HistogramBlobs histogramBlobs = new HistogramBlobs(imFrame, blobMeasList);
        Statistics[] statisticsArray = histogramBlobs.getStatistics();
        ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
        arrayList.add(new Measurement("number of blobs", blobMeasList.size(), ""));
        arrayList.add(new Measurement("area min", statisticsArray[0].min, ""));
        arrayList.add(new Measurement("area mean ", statisticsArray[0].mean, ""));
        arrayList.add(new Measurement("area std.dev.", statisticsArray[0].stdDev, ""));
        arrayList.add(new Measurement("area mode", statisticsArray[0].mode, ""));
        arrayList.add(new Measurement("area max", statisticsArray[0].max, ""));
        arrayList.add(new Measurement("brightness min", statisticsArray[1].min, ""));
        arrayList.add(new Measurement("brightness mean ", statisticsArray[1].mean, ""));
        arrayList.add(new Measurement("brightness std.dev.", statisticsArray[1].stdDev, ""));
        arrayList.add(new Measurement("brightness mode", statisticsArray[1].mode, ""));
        arrayList.add(new Measurement("brightness max", statisticsArray[1].max, ""));
        arrayList.add(new Measurement("Histogram", histogramBlobs, ""));
        new DefaultMeasurementHandler().process(imFrame, null, arrayList);
    }

    public HistogramBlobs(ImFrame imFrame, BlobMeasList blobMeasList) {
        this.imframe = imFrame;
        this.blobMeases = blobMeasList;
        int n = 0;
        for (BlobMeas blobMeas : blobMeasList) {
            if (0 == n) {
                this.minArea = this.maxArea = blobMeas.area;
                this.minBrightness = this.maxBrightness = blobMeas.brightness;
            } else {
                if (blobMeas.area < this.minArea) {
                    this.minArea = blobMeas.area;
                } else if (blobMeas.area > this.maxArea) {
                    this.maxArea = blobMeas.area;
                }
                if (blobMeas.brightness < this.minBrightness) {
                    this.minBrightness = blobMeas.brightness;
                } else if (blobMeas.brightness > this.maxBrightness) {
                    this.maxBrightness = blobMeas.brightness;
                }
            }
            ++n;
        }
        this.fArea = new int[256];
        this.fBrightness = new int[256];
        double d = 255.0 / (double)(this.maxArea - this.minArea);
        double d2 = 255.0 / (this.maxBrightness - this.minBrightness);
        for (BlobMeas blobMeas : blobMeasList) {
            int n2 = (int)((double)(blobMeas.area - this.minArea) * d);
            this.fArea[n2] = this.fArea[n2] + 1;
            int n3 = (int)((blobMeas.brightness - this.minBrightness) * d2);
            this.fBrightness[n3] = this.fBrightness[n3] + 1;
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < 256; ++i) {
            l += (long)this.fArea[i];
            l2 += (long)(this.fArea[i] * i);
            l3 += (long)(this.fArea[i] * i * i);
            if (this.fArea[i] > n4) {
                n4 = this.fArea[i];
                n5 = i;
            }
            l4 += (long)this.fBrightness[i];
            l5 += (long)(this.fBrightness[i] * i);
            l6 += (long)(this.fBrightness[i] * i * i);
            if (this.fBrightness[i] <= n6) continue;
            n6 = this.fBrightness[i];
            n7 = i;
        }
        this.modeArea = this.minArea + (int)((double)n5 / d);
        this.meanArea = (double)this.minArea + (double)l2 / (double)l / d;
        this.stdDevArea = Math.sqrt((double)l3 / (double)l - this.meanArea * this.meanArea) / d;
        this.modeBrightness = this.minBrightness + (double)n7 / d2;
        this.meanBrightness = this.minBrightness + (double)l5 / (double)l4 / d2;
        this.stdDevBrightness = Math.sqrt((double)l6 / ((double)l4 - this.meanBrightness * this.meanBrightness)) / d2;
        this.setSize(650, 300);
        this.setPreferredSize(new Dimension(650, 300));
        this.scaledFArea = new int[256];
        this.scaledFBrightness = new int[256];
        double d3 = 255.0 / (double)n4;
        double d4 = 255.0 / (double)n6;
        for (int i = 0; i < 256; ++i) {
            this.scaledFArea[i] = (int)((double)this.fArea[i] * d3);
            this.scaledFBrightness[i] = (int)((double)this.fBrightness[i] * d4);
        }
    }

    public Statistics[] getStatistics() {
        Statistics[] statisticsArray = new Statistics[2];
        statisticsArray[0] = new Statistics();
        statisticsArray[0].min = this.minArea;
        statisticsArray[0].max = this.maxArea;
        statisticsArray[0].mode = this.modeArea;
        statisticsArray[0].mean = this.meanArea;
        statisticsArray[0].stdDev = this.stdDevArea;
        statisticsArray[1] = new Statistics();
        statisticsArray[1].min = (int)this.minBrightness;
        statisticsArray[1].max = (int)this.maxBrightness;
        statisticsArray[1].mode = (int)this.modeBrightness;
        statisticsArray[1].mean = this.meanBrightness;
        statisticsArray[1].stdDev = this.stdDevBrightness;
        return statisticsArray;
    }

    protected void draw(Graphics2D graphics2D, int n, int n2) {
        int n3;
        graphics2D.setPaint(new Color(212, 208, 200));
        graphics2D.fillRect(n, n2, this.getWidth(), this.getHeight());
        int n4 = n + 8;
        int n5 = n2 + 278;
        graphics2D.setPaint(Color.black);
        for (n3 = 0; n3 < 256; n3 += 50) {
            graphics2D.drawLine(n4 + n3, n5 - 256, n4 + n3, n5 + 5);
            graphics2D.drawLine(n4 - 5, n5 - n3, n4 + 256, n5 - n3);
        }
        graphics2D.drawString("Area", n + 130, n2 + 300);
        graphics2D.drawString(Util.format(this.minArea), n + 10, n2 + 300);
        graphics2D.drawString(Util.format(this.maxArea), n + 250, n2 + 300);
        graphics2D.setPaint(Color.magenta);
        n3 = 0;
        int n6 = n4;
        while (n3 < 256) {
            graphics2D.drawLine(n6, n5, n6, n5 - this.scaledFArea[n3]);
            ++n3;
            ++n6;
        }
        n4 += 300;
        graphics2D.setPaint(Color.black);
        for (n3 = 0; n3 < 256; n3 += 50) {
            graphics2D.drawLine(n4 + n3, n5 - 256, n4 + n3, n5 + 5);
            graphics2D.drawLine(n4 - 5, n5 - n3, n4 + 256, n5 - n3);
        }
        graphics2D.drawString("Brightness", n + 430, n2 + 300);
        graphics2D.drawString(Util.format(this.minBrightness), n + 310, n2 + 300);
        graphics2D.drawString(Util.format(this.maxBrightness), n + 550, n2 + 300);
        graphics2D.setPaint(Color.cyan);
        n3 = 0;
        n6 = n4;
        while (n3 < 256) {
            graphics2D.drawLine(n6, n5, n6, n5 - this.scaledFBrightness[n3]);
            ++n3;
            ++n6;
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.draw((Graphics2D)graphics, 0, 0);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.draw(graphics2D, 0, 0);
        return 0;
    }

    public void saveCSV() {
        String string = FileIO.selectOutputFile("Create CSV file", null, new FileIO_CSVFilter[]{new FileIO_CSVFilter(1)}, "x.csv");
        if (string != null) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(string));
                printWriter.println("centroid X, centroid Y, area (px), brightness");
                for (BlobMeas blobMeas : this.blobMeases) {
                    printWriter.println(blobMeas.centre.x + "," + blobMeas.centre.y + "," + blobMeas.area + "," + blobMeas.brightness + ",");
                }
                printWriter.close();
            }
            catch (IOException iOException) {
                Util.warning(this, "Error", (Object)iOException.toString());
            }
        }
    }

    public void saveXML() {
        String string = FileIO.selectOutputFile("Create XML file", null, new FileIO_XMLFilter[]{new FileIO_XMLFilter(1)}, "x.xml");
        if (string != null) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(string));
                printWriter.println("<?xml version=\"1.0\"?>");
                printWriter.println("<Blobs>");
                printWriter.println("\t<!-- Units: pixels -->");
                printWriter.println("\t<Image>" + this.imframe.getFilePath() + "</Image>");
                for (BlobMeas blobMeas : this.blobMeases) {
                    printWriter.println("\t<Blob>");
                    printWriter.println("\t\t<Centroid><X>" + blobMeas.centre.x + "</X><Y>" + blobMeas.centre.y + "</Y></Centroid>");
                    printWriter.println("\t\t<Area>" + blobMeas.area + "</Area>");
                    printWriter.println("\t\t<Brightness>" + blobMeas.brightness + "</Brightness>");
                    printWriter.println("\t</Blob>");
                }
                printWriter.println("</Blobs>");
                printWriter.close();
            }
            catch (IOException iOException) {
                Util.warning(this, "Error", (Object)iOException.toString());
            }
        }
    }
}

