/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import net.grelf.AbstractDialogue;
import net.grelf.FileIO;
import net.grelf.Statistics;
import net.grelf.Util;
import net.grelf.grip.GRIP;
import net.grelf.grip.Histogram;
import net.grelf.grip.ImCurve;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPreview;
import net.grelf.grip.ImPreviewActor;
import net.grelf.image.Image;
import net.grelf.image.Image64;
import net.grelf.image.IncompatibleImageException;

public class ImCurveDialogue
extends AbstractDialogue
implements ActionListener,
ImPreviewActor {
    private Image image = null;
    private double srcMaxLevel;
    private double dstMaxLevel;
    private JComboBox dropDown = new JComboBox();
    private String[] dropDownItems = new String[]{"Linear", "Linear from mode", "Invert", "V-shape", "Gamma correction"};
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JButton neutraliseButton = new JButton("Neutralise background");
    private JButton saveButton = new JButton("Save");
    private JButton loadButton = new JButton("Load");
    private JPanel imagePanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private ImPreview imPreview;
    private ImCurve imCurve;
    private Histogram imHist;
    private List<Point> points;
    private boolean accepted = false;

    public List<Point> getPoints() {
        return this.points;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public ImCurveDialogue(Image image, Histogram histogram) {
        this.setTitle("Adjust brightness curve");
        this.image = image;
        this.imHist = histogram;
        this.imCurve = new ImCurve(this);
        this.points = this.imCurve.getPoints();
        this.dstMaxLevel = this.srcMaxLevel = image.getRangeDouble().high;
        this.imPreview = new ImPreview(image, this);
        if (null == histogram) {
            this.imHist = new Histogram(image);
        }
        if (null == this.imHist) {
            Util.message("Info", "Null imHist");
        } else {
            this.imagePanel.add((Component)this.imHist, "West");
        }
        this.imagePanel.add((Component)this.imCurve, "Center");
        this.imagePanel.add((Component)this.imPreview, "East");
        for (int i = 0; i < this.dropDownItems.length; ++i) {
            this.dropDown.addItem(this.dropDownItems[i]);
        }
        this.buttonPanel.setLayout(new FlowLayout());
        this.neutraliseButton.addActionListener(this);
        this.buttonPanel.add(this.neutraliseButton);
        this.dropDown.setEditable(false);
        this.dropDown.addActionListener(this);
        this.buttonPanel.add(this.dropDown);
        this.saveButton.addActionListener(this);
        this.buttonPanel.add(this.saveButton);
        this.loadButton.addActionListener(this);
        this.buttonPanel.add(this.loadButton);
        this.okButton.addActionListener(this);
        this.buttonPanel.add(this.okButton);
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.imagePanel, "North");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setModal(true);
        this.setLocation(50, 50);
        this.setVisible(true);
    }

    public void update(List<Point> list) {
        this.points = list;
        this.imPreview.refresh();
    }

    public void applyCurve(Image image) {
        int n = image.getWidth();
        int n2 = image.getHeight();
        Point point = new Point(n / 2, n2 / 2);
        if (null != image) {
            this.previewAction(image, image, point, n, n2);
        }
    }

    @Override
    public void previewAction(Image image, Image image2, Point point, int n, int n2) {
        if (1 < this.points.size()) {
            Object object;
            int n3;
            int[] nArray = new int[256];
            double d = 255.0 / this.srcMaxLevel;
            double d2 = image2.getRangeDouble().high / 255.0;
            Object object2 = this.points.get(0);
            for (n3 = 1; n3 < this.points.size(); ++n3) {
                object = this.points.get(n3);
                double d3 = (double)((Point)object2).y * d2;
                double d4 = ((Point)object).x - ((Point)object2).x;
                if (d4 > 0.0) {
                    double d5 = d2 * (double)(((Point)object).y - ((Point)object2).y) / d4;
                    int n4 = ((Point)object2).x;
                    while (n4 <= ((Point)object).x && n4 < nArray.length) {
                        nArray[n4] = (int)d3;
                        ++n4;
                        d3 += d5;
                    }
                }
                object2 = object;
            }
            n3 = Math.min(image.getNBands(), image2.getNBands());
            object = new int[n3];
            int n5 = point.y - n2 / 2;
            for (int i = 0; i < n2; ++i) {
                int n6 = point.x - n / 2;
                for (int j = 0; j < n; ++j) {
                    double[] dArray = image.getPixelDouble(n6, n5);
                    for (int k = 0; k < n3; ++k) {
                        object[k] = nArray[(int)(dArray[k] * d)];
                    }
                    image2.setPixel(j, i, (int[])object);
                    ++n6;
                }
                ++n5;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.accepted = true;
            this.setVisible(false);
        } else if (object == this.cancelButton) {
            this.accepted = false;
            this.setVisible(false);
        } else if (object == this.dropDown) {
            switch (this.dropDown.getSelectedIndex()) {
                case 0: {
                    this.imCurve.replacePoints(new Point[]{new Point(0, 0), new Point(255, 255)});
                    break;
                }
                case 1: {
                    Statistics statistics = this.imHist.getStatistics()[0];
                    int n = (int)(255.0 * (double)statistics.mode / this.srcMaxLevel);
                    this.imCurve.replacePoints(new Point[]{new Point(0, 0), new Point(n, 0), new Point(255, 255)});
                    break;
                }
                case 2: {
                    Point[] pointArray = this.imCurve.getPointsAsArray();
                    for (int i = 0; i < pointArray.length; ++i) {
                        pointArray[i].y = 255 - pointArray[i].y;
                    }
                    this.imCurve.replacePoints(pointArray);
                    break;
                }
                case 3: {
                    this.imCurve.replacePoints(new Point[]{new Point(0, 255), new Point(127, 0), new Point(255, 255)});
                    break;
                }
                case 4: {
                    double d = Util.askDouble("Gamma value [0.05 .. 5.0]?", 1.0, 0.05, 5.0);
                    if (Double.isNaN(d)) break;
                    Point[] pointArray = new Point[11];
                    pointArray[0] = new Point(0, 0);
                    for (int i = 1; i < 10; ++i) {
                        int n = (int)(25.5 * (double)i);
                        int n2 = (int)(255.0 * Math.exp(d * Math.log((double)i * 0.1)));
                        pointArray[i] = new Point(n, n2);
                    }
                    pointArray[10] = new Point(255, 255);
                    this.imCurve.replacePoints(pointArray);
                }
            }
        } else if (object == this.loadButton) {
            this.loadCurve();
        } else if (object == this.neutraliseButton) {
            this.neutraliseButton.setEnabled(false);
            this.setCursor(GRIP.GRIP_WAIT_CURSOR);
            this.image.neutraliseBackground();
            Histogram histogram = new Histogram(this.image);
            this.imPreview.refresh();
            this.imagePanel.removeAll();
            this.imHist = histogram;
            this.imagePanel.add((Component)this.imHist, "West");
            this.imagePanel.add((Component)this.imCurve, "Center");
            this.imagePanel.add((Component)this.imPreview, "East");
            this.imagePanel.validate();
            this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        } else if (object == this.saveButton) {
            this.saveCurve();
        }
    }

    public static List<Point> askCurve(ImFrame imFrame) {
        imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
        List<Point> list = ImCurveDialogue.askCurve(imFrame.getImPane().getImage(), null);
        imFrame.addHistory("Curves");
        imFrame.redisplay();
        imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        return list;
    }

    public static List<Point> askCurve(Image image, Histogram histogram) {
        ImCurveDialogue imCurveDialogue = new ImCurveDialogue(image, histogram);
        List<Point> list = null;
        if (imCurveDialogue.isAccepted()) {
            list = imCurveDialogue.getPoints();
            if (null != image) {
                try {
                    if (image instanceof Image64) {
                        ((Image64)image).applyCurveDouble(list);
                    } else {
                        image.applyCurve(image.getRange(), list, null);
                    }
                }
                catch (IncompatibleImageException incompatibleImageException) {
                    Util.warning("Error", incompatibleImageException);
                }
            }
        }
        imCurveDialogue.setVisible(false);
        imCurveDialogue.dispose();
        return list;
    }

    private void loadCurve() {
        String string = "curve";
        String string2 = FileIO.selectInputFile("Open curve file", null, null, string + ".curve");
        if (string2 != null) {
            try {
                BufferedReader bufferedReader = null;
                try {
                    String string3;
                    bufferedReader = new BufferedReader(new FileReader(string2));
                    String string4 = bufferedReader.readLine();
                    if (null == string4 || !string4.startsWith("GRIP v") || !string4.endsWith(" curve")) {
                        throw new ImCurveLoadException();
                    }
                    ArrayList<Point> arrayList = new ArrayList<Point>();
                    while (null != (string3 = bufferedReader.readLine())) {
                        String[] stringArray = string3.split(",");
                        if (stringArray.length != 2) {
                            throw new ImCurveLoadException();
                        }
                        int n = Integer.parseInt(stringArray[0]);
                        int n2 = Integer.parseInt(stringArray[1]);
                        arrayList.add(new Point(n, n2));
                    }
                    if (this.points.size() >= 2) {
                        this.imCurve.replacePoints(arrayList);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ImCurveLoadException();
                }
                finally {
                    if (null != bufferedReader) {
                        bufferedReader.close();
                    }
                }
            }
            catch (ImCurveLoadException imCurveLoadException) {
                Util.warning("Error", "This is not a valid curve file created by GRIP");
            }
            catch (IOException iOException) {
                Util.warning("Error", iOException.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCurve() {
        String string = "curve";
        String string2 = FileIO.selectOutputFile("Create curve file", null, null, string + ".curve");
        if (string2 != null) {
            try {
                PrintWriter printWriter = null;
                try {
                    printWriter = new PrintWriter(new FileWriter(string2));
                    printWriter.println("GRIP v12.6.24 curve");
                    for (Point point : this.imCurve.getPoints()) {
                        printWriter.println(point.x + "," + point.y);
                    }
                }
                finally {
                    if (null != printWriter) {
                        printWriter.close();
                    }
                }
            }
            catch (IOException iOException) {
                Util.warning("Error", iOException.toString());
            }
        }
    }

    private static class ImCurveLoadException
    extends Exception {
        private ImCurveLoadException() {
        }
    }
}

