/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ProgressMonitor;
import javax.swing.filechooser.FileFilter;
import net.grelf.FileIO;
import net.grelf.FileIOBlobsFilter;
import net.grelf.FileIOImageFilter;
import net.grelf.PointFloat;
import net.grelf.Stack;
import net.grelf.Stack_;
import net.grelf.TimeInterval;
import net.grelf.Timer;
import net.grelf.Util;
import net.grelf.astro.JulianDate;
import net.grelf.grip.BatchProcessor;
import net.grelf.grip.Blob;
import net.grelf.grip.BlobMask;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.Config;
import net.grelf.grip.ConvolutionMenu;
import net.grelf.grip.DefaultMeasurementHandler;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GRIP;
import net.grelf.grip.GeometryMenu;
import net.grelf.grip.GlassPane;
import net.grelf.grip.HelpMenu;
import net.grelf.grip.ImPane;
import net.grelf.grip.ImTable;
import net.grelf.grip.ImThreshDialogue;
import net.grelf.grip.ImThreshRGBDialogue;
import net.grelf.grip.ImageMenu;
import net.grelf.grip.LevelsMenu;
import net.grelf.grip.MagnifiedFrame;
import net.grelf.grip.MeasurementHandler;
import net.grelf.grip.MeasurementMenu;
import net.grelf.grip.OpThread;
import net.grelf.image.HistogramAll;
import net.grelf.image.Image;
import net.grelf.image.Image16;
import net.grelf.image.Image8;
import net.grelf.image.ImageBase;
import net.grelf.image.IncompatibleImageException;
import net.grelf.image.Kernel;
import net.grelf.image.Metadata;
import net.grelf.image.Threshold;

public class ImFrame
extends JFrame {
    private static int nInstances = 0;
    protected JMenuBar menubar = null;
    protected LevelsMenu levelsMenu = null;
    private List<String> history = new ArrayList<String>();
    private BlobMeasList blobMeases = null;
    protected ImFrame parentFrame = null;
    private String caption;
    private Stack<String> captionStack = new Stack_<String>();
    private GlassPane gp;
    private ImPane ip;
    private JScrollPane sp;

    public String getFilePath() {
        return this.getImPane().getImage().getFilePath();
    }

    protected final void setFilePath(String string) {
        Image image;
        ImPane imPane = this.getImPane();
        if (null != imPane && null != (image = this.getImPane().getImage())) {
            image.setFilePath(string);
        }
    }

    public void addHistory(String string) {
        this.history.add(string);
    }

    public void showHistory() {
        StringBuffer stringBuffer = new StringBuffer("<html>");
        for (String string : this.history) {
            stringBuffer.append(string);
            stringBuffer.append("<br>");
        }
        Util.message(this, "History of this frame", stringBuffer.toString());
    }

    public void setBlobMeases(BlobMeasList blobMeasList) {
        this.blobMeases = blobMeasList;
        if (null != this.levelsMenu) {
            this.levelsMenu.setBlobMeases(blobMeasList);
        }
        this.getGP().setDrawingMode(DrawingMode.BLOB_HOVER);
    }

    public BlobMeasList getBlobMeases() {
        return this.blobMeases;
    }

    public void saveBlobMeasList() {
        if (null == this.blobMeases) {
            Util.warning("Sorry", "There are no blob data to save");
        } else {
            String string = FileIO.selectOutputFile("Save in a .blobs file", null, new FileIOBlobsFilter[]{new FileIOBlobsFilter(1)}, FileIO.removeExtension(this.getCaption()) + ".blobs");
            if (null != string) {
                this.blobMeases.saveAsXML(string);
            }
        }
    }

    public ImFrame getParentFrame() {
        return this.parentFrame;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String string) {
        this.caption = string;
        this.setTitle(string);
    }

    protected void pushCaption() {
        this.captionStack.push(this.caption);
    }

    protected void popCaption() {
        String string = this.captionStack.pop();
        if (null != string) {
            this.setCaption(string);
        }
    }

    public GlassPane getGP() {
        return this.gp;
    }

    public ImPane getImPane() {
        return this.ip;
    }

    public JScrollPane getScrollPane() {
        return this.sp;
    }

    @Override
    public void dispose() {
        List<ImFrame> list = GRIP.getImFramesList();
        for (int i = list.size() - 1; i >= 0; --i) {
            ImFrame imFrame = list.get(i);
            if (imFrame.getParentFrame() != this) continue;
            imFrame.dispose();
        }
        list.remove(this);
        if (null != this.blobMeases) {
            this.blobMeases.clear();
            this.blobMeases = null;
        }
        if (null != this.ip) {
            this.ip.dispose();
            this.ip = null;
        }
        if (null != this.gp) {
            this.gp.dispose();
            this.gp = null;
        }
        if (null != this.sp) {
            this.sp.removeAll();
            this.sp = null;
        }
        this.parentFrame = null;
        this.caption = null;
        this.captionStack = null;
        this.history = null;
        if (--nInstances <= 0) {
            nInstances = 0;
        }
        super.dispose();
        ImTable imTable = GRIP.getTable();
        if (null != imTable) {
            imTable.refresh();
        }
        System.gc();
    }

    public void redisplay() {
        this.ip.reScale();
        this.ip.repaint();
        if (null != this.gp) {
            this.gp.repaint();
        }
        this.toFront();
    }

    public ImFrame duplicate() {
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        this.addHistory("Clone");
        Image image = this.getImPane().getImage();
        net.grelf.image.Timer timer = new net.grelf.image.Timer("ImFrame.clone", image);
        Image image2 = image.clone();
        if (null != image2) {
            ImFrame imFrame = new ImFrame(this.getCaption() + " (clone)", image2);
            imFrame.setFilePath(this.getFilePath());
            image2.setMetadata(image.getMetadata());
            if (image2 instanceof Image16) {
                ((Image16)image2).setRaw(image.isRaw());
            }
            image2.setCalibration(image.getCalibration());
            imFrame.addHistory("Cloned");
            imFrame.redisplay();
            this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            timer.stop();
            return imFrame;
        }
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        timer.stop();
        return null;
    }

    public void saveAs() {
        Image image = this.getImPane().getImage();
        int n = image.getNBands();
        FileFilter[] fileFilterArray = null;
        switch (image.getBitsPerChannel()) {
            case 8: {
                fileFilterArray = new FileIOImageFilter[]{FileIOImageFilter.PNG_FILTER, FileIOImageFilter.FITS_FILTER, FileIOImageFilter.JPG_FILTER, FileIOImageFilter.TIF_FILTER};
                break;
            }
            case 16: {
                fileFilterArray = new FileIOImageFilter[]{FileIOImageFilter.FITS_FILTER, FileIOImageFilter.TIF_FILTER};
                break;
            }
            case 32: {
                if (1 == n || 3 == n) {
                    fileFilterArray = new FileIOImageFilter[]{FileIOImageFilter.TIF_FILTER, FileIOImageFilter.FITS_FILTER};
                    break;
                }
                fileFilterArray = new FileIOImageFilter[]{FileIOImageFilter.FITS_FILTER};
                break;
            }
            case 64: {
                fileFilterArray = new FileIOImageFilter[]{FileIOImageFilter.FITS_FILTER};
            }
        }
        String string = FileIO.selectOutputFile("Save copy of image", null, fileFilterArray, FileIO.removeExtension(this.getCaption()));
        if (string != null) {
            File file = new File(string);
            boolean bl = false;
            for (FileFilter fileFilter : fileFilterArray) {
                if (!((FileIOImageFilter)fileFilter).accept(file)) continue;
                bl = true;
            }
            if (!bl) {
                Util.warning("Error", "File name does not have a suitable extension");
            } else {
                this.setCursor(GRIP.GRIP_WAIT_CURSOR);
                image.save(string);
                this.addHistory("Save as " + string);
                this.setFilePath(string);
                this.setCaption(new File(string).getName());
                this.setTitle(this.getCaption() + " " + ImPane.zoomPercents[this.getImPane().getScale() - 1]);
                this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
                GRIP.getTable().refresh();
                this.toFront();
            }
        }
    }

    public ImFrame(String string, int n, int n2) {
        this(string, DrawingMode.UNDEFINED, null, -1, n, n2, new DefaultMeasurementHandler(), false);
    }

    public ImFrame(String string, int n, int n2, boolean bl) {
        this(string, DrawingMode.UNDEFINED, null, -1, n, n2, new DefaultMeasurementHandler(), bl);
    }

    public ImFrame(String string, int n, int n2, boolean bl, ImFrame imFrame) {
        this(string, DrawingMode.UNDEFINED, null, -1, n, n2, new DefaultMeasurementHandler(), bl, null, imFrame, null);
    }

    public ImFrame(String string, MeasurementHandler measurementHandler) {
        this(new File(string).getName(), DrawingMode.UNDEFINED, string, -1, 0, 0, measurementHandler);
    }

    public ImFrame(String string, int n, int n2, int n3, MeasurementHandler measurementHandler) {
        this(string, DrawingMode.UNDEFINED, null, n, n2, n3, measurementHandler);
    }

    public ImFrame(String string, DrawingMode drawingMode, String string2, int n, int n2, int n3, MeasurementHandler measurementHandler) {
        this(string, drawingMode, string2, n, n2, n3, measurementHandler, true, null, null, null);
    }

    public ImFrame(String string, DrawingMode drawingMode, String string2, int n, int n2, int n3, MeasurementHandler measurementHandler, boolean bl) {
        this(string, drawingMode, string2, n, n2, n3, measurementHandler, bl, null, null, null);
    }

    public ImFrame(String string, ImPane imPane) {
        this(string, DrawingMode.UNDEFINED, null, -1, imPane.getWidth(), imPane.getHeight(), new DefaultMeasurementHandler(), false, imPane, null, null);
    }

    public ImFrame(String string, Image image) {
        this(string, DrawingMode.UNDEFINED, string, 0, 0, 0, new DefaultMeasurementHandler(), true, null, null, image);
    }

    public ImFrame(String string, DrawingMode drawingMode, String string2, int n, int n2, int n3, MeasurementHandler measurementHandler, boolean bl, ImPane imPane, ImFrame imFrame, Image image) {
        super(string);
        ImageIcon imageIcon = GRIP.getIcon();
        if (null != imageIcon) {
            this.setIconImage(imageIcon.getImage());
        }
        ++nInstances;
        this.caption = string;
        this.parentFrame = imFrame;
        if (bl) {
            this.menubar = new JMenuBar();
            this.setJMenuBar(this.menubar);
        }
        this.gp = new GlassPane(drawingMode, this.menubar, measurementHandler, this);
        if (null != image) {
            this.setFilePath(string2);
            this.ip = new ImPane(this, null, 0, 0, this.gp, image);
        } else if (null != string2) {
            this.setFilePath(string2);
            this.ip = new ImPane(this, string2, this.gp);
        } else {
            if (0 > n) {
                n = GRIP.getNNewImages() + 1;
            }
            this.setFilePath("New_image_" + n);
            GRIP.incNNewImages();
            this.ip = null == imPane ? new ImPane(this, n2, n3, this.gp) : imPane;
        }
        if (this.ip.getImage() != null) {
            GRIP.getImFramesList().add(this);
            if (bl) {
                this.menubar.add(new ImageMenu(this));
                this.menubar.add(new MeasurementMenu(this));
                this.menubar.add(new GeometryMenu(this));
                this.levelsMenu = new LevelsMenu(this);
                this.menubar.add(this.levelsMenu);
                this.menubar.add(new ConvolutionMenu(this));
                this.menubar.add(new HelpMenu());
            }
            this.sp = new JScrollPane(this.ip, 22, 32);
            Container container = this.getContentPane();
            container.add(this.sp);
            this.setGlassPane(this.gp);
            this.gp.setVisible(true);
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    ImFrame imFrame = (ImFrame)windowEvent.getSource();
                    if (GRIP.GRIP_WAIT_CURSOR != ImFrame.this.getCursor()) {
                        imFrame.dispose();
                        if (null != GRIP.getTable()) {
                            GRIP.getTable().refresh();
                        }
                        System.gc();
                    }
                }
            });
            Dimension dimension = this.getToolkit().getScreenSize();
            BufferedImage bufferedImage = this.ip.getScaledImage();
            int n4 = nInstances * 20 % (int)((double)dimension.width * 0.4);
            int n5 = 120 + nInstances * 20 % (int)((double)dimension.height * 0.4);
            this.setLocation(n4, n5);
            int n6 = bufferedImage.getWidth() + 35;
            int n7 = bufferedImage.getHeight() + 85;
            this.setSize(n6, n7);
            this.setVisible(true);
            if (null != GRIP.getTable()) {
                GRIP.getTable().refresh();
                this.toFront();
            }
        }
    }

    public String getInfo() {
        Image image = this.getImPane().getImage();
        return image.toFoldedString("\n");
    }

    public void showInfo() {
        JTextArea jTextArea = new JTextArea(this.getInfo(), 24, 80);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        Util.message(this, "About this image", jScrollPane);
        JFrame jFrame = new JFrame("About this image");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Edit");
    }

    public TimeInterval getImageTimeSpan() {
        Map<String, String> map;
        Image image = this.getImPane().getImage();
        Metadata metadata = image.getMetadata();
        if (null != metadata && null != (map = metadata.getMap())) {
            Object object;
            String string;
            String string2;
            if (map.containsKey("ImageKind") && (string2 = map.get("ImageKind")).contains("GRIP")) {
                string = metadata.getValue("DateTimeFirst");
                object = metadata.getValue("DateTimeLast");
                String string3 = metadata.getValue("Exposure");
                if (null != string && null != object && null != string3) {
                    int n;
                    int n2 = string3.indexOf("x");
                    if (-1 != n2) {
                        string3 = string3.substring(n2 + 1);
                    }
                    if (-1 != (n = string3.indexOf("s"))) {
                        string3 = string3.substring(0, n);
                    }
                    try {
                        long l = (long)(Double.parseDouble(string3.trim()) * 1000.0);
                        JulianDate julianDate = JulianDate.createJulianDate(string);
                        JulianDate julianDate2 = JulianDate.createJulianDate((String)object);
                        if (null != julianDate && null != julianDate2) {
                            long l2 = julianDate2.toGregorianCalendar().getTimeInMillis();
                            long l3 = julianDate.toGregorianCalendar().getTimeInMillis() - l;
                            return new TimeInterval(l3, l2);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (map.containsKey("ExposureTime") && map.containsKey("DateTimeOriginal")) {
                string2 = map.get("ExposureTime");
                string = map.get("DateTimeOriginal");
                object = JulianDate.createJulianDate(string);
                if (null != object) {
                    try {
                        long l = ((JulianDate)object).toGregorianCalendar().getTimeInMillis();
                        long l4 = l - (long)(Double.parseDouble(string2) * 1000.0);
                        return new TimeInterval(l4, l);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    public void magnifier(int n, int n2) {
        MagnifiedFrame.create(n, n2, this);
    }

    public void analyseAsSpectrum() {
        this.addHistory("Analyse as spectrum");
        this.pushCaption();
        this.setCaption("Draw rectangle enclosing star and spectrum");
        this.gp.setDrawingMode(DrawingMode.ENCLOSE_SPECTRUM);
    }

    public BlobMeasList detectBlobs() {
        return this.detectBlobs(false, false);
    }

    public BlobMeasList detectBlobs(boolean bl) {
        return this.detectBlobs(bl, false);
    }

    public BlobMeasList detectBlobs(boolean bl, boolean bl2) {
        byte[][] byArray = this.gp.getMask().getData();
        BlobMeasList blobMeasList = null;
        if (null == byArray && null != this.threshold()) {
            byArray = this.gp.getMask().getData();
        }
        if (null != byArray) {
            this.setCursor(GRIP.GRIP_WAIT_CURSOR);
            Image image = this.ip.getImage();
            int n = image.getNBands();
            Timer timer = new Timer("Blob.detectBlobs", null);
            BlobMask blobMask = new BlobMask(byArray);
            List<Blob> list = blobMask.detectBlobs(bl);
            if (null != list && list.size() > 0) {
                Iterator iterator;
                blobMeasList = new BlobMeasList(this);
                for (Blob object : list) {
                    iterator = object.measure(image);
                    blobMeasList.insert((BlobMeas)((Object)iterator));
                }
                if (bl2) {
                    Object object2 = new long[n];
                    long[] lArray = new long[n];
                    iterator = blobMeasList.iterator();
                    if (iterator.hasNext()) {
                        int fArray;
                        BlobMeas blobMeas2 = (BlobMeas)iterator.next();
                        for (fArray = 0; fArray < n; ++fArray) {
                            lArray[fArray] = blobMeas2.channelBrightnesses[fArray];
                            object2[fArray] = lArray[fArray];
                        }
                        while (iterator.hasNext()) {
                            blobMeas2 = (BlobMeas)iterator.next();
                            for (fArray = 0; fArray < n; ++fArray) {
                                long f = blobMeas2.channelBrightnesses[fArray];
                                if (f < object2[fArray]) {
                                    object2[fArray] = f;
                                    continue;
                                }
                                if (f <= lArray[fArray]) continue;
                                lArray[fArray] = f;
                            }
                        }
                        float[] fArray2 = new float[n];
                        float f = (float)image.getRangeDouble().high;
                        for (int nArray = 0; nArray < n; ++nArray) {
                            fArray2[nArray] = f / (float)(lArray[nArray] - object2[nArray]);
                        }
                        int[] nArray = new int[n];
                        for (BlobMeas blobMeas2 : blobMeasList) {
                            long[] lArray2 = blobMeas2.channelBrightnesses;
                            for (int i = 0; i < n; ++i) {
                                nArray[i] = (int)((float)(lArray2[i] - object2[i]) * fArray2[i]);
                            }
                            PointFloat i = blobMeas2.centre;
                            int n2 = Math.round(i.x);
                            int n3 = Math.round(i.y);
                            image.setPixel(n2, n3, nArray);
                        }
                        this.gp.clearPoints();
                    }
                }
            }
            this.redisplay();
            this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            timer.stop();
        }
        this.blobMeases = blobMeasList;
        return blobMeasList;
    }

    public BlobMeasList replotBlobs() {
        return this.detectBlobs(true, true);
    }

    public void doOpInBackground(OpThread.Ops ops) {
        new OpThread(ops, this, -1).start();
    }

    public void doOpInBackground(OpThread.Ops ops, int n) {
        new OpThread(ops, this, n).start();
    }

    public void autoCrop() {
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Image image = this.getImPane().getImage();
        image.autoCrop();
        this.redisplay();
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void autoStretch() {
        Image image = this.getImPane().getImage();
        boolean bl = true;
        if (image.getNBands() > 1) {
            bl = Util.confirm(null, "Contrast stretch", "All channels stretched the same?");
        }
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        image.autoStretch(bl);
        this.redisplay();
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void blurGaussian(int n, int n2) {
        this.pushCaption();
        this.setCaption("Blurring");
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Image image = this.getImPane().getImage();
        image.blurGaussian(n, n2, new ProgressMonitor(this, "Gaussian blurring " + n + " x " + n2, "", 0, image.getHeight() + image.getWidth()));
        this.redisplay();
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        this.popCaption();
    }

    public void convertToMonochrome() {
        this.convertToMonochrome(0.65, 1.0, 0.35);
    }

    public void convertToMonochrome(double ... dArray) {
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Image image = this.getImPane().getImage();
        image.convertToMonochrome(dArray);
        this.redisplay();
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void convolve(Kernel kernel) {
        Kernel kernel2 = kernel;
        if (null == kernel2) {
            Util.warning("ERROR", "The kernel is not yet set");
        } else {
            this.pushCaption();
            this.setCaption("Convolving");
            this.setCursor(GRIP.GRIP_WAIT_CURSOR);
            Image image = this.getImPane().getImage();
            image.convolve(kernel2, new ProgressMonitor(this, "Convolving", "", 0, image.getHeight()));
            this.redisplay();
            this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            this.popCaption();
        }
    }

    public void correctBackground(double d, int n) {
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Image image = this.getImPane().getImage();
        image.correctBackground(d, n);
        this.redisplay();
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void correctBackground() {
        double d = 1.0;
        try {
            d = Math.abs(Double.parseDouble(Config.getValue("BackgroundFactor.value")));
        }
        catch (NumberFormatException numberFormatException) {
            d = 1.0;
        }
        int n = 256;
        try {
            n = Integer.parseInt(Config.getValue("BackgroundCellFactor.value"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 256;
        }
        this.correctBackground(d, n);
    }

    public void crop(Point point, Point point2) {
        this.crop(point, point2, true);
    }

    public void crop(Point point, Point point2, boolean bl) {
        Object object;
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Image image = this.ip.getImage();
        if (!BatchProcessor.isBatchCropping() && bl) {
            if (Util.confirm(this, "Cropping", "Confirm cropping rectangle?")) {
                image.crop(point, point2);
                object = this.getBlobMeases();
                if (null != object) {
                    this.setBlobMeases(((BlobMeasList)object).crop(point, point2));
                } else {
                    this.ip.getGlassPane().clearPoints();
                }
            }
        } else {
            image.crop(point, point2);
            this.ip.getGlassPane().clearPoints();
        }
        this.redisplay();
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        if (BatchProcessor.isBatchCropping()) {
            object = this.getFilePath();
            String string = FileIO.removeExtension((String)object) + "_crop" + FileIO.getExtension((String)object);
            this.ip.getImage().save(string);
            this.dispose();
            new BatchProcessor().cropOthers(point, point2);
        }
    }

    public void deconvolve(Kernel kernel, int n, double d) {
        if (null == kernel) {
            Util.warning("ERROR", "The kernel is not yet set");
        } else {
            this.setCursor(GRIP.GRIP_WAIT_CURSOR);
            this.pushCaption();
            this.setCaption("Deconvolving");
            Image image = this.getImPane().getImage();
            image.deconvolve(kernel, n, d, new ProgressMonitor(this, "Deconvolving", "", 0, n * image.getHeight()));
            this.redisplay();
            System.gc();
            this.popCaption();
            this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        }
    }

    public void divideByFlatField(ImFrame imFrame) {
        Image image = this.getImPane().getImage();
        Image image2 = imFrame.getImPane().getImage();
        image.divideByFlatField(image2);
        this.redisplay();
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void drawOverlay(boolean bl) {
        this.addHistory("Draw overlay into image");
        int n = 1;
        ImPane imPane = this.getImPane();
        Image image = imPane.getImage();
        int n2 = image.getWidth();
        int n3 = image.getHeight();
        int n4 = image.getNBands();
        if (n4 > 1 && Util.confirm(this, "Monochrome?", "Create monochrome image?\n(Otherwise will have " + n4 + " bands)")) {
            n4 = 1;
        }
        Image8 image8 = new Image8(n2, n3, n4, false, false);
        this.getGP().drawComponent(image8.getBufferedImage().getGraphics(), n, new Point(0, this.getJMenuBar().getHeight()));
        if (bl) {
            ImFrame imFrame = new ImFrame("Mask (" + n4 + "-channel)", n2, n3, true, this);
            imFrame.getImPane().setImage(image8);
            imFrame.redisplay();
        } else {
            imPane.setImage(image8);
            this.redisplay();
        }
    }

    public void equaliseHistogram() {
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Image image = this.getImPane().getImage();
        HistogramAll histogramAll = new HistogramAll(image);
        histogramAll.equalise(image);
        this.redisplay();
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void fit(int n, int n2) {
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Image image = this.getImPane().getImage();
        image.fit(n, n2);
        this.redisplay();
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void flipHorizontal() {
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Image image = this.getImPane().getImage();
        image.flipHorizontal();
        this.redisplay();
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void flipVertical() {
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Image image = this.getImPane().getImage();
        image.flipVertical();
        this.redisplay();
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void gnomonicProjection() {
        int n = 0;
        Metadata metadata = this.getImPane().getImage().getMetadata();
        if (null != metadata) {
            n = metadata.getFocalLength();
        }
        if (0 == n) {
            n = Util.askInteger("Lens focal length (mm) [5..1000]", 100, 5, 1000);
        }
        if (0 < n) {
            this.setCursor(GRIP.GRIP_WAIT_CURSOR);
            double d = Double.parseDouble(Config.getValue("Detector.width.mm.value"));
            double d2 = Double.parseDouble(Config.getValue("Detector.height.mm.value"));
            Image image = this.ip.getImage();
            Image image2 = image.gnomonicProjection(n, d, d2);
            if (null != image2) {
                this.ip.setImage(image2);
                this.redisplay();
            }
            this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        }
    }

    public void inverseGnomonicProjection() {
        int n = 0;
        Metadata metadata = this.getImPane().getImage().getMetadata();
        if (null != metadata) {
            n = metadata.getFocalLength();
        }
        if (0 == n) {
            n = Util.askInteger("Lens focal length (mm) [5..1000]", 100, 5, 1000);
        }
        if (0 < n) {
            this.setCursor(GRIP.GRIP_WAIT_CURSOR);
            double d = Double.parseDouble(Config.getValue("Detector.width.mm.value"));
            double d2 = Double.parseDouble(Config.getValue("Detector.height.mm.value"));
            Image image = this.ip.getImage();
            Image image2 = image.inverseGnomonicProjection(n, d, d2);
            if (null != image2) {
                this.ip.setImage(image2);
                this.redisplay();
            }
            this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        }
    }

    public void invert() {
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Image image = this.getImPane().getImage();
        image.invert();
        this.redisplay();
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void meanFilter() {
        int n = Util.askInteger("Half-width [1..9]?", 3, 1, 9);
        if (Integer.MIN_VALUE != n) {
            this.setCursor(GRIP.GRIP_WAIT_CURSOR);
            Image image = this.getImPane().getImage();
            image.meanFilter(n, new ProgressMonitor(this, "Mean filter", "", 0, image.getHeight()));
            this.redisplay();
            this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            int n2 = 2 * n + 1;
            this.addHistory("meanFilter [" + n2 + "x" + n2 + "]");
        }
    }

    public void medianFilter() {
        int n = Util.askInteger("Half-width [1..9]?", 3, 1, 9);
        if (Integer.MIN_VALUE != n) {
            this.setCursor(GRIP.GRIP_WAIT_CURSOR);
            Image image = this.getImPane().getImage();
            image.medianFilter(n, new ProgressMonitor(this, "Median filter", "", 0, image.getHeight()));
            this.redisplay();
            this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            int n2 = 2 * n + 1;
            this.addHistory("medianFilter [" + n2 + "x" + n2 + "]");
        }
    }

    public void multiply(double d) {
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        this.getImPane().getImage().multiply(d);
        this.redisplay();
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void multiply(ImFrame imFrame) {
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Image image = this.getImPane().getImage();
        Image image2 = imFrame.getImPane().getImage();
        image.multiply(image2);
        this.redisplay();
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void nearestExtremeFilter() {
        int n = Util.askInteger("Half-width? [1..19]", 3, 1, 19);
        if (Integer.MIN_VALUE != n) {
            this.setCursor(GRIP.GRIP_WAIT_CURSOR);
            Image image = this.getImPane().getImage();
            image.nearestExtremeFilter(n, new ProgressMonitor(this, "Nearest extreme filter", "", 0, image.getHeight()));
            this.redisplay();
            this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            int n2 = 2 * n + 1;
            this.addHistory("nearestExtremeFilter [" + n2 + "x" + n2 + "]");
        }
    }

    public void neutraliseBackground() {
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Image image = this.getImPane().getImage();
        image.neutraliseBackground();
        this.redisplay();
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void rankFilter() {
        int n = Util.askInteger("Half-width? [1..19]", 3, 1, 19);
        if (Integer.MIN_VALUE != n) {
            this.setCursor(GRIP.GRIP_WAIT_CURSOR);
            Image image = this.getImPane().getImage();
            image.rankFilter(n, new ProgressMonitor(this, "Rank filter", "", 0, image.getHeight()));
            this.redisplay();
            this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            int n2 = 2 * n + 1;
            this.addHistory("rankFilter [" + n2 + "x" + n2 + "]");
        }
    }

    public void rotate() {
        double d = Util.askDouble("Angle to rotate anti-clockwise (degrees) [-360..360]?", 0.0, -360.0, 360.0);
        if (-360.0 <= d && d <= 360.0) {
            this.rotate(d);
        }
    }

    public void rotate(double d) {
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Image image = this.ip.getImage();
        image.rotate(d);
        this.redisplay();
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void scale() {
        double d = Util.askDouble("Factor to scale by [0.05..20]?", 1.0, 0.05, 20.0);
        if (0.05 <= d && d <= 20.0) {
            boolean bl = Util.confirm("Scale image", "Interpolating pixels, for smooth result?");
            this.scale(d, bl);
        }
    }

    public void scale(double d, boolean bl) {
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Image image = this.ip.getImage();
        image.scale(d, bl);
        this.redisplay();
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public ImFrame[] splitChannels() {
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Image image = this.getImPane().getImage();
        String string = new File(this.getFilePath()).getName();
        Image[] imageArray = image.splitChannels();
        int n = imageArray.length;
        ImFrame[] imFrameArray = new ImFrame[n];
        if (3 == n) {
            imFrameArray[0] = new ImFrame(string + "_Red", imageArray[0]);
            imFrameArray[1] = new ImFrame(string + "_Green", imageArray[1]);
            imFrameArray[2] = new ImFrame(string + "_Blue", imageArray[2]);
        } else {
            for (int i = 0; i < n; ++i) {
                imFrameArray[i] = new ImFrame(string + "_Channel_" + i, imageArray[i]);
            }
        }
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        return imFrameArray;
    }

    public ImFrame[] splitIntensity() {
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Image image = this.getImPane().getImage();
        Image[] imageArray = image.splitIntensity();
        if (null == imageArray || 2 != imageArray.length) {
            return null;
        }
        int n = image.getWidth();
        int n2 = image.getHeight();
        String string = new File(this.getFilePath()).getName();
        ImFrame imFrame = new ImFrame(string + " [Intensity]", DrawingMode.UNDEFINED, null, -1, n, n2, new DefaultMeasurementHandler(), true);
        imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
        imFrame.getImPane().setImage(imageArray[0]);
        imFrame.redisplay();
        imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        ImFrame imFrame2 = new ImFrame(string + " [Colours]", DrawingMode.UNDEFINED, null, -1, n, n2, new DefaultMeasurementHandler(), true);
        imFrame2.setCursor(GRIP.GRIP_WAIT_CURSOR);
        imFrame2.getImPane().setImage(imageArray[1]);
        imFrame2.redisplay();
        imFrame2.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        ImFrame[] imFrameArray = new ImFrame[]{imFrame, imFrame2};
        return imFrameArray;
    }

    public void stereo(ImFrame imFrame) {
        Image image = this.getImPane().getImage();
        Image image2 = imFrame.getImPane().getImage();
        if (!ImageBase.sameSizeBitsAndBands(image, image2)) {
            Util.warning("Sorry", "Both images must be the same size\nand bit-depth for stereo");
            return;
        }
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        if (image.getNBands() > 1) {
            image.convertToMonochrome();
        }
        if (image2.getNBands() > 1) {
            image2.convertToMonochrome();
        }
        Image image3 = ImageBase.createImage(image.getWidth(), image.getHeight(), 1, image.getBitsPerChannel(), true, false);
        this.getImPane().setImage(ImageBase.recombine(image, image2, image3));
        this.redisplay();
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void sub(ImFrame imFrame) {
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        try {
            Image image = this.getImPane().getImage();
            Image image2 = imFrame.getImPane().getImage();
            image.subtract(image2);
            this.redisplay();
        }
        catch (IncompatibleImageException incompatibleImageException) {
            Util.warning("Sorry", incompatibleImageException.getMessage());
        }
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void subToZero(ImFrame imFrame) {
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        try {
            Image image = this.getImPane().getImage();
            Image image2 = imFrame.getImPane().getImage();
            image.subtractToZero(image2);
            this.redisplay();
        }
        catch (IncompatibleImageException incompatibleImageException) {
            Util.warning("Sorry", incompatibleImageException.getMessage());
        }
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public Threshold threshold() {
        Image image = this.getImPane().getImage();
        int n = image.getNBands();
        switch (n) {
            case 1: {
                Threshold threshold = ImThreshDialogue.askThreshold(this);
                if (null != threshold) {
                    this.threshold(threshold);
                }
                return threshold;
            }
            case 3: {
                Threshold threshold = ImThreshRGBDialogue.askThreshold(this);
                if (null != threshold) {
                    this.threshold(threshold);
                }
                return threshold;
            }
        }
        Util.message("Sorry", "Only 1-channel (monochrome) or\n3-channel (RGB) images can be\nthresholded interactively.");
        return null;
    }

    public void threshold(Threshold threshold) {
        this.setCursor(GRIP.GRIP_WAIT_CURSOR);
        Image image = this.ip.getImage();
        byte[][] byArray = image.threshold(threshold).getData();
        if (null != byArray) {
            this.gp.setMask(new BlobMask(byArray));
            this.gp.setDrawingMode(DrawingMode.MASK);
            this.ip.repaint();
            this.gp.repaint();
        }
        this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
    }

    public void translate() {
        int n;
        Image image = this.getImPane().getImage();
        int n2 = image.getWidth();
        int n3 = image.getHeight();
        int n4 = Util.askInteger("X displacement [-" + n2 + ".." + n2 + "]?", 0, -n2, n2);
        if (Integer.MIN_VALUE != n4 && Integer.MIN_VALUE != (n = Util.askInteger("Y displacement [-" + n3 + ".." + n3 + "]?", 0, -n3, n3))) {
            this.setCursor(GRIP.GRIP_WAIT_CURSOR);
            image.translate(n4, n);
            this.redisplay();
            this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        }
    }

    public void varianceFilter() {
        int n = Util.askInteger("Half-width? [1..19]", 3, 1, 19);
        if (Integer.MIN_VALUE != n) {
            this.setCursor(GRIP.GRIP_WAIT_CURSOR);
            Image image = this.getImPane().getImage();
            image.varianceFilter(n, new ProgressMonitor(this, "Variance filter", "", 0, image.getHeight()));
            this.redisplay();
            this.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            int n2 = 2 * n + 1;
            this.addHistory("varianceFilter [" + n2 + "x" + n2 + "]");
        }
    }
}

