/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.grelf.Util;
import net.grelf.grip.GRIP;
import net.grelf.grip.HelpMenu;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImTable;
import net.grelf.image.Image;
import net.grelf.image.Image16;
import net.grelf.image.Image32;
import net.grelf.image.Image64;
import net.grelf.image.Image8;

public class ImTableMenu
implements ActionListener,
MenuListener,
ListSelectionListener {
    private JFrame frame;
    private ImTable table;
    private JMenuBar menubar;
    private JMenuItem itemSaveCSV;
    private JMenuItem itemSaveXML;
    private JMenuItem itemCloseSel;
    private JMenuItem itemSelect;
    private JMenuItem itemDeselect;
    private JMenuItem itemFront;
    private JMenuItem itemRefresh;
    private JMenuItem itemSwap;
    private JMenuItem itemAdd;
    private JMenuItem itemAddP;
    private JMenuItem itemAve;
    private JMenuItem itemDiv;
    private JMenuItem itemRevSub;
    private JMenuItem itemSub;
    private JMenuItem itemSubZero;
    private JMenuItem itemMpy;
    private JMenuItem itemMpyP;
    private JMenuItem itemReapply;
    private JMenuItem itemRecombBands;
    private JMenuItem itemStereo;
    private JMenuItem itemRGB;
    private static final String CRITERION_2 = "Must be 2 selected, both same bit depth";
    private static final String CRITERION_28 = "Must be 2 selected, both 8 bits per channel";
    private static final String CRITERION_2MORE = "Must be 2 or more selected, all same bit depth";
    private static final String CRITERION_2I = "Must be 2 selected, both same bit depth, 1 mono & other multi-band";
    private static final String CRITERION_3 = "Must be 3 selected, all same bit depth";
    private static final String CRITERION_3MONO = "Must be 3 selected, all monochrome";

    public JMenuBar getMenuBar() {
        return this.menubar;
    }

    public ImTableMenu(JFrame jFrame, ImTable imTable) {
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        this.itemSaveCSV = Util.menuItem(this, "Save table as CSV", "savecsv", 83, 0);
        jMenu.add(this.itemSaveCSV);
        this.itemSaveXML = Util.menuItem(this, "Save table as XML", "savexml", 88, 83);
        jMenu.add(this.itemSaveXML);
        jMenu.addSeparator();
        this.itemFront = Util.menuItem(this, "Show selected in front", "front", 70, 116);
        jMenu.add(this.itemFront);
        this.itemCloseSel = Util.menuItem(this, "Close selected images", "closeSel", 67, 0);
        jMenu.add(this.itemCloseSel);
        jMenu.addSeparator();
        jMenu.add(Util.menuItem(this, "Find GRIP window", "grip", 71, 71));
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic('E');
        this.itemSelect = Util.menuItem(this, "Select all", "select", 83, 65);
        jMenu2.add(this.itemSelect);
        this.itemDeselect = Util.menuItem(this, "Deselect all", "deselect", 68, 68);
        jMenu2.add(this.itemDeselect);
        jMenu2.addSeparator();
        this.itemSwap = Util.menuItem(this, "Swap 2 selected images", "swap", 87, 0);
        jMenu2.add(this.itemSwap);
        jMenu2.addSeparator();
        this.itemRefresh = Util.menuItem(this, "Refresh the table", "refresh", 82, 116);
        jMenu2.add(this.itemRefresh);
        JMenu jMenu3 = new JMenu("Combine");
        jMenu3.setMnemonic('C');
        this.itemAdd = Util.menuItem(this, "Add selected images", "add", 65, 0);
        jMenu3.add(this.itemAdd);
        this.itemAdd.setToolTipText(CRITERION_2MORE);
        this.itemAddP = Util.menuItem(this, "Add proportions of selected images", "addP", 80, 0);
        jMenu3.add(this.itemAddP);
        this.itemAddP.setToolTipText(CRITERION_2);
        this.itemAve = Util.menuItem(this, "Average selected images", "ave", 86, 0);
        jMenu3.add(this.itemAve);
        this.itemAve.setToolTipText(CRITERION_2MORE);
        this.itemSub = Util.menuItem(this, "Subtract selected images (to grey)", "sub", 83, 0);
        jMenu3.add(this.itemSub);
        this.itemSub.setToolTipText(CRITERION_2);
        this.itemSubZero = Util.menuItem(this, "Subtract selected images (to zero)", "subzero", 90, 0);
        jMenu3.add(this.itemSubZero);
        this.itemSubZero.setToolTipText(CRITERION_2);
        this.itemRevSub = Util.menuItem(this, "Reverse subtract selected images (to grey)", "revsub", 82, 0);
        jMenu3.add(this.itemRevSub);
        this.itemRevSub.setToolTipText(CRITERION_2);
        this.itemMpy = Util.menuItem(this, "Multiply selected images", "mpy", 77, 0);
        jMenu3.add(this.itemMpy);
        this.itemMpy.setToolTipText(CRITERION_2);
        this.itemMpyP = Util.menuItem(this, "Multiply proportions of selected images", "mpyP", 79, 0);
        jMenu3.add(this.itemMpyP);
        this.itemMpyP.setToolTipText(CRITERION_2);
        this.itemDiv = Util.menuItem(this, "Divide 1st image by 2nd (flat field)", "div", 68, 0);
        jMenu3.add(this.itemDiv);
        this.itemDiv.setToolTipText(CRITERION_2);
        this.itemReapply = Util.menuItem(this, "Reapply colour", "reapply", 89, 0);
        jMenu3.add(this.itemReapply);
        this.itemReapply.setToolTipText(CRITERION_2I);
        this.itemRecombBands = Util.menuItem(this, "Recombine channels", "recomb", 67, 0);
        jMenu3.add(this.itemRecombBands);
        this.itemRecombBands.setToolTipText(CRITERION_3);
        this.itemRGB = Util.menuItem(this, "Build 1 RGB image", "rgb", 49, 0);
        jMenu3.add(this.itemRGB);
        this.itemRGB.setToolTipText(CRITERION_3MONO);
        this.itemStereo = Util.menuItem(this, "Show as red-green stereo", "stereo", 84, 0);
        jMenu3.add(this.itemStereo);
        this.itemStereo.setToolTipText(CRITERION_28);
        jMenu3.addSeparator();
        jMenu3.add(Util.menuItem(this, "Help about this menu", "help", 72, 0));
        this.menubar = new JMenuBar();
        this.menubar.add(jMenu);
        this.menubar.add(jMenu2);
        this.menubar.add(jMenu3);
        this.menubar.add(new HelpMenu());
        this.frame = jFrame;
        this.table = imTable;
        this.table.getJTable().getSelectionModel().addListSelectionListener(this);
        this.enableItems();
        this.frame.setJMenuBar(this.menubar);
    }

    protected void enableItems() {
        this.itemSaveCSV.setEnabled(true);
        this.itemSaveXML.setEnabled(true);
        this.itemCloseSel.setEnabled(true);
        this.itemSelect.setEnabled(true);
        this.itemDeselect.setEnabled(true);
        this.itemFront.setEnabled(false);
        this.itemSwap.setEnabled(false);
        this.itemRefresh.setEnabled(true);
        this.itemAdd.setEnabled(false);
        this.itemAddP.setEnabled(false);
        this.itemAve.setEnabled(false);
        this.itemDiv.setEnabled(false);
        this.itemRevSub.setEnabled(false);
        this.itemSub.setEnabled(false);
        this.itemSubZero.setEnabled(false);
        this.itemMpy.setEnabled(false);
        this.itemMpyP.setEnabled(false);
        this.itemReapply.setEnabled(false);
        this.itemRGB.setEnabled(false);
        this.itemRecombBands.setEnabled(false);
        this.itemStereo.setEnabled(false);
        int n = this.table.getNSelected();
        switch (n) {
            case 0: {
                this.itemCloseSel.setEnabled(false);
                this.itemDeselect.setEnabled(false);
                break;
            }
            case 1: {
                this.itemFront.setEnabled(true);
                break;
            }
            case 2: {
                if (!this.areSelectedAllSameBitDepth()) break;
                this.itemAdd.setEnabled(true);
                this.itemAddP.setEnabled(true);
                this.itemAve.setEnabled(true);
                this.itemDiv.setEnabled(true);
                this.itemRevSub.setEnabled(true);
                this.itemSub.setEnabled(true);
                this.itemSubZero.setEnabled(true);
                this.itemMpy.setEnabled(true);
                this.itemMpyP.setEnabled(true);
                this.itemStereo.setEnabled(true);
                this.itemSwap.setEnabled(true);
                List<ImFrame> list = this.table.getSelected();
                Image image = list.get(0).getImPane().getImage();
                Image image2 = list.get(1).getImPane().getImage();
                int n2 = image.getNBands();
                int n3 = image2.getNBands();
                if ((1 != n2 || 1 >= n3) && (1 >= n2 || 1 != n3)) break;
                this.itemReapply.setEnabled(true);
                break;
            }
            case 3: {
                if (!this.areSelectedAllSameBitDepth()) break;
                this.itemAdd.setEnabled(true);
                this.itemAve.setEnabled(true);
                this.itemRecombBands.setEnabled(true);
                boolean bl = true;
                for (ImFrame imFrame : this.table.getSelected()) {
                    if (imFrame.getImPane().getImage().getNBands() == 1) continue;
                    bl = false;
                }
                this.itemRGB.setEnabled(bl);
                break;
            }
            default: {
                if (!this.areSelectedAllSameBitDepth()) break;
                this.itemAdd.setEnabled(true);
                this.itemAve.setEnabled(true);
            }
        }
    }

    private boolean areSelectedAllSameBitDepth() {
        List<ImFrame> list = this.table.getSelected();
        int n = list.get(0).getImPane().getImage().getBitsPerChannel();
        for (int i = 1; i < list.size(); ++i) {
            if (n == list.get(i).getImPane().getImage().getBitsPerChannel()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.enableItems();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("add")) {
            if (2 > this.table.getNSelected()) {
                Util.warning(this.frame, "Not possible", (Object)"You must select at least 2 images, to add them");
            } else {
                this.table.combine("add");
            }
        } else if (string.equals("addP")) {
            if (2 != this.table.getNSelected()) {
                Util.warning(this.frame, "Not possible", (Object)"You must select 2 images, to add them proportionately");
            } else {
                this.table.combine("addP");
            }
        } else if (string.equals("ave")) {
            if (2 > this.table.getNSelected()) {
                Util.warning(this.frame, "Not possible", (Object)"You must select at least 2 images, to average them");
            } else {
                this.table.combine("ave");
            }
        } else if (string.equals("closeSel")) {
            List<ImFrame> list = this.table.getSelected();
            for (int i = list.size() - 1; i >= 0; --i) {
                ImFrame imFrame = list.get(i);
                imFrame.setVisible(false);
                imFrame.dispose();
            }
            this.table.refresh();
        } else if (string.equals("deselect")) {
            this.table.getJTable().getSelectionModel().clearSelection();
        } else if (string.equals("div")) {
            if (2 != this.table.getNSelected()) {
                Util.warning(this.frame, "Not possible", (Object)"You must select exactly 2 images, to divide them with the 2nd being a flat field");
            } else {
                this.table.combine("div");
            }
        } else if (string.equals("front")) {
            List<ImFrame> list = this.table.getSelected();
            if (1 == list.size()) {
                ImFrame imFrame = list.get(0);
                imFrame.toFront();
            }
        } else if (string.equals("grip")) {
            GRIP.getInstance().toFront();
        } else if (string.equals("help")) {
            HelpMenu.help("pages/combine_menu.html");
        } else if (string.equals("mpy")) {
            if (2 > this.table.getNSelected()) {
                Util.warning(this.frame, "Not possible", (Object)"You must select exactly 2 images, to multiply them");
            } else {
                this.table.combine("mpy");
            }
        } else if (string.equals("mpyP")) {
            if (2 != this.table.getNSelected()) {
                Util.warning(this.frame, "Not possible", (Object)"You must select 2 images, to multiply them proportionately");
            } else {
                this.table.combine("mpyP");
            }
        } else if (string.equals("reapply")) {
            this.table.reapplyColour();
        } else if (string.equals("recomb")) {
            if (3 != this.table.getNSelected()) {
                Util.warning(this.frame, "Not possible", (Object)"You must select exactly 3 images, to recombine channels from them");
            } else {
                this.table.recombine();
            }
        } else if (string.equals("refresh")) {
            this.table.refresh();
            this.table.getJTable().getSelectionModel().addListSelectionListener(this);
            this.enableItems();
        } else if (string.equals("revsub")) {
            if (2 != this.table.getNSelected()) {
                Util.warning(this.frame, "Not possible", (Object)"You must select exactly 2 images, to subtract them");
            } else {
                this.table.combine("revsub");
            }
        } else if (string.equals("rgb")) {
            if (3 == this.table.getNSelected()) {
                List<ImFrame> list = this.table.getSelected();
                int n = list.get(0).getImPane().getImage().getBitsPerChannel();
                int n2 = list.get(1).getImPane().getImage().getBitsPerChannel();
                int n3 = list.get(2).getImPane().getImage().getBitsPerChannel();
                if (n != n2 || n != n3) {
                    Util.message("Sorry", "All 3 selected images must have the same number of bits per channel");
                } else if (n == 64) {
                    Image[] imageArray = new Image[3];
                    int[] nArray = new int[3];
                    int[] nArray2 = new int[3];
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    for (ImFrame object : list) {
                        imageArray[n4] = object.getImPane().getImage();
                        nArray[n4] = imageArray[n4].getWidth();
                        nArray2[n4] = imageArray[n4].getHeight();
                        n5 = Math.max(n5, nArray[n4]);
                        n6 = Math.max(n6, nArray2[n4]);
                        ++n4;
                    }
                    Image64 image64 = new Image64(n5, n6, 3);
                    if (null != image64) {
                        double[] object2 = new double[3];
                        for (int j = 0; j < n6; ++j) {
                            for (int i = 0; i < n5; ++i) {
                                for (int k = 0; k < 3; ++k) {
                                    double d;
                                    object2[k] = i < nArray[k] && j < nArray2[k] ? (d = imageArray[k].getPixelDouble(i, j)[0]) : 0.0;
                                }
                                image64.setPixelDouble(i, j, object2);
                            }
                        }
                        image64.getRangeByRescanningDouble();
                        ImFrame imFrame = new ImFrame("RGB", image64);
                        imFrame.redisplay();
                    }
                } else {
                    Image[] imageArray = new Image[3];
                    int[] nArray = new int[3];
                    int[] nArray3 = new int[3];
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = 0;
                    for (ImFrame imFrame : list) {
                        imageArray[n7] = imFrame.getImPane().getImage();
                        nArray[n7] = imageArray[n7].getWidth();
                        nArray3[n7] = imageArray[n7].getHeight();
                        n8 = Math.max(n8, nArray[n7]);
                        n9 = Math.max(n9, nArray3[n7]);
                        ++n7;
                    }
                    Object object = null;
                    object = n == 8 ? new Image8(n8, n9, 3) : (n == 16 ? new Image16(n8, n9, 3) : new Image32(n8, n9, 3));
                    if (null != object) {
                        int[] nArray2 = new int[3];
                        for (int i = 0; i < n9; ++i) {
                            for (int j = 0; j < n8; ++j) {
                                for (int k = 0; k < 3; ++k) {
                                    int n4;
                                    nArray2[k] = j < nArray[k] && i < nArray3[k] ? (n4 = imageArray[k].getPixel(j, i)[0]) : 0;
                                }
                                object.setPixel(j, i, nArray2);
                            }
                        }
                        object.getRangeByRescanning();
                        ImFrame imFrame = new ImFrame("RGB", (Image)object);
                        imFrame.redisplay();
                    }
                }
            }
        } else if (string.equals("savecsv")) {
            this.table.saveAsCSV();
        } else if (string.equals("savexml")) {
            this.table.saveAsXML();
        } else if (string.equals("select")) {
            this.table.getJTable().getSelectionModel().setSelectionInterval(0, this.table.getJTable().getModel().getRowCount() - 1);
        } else if (string.equals("stereo")) {
            if (2 != this.table.getNSelected()) {
                Util.warning(this.frame, "Not possible", (Object)"You must select exactly 2 images, to show them in stereo");
            } else {
                this.table.combine("stereo");
            }
        } else if (string.equals("sub")) {
            if (2 != this.table.getNSelected()) {
                Util.warning(this.frame, "Not possible", (Object)"You must select exactly 2 images, to subtract them");
            } else {
                this.table.combine("sub");
            }
        } else if (string.equals("subzero")) {
            if (2 != this.table.getNSelected()) {
                Util.warning(this.frame, "Not possible", (Object)"You must select exactly 2 images, to subtract them");
            } else {
                this.table.combine("subzero");
            }
        } else if (string.equals("swap")) {
            if (2 != this.table.getNSelected()) {
                Util.warning(this.frame, "Not possible", (Object)"You must select exactly 2 images, to swap them");
            } else {
                this.table.swap();
            }
        }
        this.table.refresh();
        this.enableItems();
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        this.enableItems();
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }
}

