/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import net.grelf.FileIO;
import net.grelf.FileIOChartFilter;
import net.grelf.Util;
import net.grelf.grip.GRIP;
import net.grelf.grip.HelpMenu;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImGraphic;
import net.grelf.grip.ImPane;
import net.grelf.grip.Pseudocolour;
import net.grelf.grip.StarChartFrame;
import net.grelf.image.Image;
import net.grelf.image.Image16;
import net.grelf.image.Image8;
import net.grelf.image.Image8or16Base;
import net.grelf.image.ImageLoader;
import net.grelf.image.IncompatibleImageException;

public class ImageMenu
extends JMenu
implements ActionListener,
MenuListener {
    private ImFrame imframe;
    private JMenuItem itemPseudo;
    private JMenuItem itemBlobs;
    private JMenuItem itemChart;
    private JMenuItem itemUndo;

    public ImageMenu(ImFrame imFrame) {
        super("Image");
        this.imframe = imFrame;
        this.setMnemonic('I');
        this.add(Util.menuItem(this, "Zoom in", "zoomin", 61, 61));
        this.add(Util.menuItem(this, "Zoom out", "zoomout", 45, 45));
        this.add(Util.menuItem(this, "Fit to screen", "zoomfit", 70, 48));
        this.itemPseudo = Util.menuItem(this, "Display in pseudocolour", "pseudo", 80, 0);
        this.add(this.itemPseudo);
        this.itemPseudo.setToolTipText("Affects display only, not the image");
        this.addSeparator();
        this.add(Util.menuItem(this, "Save as", "saveas", 83, 83));
        this.itemBlobs = Util.menuItem(this, "Save with blob/star data", "saveblobs", 66, 0);
        this.add(this.itemBlobs);
        this.itemBlobs.setToolTipText("Saves 2 files: image and .blobs (XML)");
        this.itemChart = Util.menuItem(this, "Save as star chart", "savechart", 86, 0);
        this.add(this.itemChart);
        this.itemChart.setToolTipText("Saves XML; window caption is chart title");
        this.addSeparator();
        this.itemUndo = Util.menuItem(this, "Undo (not)", "undo", 85, 90);
        this.add(this.itemUndo);
        this.itemUndo.setToolTipText("Select for an explanation of why there is no Undo");
        this.add(Util.menuItem(this, "Clone, in new window", "clone", 67, 0));
        this.add(Util.menuItem(this, "Reload this window from file", "reload", 82, 0));
        this.addSeparator();
        this.add(Util.menuItem(this, "Show image information", "info", 73, 0));
        this.add(Util.menuItem(this, "View history of this window", "history", 72, 0));
        this.add(Util.menuItem(this, "Edit window caption", "caption", 69, 0));
        this.add(Util.menuItem(this, "Add 1-pixel white rim", "rim", 49, 0));
        this.addSeparator();
        this.add(Util.menuItem(this, "Find GRIP window", "grip", 71, 71));
        this.add(Util.menuItem(this, "Close this window", "close", 87, 87));
        this.addSeparator();
        this.add(Util.menuItem(this, "Help about this menu", "help", 0, 0));
        this.addMenuListener(this);
    }

    private void reviseSettings() {
        ImFrame imFrame = this.imframe;
        this.itemBlobs.setEnabled(null != imFrame.getBlobMeases());
        if (imFrame instanceof StarChartFrame) {
            this.itemChart.setEnabled(null != ((StarChartFrame)imFrame).getStarChart());
        } else {
            this.itemChart.setEnabled(false);
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        this.reviseSettings();
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("caption")) {
            String string2 = Util.askString("Image window caption", this.imframe.getCaption());
            if (null != string2) {
                this.imframe.setCaption(string2);
            }
        } else if (string.equals("clone")) {
            this.imframe.duplicate();
        } else if (string.equals("close")) {
            this.imframe.setVisible(false);
            this.imframe.dispose();
        } else if (string.equals("experiment")) {
            this.experiment();
        } else if (string.equals("grip")) {
            GRIP.getInstance().toFront();
        } else if (string.equals("help")) {
            HelpMenu.help("pages/image_menu.html");
        } else if (string.equals("history")) {
            this.imframe.showHistory();
        } else if (string.equals("info")) {
            this.imframe.getImPane().getImage().showInfo();
        } else if (string.equals("pseudo")) {
            ImPane imPane = this.imframe.getImPane();
            if (imPane.isPseudocolour()) {
                imPane.setPseudocolour(null);
                this.itemPseudo.setText("Display in pseudocolour");
            } else {
                try {
                    BufferedImage bufferedImage = imPane.getScaledImage();
                    int n = Image8or16Base.getBitsPerChannel(bufferedImage);
                    if (8 == n) {
                        imPane.setPseudocolour(new Pseudocolour(new Image8(bufferedImage)));
                    } else {
                        imPane.setPseudocolour(new Pseudocolour(new Image16(bufferedImage)));
                    }
                }
                catch (IncompatibleImageException incompatibleImageException) {
                    Util.warning("Error", incompatibleImageException.getMessage());
                }
                this.itemPseudo.setText("Display without pseudocolour");
            }
            this.imframe.redisplay();
        } else if (string.equals("reload")) {
            String string3 = this.imframe.getFilePath();
            if (null == string3) {
                Util.message("Sorry", "This image does not have an associated file");
            } else {
                this.imframe.setCursor(GRIP.GRIP_WAIT_CURSOR);
                this.imframe.addHistory("Reload");
                Image image = ImageLoader.load(string3);
                if (null == image) {
                    Util.message("Sorry", "Could not reload image from " + string3);
                } else {
                    this.imframe.getImPane().setImage(image);
                    this.imframe.redisplay();
                }
                this.imframe.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            }
        } else if (string.equals("rim")) {
            this.imframe.addHistory("1-pixel white rim");
            new ImGraphic().drawRim(this.imframe, 1, Color.white);
        } else if (string.equals("saveas")) {
            this.imframe.saveAs();
        } else if (string.equals("saveblobs")) {
            this.imframe.saveAs();
            this.imframe.saveBlobMeasList();
        } else if (string.equals("savechart")) {
            String string4;
            if (this.imframe instanceof StarChartFrame && null != (string4 = FileIO.selectOutputFile("Star chart", null, new FileFilter[]{new FileIOChartFilter(1)}, FileIO.removeExtension(this.imframe.getCaption()) + ".chart"))) {
                ((StarChartFrame)this.imframe).getStarChart().saveAsXML(string4, this.imframe.getCaption());
            }
        } else if (string.equals("undo")) {
            StringBuffer stringBuffer = new StringBuffer("There is no Undo.\n");
            stringBuffer.append("The reason for this is that we do not want to waste\n");
            stringBuffer.append("processing time on making copies of images when\n");
            stringBuffer.append("they may never be needed.\n");
            stringBuffer.append("Instead we put the onus on you, the user. If you\n");
            stringBuffer.append("think the next step you are about take may need\n");
            stringBuffer.append("to be reversed, you have two options available:\n");
            stringBuffer.append("(1) save the image on disc, so that Image/Reload\n");
            stringBuffer.append("can bring it back quickly, or\n");
            stringBuffer.append("(2) use Image/Clone to make a visible copy of the\n");
            stringBuffer.append("image in a new window.\n");
            stringBuffer.append("This is explained in the Help documentation,\n");
            stringBuffer.append("along with much else.");
            Util.message(this.imframe, "Sorry", stringBuffer.toString());
        } else if (string.equals("zoomfit")) {
            this.imframe.setCursor(GRIP.GRIP_WAIT_CURSOR);
            this.imframe.getImPane().setInitialScale();
            this.imframe.redisplay();
            this.imframe.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        } else if (string.equals("zoomin")) {
            this.imframe.setCursor(GRIP.GRIP_WAIT_CURSOR);
            this.imframe.getImPane().zoomUp();
            this.imframe.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        } else if (string.equals("zoomout")) {
            this.imframe.setCursor(GRIP.GRIP_WAIT_CURSOR);
            this.imframe.getImPane().zoomDown();
            this.imframe.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        }
    }

    private void experiment() {
    }
}

