/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import net.grelf.AbstractDialogue;
import net.grelf.PointFloat;
import net.grelf.grip.BatchMetadata;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.DriveErrorsGraph;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImageSummary;
import net.grelf.grip.ImageSummaryTable;
import net.grelf.grip.MatchPair;

public class ImageSummaryDialogue
extends AbstractDialogue
implements TableModelListener {
    private static final int TABLE_WIDTH = 590;
    private static final int TABLE_HEIGHT = 400;
    private DriveErrorsGraph deGraph;
    private ImageSummaryTable deTable;
    private boolean[] selected;

    public boolean[] getSelected() {
        return this.selected;
    }

    private void setSelected(boolean[] blArray) {
        this.selected = blArray;
    }

    public ImageSummaryDialogue(BatchMetadata batchMetadata, List<MatchPair> list, BlobMeas[][] blobMeasArray, int n, boolean bl) {
        super(GRIP.getInstance(), "Image sequence summary", true);
        JButton jButton;
        Object object;
        int n2 = batchMetadata.getNImages();
        Offset[][] offsetArray = new Offset[n2][n2];
        for (MatchPair object22 : list) {
            if (object22.blobNo1 >= n || object22.blobNo2 >= n) continue;
            PointFloat l = blobMeasArray[object22.imNo1][object22.blobNo1].centre;
            PointFloat pointFloat = blobMeasArray[object22.imNo2][object22.blobNo2].centre;
            float i = pointFloat.x - l.x;
            float imageSummary = pointFloat.y - l.y;
            object = offsetArray[object22.imNo1][object22.imNo2];
            if (null == object) {
                object = new Offset();
                ((Offset)object).sumDx = i;
                ((Offset)object).sumDy = imageSummary;
                ((Offset)object).n = 1;
                offsetArray[object22.imNo1][object22.imNo2] = object;
                continue;
            }
            ((Offset)object).sumDx += i;
            ((Offset)object).sumDy += imageSummary;
            ++((Offset)object).n;
        }
        ArrayList arrayList = new ArrayList();
        ImageSummary imageSummary = new ImageSummary();
        imageSummary.exposureS = batchMetadata.getExposureS(0);
        imageSummary.fileName = batchMetadata.getFileName(0);
        imageSummary.nStars = batchMetadata.getNStars(0);
        imageSummary.meanCircularity = batchMetadata.getMeanCircularity(0);
        arrayList.add(imageSummary);
        long l = batchMetadata.getCaptureTimeMs(0);
        for (int dimension = 1; dimension < n2; ++dimension) {
            ImageSummary jPanel = new ImageSummary();
            jPanel.captureTimeMs = batchMetadata.getCaptureTimeMs(dimension) - l;
            jPanel.exposureS = batchMetadata.getExposureS(dimension);
            jPanel.fileName = batchMetadata.getFileName(dimension);
            jPanel.nStars = batchMetadata.getNStars(dimension);
            jPanel.meanCircularity = batchMetadata.getMeanCircularity(dimension);
            object = offsetArray[dimension - 1][dimension];
            if (null == object) continue;
            jPanel.dx = ((Offset)object).sumDx / (float)((Offset)object).n;
            jPanel.dy = ((Offset)object).sumDy / (float)((Offset)object).n;
            arrayList.add(jPanel);
        }
        Dimension dimension = new Dimension(1000, 500);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        this.setDefaultCloseOperation(1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.deTable = new ImageSummaryTable(this, arrayList, bl);
        object = new JScrollPane(this.deTable);
        Dimension dimension2 = new Dimension(590, 400);
        ((Component)object).setSize(dimension2);
        ((JComponent)object).setPreferredSize(dimension2);
        jPanel.add((Component)object, "West");
        this.deGraph = new DriveErrorsGraph(arrayList);
        jPanel.add((Component)this.deGraph, "East");
        this.getContentPane().add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        ActionListener actionListener = new ActionListener(this, this.deTable, this.deGraph);
        JButton jButton2 = new JButton("Save data as CSV");
        jButton2.addActionListener(actionListener);
        jButton2.setActionCommand("saveCSV");
        jPanel2.add(jButton2);
        JButton jButton3 = bl ? new JButton("OK - proceed to pass 2") : new JButton("Close");
        jButton3.addActionListener(actionListener);
        jButton3.setActionCommand("ok");
        jPanel2.add(jButton3);
        if (bl) {
            jButton = new JButton("Cancel processing");
            jButton.addActionListener(actionListener);
            jButton.setActionCommand("cancel");
            jPanel2.add(jButton);
        }
        jButton = new JButton("Save graph as image");
        jButton.addActionListener(actionListener);
        jButton.setActionCommand("saveImage");
        jPanel2.add(jButton);
        this.getContentPane().add((Component)jPanel2, "South");
        ImageIcon imageIcon = GRIP.getIcon();
        if (null != imageIcon) {
            this.setIconImage(imageIcon.getImage());
        }
        this.pack();
        this.setLocation(50, 50);
        this.setVisible(true);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.selected = this.deTable.getSelected();
        this.deGraph.repaint(this.selected);
    }

    private static class Offset {
        float sumDx;
        float sumDy;
        int n;

        private Offset() {
        }
    }

    private static class ActionListener
    implements java.awt.event.ActionListener {
        private ImageSummaryDialogue de;
        private ImageSummaryTable deTable;
        private DriveErrorsGraph deGraph;

        public ActionListener(ImageSummaryDialogue imageSummaryDialogue, ImageSummaryTable imageSummaryTable, DriveErrorsGraph driveErrorsGraph) {
            this.de = imageSummaryDialogue;
            this.deTable = imageSummaryTable;
            this.deGraph = driveErrorsGraph;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel")) {
                this.de.dispose();
            } else if (string.equals("ok")) {
                this.de.setSelected(this.deTable.getSelected());
                this.de.dispose();
            } else if (string.equals("saveCSV")) {
                this.deTable.saveAsCSV("DriveErrors");
            } else if (string.equals("saveImage")) {
                this.deGraph.saveAsImage();
            }
        }
    }
}

