/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.grelf.FileIO;
import net.grelf.FileIO_CSVFilter;
import net.grelf.Util;
import net.grelf.grip.ImageSummary;
import net.grelf.grip.ImageSummaryDialogue;

public class ImageSummaryTable
extends JTable {
    private static String[] columnNames;
    private static final DecimalFormat DF1;
    private static final DecimalFormat DF2;
    private TableModel model;
    private List<ImageSummary> imData;
    private final Object[][] rowData;
    private boolean userMayRejectImages;

    public ImageSummaryTable(ImageSummaryDialogue imageSummaryDialogue, final List<ImageSummary> list, final boolean bl) {
        this.imData = list;
        this.userMayRejectImages = bl;
        columnNames = bl ? new String[]{"Keep", "File", "When (ms)", "Exp (ms)", "Stars", "Circ.", "dx (px)", "dy (px)", "dr (px)"} : new String[]{"Image", "File", "When (ms)", "Exp (ms)", "Stars", "Circ.", "dx (px)", "dy (px)", "dr (px)"};
        this.rowData = new Object[list.size()][columnNames.length];
        int n = 0;
        for (ImageSummary imageSummary : list) {
            this.rowData[n][0] = bl ? Boolean.valueOf(true) : "" + n;
            this.rowData[n][1] = imageSummary.fileName;
            this.rowData[n][2] = "" + imageSummary.captureTimeMs;
            this.rowData[n][3] = "" + StrictMath.round(imageSummary.exposureS * 1000.0f);
            this.rowData[n][4] = "" + imageSummary.nStars;
            this.rowData[n][5] = "" + DF2.format(imageSummary.meanCircularity);
            if (0 == n) {
                this.rowData[n][6] = "";
                this.rowData[n][7] = "";
                this.rowData[n][8] = "";
            } else {
                this.rowData[n][6] = "" + DF1.format(imageSummary.dx);
                this.rowData[n][7] = "" + DF1.format(imageSummary.dy);
                this.rowData[n][8] = "" + DF1.format(StrictMath.sqrt(imageSummary.dx * imageSummary.dx + imageSummary.dy * imageSummary.dy));
            }
            ++n;
        }
        this.model = new AbstractTableModel(){

            @Override
            public String getColumnName(int n) {
                return columnNames[n];
            }

            @Override
            public int getRowCount() {
                return list.size();
            }

            @Override
            public int getColumnCount() {
                return columnNames.length;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return ImageSummaryTable.this.rowData[n][n2];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return bl && n2 == 0;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                ((ImageSummaryTable)ImageSummaryTable.this).rowData[n][n2] = object;
                this.fireTableCellUpdated(n, n2);
            }

            public Class getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }
        };
        this.model.addTableModelListener(imageSummaryDialogue);
        this.setModel(this.model);
    }

    public boolean[] getSelected() {
        if (!this.userMayRejectImages) {
            return null;
        }
        boolean[] blArray = new boolean[this.imData.size()];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = (Boolean)this.rowData[i][0];
        }
        return blArray;
    }

    public void saveAsCSV(String string) {
        String string2 = FileIO.selectOutputFile("Create CSV file", null, new FileIO_CSVFilter[]{new FileIO_CSVFilter(1)}, string + ".csv");
        if (string2 != null) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(string2));
                printWriter.println("Image, File, When (ms), Exp (ms), No of stars, Circularity, dx (px), dy (px), dr (px)");
                int n = 1;
                for (ImageSummary imageSummary : this.imData) {
                    printWriter.print(n + "," + imageSummary.fileName + "," + imageSummary.captureTimeMs + "," + StrictMath.round(imageSummary.exposureS * 1000.0f) + "," + imageSummary.nStars + "," + DF2.format(imageSummary.meanCircularity));
                    if (1 == n) {
                        printWriter.println(",,,,");
                    } else {
                        printWriter.println("," + DF1.format(imageSummary.dx) + "," + DF1.format(imageSummary.dy) + "," + DF1.format(StrictMath.sqrt(imageSummary.dx * imageSummary.dx + imageSummary.dy * imageSummary.dy)) + ",");
                    }
                    ++n;
                }
                printWriter.close();
            }
            catch (IOException iOException) {
                Util.warning("Error", iOException.toString());
            }
        }
    }

    static {
        DF1 = new DecimalFormat("0.0");
        DF2 = new DecimalFormat("0.00");
    }
}

