/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Point;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import net.grelf.Angle;
import net.grelf.Length;
import net.grelf.Statistics;
import net.grelf.Units;
import net.grelf.Util;
import net.grelf.astro.SkyPoint;
import net.grelf.astro.SkyVector;
import net.grelf.astro.Star;
import net.grelf.astro.StarChart;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.Calibrator;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GRIP;
import net.grelf.grip.GlassPane;
import net.grelf.grip.Histogram;
import net.grelf.grip.ImFrame;
import net.grelf.grip.Measurement;
import net.grelf.grip.MeasurementHandler;
import net.grelf.grip.Profile1D;
import net.grelf.grip.StarChartFrame;
import net.grelf.grip.XYText;
import net.grelf.image.Calibration;
import net.grelf.image.Image;
import net.grelf.image.Metadata;

public class PointList {
    private List<Point> points = new ArrayList<Point>();
    private List<XYText> labels = null;
    private MeasurementHandler mh = null;
    private List<Measurement> ml = null;
    protected int centreX = 0;
    protected int centreY = 0;

    public List<Point> getPoints() {
        return this.points;
    }

    public void add(Point point) {
        this.points.add(point);
    }

    public void clear() {
        this.points = new ArrayList<Point>();
    }

    public Point get(int n) {
        return this.points.get(n);
    }

    public int size() {
        return this.points.size();
    }

    public List<XYText> getLabels() {
        return this.labels;
    }

    public void setLabels(List<XYText> list) {
        this.labels = list;
    }

    public MeasurementHandler getMeasurementHandler() {
        return this.mh;
    }

    public List<Measurement> getMeasurementList() {
        return this.ml;
    }

    public PointList(MeasurementHandler measurementHandler) {
        this.mh = measurementHandler;
    }

    public PointList(PointList pointList) {
        this.mh = pointList.getMeasurementHandler();
        this.points = pointList.getPoints();
        this.labels = pointList.getLabels();
    }

    public PointList() {
    }

    public void calibrate(ImFrame imFrame) {
        GlassPane glassPane = imFrame.getGP();
        if (2 == this.size()) {
            Point point = this.get(0);
            Point point2 = this.get(1);
            double d = point2.getX() - point.getX();
            double d2 = point2.getY() - point.getY();
            double d3 = Math.sqrt(d * d + d2 * d2);
            String string = "";
            boolean bl = true;
            boolean bl2 = false;
            double d4 = 1.0;
            Calibration.Units units = null;
            do {
                Object[] objectArray = new String[]{"OK", "Cancel"};
                JLabel jLabel = new JLabel(string);
                JLabel jLabel2 = new JLabel("Measured separation = " + (int)Math.round(d3) + " pixels");
                JLabel jLabel3 = new JLabel("Units to be used?");
                List<String> list = Angle.Units.RADIANS.getNames();
                List<String> list2 = Length.Units.METRE.getNames();
                Object[] objectArray2 = new Object[list.size() + list2.size()];
                int n = 0;
                int n2 = 0;
                while (n2 < list.size()) {
                    objectArray2[n] = list.get(n2);
                    ++n2;
                    ++n;
                }
                n2 = 0;
                while (n2 < list2.size()) {
                    objectArray2[n] = list2.get(n2);
                    ++n2;
                    ++n;
                }
                JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray2);
                JLabel jLabel4 = new JLabel("Actual distance in those units?");
                JTextField jTextField = new JTextField("", 20);
                Object[] objectArray3 = new Object[]{jLabel, jLabel2, jLabel3, jComboBox, jLabel4, jTextField};
                bl = true;
                if (0 == JOptionPane.showOptionDialog(imFrame, objectArray3, "Calibration", 2, 3, GRIP.getIcon(), objectArray, objectArray[0])) {
                    try {
                        String string2 = (String)jComboBox.getSelectedItem();
                        Length.Units units2 = Length.Units.PIXEL;
                        Enum enum_ = Length.Units.METRE.createUnitsFromName(string2);
                        if (null == enum_) {
                            enum_ = Angle.Units.RADIANS.createUnitsFromName(string2);
                        }
                        units = new Calibration.Units(units2, (Units)((Object)enum_));
                        d4 = Double.parseDouble(jTextField.getText()) / d3;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                        string = "<html><font color=red>Distance entered was not a number</font></html>";
                    }
                    catch (NullPointerException nullPointerException) {
                        bl = false;
                        string = "<html><font color=red>Units not recognised</font></html>";
                    }
                    continue;
                }
                bl2 = true;
            } while (!bl && !bl2);
            if (!bl2) {
                imFrame.getImPane().getImage().getCalibration().setValue(d4, units, true);
                Calibrator.show(imFrame);
            }
        } else {
            Util.warning(imFrame, "ERROR", (Object)"Could not detect exactly 2 points");
        }
        glassPane.setDrawingMode(DrawingMode.UNDEFINED);
        imFrame.setTitle(imFrame.getCaption());
    }

    public void measureArea(ImFrame imFrame) {
        if (this.size() > 2) {
            int n;
            int n2;
            int n3;
            imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
            Point point = this.get(0);
            int n4 = (int)Math.round(point.getX());
            int n5 = (int)Math.round(point.getY());
            int n6 = n4;
            int n7 = n4;
            int n8 = n5;
            int n9 = n5;
            double d = 0.0;
            double d2 = 0.0;
            for (n3 = 1; n3 < this.size(); ++n3) {
                n2 = n4;
                int n10 = n5;
                Point point2 = this.get(n3);
                n4 = (int)Math.round(point2.getX());
                n5 = (int)Math.round(point2.getY());
                if (n4 < n6) {
                    n6 = n4;
                } else if (n4 > n7) {
                    n7 = n4;
                }
                if (n5 < n8) {
                    n8 = n5;
                } else if (n5 > n9) {
                    n9 = n5;
                }
                int n11 = n4 - n2;
                int n12 = n5 - n10;
                d += Math.sqrt(n11 * n11 + n12 * n12);
                d2 += (double)(n11 * (n5 + n10)) * 0.5;
                point = new Point(point2);
            }
            n3 = n7 - n6 + 1;
            n2 = n9 - n8 + 1;
            d2 = Math.abs(d2);
            Image image = imFrame.getImPane().getImage();
            Histogram histogram = new Histogram(image, this, DrawingMode.CLOSED_CURVE);
            Statistics[] statisticsArray = histogram.getStatistics();
            long l = 0L;
            long l2 = 0L;
            int n13 = 0;
            int n14 = this.size();
            int[] nArray = new int[n14];
            int[] nArray2 = new int[n14];
            for (int i = 0; i < n14; ++i) {
                nArray[i] = this.get((int)i).x;
                nArray2[i] = this.get((int)i).y;
            }
            Polygon polygon = new Polygon(nArray, nArray2, n14);
            for (n = n6; n <= n7; ++n) {
                for (int i = n8; i <= n9; ++i) {
                    if (!polygon.contains(n, i)) continue;
                    l += (long)n;
                    l2 += (long)i;
                    ++n13;
                }
            }
            this.centreX = (int)(l / (long)n13);
            this.centreY = (int)(l2 / (long)n13);
            imFrame.getGP().setMeasured(true);
            imFrame.getGP().repaint();
            this.ml = new ArrayList<Measurement>();
            this.ml.add(new Measurement("area", d2, null, 2));
            this.ml.add(new Measurement("centroid (x, y)", "(" + this.centreX + ", " + this.centreY + ")", "pixels from image top left"));
            this.ml.add(new Measurement("height", n2));
            this.ml.add(new Measurement("perimeter", Math.round(d)));
            this.ml.add(new Measurement("width", n3));
            if (statisticsArray.length == 1) {
                this.ml.add(new Measurement("grey min", statisticsArray[0].min, ""));
                this.ml.add(new Measurement("grey mean ", statisticsArray[0].mean, ""));
                this.ml.add(new Measurement("grey std.dev.", statisticsArray[0].stdDev, ""));
                this.ml.add(new Measurement("grey mode", statisticsArray[0].mode, ""));
                this.ml.add(new Measurement("grey max", statisticsArray[0].max, ""));
            } else if (statisticsArray.length == 3) {
                this.ml.add(new Measurement("red min", statisticsArray[0].min, ""));
                this.ml.add(new Measurement("red mean ", statisticsArray[0].mean, ""));
                this.ml.add(new Measurement("red std.dev.", statisticsArray[0].stdDev, ""));
                this.ml.add(new Measurement("red mode", statisticsArray[0].mode, ""));
                this.ml.add(new Measurement("red max", statisticsArray[0].max, ""));
                this.ml.add(new Measurement("green min", statisticsArray[1].min, ""));
                this.ml.add(new Measurement("green mean ", statisticsArray[1].mean, ""));
                this.ml.add(new Measurement("green std.dev.", statisticsArray[1].stdDev, ""));
                this.ml.add(new Measurement("green mode", statisticsArray[1].mode, ""));
                this.ml.add(new Measurement("green max", statisticsArray[1].max, ""));
                this.ml.add(new Measurement("blue min", statisticsArray[2].min, ""));
                this.ml.add(new Measurement("blue mean ", statisticsArray[2].mean, ""));
                this.ml.add(new Measurement("blue std.dev.", statisticsArray[2].stdDev, ""));
                this.ml.add(new Measurement("blue mode", statisticsArray[2].mode, ""));
                this.ml.add(new Measurement("blue max", statisticsArray[2].max, ""));
            } else {
                for (n = 0; n < statisticsArray.length; ++n) {
                    this.ml.add(new Measurement("channel " + n + " min", statisticsArray[n].min, ""));
                    this.ml.add(new Measurement("channel " + n + " mean ", statisticsArray[n].mean, ""));
                    this.ml.add(new Measurement("channel " + n + " std.dev.", statisticsArray[n].stdDev, ""));
                    this.ml.add(new Measurement("channel " + n + " mode", statisticsArray[n].mode, ""));
                    this.ml.add(new Measurement("channel " + n + " max", statisticsArray[n].max, ""));
                }
            }
            this.ml.add(new Measurement("Histogram", histogram, ""));
            this.addImageMetadata(imFrame, this.ml);
            imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            this.mh.process(imFrame, this, this.ml);
        }
    }

    public void measureWhole(ImFrame imFrame) {
        this.points = new ArrayList<Point>();
        Point point = new Point(0, 0);
        Image image = imFrame.getImPane().getImage();
        Point point2 = new Point(image.getWidth() - 1, image.getHeight() - 1);
        this.points.add(point);
        this.points.add(point2);
        this.measureRectangle(imFrame, point, point2);
    }

    public void measureRectangle(ImFrame imFrame) {
        if (2 == this.size()) {
            Point point = this.get(0);
            Point point2 = this.get(1);
            this.measureRectangle(imFrame, point, point2);
        }
    }

    public void measureRectangle(ImFrame imFrame, Point point, Point point2) {
        imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
        int n = Math.min(point.x, point2.x);
        int n2 = Math.max(point.x, point2.x);
        int n3 = Math.min(point.y, point2.y);
        int n4 = Math.max(point.y, point2.y);
        int n5 = n2 - n + 1;
        int n6 = n4 - n3 + 1;
        double d = 2.0 * (double)(n5 + n6);
        double d2 = n5 * n6;
        Image image = imFrame.getImPane().getImage();
        Histogram histogram = new Histogram(image, this, DrawingMode.RECTANGLE);
        Statistics[] statisticsArray = histogram.getStatistics();
        this.centreX = (point.x + point2.x) / 2;
        this.centreY = (point.y + point2.y) / 2;
        imFrame.getGP().setMeasured(true);
        imFrame.getGP().repaint();
        this.ml = new ArrayList<Measurement>();
        this.ml.add(new Measurement("area", d2, null, 2));
        this.ml.add(new Measurement("centroid (x, y)", "(" + this.centreX + ", " + this.centreY + ")", "pixels from image top left"));
        this.ml.add(new Measurement("height", n6));
        this.ml.add(new Measurement("perimeter", Math.round(d)));
        this.ml.add(new Measurement("width", n5));
        if (statisticsArray.length == 1) {
            this.ml.add(new Measurement("grey min", statisticsArray[0].min, ""));
            this.ml.add(new Measurement("grey mean ", statisticsArray[0].mean, ""));
            this.ml.add(new Measurement("grey std.dev.", statisticsArray[0].stdDev, ""));
            this.ml.add(new Measurement("grey mode", statisticsArray[0].mode, ""));
            this.ml.add(new Measurement("grey max", statisticsArray[0].max, ""));
        } else if (statisticsArray.length == 3) {
            this.ml.add(new Measurement("red min", statisticsArray[0].min, ""));
            this.ml.add(new Measurement("red mean ", statisticsArray[0].mean, ""));
            this.ml.add(new Measurement("red std.dev.", statisticsArray[0].stdDev, ""));
            this.ml.add(new Measurement("red mode", statisticsArray[0].mode, ""));
            this.ml.add(new Measurement("red max", statisticsArray[0].max, ""));
            this.ml.add(new Measurement("green min", statisticsArray[1].min, ""));
            this.ml.add(new Measurement("green mean ", statisticsArray[1].mean, ""));
            this.ml.add(new Measurement("green std.dev.", statisticsArray[1].stdDev, ""));
            this.ml.add(new Measurement("green mode", statisticsArray[1].mode, ""));
            this.ml.add(new Measurement("green max", statisticsArray[1].max, ""));
            this.ml.add(new Measurement("blue min", statisticsArray[2].min, ""));
            this.ml.add(new Measurement("blue mean ", statisticsArray[2].mean, ""));
            this.ml.add(new Measurement("blue std.dev.", statisticsArray[2].stdDev, ""));
            this.ml.add(new Measurement("blue mode", statisticsArray[2].mode, ""));
            this.ml.add(new Measurement("blue max", statisticsArray[2].max, ""));
        } else {
            for (int i = 0; i < statisticsArray.length; ++i) {
                this.ml.add(new Measurement("channel " + i + " min", statisticsArray[i].min, ""));
                this.ml.add(new Measurement("channel " + i + " mean ", statisticsArray[i].mean, ""));
                this.ml.add(new Measurement("channel " + i + " std.dev.", statisticsArray[i].stdDev, ""));
                this.ml.add(new Measurement("channel " + i + " mode", statisticsArray[i].mode, ""));
                this.ml.add(new Measurement("channel " + i + " max", statisticsArray[i].max, ""));
            }
        }
        this.ml.add(new Measurement("Histogram", histogram, ""));
        this.addImageMetadata(imFrame, this.ml);
        imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        this.mh.process(imFrame, this, this.ml);
    }

    public void measureCurve(ImFrame imFrame) {
        if (this.size() > 2) {
            int n;
            int n2;
            int n3;
            imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
            Point point = this.get(0);
            int n4 = (int)Math.round(point.getX());
            int n5 = (int)Math.round(point.getY());
            int n6 = n4;
            int n7 = n4;
            int n8 = n5;
            int n9 = n5;
            double d = 0.0;
            for (n3 = 1; n3 < this.size(); ++n3) {
                n2 = n4;
                int n10 = n5;
                Point point2 = this.get(n3);
                n4 = (int)Math.round(point2.getX());
                n5 = (int)Math.round(point2.getY());
                if (n4 < n6) {
                    n6 = n4;
                } else if (n4 > n7) {
                    n7 = n4;
                }
                if (n5 < n8) {
                    n8 = n5;
                } else if (n5 > n9) {
                    n9 = n5;
                }
                int n11 = n4 - n2;
                n = n5 - n10;
                d += Math.sqrt(n11 * n11 + n * n);
                point = new Point(point2);
            }
            n3 = n7 - n6 + 1;
            n2 = n9 - n8 + 1;
            Profile1D profile1D = new Profile1D(imFrame, this);
            Image image = imFrame.getImPane().getImage();
            n = image.getRange().high;
            Statistics[] statisticsArray = profile1D.getStatistics(0, n);
            imFrame.getGP().setMeasured(true);
            imFrame.getGP().repaint();
            this.ml = new ArrayList<Measurement>();
            this.ml.add(new Measurement("length along curve", Math.round(d)));
            this.ml.add(new Measurement("overall height", n2));
            this.ml.add(new Measurement("overall width", n3));
            if (statisticsArray.length == 1) {
                this.ml.add(new Measurement("grey min", statisticsArray[0].min, ""));
                this.ml.add(new Measurement("grey mean ", statisticsArray[0].mean, ""));
                this.ml.add(new Measurement("grey std.dev.", statisticsArray[0].stdDev, ""));
                this.ml.add(new Measurement("grey mode", statisticsArray[0].mode, ""));
                this.ml.add(new Measurement("grey max", statisticsArray[0].max, ""));
            } else if (statisticsArray.length == 3) {
                this.ml.add(new Measurement("red min", statisticsArray[0].min, ""));
                this.ml.add(new Measurement("red mean ", statisticsArray[0].mean, ""));
                this.ml.add(new Measurement("red std.dev.", statisticsArray[0].stdDev, ""));
                this.ml.add(new Measurement("red mode", statisticsArray[0].mode, ""));
                this.ml.add(new Measurement("red max", statisticsArray[0].max, ""));
                this.ml.add(new Measurement("green min", statisticsArray[1].min, ""));
                this.ml.add(new Measurement("green mean ", statisticsArray[1].mean, ""));
                this.ml.add(new Measurement("green std.dev.", statisticsArray[1].stdDev, ""));
                this.ml.add(new Measurement("green mode", statisticsArray[1].mode, ""));
                this.ml.add(new Measurement("green max", statisticsArray[1].max, ""));
                this.ml.add(new Measurement("blue min", statisticsArray[2].min, ""));
                this.ml.add(new Measurement("blue mean ", statisticsArray[2].mean, ""));
                this.ml.add(new Measurement("blue std.dev.", statisticsArray[2].stdDev, ""));
                this.ml.add(new Measurement("blue mode", statisticsArray[2].mode, ""));
                this.ml.add(new Measurement("blue max", statisticsArray[2].max, ""));
            } else {
                for (int i = 0; i < statisticsArray.length; ++i) {
                    this.ml.add(new Measurement("channel " + i + " min", statisticsArray[i].min, ""));
                    this.ml.add(new Measurement("channel " + i + " mean ", statisticsArray[i].mean, ""));
                    this.ml.add(new Measurement("channel " + i + " std.dev.", statisticsArray[i].stdDev, ""));
                    this.ml.add(new Measurement("channel " + i + " mode", statisticsArray[i].mode, ""));
                    this.ml.add(new Measurement("channel " + i + " max", statisticsArray[i].max, ""));
                }
            }
            this.ml.add(new Measurement("Profile", profile1D, ""));
            if (statisticsArray.length == 3) {
                this.ml.add(new Measurement("(black trace is square root of sum of squares of channels)", "", ""));
            }
            this.addImageMetadata(imFrame, this.ml);
            imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            this.mh.process(imFrame, this, this.ml);
        }
    }

    public void measureLine(ImFrame imFrame) {
        if (2 == this.size()) {
            imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
            Point point = this.get(0);
            Point point2 = this.get(1);
            double d = point.getX();
            double d2 = point.getY();
            double d3 = point2.getX() - d;
            double d4 = point2.getY() - d2;
            int n = (int)Math.round(Math.sqrt(d3 * d3 + d4 * d4));
            if (0 < n) {
                Angle angle = Angle.atan2(-d4, d3);
                int n2 = (int)angle.getDegrees();
                Profile1D profile1D = new Profile1D(imFrame, this);
                Image image = imFrame.getImPane().getImage();
                int n3 = image.getRange().high;
                Statistics[] statisticsArray = profile1D.getStatistics(0, n3);
                imFrame.getGP().setMeasured(true);
                imFrame.getGP().repaint();
                this.ml = new ArrayList<Measurement>();
                this.ml.add(new Measurement("angle", n2, Angle.Units.DEGREES.getSymbol()));
                this.ml.add(new Measurement("length", n));
                if (statisticsArray.length == 1) {
                    this.ml.add(new Measurement("grey min", statisticsArray[0].min, ""));
                    this.ml.add(new Measurement("grey mean ", statisticsArray[0].mean, ""));
                    this.ml.add(new Measurement("grey std.dev.", statisticsArray[0].stdDev, ""));
                    this.ml.add(new Measurement("grey mode", statisticsArray[0].mode, ""));
                    this.ml.add(new Measurement("grey max", statisticsArray[0].max, ""));
                } else if (statisticsArray.length == 3) {
                    this.ml.add(new Measurement("red min", statisticsArray[0].min, ""));
                    this.ml.add(new Measurement("red mean ", statisticsArray[0].mean, ""));
                    this.ml.add(new Measurement("red std.dev.", statisticsArray[0].stdDev, ""));
                    this.ml.add(new Measurement("red mode", statisticsArray[0].mode, ""));
                    this.ml.add(new Measurement("red max", statisticsArray[0].max, ""));
                    this.ml.add(new Measurement("green min", statisticsArray[1].min, ""));
                    this.ml.add(new Measurement("green mean ", statisticsArray[1].mean, ""));
                    this.ml.add(new Measurement("green std.dev.", statisticsArray[1].stdDev, ""));
                    this.ml.add(new Measurement("green mode", statisticsArray[1].mode, ""));
                    this.ml.add(new Measurement("green max", statisticsArray[1].max, ""));
                    this.ml.add(new Measurement("blue min", statisticsArray[2].min, ""));
                    this.ml.add(new Measurement("blue mean ", statisticsArray[2].mean, ""));
                    this.ml.add(new Measurement("blue std.dev.", statisticsArray[2].stdDev, ""));
                    this.ml.add(new Measurement("blue mode", statisticsArray[2].mode, ""));
                    this.ml.add(new Measurement("blue max", statisticsArray[2].max, ""));
                } else {
                    for (int i = 0; i < statisticsArray.length; ++i) {
                        this.ml.add(new Measurement("channel " + i + " min", statisticsArray[i].min, ""));
                        this.ml.add(new Measurement("channel " + i + " mean ", statisticsArray[i].mean, ""));
                        this.ml.add(new Measurement("channel " + i + " std.dev.", statisticsArray[i].stdDev, ""));
                        this.ml.add(new Measurement("channel " + i + " mode", statisticsArray[i].mode, ""));
                        this.ml.add(new Measurement("channel " + i + " max", statisticsArray[i].max, ""));
                    }
                }
                this.ml.add(new Measurement("Profile", profile1D, ""));
                if (statisticsArray.length == 3) {
                    this.ml.add(new Measurement("(black trace is square root of sum of squares of channels)", "", ""));
                }
                this.addImageMetadata(imFrame, this.ml);
                imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
                this.mh.process(imFrame, this, this.ml);
            } else {
                imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
            }
        }
    }

    public void measureBlobLine(ImFrame imFrame) {
        BlobMeasList blobMeasList = imFrame.getBlobMeases();
        if (2 == this.size() && null != blobMeasList) {
            imFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
            Point point = this.get(0);
            Point point2 = this.get(1);
            BlobMeas blobMeas = null;
            BlobMeas blobMeas2 = null;
            for (BlobMeas blobMeas3 : blobMeasList) {
                if (point.x == (int)blobMeas3.centre.x && point.y == (int)blobMeas3.centre.y) {
                    blobMeas = blobMeas3;
                    continue;
                }
                if (point2.x != (int)blobMeas3.centre.x || point2.y != (int)blobMeas3.centre.y) continue;
                blobMeas2 = blobMeas3;
            }
            if (null != blobMeas && null != blobMeas2) {
                double d = blobMeas2.centre.x - blobMeas.centre.x;
                double d2 = blobMeas2.centre.y - blobMeas.centre.y;
                double d3 = Math.sqrt(d * d + d2 * d2);
                double d4 = Math.toDegrees(Math.atan2(-d2, d));
                imFrame.getGP().setMeasured(true);
                imFrame.getGP().repaint();
                this.ml = new ArrayList<Measurement>();
                this.ml.add(new Measurement("Line in image:<br>angle", this.roundTo2DecimalPlaces(d4), "degrees"));
                this.ml.add(new Measurement("length", this.roundTo2DecimalPlaces(d3)));
                if (null != blobMeas.getStar() && null != blobMeas2.getStar()) {
                    SkyPoint skyPoint = blobMeas.getStar().getPosition();
                    SkyPoint skyPoint2 = blobMeas2.getStar().getPosition();
                    if (null != skyPoint && null != skyPoint2) {
                        SkyVector skyVector = skyPoint.calculateSeparation(skyPoint2);
                        this.ml.add(new Measurement("Stars:<br>PA", this.roundTo2DecimalPlaces(skyVector.getPa().getDegrees()), "degrees"));
                        this.ml.add(new Measurement("separation", this.roundTo3DecimalPlaces(skyVector.getSeparation().getDegrees()), "degrees"));
                        double d5 = 360.0 - skyVector.getPa().getDegrees() + d4;
                        this.ml.add(new Measurement("=> meridian angle in image", this.roundTo2DecimalPlaces(d5), "degrees"));
                    }
                }
                this.addImageMetadata(imFrame, this.ml);
                this.mh.process(imFrame, this, this.ml);
            } else {
                Util.warning("Sorry", "Blobs not found");
            }
            imFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        }
    }

    public void measureStarLine(ImFrame imFrame) {
        if (imFrame instanceof StarChartFrame) {
            StarChartFrame starChartFrame = (StarChartFrame)imFrame;
            StarChart starChart = starChartFrame.getStarChart();
            if (null == starChart) {
                Util.logWarning("Chart is null in PointList.measureStarLine");
                return;
            }
            if (2 != this.size()) {
                Util.logWarning("Size is not 2 in PointList.measureStarLine");
                return;
            }
            starChartFrame.setCursor(GRIP.GRIP_WAIT_CURSOR);
            Point point = this.get(0);
            Point point2 = this.get(1);
            Star star = starChart.findNearestStar(point.x, point.y);
            Star star2 = starChart.findNearestStar(point2.x, point2.y);
            if (null != star && null != star2) {
                SkyPoint skyPoint = star.getPosition();
                SkyPoint skyPoint2 = star2.getPosition();
                if (null != skyPoint && null != skyPoint2) {
                    SkyVector skyVector = skyPoint.calculateSeparation(skyPoint2);
                    starChartFrame.getGP().setMeasured(true);
                    starChartFrame.getGP().repaint();
                    this.ml = new ArrayList<Measurement>();
                    this.ml.add(new Measurement("PA", this.roundTo2DecimalPlaces(skyVector.getPa().getDegrees()), "degrees"));
                    this.ml.add(new Measurement("separation", this.roundTo3DecimalPlaces(skyVector.getSeparation().getDegrees()), "degrees"));
                    this.mh.process(starChartFrame, this, this.ml);
                } else {
                    Util.warning("Sorry", "Star positions not found");
                }
            } else {
                Util.warning("Sorry", "Stars not found");
            }
            starChartFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        }
    }

    private double roundTo2DecimalPlaces(double d) {
        return 0.01 * (double)((int)Math.round(d * 100.0));
    }

    private double roundTo3DecimalPlaces(double d) {
        return 0.001 * (double)((int)Math.round(d * 1000.0));
    }

    public void measurePoint(ImFrame imFrame) {
        Point point = this.get(0);
        Image image = imFrame.getImPane().getImage();
        int n = image.getNBands();
        int[] nArray = image.getPixel(point.x, point.y);
        imFrame.getGP().setMeasured(true);
        imFrame.getGP().repaint();
        this.ml = new ArrayList<Measurement>();
        if (n == 1) {
            this.ml.add(new Measurement("Grey", nArray[0], ""));
        } else if (n == 3) {
            this.ml.add(new Measurement("Red", nArray[0], ""));
            this.ml.add(new Measurement("Green", nArray[1], ""));
            this.ml.add(new Measurement("Blue", nArray[2], ""));
        } else {
            for (int i = 0; i < n; ++i) {
                this.ml.add(new Measurement("Channel " + i + ": ", nArray[i], ""));
            }
        }
        this.ml.add(new Measurement("x", point.x));
        this.ml.add(new Measurement("y", point.y));
        this.addImageMetadata(imFrame, this.ml);
        this.mh.process(imFrame, this, this.ml);
    }

    private void addImageMetadata(ImFrame imFrame, List<Measurement> list) {
        Map<String, String> map;
        Metadata metadata = imFrame.getImPane().getImage().getMetadata();
        if (null != metadata && null != (map = metadata.getMap())) {
            long l;
            String string;
            if (map.containsKey("FNumber") && !(string = Util.rational(map.get("FNumber"))).equals("NaN")) {
                list.add(new Measurement("Camera aperture", "" + string, "f/"));
            }
            if (map.containsKey("ISOSpeedRatings")) {
                list.add(new Measurement("Camera ISO", map.get("ISOSpeedRatings"), ""));
            }
            if (map.containsKey("ExposureTime") && !(string = Util.rational(map.get("ExposureTime"))).equals("NaN")) {
                list.add(new Measurement("Exposure time", string, "s"));
            }
            if (map.containsKey("FocalLength") && !(string = Util.rational(map.get("FocalLength"))).equals("NaN")) {
                list.add(new Measurement("Focal length", string, "mm"));
            }
            if (map.containsKey("DateTimeOriginal") && 0L < (l = Util.getMilliseconds(string = map.get("DateTimeOriginal")))) {
                list.add(new Measurement("When taken (date & time)", string, "yyyy:mm:dd hh:mm:ss"));
                list.add(new Measurement("When taken (time since 1970.0)", l / 1000L, "s"));
            }
        }
    }
}

