/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.grelf.grip.RangeSliderUser;
import net.grelf.image.RangeInt;

public class RangeSlider
extends JPanel
implements ChangeListener {
    private RangeSliderUser caller;
    private RangeInt limits;
    private RangeInt values;
    private String channelLabel;
    private JSlider highSlider;
    private JSlider lowSlider;
    private JPanel sliderPanel;
    private JLabel highLabel;
    private JLabel lowLabel;

    private RangeSlider() {
    }

    public RangeSlider(RangeInt rangeInt, RangeInt rangeInt2, int n, Color color, int n2, int n3, String string, Color color2, int n4, RangeSliderUser rangeSliderUser) {
        super(new BorderLayout());
        this.caller = rangeSliderUser;
        this.limits = rangeInt;
        this.values = rangeInt2;
        this.channelLabel = string;
        this.highSlider = new JSlider(n, this.limits.low, this.limits.high, this.values.high);
        this.highSlider.setMajorTickSpacing(n2);
        this.highSlider.setMinorTickSpacing(n3);
        this.highSlider.setPaintTicks(true);
        this.highSlider.setBackground(color);
        this.highSlider.addChangeListener(this);
        this.lowSlider = new JSlider(n, this.limits.low, this.limits.high, this.values.low);
        this.lowSlider.setMajorTickSpacing(n2);
        this.lowSlider.setMinorTickSpacing(n3);
        this.lowSlider.setPaintTicks(true);
        this.lowSlider.setBackground(color);
        this.lowSlider.addChangeListener(this);
        this.sliderPanel = new JPanel(new BorderLayout());
        this.sliderPanel.add((Component)this.highSlider, "North");
        this.sliderPanel.add((Component)this.lowSlider, "South");
        this.highLabel = new JLabel();
        this.lowLabel = new JLabel();
        this.checkOrder();
        this.setLabels();
        this.add((Component)this.lowLabel, "West");
        this.add((Component)this.sliderPanel, "Center");
        this.add((Component)this.highLabel, "East");
        this.setBorder(BorderFactory.createLineBorder(color2, n4));
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.highSlider) {
            this.values.high = this.highSlider.getValue();
            this.checkOrder();
            this.setLabels();
            this.caller.rangeChanged(this, this.values);
        } else if (object == this.lowSlider) {
            this.values.low = this.lowSlider.getValue();
            this.checkOrder();
            this.setLabels();
            this.caller.rangeChanged(this, this.values);
        }
    }

    private void checkOrder() {
        if (this.values.order()) {
            this.highSlider.setValue(this.values.high);
            this.lowSlider.setValue(this.values.low);
        }
    }

    private String format(int n) {
        if (n < 10) {
            return "     " + n + " ";
        }
        if (n < 100) {
            return "    " + n + " ";
        }
        if (n < 1000) {
            return "   " + n + " ";
        }
        if (n < 10000) {
            return "  " + n + " ";
        }
        return " " + n + " ";
    }

    private void setLabels() {
        this.highLabel.setText(this.channelLabel + this.format(this.values.high));
        this.lowLabel.setText(this.channelLabel + this.format(this.values.low));
    }
}

