/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.image;

import java.io.Serializable;
import java.util.List;
import net.grelf.Length;
import net.grelf.Util;

public class Calibration
implements Serializable {
    private boolean calibrated = false;
    private Units units = new Units(Length.Units.PIXEL, null);
    private double scale = 1.0;

    public boolean isCalibrated() {
        return this.calibrated;
    }

    public void setCalibrated(boolean bl) {
        this.calibrated = bl;
    }

    public Units getUnits() {
        return this.units;
    }

    public void setUnits(Units units) {
        this.units = units;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public Calibration() {
    }

    public Calibration(Units units, double d) {
        this();
        this.setUnits(units);
        this.setScale(d);
        this.setCalibrated(null != units.getToUnits());
    }

    public Calibration(Calibration calibration) {
        this();
        this.setUnits(calibration.getUnits());
        this.setScale(calibration.getScale());
        this.setCalibrated(null != calibration.units.getToUnits());
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        Calibration calibration = (Calibration)object;
        if (calibration.calibrated != this.calibrated) {
            return false;
        }
        if (!calibration.units.equals(this.units)) {
            return false;
        }
        return calibration.scale == this.scale;
    }

    public int hashCode() {
        return this.units.hashCode() * 23 + (int)(this.scale * 1234.0) + (this.calibrated ? 17 : 7);
    }

    public String toString() {
        return "Calibration: " + this.getValue();
    }

    public String getValue() {
        return this.getValue(false);
    }

    public String getValue(boolean bl) {
        if (!this.calibrated) {
            return this.units.toString();
        }
        if (this.scale < 1.0) {
            if (bl) {
                return "<html>" + Util.formatHTML(1.0 / this.scale) + " " + this.units.toString();
            }
            return Util.format(1.0 / this.scale) + " " + this.units.toString();
        }
        if (bl) {
            return "<html>" + Util.formatHTML(this.scale) + " " + this.units.toString();
        }
        return Util.format(this.scale) + " " + this.units.toString();
    }

    public void setValue(double d, Units units, boolean bl) {
        this.scale = d;
        this.units = units;
        this.calibrated = bl;
    }

    public void show() {
        Util.message("Calibration", this.getValue(true));
    }

    public void uncalibrate() {
        this.scale = 1.0;
        this.units = new Units(Length.Units.PIXEL, null);
        this.calibrated = false;
    }

    public static class Units
    implements net.grelf.Units,
    Serializable {
        private net.grelf.Units fromUnits;
        private net.grelf.Units toUnits;

        public net.grelf.Units getFromUnits() {
            return this.fromUnits;
        }

        public net.grelf.Units getToUnits() {
            return this.toUnits;
        }

        public Units(net.grelf.Units units, net.grelf.Units units2) {
            this.fromUnits = units;
            this.toUnits = units2;
        }

        @Override
        public String getSymbol() {
            StringBuffer stringBuffer = new StringBuffer();
            if (null == this.toUnits) {
                stringBuffer.append(this.fromUnits.getSymbol());
                stringBuffer.append(" (uncalibrated)");
            } else {
                stringBuffer.append(this.fromUnits.getSymbol());
                stringBuffer.append(" / ");
                stringBuffer.append(this.toUnits.getSymbol());
            }
            return stringBuffer.toString();
        }

        @Override
        public Units createUnitsFromName(String string) {
            return null;
        }

        @Override
        public List<String> getNames() {
            return null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (null == this.toUnits) {
                stringBuffer.append(this.fromUnits.toString());
                stringBuffer.append(" (uncalibrated)");
            } else {
                stringBuffer.append(this.fromUnits.toString());
                stringBuffer.append(" / ");
                stringBuffer.append(this.toUnits.toString());
            }
            return stringBuffer.toString();
        }
    }
}

