/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.image;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.grelf.Util;
import net.grelf.image.FITS_Header;
import net.grelf.image.FITS_KeywordRecord;
import net.grelf.image.Image;
import net.grelf.image.Image16;
import net.grelf.image.Image32;
import net.grelf.image.Image64;
import net.grelf.image.Image8;
import net.grelf.image.Image8or16Base;
import net.grelf.image.ImageBase;
import net.grelf.image.IncompatibleImageException;
import net.grelf.image.Metadata;
import net.grelf.image.NoImageException;
import net.grelf.image.RangeDouble;
import net.grelf.image.RangeInt;
import net.grelf.image.Timer;

public class FITS {
    private int findChannelIndex(int[] nArray) {
        int n = 0;
        int n2 = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] >= n2) continue;
            n2 = nArray[i];
            n = i;
        }
        return n;
    }

    public void saveImage(String string, Image image) {
        if (image instanceof Image64 || image instanceof Image32) {
            image.saveAsFITS(string);
        } else {
            Timer timer = new Timer("FITS.saveImage", image);
            int n = image.getWidth();
            int n2 = image.getHeight();
            int n3 = image.getNBands();
            int n4 = image.getBitsPerChannel();
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(FITS.padTo(80, "SIMPLE  =                    T / GRIP (www.grelf.net)"));
                stringBuffer.append(FITS.padTo(80, "BITPIX  = " + FITS.rJustified20(n4)));
                stringBuffer.append(FITS.padTo(80, "NAXIS   =                    3"));
                stringBuffer.append(FITS.padTo(80, "NAXIS1  = " + FITS.rJustified20(n)));
                stringBuffer.append(FITS.padTo(80, "NAXIS2  = " + FITS.rJustified20(n2)));
                stringBuffer.append(FITS.padTo(80, "NAXIS3  = " + FITS.rJustified20(n3)));
                stringBuffer.append(FITS.padTo(80, "BSCALE  =                  1.0"));
                switch (n4) {
                    case 8: {
                        stringBuffer.append(FITS.padTo(80, "BZERO   = " + FITS.rJustified20(-128)));
                        break;
                    }
                    case 16: {
                        stringBuffer.append(FITS.padTo(80, "BZERO   = " + FITS.rJustified20(32768)));
                        break;
                    }
                    default: {
                        stringBuffer.append(FITS.padTo(80, "BZERO   = " + FITS.rJustified20(0)));
                    }
                }
                stringBuffer.append(FITS.padTo(80, "DATE    = " + Util.format_yyyyMMddTHHmmss(new Date())));
                Metadata metadata = image.getMetadata();
                if (null != metadata) {
                    String string2;
                    if (null != metadata.getMap()) {
                        metadata.convertImageKindString();
                        for (String object2 : metadata.getMap().keySet()) {
                            if (!Metadata.FITS_KEYWORDS.containsValue(object2) || null == (string2 = metadata.getMap().get(object2)) || -1 != stringBuffer.indexOf(object2)) continue;
                            stringBuffer.append(FITS.padTo(80, FITS.padTo(8, object2) + "= " + string2));
                        }
                    }
                    if (null != metadata.getList()) {
                        for (FITS_KeywordRecord fITS_KeywordRecord : metadata.getList()) {
                            string2 = fITS_KeywordRecord.getKeyword();
                            if (-1 != stringBuffer.indexOf(string2)) continue;
                            stringBuffer.append(fITS_KeywordRecord.getRecord());
                        }
                    }
                }
                stringBuffer.append(FITS.padTo(80, "END"));
                stringBuffer = FITS.padTo(2880, stringBuffer);
                dataOutputStream.writeBytes(stringBuffer.toString());
                switch (n4) {
                    case 16: {
                        int n5;
                        int n6;
                        Object object = ((Image16)image).getBufferedImage();
                        WritableRaster writableRaster = ((BufferedImage)object).getRaster();
                        for (n6 = 0; n6 < n3; ++n6) {
                            for (n5 = 0; n5 < n2; ++n5) {
                                for (int i = 0; i < n; ++i) {
                                    dataOutputStream.writeShort((short)(writableRaster.getSample(i, n5, n6) - 32768));
                                }
                            }
                        }
                        n6 = (int)(2L * (long)n3 * (long)n * (long)n2 % 2880L);
                        for (n5 = 0; n5 < 2880 - n6; ++n5) {
                            dataOutputStream.writeByte(32);
                        }
                        break;
                    }
                    case 8: {
                        int n7;
                        int n8;
                        Object object = ((Image8)image).getBufferedImage();
                        WritableRaster writableRaster = ((BufferedImage)object).getRaster();
                        for (n8 = 0; n8 < n3; ++n8) {
                            for (n7 = 0; n7 < n2; ++n7) {
                                for (int i = 0; i < n; ++i) {
                                    dataOutputStream.writeByte((byte)(writableRaster.getSample(i, n7, n8) + 128));
                                }
                            }
                        }
                        n8 = (int)(1L * (long)n3 * (long)n * (long)n2 % 2880L);
                        for (n7 = 0; n7 < 2880 - n8; ++n7) {
                            dataOutputStream.writeByte(32);
                        }
                        break;
                    }
                    default: {
                        Util.warning("Error", "Cannot save an image having\n" + image.getBitsPerChannel() + " bits per channel");
                    }
                }
                dataOutputStream.close();
                image.setFilePath(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Util.warning("Error", fileNotFoundException);
            }
            catch (IOException iOException) {
                Util.warning("Error", iOException);
            }
            timer.stop();
        }
    }

    public static String padTo(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer = FITS.padTo(n, stringBuffer);
        return stringBuffer.toString();
    }

    public static StringBuffer padTo(int n, StringBuffer stringBuffer) {
        for (int i = stringBuffer.length(); i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer;
    }

    public static String rJustified20(int n) {
        String string = "" + n;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 20 - string.length(); ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public List<Image> loadImage(File file) {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        if (!file.exists()) {
            Util.warning("Error", "File not found: " + file.getPath());
        } else {
            FilterInputStream filterInputStream = null;
            try {
                try {
                    filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                    Object object = new FITS_Header().read((DataInputStream)filterInputStream, file.getName(), true);
                    if (null == object) {
                        throw new NoImageException("No valid FITS primary header found");
                    }
                    arrayList.addAll(this.loadImage((DataInputStream)filterInputStream, (FITS_Header)object));
                    int n = 2;
                    while (filterInputStream.available() != 0) {
                        object = new FITS_Header().read((DataInputStream)filterInputStream, file.getName(), false);
                        if (null != object) {
                            if (((FITS_Header)object).isImageHeader()) {
                                List<Image> list = this.loadImage((DataInputStream)filterInputStream, (FITS_Header)object);
                                for (Image image : list) {
                                    image.setMetadata(((FITS_Header)object).getMetadata());
                                }
                                arrayList.addAll(list);
                            } else {
                                Util.logInfo("Extension block in " + file.getName() + " is not an image");
                            }
                        }
                        ++n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NoImageException("Non-integer keyword value (NAXIS, NAXISn or BITPIX)");
                }
                finally {
                    if (null != filterInputStream) {
                        filterInputStream.close();
                    }
                }
            }
            catch (NoImageException noImageException) {
                noImageException.warnAndLog();
            }
            catch (IOException iOException) {
                Util.warning("Error", "Exception occurred while reading file:\n" + iOException);
            }
            for (Image image : arrayList) {
                image.setFilePath(file.getPath());
            }
        }
        return arrayList;
    }

    private List<Image> loadImage(DataInputStream dataInputStream, FITS_Header fITS_Header) throws IOException, NoImageException {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        int[] nArray = fITS_Header.getAxes();
        int n = fITS_Header.getBitpix();
        double d = fITS_Header.getBscale();
        double d2 = fITS_Header.getBzero();
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        switch (nArray.length) {
            case 2: {
                n4 = nArray[0];
                n5 = nArray[1];
                break;
            }
            case 3: {
                n2 = this.findChannelIndex(nArray);
                n3 = nArray[n2];
                switch (n2) {
                    case 0: {
                        n4 = nArray[1];
                        n5 = nArray[2];
                        break;
                    }
                    case 1: {
                        n4 = nArray[0];
                        n5 = nArray[2];
                        break;
                    }
                    case 2: {
                        n4 = nArray[0];
                        n5 = nArray[1];
                    }
                }
                break;
            }
            default: {
                Util.warning("Sorry", "Cannot load images having other than 2 or 3 axes\n(in this case " + nArray.length + ")");
            }
        }
        switch (n) {
            case 8: {
                Object object;
                Object object2;
                int n6 = (int)d2;
                if (1 == n3) {
                    try {
                        object2 = new BufferedImage(n4, n5, 11);
                        object = ((BufferedImage)object2).getRaster();
                        for (int i = 0; i < n5; ++i) {
                            for (int j = 0; j < n4; ++j) {
                                ((WritableRaster)object).setSample(j, i, 0, dataInputStream.readByte() + n6);
                            }
                        }
                        Image8 image8 = new Image8((BufferedImage)object2);
                        image8.setMetadata(fITS_Header.getMetadata());
                        arrayList.add(image8);
                    }
                    catch (IncompatibleImageException incompatibleImageException) {
                        Util.logWarning(incompatibleImageException.toString());
                    }
                    break;
                }
                if (3 == n3) {
                    try {
                        object2 = new BufferedImage(n4, n5, 1);
                        object = ((BufferedImage)object2).getRaster();
                        switch (n2) {
                            case 0: {
                                int n7;
                                int n8;
                                for (n8 = 0; n8 < n5; ++n8) {
                                    for (n7 = 0; n7 < n4; ++n7) {
                                        for (int i = 0; i < n3; ++i) {
                                            ((WritableRaster)object).setSample(n7, n8, i, dataInputStream.readByte() + n6);
                                        }
                                    }
                                }
                                break;
                            }
                            case 1: {
                                int n7;
                                int n8;
                                for (n8 = 0; n8 < n5; ++n8) {
                                    for (n7 = 0; n7 < n3; ++n7) {
                                        for (int i = 0; i < n4; ++i) {
                                            ((WritableRaster)object).setSample(i, n8, n7, dataInputStream.readByte() + n6);
                                        }
                                    }
                                }
                                break;
                            }
                            case 2: {
                                int n7;
                                int n8;
                                for (n8 = 0; n8 < n3; ++n8) {
                                    for (n7 = 0; n7 < n5; ++n7) {
                                        for (int i = 0; i < n4; ++i) {
                                            ((WritableRaster)object).setSample(i, n7, n8, dataInputStream.readByte() + n6);
                                        }
                                    }
                                }
                                break;
                            }
                        }
                        Image8 image8 = new Image8((BufferedImage)object2);
                        image8.setMetadata(fITS_Header.getMetadata());
                        arrayList.add(image8);
                    }
                    catch (IncompatibleImageException incompatibleImageException) {
                        Util.logWarning(incompatibleImageException.toString());
                    }
                    break;
                }
                try {
                    int n9;
                    int n10;
                    object = new BufferedImage[n3];
                    WritableRaster[] writableRasterArray = new WritableRaster[n3];
                    for (n10 = 0; n10 < n3; ++n10) {
                        object[n10] = new BufferedImage(n4, n5, 11);
                        writableRasterArray[n10] = object[n10].getRaster();
                    }
                    switch (n2) {
                        case 0: {
                            int n11;
                            for (n10 = 0; n10 < n5; ++n10) {
                                for (n11 = 0; n11 < n4; ++n11) {
                                    for (n9 = 0; n9 < n3; ++n9) {
                                        writableRasterArray[n9].setSample(n11, n10, 0, dataInputStream.readByte() + n6);
                                    }
                                }
                            }
                            break;
                        }
                        case 1: {
                            int n11;
                            for (n10 = 0; n10 < n5; ++n10) {
                                for (n11 = 0; n11 < n3; ++n11) {
                                    for (n9 = 0; n9 < n4; ++n9) {
                                        writableRasterArray[n11].setSample(n9, n10, 0, dataInputStream.readByte() + n6);
                                    }
                                }
                            }
                            break;
                        }
                        case 2: {
                            int n11;
                            for (n10 = 0; n10 < n3; ++n10) {
                                for (n11 = 0; n11 < n5; ++n11) {
                                    for (n9 = 0; n9 < n4; ++n9) {
                                        writableRasterArray[n10].setSample(n9, n11, 0, dataInputStream.readByte() + n6);
                                    }
                                }
                            }
                            break;
                        }
                    }
                    Image8 image8 = new Image8(object[0]);
                    Metadata metadata = fITS_Header.getMetadata();
                    image8.setMetadata(metadata);
                    arrayList.add(image8);
                    for (n9 = 1; n9 < n3; ++n9) {
                        Image8 image82 = new Image8((BufferedImage)object[n9]);
                        image82.setMetadata(metadata);
                        arrayList.add(image82);
                    }
                    break;
                }
                catch (IncompatibleImageException incompatibleImageException) {
                    Util.logWarning(incompatibleImageException.toString());
                    break;
                }
            }
            case 16: {
                int n12;
                Image16 image16;
                Object object;
                Object object2;
                int n13 = (int)d2;
                if (1 == n3) {
                    try {
                        object = ImageBase.createImage(n4, n5, n3, 16);
                        object2 = ((Image8or16Base)object).getBufferedImage();
                        WritableRaster writableRaster = ((BufferedImage)object2).getRaster();
                        for (int i = 0; i < n5; ++i) {
                            for (int j = 0; j < n4; ++j) {
                                writableRaster.setSample(j, i, 0, dataInputStream.readUnsignedShort() + n13);
                            }
                        }
                        image16 = new Image16((BufferedImage)object2);
                        image16.setMetadata(fITS_Header.getMetadata());
                        arrayList.add(image16);
                    }
                    catch (IncompatibleImageException incompatibleImageException) {
                        Util.logWarning(incompatibleImageException.toString());
                    }
                    break;
                }
                if (3 == n3) {
                    try {
                        object = ImageBase.createImage(n4, n5, n3, 16);
                        object2 = ((Image8or16Base)object).getBufferedImage();
                        WritableRaster writableRaster = ((BufferedImage)object2).getRaster();
                        switch (n2) {
                            case 0: {
                                int n14;
                                for (n14 = 0; n14 < n5; ++n14) {
                                    for (int i = 0; i < n4; ++i) {
                                        for (n12 = 0; n12 < n3; ++n12) {
                                            writableRaster.setSample(i, n14, n12, dataInputStream.readUnsignedShort() + n13);
                                        }
                                    }
                                }
                                break;
                            }
                            case 1: {
                                int n14;
                                for (n14 = 0; n14 < n5; ++n14) {
                                    for (int i = 0; i < n3; ++i) {
                                        for (n12 = 0; n12 < n4; ++n12) {
                                            writableRaster.setSample(n12, n14, i, dataInputStream.readUnsignedShort() + n13);
                                        }
                                    }
                                }
                                break;
                            }
                            case 2: {
                                int n14;
                                for (n14 = 0; n14 < n3; ++n14) {
                                    for (int i = 0; i < n5; ++i) {
                                        for (n12 = 0; n12 < n4; ++n12) {
                                            writableRaster.setSample(n12, i, n14, dataInputStream.readUnsignedShort() + n13);
                                        }
                                    }
                                }
                                break;
                            }
                        }
                        image16 = new Image16((BufferedImage)object2);
                        image16.setMetadata(fITS_Header.getMetadata());
                        arrayList.add(image16);
                    }
                    catch (IncompatibleImageException incompatibleImageException) {
                        Util.logWarning(incompatibleImageException.toString());
                    }
                    break;
                }
                try {
                    int n15;
                    object = new BufferedImage[n3];
                    WritableRaster[] writableRasterArray = new WritableRaster[n3];
                    for (n15 = 0; n15 < n3; ++n15) {
                        Image image = ImageBase.createImage(n4, n5, n3, 16);
                        object[n15] = ((Image8or16Base)image).getBufferedImage();
                        writableRasterArray[n15] = object[n15].getRaster();
                    }
                    switch (n2) {
                        case 0: {
                            for (n15 = 0; n15 < n5; ++n15) {
                                for (int i = 0; i < n4; ++i) {
                                    for (n12 = 0; n12 < n3; ++n12) {
                                        writableRasterArray[n12].setSample(i, n15, 0, dataInputStream.readUnsignedShort() + n13);
                                    }
                                }
                            }
                            break;
                        }
                        case 1: {
                            for (n15 = 0; n15 < n5; ++n15) {
                                for (int i = 0; i < n3; ++i) {
                                    for (n12 = 0; n12 < n4; ++n12) {
                                        writableRasterArray[i].setSample(n12, n15, 0, dataInputStream.readUnsignedShort() + n13);
                                    }
                                }
                            }
                            break;
                        }
                        case 2: {
                            for (n15 = 0; n15 < n3; ++n15) {
                                for (int i = 0; i < n5; ++i) {
                                    for (n12 = 0; n12 < n4; ++n12) {
                                        writableRasterArray[n15].setSample(n12, i, 0, dataInputStream.readUnsignedShort() + n13);
                                    }
                                }
                            }
                            break;
                        }
                    }
                    image16 = new Image16(object[0]);
                    Metadata metadata = fITS_Header.getMetadata();
                    image16.setMetadata(metadata);
                    arrayList.add(image16);
                    for (n12 = 1; n12 < n3; ++n12) {
                        Image16 image162 = new Image16(object[n12]);
                        image162.setMetadata(metadata);
                        arrayList.add(image162);
                    }
                    break;
                }
                catch (IncompatibleImageException incompatibleImageException) {
                    Util.logWarning(incompatibleImageException.toString());
                    break;
                }
            }
            case 32: {
                Object object2;
                if (Math.abs(d - 1.0) < 1.0E-12 && Math.abs(d2) < 1.0E-12) {
                    int n16;
                    int n17 = 0;
                    int n18 = Integer.MAX_VALUE;
                    int n19 = Integer.MIN_VALUE;
                    if (1 == n3) {
                        object2 = new Image32(n4, n5, n3);
                        for (n16 = 0; n16 < n5; ++n16) {
                            for (int i = 0; i < n4; ++i) {
                                n17 = dataInputStream.readInt();
                                ((Image32)object2).setPixel(i, n16, 0, n17);
                                if (n17 < n18) {
                                    n18 = n17;
                                }
                                if (n17 <= n19) continue;
                                n19 = n17;
                            }
                        }
                        if (n18 == n19) {
                            ++n19;
                        }
                        ((Image32)object2).setRange(new RangeInt(n18, n19));
                        ((ImageBase)object2).setMetadata(fITS_Header.getMetadata());
                        arrayList.add((Image)object2);
                        break;
                    }
                    object2 = new Image32(n4, n5, n3);
                    switch (n2) {
                        case 0: {
                            int n20;
                            for (n16 = 0; n16 < n5; ++n16) {
                                for (int i = 0; i < n4; ++i) {
                                    for (n20 = 0; n20 < n3; ++n20) {
                                        n17 = dataInputStream.readInt();
                                        ((Image32)object2).setPixel(i, n16, n20, n17);
                                        if (n17 < n18) {
                                            n18 = n17;
                                        }
                                        if (n17 <= n19) continue;
                                        n19 = n17;
                                    }
                                }
                            }
                            break;
                        }
                        case 1: {
                            int n20;
                            for (n16 = 0; n16 < n5; ++n16) {
                                for (int i = 0; i < n3; ++i) {
                                    for (n20 = 0; n20 < n4; ++n20) {
                                        n17 = dataInputStream.readInt();
                                        ((Image32)object2).setPixel(n20, n16, i, n17);
                                        if (n17 < n18) {
                                            n18 = n17;
                                        }
                                        if (n17 <= n19) continue;
                                        n19 = n17;
                                    }
                                }
                            }
                            break;
                        }
                        case 2: {
                            int n20;
                            for (n16 = 0; n16 < n3; ++n16) {
                                for (int i = 0; i < n5; ++i) {
                                    for (n20 = 0; n20 < n4; ++n20) {
                                        n17 = dataInputStream.readInt();
                                        ((Image32)object2).setPixel(n20, i, n16, n17);
                                        if (n17 < n18) {
                                            n18 = n17;
                                        }
                                        if (n17 <= n19) continue;
                                        n19 = n17;
                                    }
                                }
                            }
                            break;
                        }
                    }
                    if (n18 == n19) {
                        ++n19;
                    }
                    ((Image32)object2).setRange(new RangeInt(n18, n19));
                    ((ImageBase)object2).setMetadata(fITS_Header.getMetadata());
                    arrayList.add((Image)object2);
                    break;
                }
                double d3 = 0.0;
                double d4 = Double.MAX_VALUE;
                double d5 = Double.MIN_VALUE;
                if (1 == n3) {
                    object2 = new Image64(n4, n5, n3);
                    for (int i = 0; i < n5; ++i) {
                        for (int j = 0; j < n4; ++j) {
                            d3 = (double)dataInputStream.readInt() * d + d2;
                            ((Image64)object2).setPixelDouble(j, i, 0, d3);
                            if (d3 < d4) {
                                d4 = d3;
                            }
                            if (!(d3 > d5)) continue;
                            d5 = d3;
                        }
                    }
                    if (d5 - d4 < 1.0) {
                        d5 = d4 + 1.0;
                    }
                    ((Image64)object2).setRangeDouble(new RangeDouble(d4, d5));
                    ((ImageBase)object2).setMetadata(fITS_Header.getMetadata());
                    arrayList.add((Image)object2);
                    break;
                }
                object2 = new Image64(n4, n5, n3);
                switch (n2) {
                    case 0: {
                        for (int i = 0; i < n5; ++i) {
                            for (int j = 0; j < n4; ++j) {
                                for (int k = 0; k < n3; ++k) {
                                    d3 = (double)dataInputStream.readInt() * d + d2;
                                    ((Image64)object2).setPixelDouble(j, i, k, d3);
                                    if (d3 < d4) {
                                        d4 = d3;
                                    }
                                    if (!(d3 > d5)) continue;
                                    d5 = d3;
                                }
                            }
                        }
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < n5; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                for (int k = 0; k < n4; ++k) {
                                    d3 = (double)dataInputStream.readInt() * d + d2;
                                    ((Image64)object2).setPixelDouble(k, i, j, d3);
                                    if (d3 < d4) {
                                        d4 = d3;
                                    }
                                    if (!(d3 > d5)) continue;
                                    d5 = d3;
                                }
                            }
                        }
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < n3; ++i) {
                            for (int j = 0; j < n5; ++j) {
                                for (int k = 0; k < n4; ++k) {
                                    d3 = (double)dataInputStream.readInt() * d + d2;
                                    ((Image64)object2).setPixelDouble(k, j, i, d3);
                                    if (d3 < d4) {
                                        d4 = d3;
                                    }
                                    if (!(d3 > d5)) continue;
                                    d5 = d3;
                                }
                            }
                        }
                        break;
                    }
                }
                if (d5 - d4 < 1.0) {
                    d5 = d4 + 1.0;
                }
                ((Image64)object2).setRangeDouble(new RangeDouble(d4, d5));
                ((ImageBase)object2).setMetadata(fITS_Header.getMetadata());
                arrayList.add((Image)object2);
                break;
            }
            case 64: {
                Util.warning("Sorry", "Cannot read images having 64 bit integers per channel");
                break;
            }
            case -32: {
                Object object2;
                float f = 0.0f;
                double d6 = 0.0;
                double d7 = Double.MAX_VALUE;
                double d8 = Double.MIN_VALUE;
                if (1 == n3) {
                    object2 = new Image64(n4, n5, n3);
                    for (int i = 0; i < n5; ++i) {
                        for (int j = 0; j < n4; ++j) {
                            f = dataInputStream.readFloat();
                            if (Float.isNaN(f)) {
                                f = 0.0f;
                            }
                            d6 = (double)f * d + d2;
                            ((Image64)object2).setPixelDouble(j, i, 0, d6);
                            if (d6 < d7) {
                                d7 = d6;
                            }
                            if (!(d6 > d8)) continue;
                            d8 = d6;
                        }
                    }
                    if (d8 - d7 < 1.0) {
                        d8 = d7 + 1.0;
                    }
                    ((Image64)object2).setRangeDouble(new RangeDouble(d7, d8));
                    if (d7 < 0.0) {
                        ((Image64)object2).add(-d7);
                    }
                    ((ImageBase)object2).setMetadata(fITS_Header.getMetadata());
                    arrayList.add((Image)object2);
                    break;
                }
                object2 = new Image64(n4, n5, n3);
                switch (n2) {
                    case 0: {
                        for (int i = 0; i < n5; ++i) {
                            for (int j = 0; j < n4; ++j) {
                                for (int k = 0; k < n3; ++k) {
                                    f = dataInputStream.readFloat();
                                    if (Float.isNaN(f)) {
                                        f = 0.0f;
                                    }
                                    d6 = (double)f * d + d2;
                                    ((Image64)object2).setPixelDouble(j, i, k, d6);
                                    if (d6 < d7) {
                                        d7 = d6;
                                    }
                                    if (!(d6 > d8)) continue;
                                    d8 = d6;
                                }
                            }
                        }
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < n5; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                for (int k = 0; k < n4; ++k) {
                                    f = dataInputStream.readFloat();
                                    if (Float.isNaN(f)) {
                                        f = 0.0f;
                                    }
                                    d6 = (double)f * d + d2;
                                    ((Image64)object2).setPixelDouble(k, i, j, d6);
                                    if (d6 < d7) {
                                        d7 = d6;
                                    }
                                    if (!(d6 > d8)) continue;
                                    d8 = d6;
                                }
                            }
                        }
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < n3; ++i) {
                            for (int j = 0; j < n5; ++j) {
                                for (int k = 0; k < n4; ++k) {
                                    f = dataInputStream.readFloat();
                                    if (Float.isNaN(f)) {
                                        f = 0.0f;
                                    }
                                    d6 = (double)f * d + d2;
                                    ((Image64)object2).setPixelDouble(k, j, i, d6);
                                    if (d6 < d7) {
                                        d7 = d6;
                                    }
                                    if (!(d6 > d8)) continue;
                                    d8 = d6;
                                }
                            }
                        }
                        break;
                    }
                }
                if (d8 - d7 < 1.0) {
                    d8 = d7 + 1.0;
                }
                ((Image64)object2).setRangeDouble(new RangeDouble(d7, d8));
                if (d7 < 0.0) {
                    ((Image64)object2).add(-d7);
                }
                ((ImageBase)object2).setMetadata(fITS_Header.getMetadata());
                arrayList.add((Image)object2);
                break;
            }
            case -64: {
                Object object2;
                double d9 = 0.0;
                double d10 = Double.MAX_VALUE;
                double d11 = Double.MIN_VALUE;
                if (1 == n3) {
                    object2 = new Image64(n4, n5, n3);
                    for (int i = 0; i < n5; ++i) {
                        for (int j = 0; j < n4; ++j) {
                            d9 = dataInputStream.readDouble();
                            if (Double.isNaN(d9)) {
                                d9 = 0.0;
                            }
                            d9 = d9 * d + d2;
                            ((Image64)object2).setPixelDouble(j, i, 0, d9);
                            if (d9 < d10) {
                                d10 = d9;
                            }
                            if (!(d9 > d11)) continue;
                            d11 = d9;
                        }
                    }
                    if (d11 - d10 < 1.0) {
                        d11 = d10 + 1.0;
                    }
                    ((Image64)object2).setRangeDouble(new RangeDouble(d10, d11));
                    if (d10 < 0.0) {
                        ((Image64)object2).add(-d10);
                    }
                    ((ImageBase)object2).setMetadata(fITS_Header.getMetadata());
                    arrayList.add((Image)object2);
                    break;
                }
                object2 = new Image64(n4, n5, n3);
                switch (n2) {
                    case 0: {
                        for (int i = 0; i < n5; ++i) {
                            for (int j = 0; j < n4; ++j) {
                                for (int k = 0; k < n3; ++k) {
                                    d9 = dataInputStream.readDouble();
                                    if (Double.isNaN(d9)) {
                                        d9 = 0.0;
                                    }
                                    d9 = d9 * d + d2;
                                    ((Image64)object2).setPixelDouble(j, i, k, d9);
                                    if (d9 < d10) {
                                        d10 = d9;
                                    }
                                    if (!(d9 > d11)) continue;
                                    d11 = d9;
                                }
                            }
                        }
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < n5; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                for (int k = 0; k < n4; ++k) {
                                    d9 = dataInputStream.readDouble();
                                    if (Double.isNaN(d9)) {
                                        d9 = 0.0;
                                    }
                                    d9 = d9 * d + d2;
                                    ((Image64)object2).setPixelDouble(k, i, j, d9);
                                    if (d9 < d10) {
                                        d10 = d9;
                                    }
                                    if (!(d9 > d11)) continue;
                                    d11 = d9;
                                }
                            }
                        }
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < n3; ++i) {
                            for (int j = 0; j < n5; ++j) {
                                for (int k = 0; k < n4; ++k) {
                                    d9 = dataInputStream.readDouble();
                                    if (Double.isNaN(d9)) {
                                        d9 = 0.0;
                                    }
                                    d9 = d9 * d + d2;
                                    ((Image64)object2).setPixelDouble(k, j, i, d9);
                                    if (d9 < d10) {
                                        d10 = d9;
                                    }
                                    if (!(d9 > d11)) continue;
                                    d11 = d9;
                                }
                            }
                        }
                        break;
                    }
                }
                if (d11 - d10 < 1.0) {
                    d11 = d10 + 1.0;
                }
                ((Image64)object2).setRangeDouble(new RangeDouble(d10, d11));
                if (d10 < 0.0) {
                    ((Image64)object2).add(-d10);
                }
                ((ImageBase)object2).setMetadata(fITS_Header.getMetadata());
                arrayList.add((Image)object2);
                break;
            }
            default: {
                throw new NoImageException("Invalid BITPIX value: " + n);
            }
        }
        long l = 0L;
        switch (n) {
            case 8: {
                l = 1L;
                break;
            }
            case 16: {
                l = 2L;
                break;
            }
            case -32: 
            case 32: {
                l = 4L;
                break;
            }
            case -64: 
            case 64: {
                l = 8L;
            }
        }
        long l2 = l * (long)n4 * (long)n5 * (long)n3;
        long l3 = 2880L - l2 % 2880L;
        long l4 = dataInputStream.skip(l3);
        if (l4 != l3) {
            Util.logWarning("Expected number of bytes not skipped at end of FITS.loadImage()");
        }
        return arrayList;
    }
}

