/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.image;

import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.ProgressMonitor;
import net.grelf.image.ByteMask;
import net.grelf.image.Calibration;
import net.grelf.image.IncompatibleImageException;
import net.grelf.image.Kernel;
import net.grelf.image.Metadata;
import net.grelf.image.RangeDouble;
import net.grelf.image.RangeInt;
import net.grelf.image.Threshold;

public interface Image {
    public void add(Image var1) throws IncompatibleImageException;

    public void add(BufferedImage var1) throws IncompatibleImageException;

    public void addProportion(Image var1, double var2, double var4) throws IncompatibleImageException;

    public void addTranslated(BufferedImage var1, int var2, int var3) throws IncompatibleImageException;

    public void addTranslated(BufferedImage var1, double var2, double var4) throws IncompatibleImageException;

    public void applyCurve(RangeInt var1, List<Point> var2, BufferedImage var3) throws IncompatibleImageException;

    public void autoCrop();

    public void autoStretch(boolean var1);

    public void autoStretch(boolean var1, Point var2, Point var3);

    public ByteMask autoThreshold();

    public void averageVertically();

    public void averageVertically(int var1, int var2);

    public void blurGaussian(int var1, int var2, ProgressMonitor var3);

    public Image clone();

    public Image convertToImage8();

    public Image convertToImage16();

    public Image convertToImage32();

    public Image convertToImage64();

    public void convertToMonochrome();

    public void convertToMonochrome(double ... var1);

    public void convolve(Kernel var1, ProgressMonitor var2);

    public void convolve(double[] var1, double[] var2, ProgressMonitor var3);

    public void correctBackground(double var1, int var3);

    public void crop(Point var1, Point var2);

    public void deconvolve(Kernel var1, int var2, double var3, ProgressMonitor var5);

    public void dispose();

    public void divide(int var1);

    public void divideByFlatField(Image var1);

    public void drawRim(int var1, Color var2);

    public void fit(int var1, int var2);

    public void flipHorizontal();

    public void flipVertical();

    public Calibration getCalibration();

    public int getBitsPerChannel();

    public RangeInt[] getChannelRanges();

    public RangeDouble[] getChannelRangesDouble();

    public String getFilePath();

    public int getHeight();

    public String getImageTypeAsString();

    public Metadata getMetadata();

    public int getNBands();

    public int[] getPixel(int var1, int var2);

    public double[] getPixelDouble(int var1, int var2);

    public double[] getPixelDoubleInterpolated(double var1, double var3);

    public int[] getPixelInterpolated(double var1, double var3);

    public RangeInt getRange();

    public RangeDouble getRangeDouble();

    public RangeInt getRangeByRescanning();

    public RangeDouble getRangeByRescanningDouble();

    public int getWidth();

    public Image gnomonicProjection(int var1, double var2, double var4);

    public Image inverseGnomonicProjection(int var1, double var2, double var4);

    public void invert();

    public boolean isRaw();

    public void meanFilter(int var1, ProgressMonitor var2);

    public void medianFilter(int var1, ProgressMonitor var2);

    public void multiply(double var1);

    public void multiply(Image var1);

    public void multiply(Image var1, double var2, double var4);

    public void nearestExtremeFilter(int var1, ProgressMonitor var2);

    public void neutraliseBackground();

    public void rankFilter(int var1, ProgressMonitor var2);

    public void reapplyColour(Image var1, Image var2);

    public void rotate(double var1);

    public void save(String var1);

    public void save(String var1, RangeInt var2);

    public void save(String var1, RangeDouble var2);

    public void saveAsFITS(String var1);

    public void scale(double var1, boolean var3);

    public BufferedImage scaleDownForDisplay(int var1);

    public void set(BufferedImage var1) throws IncompatibleImageException;

    public void setCalibration(Calibration var1);

    public void setFilePath(String var1);

    public void setMetadata(Metadata var1);

    public void setPixel(int var1, int var2, int[] var3);

    public void setPixel(int var1, int var2, int var3, int var4);

    public void setPixelDouble(int var1, int var2, double[] var3);

    public void setPixelDouble(int var1, int var2, int var3, double var4);

    public void showInfo();

    public Image[] splitChannels();

    public Image[] splitIntensity();

    public void subtract(Image var1) throws IncompatibleImageException;

    public void subtractToZero(Image var1) throws IncompatibleImageException;

    public ByteMask threshold(Threshold var1);

    public void translate(int var1, int var2);

    public void translate(double var1, double var3);

    public String toString();

    public String toFoldedString(String var1);

    public void varianceFilter(int var1, ProgressMonitor var2);
}

