/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.image;

import java.awt.image.BufferedImage;
import net.grelf.Util;
import net.grelf.image.Image;
import net.grelf.image.Image8or16Base;

public class Timer {
    private long startTime;
    private String opName;
    private BufferedImage bim;
    private Image image;

    public Timer(String string) {
        this.opName = string;
        this.startTime = System.nanoTime();
    }

    public Timer(String string, Image image) {
        this.opName = string;
        this.image = image;
        this.startTime = System.nanoTime();
    }

    public Timer(String string, BufferedImage bufferedImage) {
        this.opName = string;
        this.bim = bufferedImage;
        this.startTime = System.nanoTime();
    }

    public void stop() {
        long l = System.nanoTime() - this.startTime;
        StringBuffer stringBuffer = new StringBuffer(this.opName + " (");
        if (null != this.image) {
            stringBuffer.append(this.image.getWidth());
            stringBuffer.append("x");
            stringBuffer.append(this.image.getHeight());
            stringBuffer.append("x");
            stringBuffer.append(this.image.getNBands());
            stringBuffer.append("x");
            stringBuffer.append(this.image.getBitsPerChannel());
        } else if (null != this.bim) {
            stringBuffer.append(this.bim.getWidth());
            stringBuffer.append("x");
            stringBuffer.append(this.bim.getHeight());
            stringBuffer.append("x");
            stringBuffer.append(Image8or16Base.getNBands(this.bim));
            stringBuffer.append("x");
            stringBuffer.append(Image8or16Base.getBitsPerChannel(this.bim));
        }
        stringBuffer.append(") took ");
        stringBuffer.append((double)l / 1.0E9);
        stringBuffer.append(" s.");
        Util.logInfo(stringBuffer.toString());
    }
}

